/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentConflictStatistics;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.weights.StudentWeights;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.base.BaseSolverParameterDef;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="studentSectioningSolverService")
public class StudentSectioningSolverService
implements SolverService<StudentSolverProxy> {
    protected static Log sLog = LogFactory.getLog(StudentSectioningSolverService.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    @Override
    public DataProperties createConfig(Long settingsId, Map<Long, String> options) {
        String mode;
        StudentWeights.Implementation studentWeights;
        DataProperties properties = new DataProperties();
        for (Object def : SolverPredefinedSettingDAO.getInstance().getSession().createQuery("from SolverParameterDef where group.type = :type").setInteger("type", SolverParameterGroup.SolverType.STUDENT.ordinal()).list()) {
            if (((SolverParameterDef)def).getDefault() != null) {
                properties.put((Object)((BaseSolverParameterDef)def).getName(), (Object)((SolverParameterDef)def).getDefault());
            }
            if (options == null || !options.containsKey(((BaseSolverParameterDef)def).getUniqueId())) continue;
            properties.put((Object)((BaseSolverParameterDef)def).getName(), (Object)options.get(((BaseSolverParameterDef)def).getUniqueId()));
        }
        SolverPredefinedSetting settings = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(settingsId);
        for (SolverParameter param : settings.getParameters()) {
            if (!param.getDefinition().isVisible().booleanValue() || param.getDefinition().getGroup().getSolverType() != SolverParameterGroup.SolverType.STUDENT) continue;
            properties.put((Object)param.getDefinition().getName(), (Object)param.getValue());
            if (options == null || !options.containsKey(param.getDefinition().getUniqueId())) continue;
            properties.put((Object)param.getDefinition().getName(), (Object)options.get(param.getDefinition().getUniqueId()));
        }
        properties.setProperty("General.SettingsId", settings.getUniqueId().toString());
        String ext = properties.getProperty("Extensions.Classes", "");
        if (properties.getPropertyBoolean("StudentSct.CBS", true)) {
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + StudentConflictStatistics.class.getName();
            properties.setProperty("ConflictStatistics.Print", "true");
        }
        if (properties.getPropertyBoolean("StudentSct.StudentDist", true)) {
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + DistanceConflict.class.getName();
        }
        if (properties.getPropertyBoolean("StudentSct.TimeOverlaps", true)) {
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + TimeOverlapsCounter.class.getName();
        }
        if (!properties.getProperty("StudentWeights.Mode", "").isEmpty() && (studentWeights = StudentWeights.Implementation.valueOf((String)properties.getProperty("StudentWeights.Mode"))) != null) {
            properties.setProperty("StudentWeights.Class", studentWeights.getImplementation().getName());
            properties.setProperty("Comparator.Class", studentWeights.getImplementation().getName());
        }
        if ("MPP".equals(mode = properties.getProperty("StudentSctBasic.Mode", "Initial"))) {
            properties.setProperty("General.MPP", "true");
        }
        properties.setProperty("Extensions.Classes", ext);
        if (properties.getPropertyBoolean("Basic.DisobeyHard", false)) {
            properties.setProperty("General.InteractiveMode", "true");
        }
        if ("No Action".equals(properties.getProperty("StudentSctBasic.WhenFinished"))) {
            properties.setProperty("General.Save", "false");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "false");
        } else if ("Save".equals(properties.getProperty("StudentSctBasic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "false");
        } else if ("Save and Unload".equals(properties.getProperty("StudentSctBasic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "true");
        }
        properties.setProperty("Xml.ShowNames", "true");
        if (properties.getProperty("Distances.Ellipsoid") == null || properties.getProperty("Distances.Ellipsoid").equals("DEFAULT")) {
            properties.setProperty("Distances.Ellipsoid", ApplicationProperties.getProperty(ApplicationProperty.DistanceEllipsoid));
        }
        if (properties.getProperty("Parallel.NrSolvers") == null) {
            properties.setProperty("Parallel.NrSolvers", String.valueOf(Math.max(1, Runtime.getRuntime().availableProcessors() / 2)));
        }
        properties.setProperty("General.UseAmPm", CONSTANTS.useAmPm() ? "true" : "false");
        properties.expand();
        return properties;
    }

    @Override
    public StudentSolverProxy createSolver(DataProperties properties) {
        try {
            if (!this.sessionContext.isAuthenticated() || this.sessionContext.getUser().getCurrentAcademicSessionId() == null) {
                return null;
            }
            this.removeSolver();
            properties.setProperty("General.SessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().toString());
            properties.setProperty("General.OwnerPuid", this.sessionContext.getUser().getExternalUserId());
            properties.setProperty("General.StartTime", String.valueOf(new Date().getTime()));
            String host = properties.getProperty("General.Host");
            String instructorFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
            if (instructorFormat != null) {
                properties.setProperty("General.InstructorFormat", instructorFormat);
            }
            StudentSolverProxy solver = this.solverServerService.createStudentSolver(host, this.sessionContext.getUser().getExternalUserId(), properties);
            solver.load(properties);
            return solver;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to start the solver: " + e.getMessage()), (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public StudentSolverProxy getSolver(String puid, Long sessionId) {
        try {
            StudentSolverProxy proxy = this.solverServerService.getStudentSolverContainer().getSolver(puid);
            if (proxy == null) {
                return null;
            }
            if (sessionId != null && !sessionId.equals(proxy.getProperties().getPropertyLong("General.SessionId", null))) {
                return null;
            }
            return proxy;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to retrieve solver, reason:" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public StudentSolverProxy getSolver() {
        StudentSolverProxy solver;
        ProxyHolder h = (ProxyHolder)this.sessionContext.getAttribute(SessionAttribute.StudentSectioningSolver);
        StudentSolverProxy studentSolverProxy = solver = h != null && h.isValid() ? (StudentSolverProxy)h.getProxy() : null;
        if (solver != null) {
            try {
                if (solver instanceof RemoteSolver && ((RemoteSolver)((Object)solver)).exists()) {
                    return solver;
                }
                this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            }
            catch (Exception e) {
                this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            }
        }
        if (!this.sessionContext.isAuthenticated()) {
            return null;
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        if (sessionId == null) {
            return null;
        }
        String puid = (String)this.sessionContext.getAttribute(SessionAttribute.StudentSectioningUser);
        if (puid != null && (solver = this.getSolver(puid, sessionId)) != null) {
            this.sessionContext.setAttribute(SessionAttribute.StudentSectioningSolver, new ProxyHolder<String, StudentSolverProxy>(puid, solver));
            return solver;
        }
        solver = this.getSolver(this.sessionContext.getUser().getExternalUserId(), sessionId);
        if (solver != null) {
            this.sessionContext.setAttribute(SessionAttribute.StudentSectioningSolver, new ProxyHolder<String, StudentSolverProxy>(this.sessionContext.getUser().getExternalUserId(), solver));
        }
        return solver;
    }

    @Override
    public StudentSolverProxy getSolverNoSessionCheck() {
        StudentSolverProxy solver;
        if (!this.sessionContext.isAuthenticated()) {
            return null;
        }
        String puid = (String)this.sessionContext.getAttribute(SessionAttribute.StudentSectioningUser);
        if (puid != null && (solver = this.getSolver(puid, null)) != null) {
            return solver;
        }
        return this.getSolver(this.sessionContext.getUser().getExternalUserId(), null);
    }

    @Override
    public void removeSolver() {
        try {
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            StudentSolverProxy solver = this.getSolverNoSessionCheck();
            if (solver != null) {
                solver.interrupt();
                solver.dispose();
            }
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningUser);
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to remove a solver: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public StudentSolverProxy reload(DataProperties properties) {
        try {
            StudentSolverProxy solver = this.getSolver();
            if (solver == null) {
                return this.createSolver(properties);
            }
            DataProperties oldProperties = solver.getProperties();
            properties.setProperty("General.SessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().toString());
            properties.setProperty("General.OwnerPuid", oldProperties.getProperty("General.OwnerPuid"));
            properties.setProperty("General.StartTime", String.valueOf(new Date().getTime()));
            String instructorFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
            if (instructorFormat != null) {
                properties.setProperty("General.InstructorFormat", instructorFormat);
            }
            solver.reload(properties);
            return solver;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to reload the solver: " + e.getMessage()), (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public Map<String, StudentSolverProxy> getSolvers() {
        HashMap<String, StudentSolverProxy> solvers = new HashMap<String, StudentSolverProxy>();
        SolverContainer<StudentSolverProxy> container = this.solverServerService.getStudentSolverContainer();
        for (String user : container.getSolvers()) {
            solvers.put(user, container.getSolver(user));
        }
        return solvers;
    }

    @Override
    public Map<String, StudentSolverProxy> getLocalSolvers() {
        HashMap<String, StudentSolverProxy> solvers = new HashMap<String, StudentSolverProxy>();
        SolverContainer<StudentSolverProxy> container = this.solverServerService.getLocalServer().getStudentSolverContainer();
        for (String user : container.getSolvers()) {
            solvers.put(user, container.getSolver(user));
        }
        return solvers;
    }
}

