/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.service;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolutionClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="classAssignmentService")
public class ClassAssignmentService
implements AssignmentService<ClassAssignmentProxy> {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public ClassAssignmentProxy getAssignment() {
        ProxyHolder h;
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        if (solver != null) {
            return new CachedClassAssignmentProxy(solver);
        }
        String solutionIdsStr = (String)this.sessionContext.getAttribute(SessionAttribute.SelectedSolution);
        HashSet<Long> solutionIds = new HashSet<Long>();
        if (solutionIdsStr != null) {
            StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
            while (s.hasMoreTokens()) {
                solutionIds.add(Long.valueOf(s.nextToken()));
            }
        }
        if ((h = (ProxyHolder)this.sessionContext.getAttribute(SessionAttribute.ClassAssignment)) != null && h.isValid(solutionIds)) {
            return (ClassAssignmentProxy)h.getProxy();
        }
        SolutionClassAssignmentProxy newProxy = new SolutionClassAssignmentProxy(solutionIds);
        this.sessionContext.setAttribute(SessionAttribute.ClassAssignment, new ProxyHolder(solutionIds, newProxy));
        return newProxy;
    }
}

