/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ClusterDiscoveryDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

public class OnlineStudentSchedulingGenericUpdater
extends Thread {
    private Logger iLog;
    private long iSleepTimeInSeconds = 5L;
    private boolean iRun = true;
    private boolean iPause = false;
    private RpcDispatcher iDispatcher;
    private OnlineStudentSchedulingContainerRemote iContainer;

    public OnlineStudentSchedulingGenericUpdater(RpcDispatcher dispatcher, OnlineStudentSchedulingContainerRemote container) {
        this.iDispatcher = dispatcher;
        this.iContainer = container;
        this.setDaemon(true);
        this.setName("Updater[generic]");
        this.iSleepTimeInSeconds = ApplicationProperty.OnlineSchedulingQueueLoadInterval.intValue().intValue();
        this.iLog = Logger.getLogger((String)(OnlineStudentSchedulingGenericUpdater.class + ".updater[generic]"));
    }

    public void run() {
        try {
            this.iLog.info((Object)"Generic updater started.");
            while (this.iRun) {
                try {
                    OnlineStudentSchedulingGenericUpdater.sleep(this.iSleepTimeInSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.iRun || this.iPause) continue;
                this.checkForNewServers();
            }
            this.iLog.info((Object)"Generic updater stopped.");
        }
        catch (Exception e) {
            this.iLog.error((Object)("Generic updater failed, " + e.getMessage()), (Throwable)e);
        }
    }

    public synchronized void pauseUpading() {
        this.iPause = true;
        this.iLog.info((Object)"Generic updater paused.");
    }

    public synchronized void resumeUpading() {
        this.interrupt();
        this.iPause = false;
        this.iLog.info((Object)"Generic updater resumed.");
    }

    public void stopUpdating() {
        this.iRun = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkForNewServers() {
        if (!this.isCoordinator()) {
            return;
        }
        if (!ClusterDiscoveryDAO.isConfigured()) {
            this.iLog.info((Object)"Hibernate is not configured yet, will check for new servers later...");
            return;
        }
        Lock lock = this.iContainer.getLockService().getLock("updater[generic].check");
        lock.lock();
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        try {
            boolean replicate = ApplicationProperty.OnlineSchedulingServerReplicated.isTrue();
            HashMap<String, HashSet<Address>> solvers = new HashMap<String, HashSet<Address>>();
            try {
                RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "getSolvers", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
                for (Rsp rsp : ret) {
                    if (rsp.getValue() == null) continue;
                    for (String solver : (Set)rsp.getValue()) {
                        HashSet<Address> members = (HashSet<Address>)solvers.get(solver);
                        if (members == null) {
                            members = new HashSet<Address>();
                            solvers.put(solver, members);
                        }
                        members.add(rsp.getSender());
                    }
                }
            }
            catch (Exception e) {
                this.iLog.error((Object)("Failed to retrieve servers: " + e.getMessage()), (Throwable)e);
                Object var15_24 = null;
                hibSession.close();
                lock.unlock();
                return;
            }
            for (Session session : SessionDAO.getInstance().findAll(hibSession)) {
                Boolean created;
                int nrSolutions;
                RspList ret;
                if (solvers.containsKey(session.getUniqueId().toString())) {
                    block30: {
                        try {
                            Set members = (Set)solvers.get(session.getUniqueId().toString());
                            if (members.size() <= 1) break block30;
                            ArrayList<Address> masters = new ArrayList<Address>();
                            ret = this.iContainer.getDispatcher().callRemoteMethods((Collection)members, "hasMaster", new Object[]{session.getUniqueId().toString()}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
                            for (Object rsp : ret) {
                                if (!Boolean.TRUE.equals(rsp.getValue())) continue;
                                masters.add(rsp.getSender());
                            }
                            if (masters.size() > 1) {
                                this.iLog.warn((Object)(masters.size() + " masters for " + session.getLabel() + " detected."));
                                this.iLog.info((Object)this.iContainer.getLockService().printLocks());
                                this.iLog.info((Object)("Releasing master locks for " + session.getLabel() + " ..."));
                                this.iContainer.getDispatcher().callRemoteMethods(masters, "invoke", new Object[]{"setProperty", session.getUniqueId().toString(), new Class[]{String.class, Object.class}, new Object[]{"ReadyToServe", Boolean.FALSE}}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                                this.iContainer.getDispatcher().callRemoteMethods(masters, "invoke", new Object[]{"setProperty", session.getUniqueId().toString(), new Class[]{String.class, Object.class}, new Object[]{"ReloadIsNeeded", Boolean.TRUE}}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                                this.iContainer.getDispatcher().callRemoteMethods(masters, "invoke", new Object[]{"releaseMasterLockIfHeld", session.getUniqueId().toString(), new Class[0], new Object[0]}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            this.iLog.error((Object)("Failed to release master locks for " + session.getLabel() + ": " + e.getMessage()), (Throwable)e);
                        }
                        continue;
                    }
                    if (!replicate) continue;
                }
                if (session.getStatusType().isTestSession() || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents() || (nrSolutions = ((Number)hibSession.createQuery("select count(s) from Solution s where s.owner.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).uniqueResult()).intValue()) == 0) continue;
                ArrayList<Address> available = new ArrayList<Address>();
                try {
                    ret = this.iDispatcher.callRemoteMethods(null, "isAvailable", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
                    for (Object rsp : ret) {
                        if (!Boolean.TRUE.equals(rsp.getValue())) continue;
                        available.add(rsp.getSender());
                    }
                }
                catch (Exception e) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                }
                if (available.isEmpty()) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: no server available."));
                    continue;
                }
                if (replicate) {
                    Collections.shuffle(available);
                    Set members = (Set)solvers.get(session.getUniqueId().toString());
                    if (members != null) {
                        Object rsp;
                        boolean ready = false;
                        rsp = members.iterator();
                        while (rsp.hasNext()) {
                            Address address = (Address)rsp.next();
                            OnlineSectioningServer server = this.iContainer.createProxy(address, session.getUniqueId().toString());
                            if (!server.isReady()) continue;
                            ready = true;
                            break;
                        }
                        if (!ready) continue;
                    }
                    try {
                        for (Address address : available) {
                            if (members != null && members.contains(address)) continue;
                            created = (Boolean)this.iContainer.getDispatcher().callRemoteMethod(address, "createRemoteSolver", new Object[]{session.getUniqueId().toString(), null, this.iDispatcher.getChannel().getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, SolverServerImplementation.sFirstResponse);
                            if (members != null || !created.booleanValue()) continue;
                        }
                    }
                    catch (Exception e) {
                        this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                try {
                    HashMap<Address, Object> usages = new HashMap<Address, Object>();
                    for (Address address : available) {
                        Integer usage = (Integer)this.iDispatcher.callRemoteMethod(address, "getUsage", new Object[0], new Class[0], SolverServerImplementation.sFirstResponse);
                        usages.put(address, usage);
                    }
                    while (!usages.isEmpty()) {
                        Address bestAddress = null;
                        int bestUsage = 0;
                        for (Map.Entry entry : usages.entrySet()) {
                            if (bestAddress != null && bestUsage <= (Integer)entry.getValue()) continue;
                            bestAddress = (Address)entry.getKey();
                            bestUsage = (Integer)entry.getValue();
                        }
                        usages.remove(bestAddress);
                        created = (Boolean)this.iContainer.getDispatcher().callRemoteMethod(bestAddress, "createRemoteSolver", new Object[]{session.getUniqueId().toString(), null, this.iDispatcher.getChannel().getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, SolverServerImplementation.sFirstResponse);
                        if (!created.booleanValue()) continue;
                    }
                }
                catch (Exception e) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                }
            }
            Object var15_25 = null;
        }
        catch (Throwable throwable) {
            Object var15_26 = null;
            hibSession.close();
            lock.unlock();
            throw throwable;
        }
        hibSession.close();
        lock.unlock();
    }

    public boolean isCoordinator() {
        return ((Address)this.iDispatcher.getChannel().getView().getMembers().get(0)).equals(this.iDispatcher.getChannel().getAddress());
    }
}

