/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.blocks.locking.LockService;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.server.InMemoryServer;
import org.unitime.timetable.onlinesectioning.server.ReplicatedServerWithMaster;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingUpdater;
import org.unitime.timetable.solver.jgroups.SolverContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineStudentSchedulingContainer
implements SolverContainer<OnlineSectioningServer> {
    private static Log sLog = LogFactory.getLog(OnlineStudentSchedulingContainer.class);
    protected Hashtable<Long, OnlineSectioningServer> iInstances = new Hashtable();
    private Hashtable<Long, OnlineStudentSchedulingUpdater> iUpdaters = new Hashtable();
    private ReentrantReadWriteLock iGlobalLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSolvers() {
        this.iGlobalLock.readLock().lock();
        try {
            TreeSet<String> ret = new TreeSet<String>();
            for (Map.Entry<Long, OnlineSectioningServer> entry : this.iInstances.entrySet()) {
                try {
                    ret.add(entry.getValue().getAcademicSession().getUniqueId().toString());
                }
                catch (IllegalStateException e) {
                    sLog.error((Object)("Server " + entry.getKey() + " appears to be in an inconsistent state: " + e.getMessage()));
                }
            }
            TreeSet<String> treeSet = ret;
            Object var6_5 = null;
            this.iGlobalLock.readLock().unlock();
            return treeSet;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.iGlobalLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public OnlineSectioningServer getSolver(String sessionId) {
        return this.getInstance(Long.valueOf(sessionId));
    }

    @Override
    public long getMemUsage(String user) {
        OnlineSectioningServer solver = this.getSolver(user);
        return solver == null ? 0L : solver.getMemUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineSectioningServer getInstance(Long sessionId) {
        OnlineSectioningServer instance;
        block6: {
            this.iGlobalLock.readLock().lock();
            try {
                instance = this.iInstances.get(sessionId);
                if (instance != null) break block6;
                OnlineSectioningServer onlineSectioningServer = null;
                Object var6_6 = null;
                this.iGlobalLock.readLock().unlock();
                return onlineSectioningServer;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.iGlobalLock.readLock().unlock();
                throw throwable;
            }
        }
        try {
            instance.getAcademicSession();
        }
        catch (IllegalStateException e) {
            sLog.error((Object)("Server " + sessionId + " appears to be in an inconsistent state: " + e.getMessage()), (Throwable)e);
            OnlineSectioningServer onlineSectioningServer = null;
            Object var6_7 = null;
            this.iGlobalLock.readLock().unlock();
            return onlineSectioningServer;
        }
        OnlineSectioningServer onlineSectioningServer = instance;
        Object var6_8 = null;
        this.iGlobalLock.readLock().unlock();
        return onlineSectioningServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSolver(String sessionId) {
        this.iGlobalLock.readLock().lock();
        try {
            boolean bl = this.iInstances.containsKey(Long.valueOf(sessionId));
            Object var4_3 = null;
            this.iGlobalLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.iGlobalLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public OnlineSectioningServer createSolver(String sessionId, DataProperties config) {
        if (!this.canCreateSolver(Long.valueOf(sessionId))) {
            return null;
        }
        return this.createInstance(Long.valueOf(sessionId), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canCreateSolver(Long sessionId) {
        org.hibernate.Session hibSession;
        block9: {
            Session session;
            block8: {
                block7: {
                    block6: {
                        boolean bl;
                        hibSession = SessionDAO.getInstance().createNewSession();
                        try {
                            session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
                            if (session != null) break block6;
                            bl = false;
                            Object var9_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            hibSession.close();
                            throw throwable;
                        }
                        hibSession.close();
                        return bl;
                    }
                    String year = ApplicationProperty.OnlineSchedulingAcademicYear.value();
                    if (year == null || session.getAcademicYear().matches(year)) break block7;
                    boolean bl = false;
                    Object var9_7 = null;
                    hibSession.close();
                    return bl;
                }
                String term = ApplicationProperty.OnlineSchedulingAcademicTerm.value();
                if (term == null || session.getAcademicTerm().matches(term)) break block8;
                boolean bl = false;
                Object var9_8 = null;
                hibSession.close();
                return bl;
            }
            String campus = ApplicationProperty.OnlineSchedulingAcademicCampus.value();
            if (campus == null || session.getAcademicInitiative().matches(campus)) break block9;
            boolean bl = false;
            Object var9_9 = null;
            hibSession.close();
            return bl;
        }
        boolean bl = true;
        Object var9_10 = null;
        hibSession.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnlineSectioningServer createInstance(Long academicSessionId, DataProperties config) {
        OnlineSectioningServer onlineSectioningServer;
        this.unload(academicSessionId, true);
        this.iGlobalLock.writeLock().lock();
        try {
            try {
                ApplicationProperties.setSessionId(academicSessionId);
                String serverClassName = ApplicationProperty.OnlineSchedulingServerClass.value();
                if (serverClassName == null) {
                    serverClassName = ApplicationProperty.OnlineSchedulingServerReplicated.isTrue() ? ReplicatedServerWithMaster.class.getName() : InMemoryServer.class.getName();
                }
                Class<?> serverClass = Class.forName(serverClassName);
                OnlineSectioningServer server = (OnlineSectioningServer)serverClass.getConstructor(OnlineSectioningServerContext.class).newInstance(this.getServerContext(academicSessionId));
                this.iInstances.put(academicSessionId, server);
                org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
                try {
                    OnlineStudentSchedulingUpdater updater = new OnlineStudentSchedulingUpdater(this, server.getAcademicSession(), StudentSectioningQueue.getLastTimeStamp(hibSession, academicSessionId));
                    this.iUpdaters.put(academicSessionId, updater);
                    updater.start();
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    hibSession.close();
                    throw throwable;
                }
                hibSession.close();
                onlineSectioningServer = server;
                Object var11_13 = null;
            }
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SectioningException(e.getMessage(), e);
            }
            this.iGlobalLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.iGlobalLock.writeLock().unlock();
            ApplicationProperties.setSessionId(null);
            throw throwable;
        }
        ApplicationProperties.setSessionId(null);
        return onlineSectioningServer;
    }

    public OnlineSectioningServerContext getServerContext(final Long academicSessionId) {
        return new OnlineSectioningServerContext(){

            public Long getAcademicSessionId() {
                return academicSessionId;
            }

            public boolean isWaitTillStarted() {
                return false;
            }

            public EmbeddedCacheManager getCacheManager() {
                return null;
            }

            public LockService getLockService() {
                return null;
            }
        };
    }

    @Override
    public void unloadSolver(String sessionId) {
        this.unload(Long.valueOf(sessionId), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(Long academicSessionId, boolean interrupt) {
        this.iGlobalLock.writeLock().lock();
        try {
            OnlineSectioningServer s;
            OnlineStudentSchedulingUpdater u = this.iUpdaters.get(academicSessionId);
            if (u != null) {
                u.stopUpdating(interrupt);
            }
            if ((s = this.iInstances.get(academicSessionId)) != null) {
                sLog.info((Object)("Unloading " + u.getAcademicSession() + "..."));
                s.unload();
            }
            this.iInstances.remove(academicSessionId);
            this.iUpdaters.remove(academicSessionId);
            Object var6_5 = null;
            this.iGlobalLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.iGlobalLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsage() {
        this.iGlobalLock.readLock().lock();
        int ret = 0;
        try {
            for (OnlineSectioningServer s : this.iInstances.values()) {
                if (s.isMaster()) {
                    ret += 200;
                    continue;
                }
                ret += 100;
            }
            Object var5_4 = null;
            this.iGlobalLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.iGlobalLock.readLock().unlock();
            throw throwable;
        }
        return ret;
    }

    @Override
    public void start() {
        sLog.info((Object)"Student Sectioning Service is starting up ...");
        OnlineSectioningLogger.startLogger();
    }

    public boolean isEnabled() {
        if (!this.iInstances.isEmpty()) {
            return true;
        }
        String year = ApplicationProperty.OnlineSchedulingAcademicYear.value();
        String term = ApplicationProperty.OnlineSchedulingAcademicTerm.value();
        String campus = ApplicationProperty.OnlineSchedulingAcademicCampus.value();
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (year != null && !session.getAcademicYear().matches(year) || term != null && !session.getAcademicTerm().matches(term) || campus != null && !session.getAcademicInitiative().matches(campus) || session.getStatusType().isTestSession() || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents()) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistrationEnabled() {
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (session.getStatusType().isTestSession() || session.getStatusType().canOnlineSectionStudents() || session.getStatusType().canSectionAssistStudents() || !session.getStatusType().canPreRegisterStudents()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAll() {
        this.iGlobalLock.writeLock().lock();
        try {
            for (OnlineStudentSchedulingUpdater u : this.iUpdaters.values()) {
                OnlineSectioningServer s;
                u.stopUpdating(true);
                if (u.getAcademicSession() == null || (s = this.iInstances.get(u.getAcademicSession().getUniqueId())) == null) continue;
                s.unload();
            }
            this.iInstances.clear();
            this.iUpdaters.clear();
            Object var5_4 = null;
            this.iGlobalLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.iGlobalLock.writeLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void stop() {
        sLog.info((Object)"Student Sectioning Service is going down ...");
        this.unloadAll();
        OnlineSectioningLogger.stopLogger();
    }
}

