/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import org.cpsolver.exam.heuristics.ExamNeighbourSelection;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.solver.AbstractSolver;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.exam.ExamDatabaseLoader;
import org.unitime.timetable.solver.exam.ExamDatabaseSaver;
import org.unitime.timetable.solver.exam.ExamModel;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ExamSuggestions;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamConflictStatisticsInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfoModel;
import org.unitime.timetable.solver.exam.ui.ExamProposedChange;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.exam.ui.ExamSuggestionsInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSolver
extends AbstractSolver<Exam, ExamPlacement, ExamModel>
implements ExamSolverProxy {
    private ExamConflictStatisticsInfo iCbsInfo = null;

    public ExamSolver(DataProperties properties, SolverDisposeListener disposeListener) {
        super(properties, disposeListener);
    }

    @Override
    protected void disposeNoInherit(boolean unregister) {
        super.disposeNoInherit(unregister);
        this.iCbsInfo = null;
    }

    @Override
    protected ProblemSaver<Exam, ExamPlacement, ExamModel> getDatabaseSaver(Solver<Exam, ExamPlacement> solver) {
        return new ExamDatabaseSaver(solver);
    }

    @Override
    protected ProblemLoader<Exam, ExamPlacement, ExamModel> getDatabaseLoader(ExamModel model, Assignment<Exam, ExamPlacement> assignment) {
        return new ExamDatabaseLoader(model, assignment);
    }

    @Override
    protected ExamModel createModel(DataProperties properties) {
        return new ExamModel(properties);
    }

    @Override
    protected Document createCurrentSolutionBackup(boolean anonymize, boolean idconv) {
        this.getProperties().setProperty("Xml.SaveConflictTable", "false");
        if (anonymize) {
            this.getProperties().setProperty("Xml.Anonymize", "true");
            this.getProperties().setProperty("Xml.ShowNames", "false");
            this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
            this.getProperties().setProperty("Xml.Anonymize", "true");
            this.getProperties().setProperty("Xml.SaveInitial", "false");
            this.getProperties().setProperty("Xml.SaveBest", "false");
            this.getProperties().setProperty("Xml.SaveSolution", "true");
        }
        Document document = ((ExamModel)this.currentSolution().getModel()).save((Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
        ExamConflictStatisticsInfo cbsInfo = this.getCbsInfo();
        if (cbsInfo != null) {
            cbsInfo.save(document.getRootElement().addElement("cbsInfo"));
        }
        if (anonymize) {
            Element notavailable;
            Element log = document.getRootElement().element("log");
            if (log != null) {
                document.getRootElement().remove(log);
            }
            if ((notavailable = document.getRootElement().element("notavailable")) != null) {
                document.getRootElement().remove(notavailable);
            }
            this.getProperties().setProperty("Xml.Anonymize", "false");
            this.getProperties().setProperty("Xml.ConvertIds", "false");
            this.getProperties().setProperty("Xml.ShowNames", "true");
            this.getProperties().remove((Object)"Xml.SaveInitial");
            this.getProperties().remove((Object)"Xml.SaveBest");
            this.getProperties().remove((Object)"Xml.SaveSolution");
        }
        return document;
    }

    @Override
    protected void restureCurrentSolutionFromBackup(Document document) {
        ExamModel model = (ExamModel)this.currentSolution().getModel();
        model.load(document, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
        if (document.getRootElement().element("cbsInfo") != null) {
            this.iCbsInfo = new ExamConflictStatisticsInfo();
            this.iCbsInfo.load(document.getRootElement().element("cbsInfo"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exam getExam(long examId) {
        Iterator iterator;
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Exam exam : this.currentSolution().getModel().variables()) {
                if (exam.getId() != examId) continue;
                Exam exam2 = exam;
                Object var8_6 = null;
                lock.unlock();
                return exam2;
            }
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
        Object var8_7 = null;
        lock.unlock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamInfo getInfo(long examId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Exam exam = this.getExam(examId);
            ExamInfo examInfo = exam == null ? null : new ExamInfo(exam);
            Object var7_5 = null;
            lock.unlock();
            return examInfo;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamAssignment getAssignment(long examId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Exam exam = this.getExam(examId);
            ExamPlacement placement = exam == null ? null : (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
            ExamAssignment examAssignment = placement == null ? null : new ExamAssignment(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
            Object var8_6 = null;
            lock.unlock();
            return examAssignment;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamAssignmentInfo getAssignmentInfo(long examId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Exam exam = this.getExam(examId);
            ExamPlacement placement = exam == null ? null : (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
            ExamAssignmentInfo examAssignmentInfo = placement == null ? null : new ExamAssignmentInfo(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
            Object var8_6 = null;
            lock.unlock();
            return examAssignmentInfo;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExamPlacement getPlacement(ExamAssignment assignment) {
        ExamPeriodPlacement period;
        Exam exam;
        Lock lock;
        block8: {
            block7: {
                lock = this.currentSolution().getLock().readLock();
                lock.lock();
                exam = this.getExam(assignment.getExamId());
                if (exam != null) break block7;
                ExamPlacement examPlacement = null;
                Object var13_6 = null;
                lock.unlock();
                return examPlacement;
            }
            period = null;
            for (ExamPeriodPlacement p : exam.getPeriodPlacements()) {
                if (!p.getId().equals(assignment.getPeriodId())) continue;
                period = p;
                break;
            }
            if (period != null) break block8;
            Iterator iterator = null;
            Object var13_7 = null;
            lock.unlock();
            return iterator;
        }
        try {
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (ExamRoomInfo roomInfo : assignment.getRooms()) {
                Long roomId = roomInfo.getLocationId();
                ExamRoomPlacement room = null;
                for (ExamRoomPlacement r : exam.getRoomPlacements()) {
                    if (r.getId() != roomId.longValue()) continue;
                    room = r;
                    break;
                }
                if (room == null) continue;
                rooms.add(room);
            }
            ExamPlacement examPlacement = new ExamPlacement(exam, period, rooms);
            Object var13_8 = null;
            lock.unlock();
            return examPlacement;
        }
        catch (Throwable throwable) {
            Object var13_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamAssignmentInfo getAssignment(Long examId, Long periodId, Collection<Long> roomIds) {
        ExamPeriodPlacement period;
        Exam exam;
        Lock lock;
        block8: {
            block7: {
                lock = this.currentSolution().getLock().readLock();
                lock.lock();
                exam = this.getExam(examId);
                if (exam != null) break block7;
                ExamAssignmentInfo examAssignmentInfo = null;
                Object var14_8 = null;
                lock.unlock();
                return examAssignmentInfo;
            }
            period = null;
            for (ExamPeriodPlacement p : exam.getPeriodPlacements()) {
                if (!p.getId().equals(periodId)) continue;
                period = p;
                break;
            }
            if (period != null) break block8;
            Iterator iterator = null;
            Object var14_9 = null;
            lock.unlock();
            return iterator;
        }
        try {
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (Long roomId : roomIds) {
                ExamRoomPlacement room = null;
                for (ExamRoomPlacement r : exam.getRoomPlacements()) {
                    if (r.getId() != roomId.longValue()) continue;
                    room = r;
                    break;
                }
                if (room == null) continue;
                rooms.add(room);
            }
            ExamAssignmentInfo examAssignmentInfo = new ExamAssignmentInfo(exam, new ExamPlacement(exam, period, rooms), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
            Object var14_10 = null;
            lock.unlock();
            return examAssignmentInfo;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String assign(ExamAssignment assignment) {
        Object object;
        Lock lock;
        block14: {
            block13: {
                block12: {
                    block11: {
                        String string;
                        block10: {
                            lock = this.currentSolution().getLock().writeLock();
                            lock.lock();
                            try {
                                ExamPeriodPlacement p2;
                                Exam exam = this.getExam(assignment.getExamId());
                                if (exam == null) {
                                    String string2 = "Examination " + assignment.getExamName() + " not found.";
                                    Object var12_6 = null;
                                    lock.unlock();
                                    return string2;
                                }
                                ExamPeriodPlacement period = null;
                                for (ExamPeriodPlacement p2 : exam.getPeriodPlacements()) {
                                    if (!p2.getId().equals(assignment.getPeriodId())) continue;
                                    period = p2;
                                    break;
                                }
                                if (period == null) {
                                    string = "Examination period " + assignment.getPeriodName() + " is not available for examination " + assignment.getExamName() + ".";
                                    break block10;
                                }
                                HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
                                for (ExamRoomInfo ri : assignment.getRooms()) {
                                    ExamRoomPlacement room = null;
                                    for (ExamRoomPlacement r : exam.getRoomPlacements()) {
                                        if (r.getId() != ri.getLocationId().longValue()) continue;
                                        room = r;
                                        break;
                                    }
                                    if (room == null) {
                                        object = "Examination room " + ri.getName() + " not found.";
                                        break block11;
                                    }
                                    if (!room.isAvailable(period.getPeriod())) {
                                        object = "Examination room " + ri.getName() + " is not available at " + assignment.getPeriodName() + ".";
                                        break block12;
                                    }
                                    rooms.add(room);
                                }
                                p2 = new ExamPlacement(exam, period, rooms);
                                Set conflicts = this.currentSolution().getModel().conflictValues(this.currentSolution().getAssignment(), (Value)p2);
                                if (conflicts.isEmpty()) {
                                    ExamPlacement old = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
                                    this.currentSolution().getAssignment().assign(0L, (Value)p2);
                                    Progress.getInstance((Object)this.currentSolution().getModel()).info(exam.getName() + ": " + (old == null ? "not assigned" : old.getName()) + " &rarr; " + p2.getName());
                                    object = null;
                                    break block13;
                                }
                                ExamPlacement other = (ExamPlacement)conflicts.iterator().next();
                                object = "Selected placement " + p2.getName() + " is in conflict with exam " + ((Exam)other.variable()).getName() + " that is assigned to " + other.getName() + ".";
                                break block14;
                            }
                            catch (Throwable throwable) {
                                Object var12_12 = null;
                                lock.unlock();
                                throw throwable;
                            }
                        }
                        Object var12_7 = null;
                        lock.unlock();
                        return string;
                    }
                    Object var12_8 = null;
                    lock.unlock();
                    return object;
                }
                Object var12_9 = null;
                lock.unlock();
                return object;
            }
            Object var12_10 = null;
            lock.unlock();
            return object;
        }
        Object var12_11 = null;
        lock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unassign(ExamInfo examInfo) {
        ExamPlacement placement;
        Exam exam;
        Lock lock;
        block5: {
            block4: {
                lock = this.currentSolution().getLock().writeLock();
                lock.lock();
                try {
                    exam = this.getExam(examInfo.getExamId());
                    if (exam != null) break block4;
                    String string = "Examination " + examInfo.getExamName() + " not found.";
                    Object var7_6 = null;
                    lock.unlock();
                    return string;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            placement = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
            if (placement != null) break block5;
            String string = "Examination " + examInfo.getExamName() + " is not assigned.";
            Object var7_7 = null;
            lock.unlock();
            return string;
        }
        Progress.getInstance((Object)this.currentSolution().getModel()).info(exam.getName() + ": " + placement.getName() + " &rarr; not assigned");
        this.currentSolution().getAssignment().unassign(0L, (Variable)exam);
        String string = null;
        Object var7_8 = null;
        lock.unlock();
        return string;
    }

    @Override
    public void load(DataProperties properties) {
        this.iCbsInfo = null;
        super.load(properties);
    }

    @Override
    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo> getAssignedExams() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
            for (Exam exam : this.currentSolution().getModel().variables()) {
                ExamPlacement placement = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
                if (placement == null) continue;
                ret.add(new ExamAssignmentInfo(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
            }
            Vector<ExamAssignmentInfo> vector = ret;
            Object var7_6 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamInfo> getUnassignedExams() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Vector<ExamInfo> ret = new Vector<ExamInfo>();
            for (Exam exam : this.currentSolution().getModel().variables()) {
                ExamPlacement placement = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam);
                if (placement != null) continue;
                ret.add(new ExamInfo(exam));
            }
            Vector<ExamInfo> vector = ret;
            Object var7_6 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo> getAssignedExams(Long subjectAreaId) {
        if (subjectAreaId == null || subjectAreaId < 0L) {
            return this.getAssignedExams();
        }
        String sa = ((SubjectArea)new SubjectAreaDAO().get(subjectAreaId)).getSubjectAreaAbbreviation() + " ";
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
            for (Exam exam : this.currentSolution().getModel().variables()) {
                ExamPlacement placement;
                boolean hasSubjectArea = false;
                Iterator f = exam.getOwners().iterator();
                while (!hasSubjectArea && f.hasNext()) {
                    ExamOwner ecs = (ExamOwner)f.next();
                    hasSubjectArea = ecs.getName().startsWith(sa);
                }
                if (!hasSubjectArea || (placement = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam)) == null) continue;
                ret.add(new ExamAssignmentInfo(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
            }
            Vector<ExamAssignmentInfo> vector = ret;
            Object var11_10 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamInfo> getUnassignedExams(Long subjectAreaId) {
        if (subjectAreaId == null || subjectAreaId < 0L) {
            return this.getUnassignedExams();
        }
        String sa = ((SubjectArea)new SubjectAreaDAO().get(subjectAreaId)).getSubjectAreaAbbreviation() + " ";
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Vector<ExamInfo> ret = new Vector<ExamInfo>();
            for (Exam exam : this.currentSolution().getModel().variables()) {
                ExamPlacement placement;
                boolean hasSubjectArea = false;
                Iterator f = exam.getOwners().iterator();
                while (!hasSubjectArea && f.hasNext()) {
                    ExamOwner ecs = (ExamOwner)f.next();
                    hasSubjectArea = ecs.getName().startsWith(sa);
                }
                if (!hasSubjectArea || (placement = (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam)) != null) continue;
                ret.add(new ExamInfo(exam));
            }
            Vector<ExamInfo> vector = ret;
            Object var11_10 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo> getAssignedExamsOfRoom(Long roomId) {
        ExamRoom room;
        Lock lock;
        block6: {
            lock = this.currentSolution().getLock().readLock();
            lock.lock();
            room = null;
            for (ExamRoom r : ((ExamModel)this.currentSolution().getModel()).getRooms()) {
                if (r.getId() != roomId.longValue()) continue;
                room = r;
                break;
            }
            if (room != null) break block6;
            Iterator iterator = null;
            Object var10_6 = null;
            lock.unlock();
            return iterator;
        }
        try {
            Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
            for (ExamPeriod period : ((ExamModel)this.currentSolution().getModel()).getPeriods()) {
                for (ExamPlacement placement : room.getPlacements(this.currentSolution().getAssignment(), period)) {
                    ret.add(new ExamAssignmentInfo(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
                }
            }
            Vector<ExamAssignmentInfo> vector = ret;
            Object var10_7 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo> getAssignedExamsOfInstructor(Long instructorId) {
        ExamInstructor instructor;
        Lock lock;
        block6: {
            lock = this.currentSolution().getLock().readLock();
            lock.lock();
            instructor = null;
            for (ExamInstructor i : ((ExamModel)this.currentSolution().getModel()).getInstructors()) {
                if (i.getId() != instructorId.longValue()) continue;
                instructor = i;
                break;
            }
            if (instructor != null) break block6;
            Iterator iterator = null;
            Object var11_6 = null;
            lock.unlock();
            return iterator;
        }
        try {
            Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
            for (ExamPeriod period : ((ExamModel)this.currentSolution().getModel()).getPeriods()) {
                Set exams = instructor.getExams(this.currentSolution().getAssignment(), period);
                if (exams == null) continue;
                for (Exam exam : exams) {
                    ret.add(new ExamAssignmentInfo((ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
                }
            }
            Vector<ExamAssignmentInfo> vector = ret;
            Object var11_7 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public Long getExamTypeId() {
        return this.getProperties().getPropertyLong("Exam.Type", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo[]> getChangesToInitial(Long subjectAreaId) {
        String sa = subjectAreaId != null && subjectAreaId >= 0L ? ((SubjectArea)new SubjectAreaDAO().get(subjectAreaId)).getSubjectAreaAbbreviation() + " " : null;
        Vector<ExamAssignmentInfo[]> changes = new Vector<ExamAssignmentInfo[]>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Exam exam : this.currentSolution().getModel().variables()) {
                if (sa != null) {
                    boolean hasSubjectArea = false;
                    Iterator f = exam.getOwners().iterator();
                    while (!hasSubjectArea && f.hasNext()) {
                        ExamOwner ecs = (ExamOwner)f.next();
                        hasSubjectArea = ecs.getName().startsWith(sa);
                    }
                    if (!hasSubjectArea) continue;
                }
                if (ToolBox.equals((Object)exam.getInitialAssignment(), (Object)this.currentSolution().getAssignment().getValue((Variable)exam))) continue;
                changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam, (ExamPlacement)exam.getInitialAssignment(), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()), new ExamAssignmentInfo(exam, (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment())});
            }
            Object var11_10 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.unlock();
            throw throwable;
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo[]> getChangesToBest(Long subjectAreaId) {
        String sa = subjectAreaId != null && subjectAreaId >= 0L ? ((SubjectArea)new SubjectAreaDAO().get(subjectAreaId)).getSubjectAreaAbbreviation() + " " : null;
        Vector<ExamAssignmentInfo[]> changes = new Vector<ExamAssignmentInfo[]>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Exam exam : this.currentSolution().getModel().variables()) {
                if (sa != null) {
                    boolean hasSubjectArea = false;
                    Iterator f = exam.getOwners().iterator();
                    while (!hasSubjectArea && f.hasNext()) {
                        ExamOwner ecs = (ExamOwner)f.next();
                        hasSubjectArea = ecs.getName().startsWith(sa);
                    }
                    if (!hasSubjectArea) continue;
                }
                if (ToolBox.equals((Object)exam.getBestAssignment(), (Object)this.currentSolution().getAssignment().getValue((Variable)exam))) continue;
                changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam, (ExamPlacement)exam.getBestAssignment(), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()), new ExamAssignmentInfo(exam, (ExamPlacement)this.currentSolution().getAssignment().getValue((Variable)exam), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment())});
            }
            Object var11_10 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.unlock();
            throw throwable;
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamConflictStatisticsInfo getCbsInfo() {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ExamConflictStatisticsInfo info = new ExamConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load(cbs);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamConflictStatisticsInfo getCbsInfo(Long examId) {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ExamConflictStatisticsInfo info = new ExamConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load(cbs, examId);
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExamProposedChange update(ExamProposedChange change) {
        ExamProposedChange examProposedChange;
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Hashtable<Exam, Object> undoAssign = new Hashtable<Exam, Object>();
            HashSet<Exam> undoUnassing = new HashSet<Exam>();
            Vector<Exam> unassign = new Vector<Exam>();
            Vector<ExamPlacement> assign = new Vector<ExamPlacement>();
            HashSet<ExamPlacement> conflicts = new HashSet<ExamPlacement>();
            for (ExamAssignment examAssignment : change.getAssignments()) {
                ExamPlacement placement = this.getPlacement(examAssignment);
                if (placement == null) {
                    ExamProposedChange examProposedChange2 = null;
                    Object var14_27 = null;
                    lock.unlock();
                    return examProposedChange2;
                }
                if (this.currentSolution().getAssignment().getValue(placement.variable()) != null) {
                    undoAssign.put((Exam)placement.variable(), this.currentSolution().getAssignment().getValue(placement.variable()));
                } else {
                    undoUnassing.add((Exam)placement.variable());
                }
                assign.add(placement);
                unassign.add((Exam)placement.variable());
            }
            for (Exam exam : unassign) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)exam);
            }
            for (ExamPlacement examPlacement : assign) {
                for (ExamPlacement conflict : ((Exam)examPlacement.variable()).getModel().conflictValues(this.currentSolution().getAssignment(), (Value)examPlacement)) {
                    Exam conflictingExam = (Exam)conflict.variable();
                    if (!undoAssign.containsKey(conflictingExam) && !undoUnassing.contains(conflictingExam)) {
                        undoAssign.put(conflictingExam, conflict);
                    }
                    conflicts.add(conflict);
                    this.currentSolution().getAssignment().unassign(0L, conflict.variable());
                }
                this.currentSolution().getAssignment().assign(0L, (Value)examPlacement);
            }
            change.getAssignments().clear();
            change.getConflicts().clear();
            for (ExamPlacement examPlacement : assign) {
                if (conflicts.contains(examPlacement)) continue;
                change.getAssignments().add(new ExamAssignmentInfo(examPlacement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
            }
            for (Exam exam : undoUnassing) {
                if (this.currentSolution().getAssignment().getValue((Variable)exam) == null) continue;
                this.currentSolution().getAssignment().unassign(0L, (Variable)exam);
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)entry.getKey());
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().assign(0L, (Value)entry.getValue());
            }
            for (ExamPlacement examPlacement : conflicts) {
                ExamPlacement original = (ExamPlacement)undoAssign.get((Exam)examPlacement.variable());
                change.getConflicts().add(new ExamAssignment(original == null ? examPlacement : original, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
            }
            examProposedChange = change;
        }
        catch (Throwable throwable) {
            Object var14_29 = null;
            lock.unlock();
            throw throwable;
        }
        Object var14_28 = null;
        lock.unlock();
        return examProposedChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<ExamRoomInfo> getRooms(long examId, long periodId, ExamProposedChange change, int minRoomSize, int maxRoomSize, String filter, boolean allowConflicts) {
        Vector<ExamRoomInfo> rooms;
        ExamPeriodPlacement period;
        Exam exam;
        Lock lock;
        block23: {
            Object p22;
            block22: {
                block21: {
                    lock = this.currentSolution().getLock().readLock();
                    lock.lock();
                    exam = this.getExam(examId);
                    if (exam != null) break block21;
                    Vector<ExamRoomInfo> vector = null;
                    Object var24_12 = null;
                    lock.unlock();
                    return vector;
                }
                period = null;
                for (Object p22 : exam.getPeriodPlacements()) {
                    if (periodId != p22.getId()) continue;
                    period = p22;
                    break;
                }
                if (period != null) break block22;
                Iterator iterator = null;
                Object var24_13 = null;
                lock.unlock();
                return iterator;
            }
            rooms = new Vector<ExamRoomInfo>();
            if (exam.getMaxRooms() != 0) break block23;
            p22 = rooms;
            Object var24_14 = null;
            lock.unlock();
            return p22;
        }
        try {
            Hashtable<Exam, Object> undoAssign = new Hashtable<Exam, Object>();
            HashSet<Exam> undoUnassing = new HashSet<Exam>();
            if (change != null) {
                for (ExamAssignment vector : change.getConflicts()) {
                    ExamPlacement examPlacement = this.getPlacement(vector);
                    if (examPlacement == null) continue;
                    undoAssign.put((Exam)examPlacement.variable(), examPlacement);
                    this.currentSolution().getAssignment().unassign(0L, examPlacement.variable());
                }
                for (ExamAssignment examAssignment : change.getAssignments()) {
                    ExamPlacement examPlacement = this.getPlacement(examAssignment);
                    if (examPlacement == null) continue;
                    for (ExamPlacement conflict : ((Exam)examPlacement.variable()).getModel().conflictValues(this.currentSolution().getAssignment(), (Value)examPlacement)) {
                        if (((Exam)conflict.variable()).equals((Object)examPlacement.variable())) continue;
                        Exam conflictingExam = (Exam)conflict.variable();
                        if (!undoAssign.containsKey(conflictingExam) && !undoUnassing.contains(conflictingExam)) {
                            undoAssign.put(conflictingExam, conflict);
                        }
                        this.currentSolution().getAssignment().unassign(0L, conflict.variable());
                    }
                    if (this.currentSolution().getAssignment().getValue(examPlacement.variable()) != null) {
                        undoAssign.put((Exam)examPlacement.variable(), this.currentSolution().getAssignment().getValue(examPlacement.variable()));
                    } else {
                        undoUnassing.add((Exam)examPlacement.variable());
                    }
                    this.currentSolution().getAssignment().assign(0L, (Value)examPlacement);
                }
            }
            ExamRoomSharing sharing = ((ExamModel)this.currentSolution().getModel()).getRoomSharing();
            for (ExamRoomPlacement examRoomPlacement : exam.getRoomPlacements()) {
                boolean conf;
                int cap = examRoomPlacement.getSize(exam.hasAltSeating());
                if (minRoomSize >= 0 && cap < minRoomSize || maxRoomSize >= 0 && cap > maxRoomSize || !ExamInfoModel.match(examRoomPlacement.getName(), filter) || !examRoomPlacement.isAvailable(period.getPeriod())) continue;
                boolean bl = conf = !exam.checkDistributionConstraints(this.currentSolution().getAssignment(), examRoomPlacement);
                if (sharing == null) {
                    for (ExamPlacement p : examRoomPlacement.getRoom().getPlacements(this.currentSolution().getAssignment(), period.getPeriod())) {
                        if (((Exam)p.variable()).equals((Object)exam)) continue;
                        conf = true;
                    }
                } else if (sharing.inConflict(exam, (Collection)examRoomPlacement.getRoom().getPlacements(this.currentSolution().getAssignment(), period.getPeriod()), examRoomPlacement.getRoom())) {
                    conf = true;
                }
                if (!allowConflicts && conf) continue;
                rooms.add(new ExamRoomInfo(examRoomPlacement.getRoom(), (conf ? 100 : 0) + examRoomPlacement.getPenalty(period.getPeriod())));
            }
            for (Exam exam2 : undoUnassing) {
                if (this.currentSolution().getAssignment().getValue((Variable)exam2) == null) continue;
                this.currentSolution().getAssignment().unassign(0L, (Variable)exam2);
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)entry.getKey());
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().assign(0L, (Value)entry.getValue());
            }
            Vector<ExamRoomInfo> vector = rooms;
            Object var24_15 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var24_16 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExamAssignmentInfo> getPeriods(long examId, ExamProposedChange change) {
        Exam exam;
        Lock lock;
        block16: {
            lock = this.currentSolution().getLock().readLock();
            lock.lock();
            exam = this.getExam(examId);
            if (exam != null) break block16;
            Collection<ExamAssignmentInfo> collection = null;
            Object var15_7 = null;
            lock.unlock();
            return collection;
        }
        try {
            Hashtable<Exam, Object> undoAssign = new Hashtable<Exam, Object>();
            HashSet<Exam> undoUnassing = new HashSet<Exam>();
            if (change != null) {
                for (ExamAssignment vector : change.getConflicts()) {
                    ExamPlacement examPlacement = this.getPlacement(vector);
                    if (examPlacement == null) continue;
                    undoAssign.put((Exam)examPlacement.variable(), examPlacement);
                    this.currentSolution().getAssignment().unassign(0L, examPlacement.variable());
                }
                for (ExamAssignment examAssignment : change.getAssignments()) {
                    ExamPlacement examPlacement = this.getPlacement(examAssignment);
                    if (examPlacement == null) continue;
                    for (ExamPlacement conflict : ((Exam)examPlacement.variable()).getModel().conflictValues(this.currentSolution().getAssignment(), (Value)examPlacement)) {
                        if (((Exam)conflict.variable()).equals((Object)examPlacement.variable())) continue;
                        Exam conflictingExam = (Exam)conflict.variable();
                        if (!undoAssign.containsKey(conflictingExam) && !undoUnassing.contains(conflictingExam)) {
                            undoAssign.put(conflictingExam, conflict);
                        }
                        this.currentSolution().getAssignment().unassign(0L, conflict.variable());
                    }
                    if (this.currentSolution().getAssignment().getValue(examPlacement.variable()) != null) {
                        undoAssign.put((Exam)examPlacement.variable(), this.currentSolution().getAssignment().getValue(examPlacement.variable()));
                    } else {
                        undoUnassing.add((Exam)examPlacement.variable());
                    }
                    this.currentSolution().getAssignment().assign(0L, (Value)examPlacement);
                }
            }
            Vector<ExamAssignmentInfo> periods = new Vector<ExamAssignmentInfo>();
            for (ExamPeriodPlacement examPeriodPlacement : exam.getPeriodPlacements()) {
                HashSet rooms = exam.findBestAvailableRooms(this.currentSolution().getAssignment(), examPeriodPlacement);
                if (rooms == null) {
                    rooms = new HashSet();
                }
                boolean conf = !exam.checkDistributionConstraints(this.currentSolution().getAssignment(), examPeriodPlacement);
                ExamAssignmentInfo assignment = new ExamAssignmentInfo(new ExamPlacement(exam, examPeriodPlacement, rooms), (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment());
                if (conf) {
                    assignment.setPeriodPref("P");
                }
                periods.add(assignment);
            }
            for (Exam exam2 : undoUnassing) {
                if (this.currentSolution().getAssignment().getValue((Variable)exam2) == null) continue;
                this.currentSolution().getAssignment().unassign(0L, (Variable)exam2);
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)entry.getKey());
            }
            for (Map.Entry entry : undoAssign.entrySet()) {
                this.currentSolution().getAssignment().assign(0L, (Value)entry.getValue());
            }
            Vector<ExamAssignmentInfo> vector = periods;
            Object var15_8 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var15_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExamSuggestionsInfo getSuggestions(long examId, ExamProposedChange change, String filter, int depth, int limit, long timeOut) {
        Exam exam;
        Lock lock;
        block3: {
            lock = this.currentSolution().getLock().writeLock();
            lock.lock();
            try {
                exam = this.getExam(examId);
                if (exam != null) break block3;
                ExamSuggestionsInfo examSuggestionsInfo = null;
                Object var16_11 = null;
                lock.unlock();
                return examSuggestionsInfo;
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                lock.unlock();
                throw throwable;
            }
        }
        ExamSuggestions s = new ExamSuggestions(this);
        s.setDepth(depth);
        s.setFilter(filter);
        s.setLimit(limit);
        s.setTimeOut(timeOut);
        TreeSet<ExamProposedChange> suggestions = s.computeSuggestions(exam, change == null ? null : change.getAssignments());
        String message = null;
        message = s.wasTimeoutReached() ? "(" + timeOut / 1000L + "s timeout reached, " + s.getNrCombinationsConsidered() + " possibilities up to " + depth + " changes were considered, " : "(all " + s.getNrCombinationsConsidered() + " possibilities up to " + depth + " changes were considered, ";
        message = suggestions.isEmpty() ? message + "no suggestion found)" : (s.getNrSolutions() > suggestions.size() ? message + "top " + suggestions.size() + " of " + s.getNrSolutions() + " suggestions displayed)" : message + suggestions.size() + " suggestions displayed)");
        ExamSuggestionsInfo examSuggestionsInfo = new ExamSuggestionsInfo(suggestions, message, s.wasTimeoutReached());
        Object var16_12 = null;
        lock.unlock();
        return examSuggestionsInfo;
    }

    protected void autoConfigure() {
        super.autoConfigure();
        this.setPerturbationsCounter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeSet<ExamAssignment> getExamsOfRoom(long locationId) {
        ExamRoom room;
        ExamModel model;
        Lock lock;
        block6: {
            lock = this.currentSolution().getLock().readLock();
            lock.lock();
            model = (ExamModel)this.currentSolution().getModel();
            room = null;
            for (ExamRoom r : model.getRooms()) {
                if (r.getId() != locationId) continue;
                room = r;
                break;
            }
            if (room != null) break block6;
            Iterator iterator = null;
            Object var12_7 = null;
            lock.unlock();
            return iterator;
        }
        try {
            TreeSet<ExamAssignment> ret = new TreeSet<ExamAssignment>();
            for (ExamPeriod period : model.getPeriods()) {
                for (ExamPlacement placement : room.getPlacements(this.currentSolution().getAssignment(), period)) {
                    ret.add(new ExamAssignment(placement, (Assignment<Exam, ExamPlacement>)this.currentSolution().getAssignment()));
                }
            }
            TreeSet<ExamAssignment> treeSet = ret;
            Object var12_8 = null;
            lock.unlock();
            return treeSet;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void stopSolverImmediately() {
        super.stopSolver();
    }

    @Override
    public void stopSolver() {
        if (this.getNeighbourSelection() instanceof ExamNeighbourSelection) {
            ExamNeighbourSelection xn = (ExamNeighbourSelection)this.getNeighbourSelection();
            if (xn.isFinalPhase()) {
                this.stopSolverImmediately();
            } else {
                xn.setFinalPhase(new Callback(){

                    public void execute() {
                        ExamSolver.this.iStop = true;
                    }
                });
            }
        } else {
            this.stopSolverImmediately();
        }
    }

    @Override
    protected void beforeStart() {
        this.iCbsInfo = null;
    }

    @Override
    public SolverParameterGroup.SolverType getType() {
        return SolverParameterGroup.SolverType.EXAM;
    }

    public class ReloadingDoneCallback
    implements Callback {
        Hashtable iCurrentAssignmentTable = new Hashtable();
        Hashtable iBestAssignmentTable = new Hashtable();
        Hashtable iInitialAssignmentTable = new Hashtable();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = ExamSolver.this.getProperties().getProperty("General.SolutionId");
            for (Exam exam : ExamSolver.this.currentSolution().getModel().variables()) {
                ExamPlacement placement = (ExamPlacement)ExamSolver.this.currentSolution().getAssignment().getValue((Variable)exam);
                if (placement != null) {
                    this.iCurrentAssignmentTable.put(exam.getId(), placement);
                }
                if (exam.getBestAssignment() != null) {
                    this.iBestAssignmentTable.put(exam.getId(), exam.getBestAssignment());
                }
                if (exam.getInitialAssignment() == null) continue;
                this.iInitialAssignmentTable.put(exam.getId(), exam.getInitialAssignment());
            }
        }

        private Exam getExam(long examId) {
            for (Exam exam : ExamSolver.this.currentSolution().getModel().variables()) {
                if (exam.getId() != examId) continue;
                return exam;
            }
            return null;
        }

        private ExamPlacement getPlacement(Exam exam, ExamPlacement placement) {
            ExamPeriodPlacement period = null;
            for (ExamPeriodPlacement p : exam.getPeriodPlacements()) {
                if (!placement.getPeriod().equals((Object)p.getPeriod())) continue;
                period = p;
                break;
            }
            if (period == null) {
                this.iProgress.warn("WARNING: Period " + placement.getPeriod() + " is not available for class " + exam.getName());
                return null;
            }
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (ExamRoomPlacement r : exam.getRoomPlacements()) {
                if (!r.isAvailable(period.getPeriod()) || !placement.contains(r.getRoom())) continue;
                rooms.add(r);
            }
            if (rooms.size() != placement.getRoomPlacements().size()) {
                this.iProgress.warn("WARNING: Room(s) " + placement.getRoomPlacements() + " are not available for exam " + exam.getName());
                return null;
            }
            return new ExamPlacement(exam, period, rooms);
        }

        private void assign(ExamPlacement placement) {
            Map conflictConstraints = ExamSolver.this.currentSolution().getModel().conflictConstraints(ExamSolver.this.currentSolution().getAssignment(), (Value)placement);
            if (conflictConstraints.isEmpty()) {
                ExamSolver.this.currentSolution().getAssignment().assign(0L, (Value)placement);
            } else {
                this.iProgress.warn("Unable to assign " + ((Exam)placement.variable()).getName() + " := " + placement.getName());
                this.iProgress.warn("&nbsp;&nbsp;Reason:");
                for (Constraint c : conflictConstraints.keySet()) {
                    Set vals = (Set)conflictConstraints.get(c);
                    for (ExamPlacement v : vals) {
                        this.iProgress.warn("&nbsp;&nbsp;&nbsp;&nbsp;" + ((Exam)v.variable()).getName() + " = " + v.getName());
                    }
                    this.iProgress.debug("&nbsp;&nbsp;&nbsp;&nbsp;in constraint " + c);
                }
            }
        }

        private void unassignAll() {
            for (Exam exam : ExamSolver.this.currentSolution().getModel().variables()) {
                ExamSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)exam);
            }
        }

        public void execute() {
            ExamPlacement placement;
            Exam exam;
            this.iProgress = Progress.getInstance((Object)ExamSolver.this.currentSolution().getModel());
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating best assignment ...", (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    exam = this.getExam((Long)entry.getKey());
                    if (exam == null || (placement = this.getPlacement(exam, (ExamPlacement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
                ExamSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating initial assignment ...", (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    exam = this.getExam((Long)entry.getKey());
                    if (exam == null || (placement = this.getPlacement(exam, (ExamPlacement)entry.getValue())) == null) continue;
                    exam.setInitialAssignment((Value)placement);
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating current assignment ...", (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    exam = this.getExam((Long)entry.getKey());
                    if (exam == null || (placement = this.getPlacement(exam, (ExamPlacement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
            }
            this.iCurrentAssignmentTable.clear();
            this.iBestAssignmentTable.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                ExamSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            ExamSolver.this.iLoadedDate = new Date();
            ExamSolver.this.iWorking = false;
            ExamSolver.this.afterLoad();
            Progress.getInstance((Object)ExamSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }
}

