/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.solver.exam.ExamResourceUnavailability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamModel
extends org.cpsolver.exam.model.ExamModel {
    private Hashtable<ExamPeriod, Vector<ExamResourceUnavailability>> iUnavailabilitites = null;

    public ExamModel(DataProperties properties) {
        super(properties);
    }

    public Vector<ExamResourceUnavailability> getUnavailabilities(ExamPeriod period) {
        return this.iUnavailabilitites == null ? null : this.iUnavailabilitites.get(period);
    }

    public void addUnavailability(ExamResourceUnavailability unavailability) {
        Vector<ExamResourceUnavailability> unavailabilities;
        if (unavailability.getStudentIds().isEmpty() && unavailability.getInstructorIds().isEmpty()) {
            return;
        }
        if (this.iUnavailabilitites == null) {
            this.iUnavailabilitites = new Hashtable();
        }
        if ((unavailabilities = this.iUnavailabilitites.get(unavailability.getPeriod())) == null) {
            unavailabilities = new Vector();
            this.iUnavailabilitites.put(unavailability.getPeriod(), unavailabilities);
        }
        unavailabilities.add(unavailability);
    }

    public boolean load(Document document, Assignment<Exam, ExamPlacement> assignment) {
        return this.load(document, assignment, null);
    }

    public boolean load(Document document, Assignment<Exam, ExamPlacement> assignment, Callback saveBest) {
        Progress p;
        Element elements;
        if (!super.load(document, assignment, saveBest)) {
            return false;
        }
        if (this.iUnavailabilitites != null) {
            this.iUnavailabilitites.clear();
        }
        if ((elements = document.getRootElement().element("notavailable")) != null) {
            Iterator i = elements.elementIterator();
            while (i.hasNext()) {
                Element e;
                Element element = (Element)i.next();
                HashSet<Long> studentIds = new HashSet<Long>();
                HashSet<Long> instructorIds = new HashSet<Long>();
                Iterator j = element.elementIterator("student");
                while (j.hasNext()) {
                    e = (Element)j.next();
                    studentIds.add(Long.valueOf(e.attributeValue("id")));
                }
                j = element.elementIterator("instructor");
                while (j.hasNext()) {
                    e = (Element)j.next();
                    instructorIds.add(Long.valueOf(e.attributeValue("id")));
                }
                this.addUnavailability(new ExamResourceUnavailability(this.getPeriod(Long.parseLong(element.attributeValue("period"))), Long.valueOf(element.attributeValue("id")), element.getName(), element.attributeValue("name", ""), element.attributeValue("date", ""), element.attributeValue("time", ""), element.attributeValue("room", ""), Integer.parseInt(element.attributeValue("size", "0")), studentIds, instructorIds));
            }
        }
        if ((p = Progress.getInstance((Object)((Object)this))) != null) {
            p.load(document.getRootElement(), true);
            p.message(4, "Restoring from backup ...");
        }
        return true;
    }

    public Document save(Assignment<Exam, ExamPlacement> assignment) {
        Progress p;
        Document document = super.save(assignment);
        if (document == null) {
            return null;
        }
        if (this.iUnavailabilitites != null) {
            Element elements = document.getRootElement().addElement("notavailable");
            for (Vector<ExamResourceUnavailability> unavailabilties : this.iUnavailabilitites.values()) {
                for (ExamResourceUnavailability unavailability : unavailabilties) {
                    Element element = elements.addElement(unavailability.getType()).addAttribute("period", unavailability.getPeriod().getId().toString()).addAttribute("id", unavailability.getId().toString()).addAttribute("name", unavailability.getName()).addAttribute("date", unavailability.getDate()).addAttribute("time", unavailability.getTime()).addAttribute("room", unavailability.getRoom()).addAttribute("size", String.valueOf(unavailability.getSize()));
                    for (Long studentId : unavailability.getStudentIds()) {
                        element.addElement("student").addAttribute("id", studentId.toString());
                    }
                    for (Long studentId : unavailability.getInstructorIds()) {
                        element.addElement("instructor").addAttribute("id", studentId.toString());
                    }
                }
            }
        }
        if ((p = Progress.getInstance((Object)((Object)this))) != null) {
            Progress.getInstance((Object)((Object)this)).save(document.getRootElement());
        }
        return document;
    }
}

