/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.FinalSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrollmentCheck {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    private TimetableModel iModel = null;
    private Assignment<Lecture, Placement> iAssignment = null;
    private int iMessageLevel = 5;
    private int iMessageLowerLevel = 3;

    public EnrollmentCheck(TimetableModel model, Assignment<Lecture, Placement> assignment, int msgLevel) {
        this.iModel = model;
        this.iAssignment = assignment;
        this.setMessageLevel(msgLevel);
    }

    public void setMessageLevel(int messageLevel) {
        this.iMessageLevel = messageLevel;
        switch (this.iMessageLevel) {
            case 7: {
                this.iMessageLowerLevel = 6;
                break;
            }
            case 6: {
                this.iMessageLowerLevel = 5;
                break;
            }
            case 5: {
                this.iMessageLowerLevel = 3;
                break;
            }
            case 3: {
                this.iMessageLowerLevel = 1;
                break;
            }
            case 1: {
                this.iMessageLowerLevel = 0;
                break;
            }
            case 0: {
                this.iMessageLowerLevel = 0;
            }
        }
    }

    public void checkJenrl(Progress p) {
        try {
            p.setPhase("Checking jenrl ...", (long)this.iModel.variables().size());
            for (Lecture l1 : this.iModel.variables()) {
                p.incProgress();
                p.debug("Checking " + l1.getName() + " ...");
                for (Lecture l2 : this.iModel.variables()) {
                    if (l1.getId() >= l2.getId()) continue;
                    double jenrl = 0.0;
                    ArrayList<Student> jenrlStudents = new ArrayList<Student>();
                    for (Student student : l1.students()) {
                        if (!l2.students().contains(student)) continue;
                        jenrl += student.getJenrlWeight(l1, l2);
                        jenrlStudents.add(student);
                    }
                    boolean found = false;
                    for (JenrlConstraint j : this.iModel.getJenrlConstraints()) {
                        Lecture a = (Lecture)j.first();
                        Lecture b = (Lecture)j.second();
                        if ((!a.equals((Object)l1) || !b.equals((Object)l2)) && (!a.equals((Object)l2) || !b.equals((Object)l1))) continue;
                        found = true;
                        if (j.getJenrl() == (long)((int)Math.ceil(jenrl))) continue;
                        p.error("Wrong jenrl between " + this.getClassLabel(l1) + " and " + this.getClassLabel(l2) + " (constraint=" + j.getJenrl() + " != computed=" + jenrl + ").<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(l1) + " has students: " + l1.students() + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(l2) + " has students: " + l2.students() + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;intersection: " + jenrlStudents);
                    }
                    if (found || !(jenrl > 0.0)) continue;
                    p.error("Missing jenrl between " + this.getClassLabel(l1) + " and " + this.getClassLabel(l2) + " (computed=" + jenrl + ").<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(l1) + " has students: " + l1.students() + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(l2) + " has students: " + l2.students() + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;intersection: " + jenrlStudents);
                }
            }
        }
        catch (Exception e) {
            p.error("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkEnrollment(Progress p, Student s, Long subpartId, Collection lectures) {
        Lecture enrolled = null;
        for (Lecture lecture : lectures) {
            if (!s.getLectures().contains(lecture)) continue;
            if (enrolled != null) {
                p.message(this.iMessageLevel, "Student " + s.getId() + " enrolled in multiple classes of the same subpart " + this.getClassLabel(enrolled) + ", " + this.getClassLabel(lecture) + ".");
            }
            enrolled = lecture;
        }
        if (enrolled == null) {
            p.message(this.iMessageLevel, "Student " + s.getId() + " not enrolled in any class of subpart " + this.getSubpartLabel(subpartId) + ".");
        } else if (enrolled.hasAnyChildren()) {
            for (Long sid : enrolled.getChildrenSubpartIds()) {
                this.checkEnrollment(p, s, sid, enrolled.getChildren(sid));
            }
        }
    }

    private String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.do?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    private String getSubpartLabel(Long subpartId) {
        SchedulingSubpart subpart = (SchedulingSubpart)new SchedulingSubpartDAO().get(subpartId);
        if (subpart != null) {
            String suffix = subpart.getSchedulingSubpartSuffix();
            return "<A href='schedulingSubpartDetail.do?ssuid=" + subpart.getUniqueId() + "'>" + subpart.getCourseName() + " " + subpart.getItypeDesc().trim() + (suffix == null || suffix.length() == 0 ? "" : " (" + suffix + ")") + "</A>";
        }
        return subpartId.toString();
    }

    private String getOfferingLabel(Long offeringId) {
        InstructionalOffering offering = (InstructionalOffering)new InstructionalOfferingDAO().get(offeringId);
        if (offering != null) {
            return "<A href='instructionalOfferingDetail.do?io=" + offering.getUniqueId() + "'>" + offering.getCourseName() + "</A>";
        }
        return offeringId.toString();
    }

    private String getOfferingsLabel(Collection offeringIds) {
        StringBuffer sb = new StringBuffer("[");
        if (offeringIds != null) {
            Iterator i = offeringIds.iterator();
            while (i.hasNext()) {
                Long offeringId = (Long)i.next();
                sb.append(this.getOfferingLabel(offeringId));
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasSubpartMixedOwnership(SchedulingSubpart subpart) {
        Department owner = null;
        for (Class_ clazz : subpart.getClasses()) {
            if (owner == null) {
                owner = clazz.getManagingDept();
                continue;
            }
            if (owner.equals(clazz.getManagingDept())) continue;
            return true;
        }
        if (subpart.getParentSubpart() != null) {
            return this.hasSubpartMixedOwnership(subpart.getParentSubpart());
        }
        return false;
    }

    public boolean hasSubpartMixedOwnership(Lecture lecture) {
        Class_ clazz = (Class_)new Class_DAO().get(lecture.getClassId());
        if (clazz == null) {
            return false;
        }
        SchedulingSubpart subpart = clazz.getSchedulingSubpart();
        if (subpart.getClasses().size() > lecture.sameSubpartLectures().size()) {
            return true;
        }
        if (lecture.getParent() != null) {
            return this.hasSubpartMixedOwnership(lecture.getParent());
        }
        if (subpart.getParentSubpart() != null) {
            return this.hasSubpartMixedOwnership(subpart.getParentSubpart());
        }
        return false;
    }

    public void checkStudentEnrollments(Progress p) {
        Criterion scc;
        Criterion sdc;
        Criterion shc;
        p.setStatus("Student Enrollments Check");
        Criterion sc = this.iModel.getCriterion(StudentConflict.class);
        if (sc.getValue(this.iAssignment) != sc.getValue(this.iAssignment, (Collection)this.iModel.variables())) {
            p.message(this.iMessageLevel, "Inconsistent number of student conflits (counter=" + sc.getValue(this.iAssignment) + ", actual=" + sc.getValue(this.iAssignment, (Collection)this.iModel.variables()) + ").");
        }
        if ((shc = this.iModel.getCriterion(StudentHardConflict.class)).getValue(this.iAssignment) != shc.getValue(this.iAssignment, (Collection)this.iModel.variables())) {
            p.message(this.iMessageLevel, "Inconsistent number of hard student conflits (counter=" + shc.getValue(this.iAssignment) + ", actual=" + shc.getValue(this.iAssignment, (Collection)this.iModel.variables()) + ").");
        }
        if ((sdc = this.iModel.getCriterion(StudentDistanceConflict.class)).getValue(this.iAssignment) != sdc.getValue(this.iAssignment, (Collection)this.iModel.variables())) {
            p.message(this.iMessageLevel, "Inconsistent number of distance student conflits (counter=" + sdc.getValue(this.iAssignment) + ", actual=" + sdc.getValue(this.iAssignment, (Collection)this.iModel.variables()) + ").");
        }
        if ((scc = this.iModel.getCriterion(StudentCommittedConflict.class)).getValue(this.iAssignment) != scc.getValue(this.iAssignment, (Collection)this.iModel.variables())) {
            p.message(this.iMessageLevel, "Inconsistent number of committed student conflits (counter=" + scc.getValue(this.iAssignment) + ", actual=" + scc.getValue(this.iAssignment, (Collection)this.iModel.variables()) + ").");
        }
        p.setPhase("Checking class limits...", (long)this.iModel.variables().size());
        for (Lecture lecture : this.iModel.variables()) {
            p.incProgress();
            p.debug("Checking " + this.getClassLabel(lecture) + " ... students=" + lecture.students().size() + ", weighted=" + lecture.nrWeightedStudents() + ", limit=" + lecture.classLimit(this.iAssignment) + " (" + lecture.minClassLimit() + ".." + lecture.maxClassLimit() + ")");
            if (lecture.students().isEmpty()) continue;
            double w = 0.0;
            Iterator i = lecture.students().iterator();
            while (i.hasNext()) {
                w = Math.max(w, ((Student)i.next()).getOfferingWeight(lecture.getConfiguration().getOfferingId()));
            }
            if (!(lecture.nrWeightedStudents() - w + FinalSectioning.sEps > (double)lecture.classLimit(this.iAssignment))) continue;
            if (this.hasSubpartMixedOwnership(lecture)) {
                p.message(this.iMessageLowerLevel, "Class limit exceeded for class " + this.getClassLabel(lecture) + " (" + sDoubleFormat.format(lecture.nrWeightedStudents()) + ">" + lecture.classLimit(this.iAssignment) + ").");
                continue;
            }
            p.message(this.iMessageLevel, "Class limit exceeded for class " + this.getClassLabel(lecture) + " (" + sDoubleFormat.format(lecture.nrWeightedStudents()) + ">" + lecture.classLimit(this.iAssignment) + ").");
        }
        p.setPhase("Checking enrollments...", (long)this.iModel.getAllStudents().size());
        Iterator i = this.iModel.getAllStudents().iterator();
        while (i.hasNext()) {
            p.incProgress();
            Student student = (Student)i.next();
            for (Lecture lecture : student.getLectures()) {
                if (student.canEnroll(lecture)) continue;
                p.message(this.iMessageLowerLevel, "Student " + student.getId() + " enrolled to invalid class " + this.getClassLabel(lecture) + ".");
            }
            if (student.getConfigurations().size() != student.getOfferings().size()) {
                Vector<Long> got = new Vector<Long>();
                for (Configuration cfg : student.getConfigurations()) {
                    got.add(cfg.getOfferingId());
                }
                p.message(this.iMessageLevel, "Student " + student.getId() + " demands offerings " + this.getOfferingsLabel(student.getOfferings()) + ", but got " + this.getOfferingsLabel(got) + ".");
            }
            for (Configuration cfg : student.getConfigurations()) {
                for (Long subpartId : cfg.getTopSubpartIds()) {
                    this.checkEnrollment(p, student, subpartId, cfg.getTopLectures(subpartId));
                }
            }
        }
    }
}

