/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=TimetableGridInterface.TimetableGridFilterRequest.class)
public class TimetableGridFilterBackend
implements GwtRpcImplementation<TimetableGridInterface.TimetableGridFilterRequest, TimetableGridInterface.TimetableGridFilterResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public TimetableGridInterface.TimetableGridFilterResponse execute(TimetableGridInterface.TimetableGridFilterRequest request, SessionContext context) {
        String mode;
        String mode2;
        context.checkPermission(Right.TimetableGrid);
        TimetableGridInterface.TimetableGridFilterResponse response = new TimetableGridInterface.TimetableGridFilterResponse();
        FilterInterface.FilterParameterInterface weeks = new FilterInterface.FilterParameterInterface();
        weeks.setName("weeks");
        weeks.setLabel(MESSAGES.propTimeGridWeek());
        weeks.setType("list");
        weeks.setMultiSelect(false);
        weeks.addOption("-100", MESSAGES.weekAll());
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        int offset = ApplicationProperty.TimeGridFirstDayOfWeek.intValue();
        int startWeek = DateUtils.getWeek(session.getSessionBeginDateTime()) - (ApplicationProperty.SessionNrExcessDays.intValue() + offset + 6) / 7;
        Calendar endCal = Calendar.getInstance(Locale.US);
        endCal.setTime(session.getSessionEndDateTime());
        endCal.add(6, ApplicationProperty.SessionNrExcessDays.intValue());
        int week = startWeek;
        Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);
        while (DateUtils.getStartDate(session.getSessionStartYear(), week, offset).compareTo(endCal.getTime()) <= 0) {
            weeks.addOption(String.valueOf(week), dfShort.format(DateUtils.getStartDate(session.getSessionStartYear(), week, offset)) + " - " + dfLong.format(DateUtils.getEndDate(session.getSessionStartYear(), week, offset)));
            ++week;
        }
        int lastWeek = Integer.parseInt(context.getUser().getProperty("TimetableGridTable.week", "-100"));
        if (lastWeek < startWeek || lastWeek >= week) {
            lastWeek = -100;
        }
        weeks.setDefaultValue(String.valueOf(lastWeek));
        response.addParameter(weeks);
        FilterInterface.FilterParameterInterface resource = new FilterInterface.FilterParameterInterface();
        resource.setName("resource");
        resource.setLabel(MESSAGES.propTimeGridResource());
        resource.setType("list");
        resource.setMultiSelect(false);
        for (int i = 0; i < CONSTANTS.timeGridResource().length; ++i) {
            resource.addOption(String.valueOf(i), CONSTANTS.timeGridResource()[i]);
        }
        resource.setDefaultValue(context.getUser().getProperty("TimetableGridTable.resourceType", "0"));
        response.addParameter(resource);
        FilterInterface.FilterParameterInterface filter = new FilterInterface.FilterParameterInterface();
        filter.setName("filter");
        filter.setLabel(MESSAGES.propTimeGridFilter());
        filter.setType("text");
        filter.setDefaultValue(context.getUser().getProperty("TimetableGridTable.findString", ""));
        response.addParameter(filter);
        FilterInterface.FilterParameterInterface days = new FilterInterface.FilterParameterInterface();
        days.setName("days");
        days.setLabel(MESSAGES.propTimeGridDays());
        days.setType("list");
        days.setMultiSelect(false);
        int i = 0;
        while ((mode2 = ApplicationProperty.TimeGridDays.value(String.valueOf(1 + i), i < CONSTANTS.timeGridDays().length ? CONSTANTS.timeGridDays()[i] : null)) != null && !mode2.isEmpty()) {
            String bitmap = mode2.split("\\|")[0];
            days.addOption(bitmap, mode2.substring(bitmap.length() + 1).replace("\\,", ","));
            ++i;
        }
        days.setDefaultValue(context.getUser().getProperty("TimetableGridTable.day", "1111100"));
        response.addParameter(days);
        FilterInterface.FilterParameterInterface times = new FilterInterface.FilterParameterInterface();
        times.setName("times");
        times.setLabel(MESSAGES.propTimeGridTimes());
        times.setType("list");
        times.setMultiSelect(false);
        int i2 = 0;
        while ((mode = ApplicationProperty.TimeGridTimes.value(String.valueOf(1 + i2), i2 < CONSTANTS.timeGridTimes().length ? CONSTANTS.timeGridTimes()[i2] : null)) != null && !mode.isEmpty()) {
            String name = mode.split("\\|")[0];
            times.addOption(mode.substring(name.length() + 1), name);
            ++i2;
        }
        times.setDefaultValue(context.getUser().getProperty("TimetableGridTable.times", times.hasOptions() ? times.getOptions().get(0).getValue() : null));
        response.addParameter(times);
        FilterInterface.FilterParameterInterface dispMode = new FilterInterface.FilterParameterInterface();
        dispMode.setName("dispMode");
        dispMode.setLabel(MESSAGES.propTimeGridDisplayMode());
        dispMode.setType("list");
        dispMode.setMultiSelect(false);
        for (int i3 = 0; i3 < CONSTANTS.timeGridDisplayMode().length; ++i3) {
            dispMode.addOption(String.valueOf(i3), CONSTANTS.timeGridDisplayMode()[i3]);
        }
        dispMode.setDefaultValue(context.getUser().getProperty("TimetableGridTable.dispMode", "0"));
        response.addParameter(dispMode);
        FilterInterface.FilterParameterInterface background = new FilterInterface.FilterParameterInterface();
        background.setName("background");
        background.setLabel(MESSAGES.propTimeGridBackground());
        background.setType("list");
        background.setMultiSelect(false);
        for (int i4 = 0; i4 < CONSTANTS.timeGridBackground().length; ++i4) {
            background.addOption(String.valueOf(i4), CONSTANTS.timeGridBackground()[i4]);
        }
        background.setDefaultValue(context.getUser().getProperty("TimetableGridTable.bgMode", "0"));
        response.addParameter(background);
        FilterInterface.FilterParameterInterface showFreeTimes = new FilterInterface.FilterParameterInterface();
        showFreeTimes.setName("showFreeTimes");
        showFreeTimes.setType("boolean");
        showFreeTimes.setLabel(MESSAGES.propTimeGridShowFreeTimes());
        showFreeTimes.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showUselessTimes", "0"));
        response.addParameter(showFreeTimes);
        FilterInterface.FilterParameterInterface showPreferences = new FilterInterface.FilterParameterInterface();
        showPreferences.setName("showPreferences");
        showPreferences.setType("boolean");
        showPreferences.setLabel(MESSAGES.propTimeGridShowPreferences());
        showPreferences.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showComments", "0"));
        response.addParameter(showPreferences);
        FilterInterface.FilterParameterInterface showInstructors = new FilterInterface.FilterParameterInterface();
        showInstructors.setName("showInstructors");
        showInstructors.setType("boolean");
        showInstructors.setLabel(MESSAGES.propTimeGridShowInstructors());
        showInstructors.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showInstructors", "0"));
        response.addParameter(showInstructors);
        FilterInterface.FilterParameterInterface showEvents = new FilterInterface.FilterParameterInterface();
        showEvents.setName("showEvents");
        showEvents.setType("boolean");
        showEvents.setLabel(MESSAGES.propTimeGridShowEvents());
        showEvents.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showEvents", "0"));
        response.addParameter(showEvents);
        FilterInterface.FilterParameterInterface showTimes = new FilterInterface.FilterParameterInterface();
        showTimes.setName("showTimes");
        showTimes.setType("boolean");
        showTimes.setLabel(MESSAGES.propTimeGridShowTimes());
        showTimes.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showTimes", "0"));
        response.addParameter(showTimes);
        FilterInterface.FilterParameterInterface showTitles = new FilterInterface.FilterParameterInterface();
        showTitles.setName("showTitles");
        showTitles.setType("boolean");
        showTitles.setLabel(MESSAGES.propTimeGridShowCourseTitles());
        showTitles.setDefaultValue(context.getUser().getProperty("TimetableGridTable.showTitles", "0"));
        response.addParameter(showTitles);
        FilterInterface.FilterParameterInterface orderBy = new FilterInterface.FilterParameterInterface();
        orderBy.setName("orderBy");
        orderBy.setType("list");
        orderBy.setMultiSelect(false);
        for (int i5 = 0; i5 < CONSTANTS.timeGridOrderBy().length; ++i5) {
            orderBy.addOption(String.valueOf(i5), CONSTANTS.timeGridOrderBy()[i5]);
        }
        orderBy.setLabel(MESSAGES.propTimeGridOrderBy());
        orderBy.setDefaultValue(context.getUser().getProperty("TimetableGridTable.orderBy", "0"));
        response.addParameter(orderBy);
        return response;
    }
}

