/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.InstructorAttributeTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.TeachingRequestsPagePropertiesRequest.class)
public class TeachingRequestsPagePropertiesBackend
implements GwtRpcImplementation<InstructorInterface.TeachingRequestsPagePropertiesRequest, InstructorInterface.TeachingRequestsPagePropertiesResponse> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public InstructorInterface.TeachingRequestsPagePropertiesResponse execute(InstructorInterface.TeachingRequestsPagePropertiesRequest request, SessionContext context) {
        String mode;
        String mode2;
        boolean hasTeachingPreference;
        context.checkPermission(Right.InstructorScheduling);
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        Long ownerId = null;
        if (solver != null) {
            ownerId = solver.getProperties().getPropertyLong("General.SolverGroupId", null);
        }
        InstructorInterface.TeachingRequestsPagePropertiesResponse ret = new InstructorInterface.TeachingRequestsPagePropertiesResponse();
        for (SubjectArea sa : SubjectArea.getUserSubjectAreas(context.getUser(), true)) {
            if (ownerId != null && (sa.getDepartment().getSolverGroup() == null || !ownerId.equals(sa.getDepartment().getSolverGroup().getUniqueId()))) continue;
            hasTeachingPreference = false;
            for (DepartmentalInstructor di : sa.getDepartment().getInstructors()) {
                if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                hasTeachingPreference = true;
                break;
            }
            if (!hasTeachingPreference) continue;
            InstructorInterface.SubjectAreaInterface subject = new InstructorInterface.SubjectAreaInterface();
            subject.setId(sa.getUniqueId());
            subject.setAbbreviation(sa.getSubjectAreaAbbreviation());
            subject.setLabel(sa.getTitle());
            ret.addSubjectArea(subject);
        }
        for (Department d : Department.getUserDepartments(context.getUser())) {
            if (ownerId != null && (d.getSolverGroup() == null || !ownerId.equals(d.getSolverGroup().getUniqueId()))) continue;
            hasTeachingPreference = false;
            for (DepartmentalInstructor di : d.getInstructors()) {
                if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                hasTeachingPreference = true;
                break;
            }
            if (!hasTeachingPreference) continue;
            InstructorInterface.DepartmentInterface department = new InstructorInterface.DepartmentInterface();
            department.setId(d.getUniqueId());
            department.setDeptCode(d.getDeptCode());
            department.setLabel(d.getName());
            department.setTitle(d.getLabel());
            department.setAbbreviation(d.getAbbreviation());
            ret.addDepartment(department);
        }
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
            ret.addPreference(new InstructorInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), true));
        }
        String sa = (String)context.getAttribute(SessionAttribute.OfferingsSubjectArea);
        if (Constants.ALL_OPTION_VALUE.equals(sa)) {
            ret.setLastSubjectAreaId(-1L);
        } else if (sa != null) {
            if (sa.indexOf(44) >= 0) {
                sa = sa.substring(0, sa.indexOf(44));
            }
            ret.setLastSubjectAreaId(Long.valueOf(sa));
        }
        String deptId = (String)context.getAttribute(SessionAttribute.DepartmentId);
        if (deptId != null) {
            try {
                ret.setLastDepartmentId(Long.valueOf(deptId));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (InstructorAttributeType type : InstructorAttributeTypeDAO.getInstance().getSession().createQuery("from InstructorAttributeType order by label").setCacheable(true).list()) {
            InstructorInterface.AttributeTypeInterface t = new InstructorInterface.AttributeTypeInterface();
            t.setId(type.getUniqueId());
            t.setAbbreviation(type.getReference());
            t.setLabel(type.getLabel());
            t.setConjunctive(type.isConjunctive());
            t.setRequired(type.isRequired());
            ret.addAttributeType(t);
        }
        int i = 0;
        while ((mode2 = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode2.isEmpty()) {
            ret.addMode(new RoomInterface.RoomSharingDisplayMode(mode2));
            ++i;
        }
        ret.setHasSolver(solver != null);
        InstructorAvailabilityWidget.InstructorAvailabilityModel model = new InstructorAvailabilityWidget.InstructorAvailabilityModel();
        int i2 = 0;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i2), i2 < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i2] : null)) != null && !mode.isEmpty()) {
            model.addMode(new RoomInterface.RoomSharingDisplayMode(mode));
            ++i2;
        }
        model.setDefaultEditable(true);
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(true)) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) continue;
            RoomInterface.RoomSharingOption option = new RoomInterface.RoomSharingOption(model.char2id(PreferenceLevel.prolog2char(pref.getPrefProlog())), pref.prefcolor(), "", pref.getPrefName(), true);
            model.addOption(option);
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) continue;
            model.setDefaultOption(option);
        }
        String defaultGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        if (defaultGridSize != null) {
            for (int i3 = 0; i3 < model.getModes().size(); ++i3) {
                if (!model.getModes().get(i3).getName().equals(defaultGridSize)) continue;
                model.setDefaultMode(i3);
                break;
            }
        }
        model.setDefaultHorizontal(CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        model.setNoteEditable(false);
        ret.setInstructorAvailabilityModel(model);
        return ret;
    }
}

