/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.server.instructor.TeachingRequestsFilterBackend;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.TeachingAssignmentsPageRequest.class)
public class TeachingAssignmentsBackend
extends InstructorSchedulingBackendHelper
implements GwtRpcImplementation<InstructorInterface.TeachingAssignmentsPageRequest, GwtRpcResponseList<InstructorInterface.InstructorInfo>> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public GwtRpcResponseList<InstructorInterface.InstructorInfo> execute(InstructorInterface.TeachingAssignmentsPageRequest request, SessionContext context) {
        InstructorSchedulingProxy solver;
        if (this.instructorSchedulingSolverService == null) {
            this.instructorSchedulingSolverService = (SolverService)SpringApplicationContextHolder.getBean("instructorSchedulingSolverService");
        }
        context.checkPermission(Right.InstructorScheduling);
        if (!request.getFilter().hasOption("instructorId")) {
            Department department;
            Long departmentId = null;
            if (request.getFilter().hasOption("departmentId")) {
                departmentId = Long.valueOf(request.getFilter().getOption("departmentId"));
            } else if (request.getFilter().hasOption("department") && (department = Department.findByDeptCode(request.getFilter().getOption("department"), context.getUser().getCurrentAcademicSessionId())) != null) {
                departmentId = department.getUniqueId();
                request.getFilter().setOption("departmentId", departmentId.toString());
            }
            context.setAttribute(SessionAttribute.DepartmentId, (Object)(departmentId == null ? null : departmentId.toString()));
        }
        if (!request.getFilter().hasSessionId()) {
            request.getFilter().setSessionId(context.getUser().getCurrentAcademicSessionId());
        }
        if ((solver = this.instructorSchedulingSolverService.getSolver()) != null) {
            return new GwtRpcResponseList<InstructorInterface.InstructorInfo>((Collection<InstructorInterface.InstructorInfo>)solver.getInstructors(request.getFilter()));
        }
        InstructorSchedulingBackendHelper.Context cx = new InstructorSchedulingBackendHelper.Context(context, solver);
        Query q = TeachingRequestsFilterBackend.toQuery(request.getFilter());
        GwtRpcResponseList<InstructorInterface.InstructorInfo> ret = new GwtRpcResponseList<InstructorInterface.InstructorInfo>();
        List instructors = TeachingRequestsFilterBackend.getQuery(request.getFilter(), context.getUser()).select("distinct i").query(DepartmentalInstructorDAO.getInstance().getSession()).list();
        for (DepartmentalInstructor instructor : instructors) {
            InstructorInterface.InstructorInfo info = this.getInstructorInfo(instructor, cx);
            if (info == null || !q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, (EventInterface.FilterRpcRequest)request.getFilter()))) continue;
            for (InstructorInterface.TeachingRequestInfo ar : info.getAssignedRequests()) {
                ar.setMatchingFilter(q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(ar, info, request.getFilter())));
            }
            ret.add(info);
        }
        Collections.sort(ret);
        return ret;
    }
}

