/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.GetInstructorsRequest.class)
public class GetInstructorsBackend
implements GwtRpcImplementation<InstructorInterface.GetInstructorsRequest, GwtRpcResponseList<InstructorInterface>> {
    @Override
    public GwtRpcResponseList<InstructorInterface> execute(InstructorInterface.GetInstructorsRequest request, SessionContext context) {
        context.checkPermission(request.getDepartmentId(), "Department", Right.InstructorAttributes);
        GwtRpcResponseList<InstructorInterface> result = new GwtRpcResponseList<InstructorInterface>();
        NameFormat instructorNameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        boolean sortByLastName = CommonValues.SortByLastName.eq(UserProperty.SortNames.get(context.getUser()));
        for (DepartmentalInstructor instructor : DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.uniqueId = :departmentId").setLong("departmentId", request.getDepartmentId().longValue()).setCacheable(true).list()) {
            PreferenceLevel pref;
            InstructorInterface i = new InstructorInterface();
            i.setId(instructor.getUniqueId());
            i.setFirstName(instructor.getFirstName());
            i.setMiddleName(instructor.getMiddleName());
            i.setLastName(instructor.getLastName());
            i.setFormattedName(instructorNameFormat.format(instructor));
            if (sortByLastName) {
                i.setOrderName(instructor.nameLastNameFirst());
            }
            i.setExternalId(instructor.getExternalUniqueId());
            if (instructor.getPositionType() != null) {
                InstructorInterface.PositionInterface p = new InstructorInterface.PositionInterface();
                p.setId(instructor.getPositionType().getUniqueId());
                p.setAbbreviation(instructor.getPositionType().getReference());
                p.setLabel(instructor.getPositionType().getLabel());
                p.setSortOrder(instructor.getPositionType().getSortOrder());
                i.setPosition(p);
            }
            if ((pref = instructor.getTeachingPreference()) == null) {
                pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
            }
            i.setTeachingPreference(new InstructorInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2color(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), true));
            i.setMaxLoad(instructor.getMaxLoad());
            for (InstructorAttribute attribute : instructor.getAttributes()) {
                InstructorInterface.AttributeInterface a = new InstructorInterface.AttributeInterface();
                a.setId(attribute.getUniqueId());
                a.setParentId(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getUniqueId());
                a.setParentName(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getName());
                a.setCode(attribute.getCode());
                a.setName(attribute.getName());
                if (attribute.getType() != null) {
                    InstructorInterface.AttributeTypeInterface t = new InstructorInterface.AttributeTypeInterface();
                    t.setId(attribute.getType().getUniqueId());
                    t.setAbbreviation(attribute.getType().getReference());
                    t.setLabel(attribute.getType().getLabel());
                    t.setConjunctive(attribute.getType().isConjunctive());
                    t.setRequired(attribute.getType().isRequired());
                    a.setType(t);
                }
                if (attribute.getDepartment() != null) {
                    InstructorInterface.DepartmentInterface d = new InstructorInterface.DepartmentInterface();
                    d.setId(attribute.getDepartment().getUniqueId());
                    d.setAbbreviation(attribute.getDepartment().getAbbreviation());
                    d.setDeptCode(attribute.getDepartment().getDeptCode());
                    d.setLabel(attribute.getDepartment().getName());
                    d.setTitle(attribute.getDepartment().getLabel());
                    a.setDepartment(d);
                }
                i.addAttribute(a);
            }
            result.add(i);
        }
        return result;
    }
}

