/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.ComputeSuggestionsRequest.class)
public class ComputeSuggestionsBackend
extends InstructorSchedulingBackendHelper
implements GwtRpcImplementation<InstructorInterface.ComputeSuggestionsRequest, InstructorInterface.SuggestionsResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public InstructorInterface.SuggestionsResponse execute(InstructorInterface.ComputeSuggestionsRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorSchedulingSolver);
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        if (solver != null) {
            return solver.computeSuggestions(request);
        }
        InstructorInterface.SuggestionsResponse response = new InstructorInterface.SuggestionsResponse();
        InstructorSchedulingBackendHelper.Context cx = new InstructorSchedulingBackendHelper.Context(context, solver);
        InstructorSchedulingBackendHelper.Suggestion s = new InstructorSchedulingBackendHelper.Suggestion(this);
        for (InstructorInterface.AssignmentInfo ai : request.getAssignments()) {
            DepartmentalInstructor instructor;
            TeachingRequest tr = (TeachingRequest)TeachingRequestDAO.getInstance().get(ai.getRequest().getRequestId());
            if (tr == null || (instructor = ai.getInstructor() == null ? null : (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(ai.getInstructor().getInstructorId())) == null) continue;
            InstructorInterface.InstructorInfo prev = ai.getRequest().getInstructor(ai.getIndex());
            s.set(tr, ai.getIndex(), instructor, prev == null ? null : (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(prev.getInstructorId()));
        }
        response.setCurrentAssignment(s.toInfo(cx));
        if (request.getSelectedInstructorId() != null) {
            DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getSelectedInstructorId());
            if (instructor == null) {
                return null;
            }
            TeachingRequest tr = null;
            if (request.getSelectedRequestId() != null) {
                tr = (TeachingRequest)TeachingRequestDAO.getInstance().get(request.getSelectedRequestId());
            }
            this.computeDomainForInstructor(response, instructor, tr, cx);
        } else if (request.getSelectedRequestId() != null) {
            TeachingRequest tr = (TeachingRequest)TeachingRequestDAO.getInstance().get(request.getSelectedRequestId());
            if (tr == null) {
                return null;
            }
            cx.setBase(s);
            this.computeDomainForClass(response, tr, request.getSelectedIndex(), cx);
        }
        return response;
    }
}

