/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.AssignmentChangesRequest.class)
public class AssignmentChangesBackend
implements GwtRpcImplementation<InstructorInterface.AssignmentChangesRequest, InstructorInterface.AssignmentChangesResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public InstructorInterface.AssignmentChangesResponse execute(InstructorInterface.AssignmentChangesRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorSchedulingSolver);
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        if (solver != null) {
            return solver.getAssignmentChanges(request);
        }
        throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
    }
}

