/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLOptionsRpcRequest.class)
public class HQLOptionsBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLOptionsRpcRequest, SavedHQLInterface.HQLOptionsInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public SavedHQLInterface.HQLOptionsInterface execute(SavedHQLInterface.HQLOptionsRpcRequest request, SessionContext context) {
        SavedHQLInterface.HQLOptionsInterface ret = new SavedHQLInterface.HQLOptionsInterface();
        for (SavedHQL.Option option : SavedHQL.Option.values()) {
            if (!option.allowSingleSelection() && !option.allowMultiSelection()) continue;
            SavedHQLInterface.Option option2 = new SavedHQLInterface.Option();
            option2.setMultiSelect(option.allowMultiSelection());
            option2.setName(this.getLocalizedText(option));
            option2.setType(option.name());
            Map<Long, String> values = option.values(this.sessionContext.getUser());
            if (values == null || values.isEmpty()) continue;
            for (Map.Entry<Long, String> e : values.entrySet()) {
                SavedHQLInterface.IdValue v = new SavedHQLInterface.IdValue();
                v.setText(e.getValue());
                v.setValue(e.getKey().toString());
                option2.values().add(v);
            }
            Collections.sort(option2.values());
            ret.addOption(option2);
        }
        for (Enum enum_ : SavedHQL.Flag.values()) {
            SavedHQLInterface.Flag flag = new SavedHQLInterface.Flag();
            flag.setValue(((SavedHQL.Flag)enum_).flag());
            flag.setText(this.getLocalizedDescription((SavedHQL.Flag)enum_));
            flag.setAppearance(((SavedHQL.Flag)enum_).getAppearance());
            ret.addFlag(flag);
        }
        ret.setEditable(this.sessionContext.hasPermission(Right.HQLReportAdd));
        return ret;
    }

    private String getLocalizedText(SavedHQL.Option option) {
        switch (option) {
            case BUILDING: {
                return MESSAGES.optionBuilding();
            }
            case BUILDINGS: {
                return MESSAGES.optionBuildings();
            }
            case DEPARTMENT: {
                return MESSAGES.optionDepartment();
            }
            case DEPARTMENTS: {
                return MESSAGES.optionDepartments();
            }
            case ROOM: {
                return MESSAGES.optionRoom();
            }
            case ROOMS: {
                return MESSAGES.optionRooms();
            }
            case SESSION: {
                return MESSAGES.optionAcademicSession();
            }
            case SUBJECT: {
                return MESSAGES.optionSubjectArea();
            }
            case SUBJECTS: {
                return MESSAGES.optionSubjectAreas();
            }
            case DistributionType: {
                return MESSAGES.optionDistributionType();
            }
            case DistributionTypes: {
                return MESSAGES.optionDistributionTypes();
            }
            case DemandOfferingType: {
                return MESSAGES.optionDemandOfferingType();
            }
            case DemandOfferingTypes: {
                return MESSAGES.optionDemandOfferingTypes();
            }
            case OfferingConsentType: {
                return MESSAGES.optionOfferingConsentType();
            }
            case OfferingConsentTypes: {
                return MESSAGES.optionOfferingConsentTypes();
            }
            case CourseCreditFormat: {
                return MESSAGES.optionCourseCreditFormat();
            }
            case CourseCreditFormats: {
                return MESSAGES.optionCourseCreditFormats();
            }
            case CourseCreditType: {
                return MESSAGES.optionCourseCreditType();
            }
            case CourseCreditTypes: {
                return MESSAGES.optionCourseCreditTypes();
            }
            case CourseCreditUnitType: {
                return MESSAGES.optionCourseCreditUnitType();
            }
            case CourseCreditUnitTypes: {
                return MESSAGES.optionCourseCreditUnitTypes();
            }
            case PositionType: {
                return MESSAGES.optionPositionType();
            }
            case PositionTypes: {
                return MESSAGES.optionPositionTypes();
            }
            case DepartmentStatusType: {
                return MESSAGES.optionDepartmentStatusType();
            }
            case DepartmentStatusTypes: {
                return MESSAGES.optionDepartmentStatusTypes();
            }
            case RoomType: {
                return MESSAGES.optionRoomType();
            }
            case RoomTypes: {
                return MESSAGES.optionRoomTypes();
            }
            case StudentSectioningStatus: {
                return MESSAGES.optionStudentSectioningStatus();
            }
            case StudentSectioningStatuses: {
                return MESSAGES.optionStudentSectioningStatuses();
            }
            case ExamType: {
                return MESSAGES.optionExamType();
            }
            case ExamTypes: {
                return MESSAGES.optionExamTypes();
            }
            case RoomFeatureType: {
                return MESSAGES.optionRoomFeatureType();
            }
            case RoomFeatureTypes: {
                return MESSAGES.optionRoomFeatureTypes();
            }
            case CourseType: {
                return MESSAGES.optionCourseType();
            }
            case CourseTypes: {
                return MESSAGES.optionCourseTypes();
            }
            case PITD: {
                return MESSAGES.optionPointInTimeData();
            }
        }
        return option.text();
    }

    private String getLocalizedDescription(SavedHQL.Flag flag) {
        switch (flag) {
            case APPEARANCE_COURSES: {
                return MESSAGES.flagAppearanceCourses();
            }
            case APPEARANCE_EXAMS: {
                return MESSAGES.flagAppearanceExaminations();
            }
            case APPEARANCE_EVENTS: {
                return MESSAGES.flagAppearanceEvents();
            }
            case APPEARANCE_SECTIONING: {
                return MESSAGES.flagAppearanceStudentSectioning();
            }
            case APPEARANCE_ADMINISTRATION: {
                return MESSAGES.flagAppearanceAdministration();
            }
            case ADMIN_ONLY: {
                return MESSAGES.flagRestrictionsAdministratorOnly();
            }
        }
        return flag.description();
    }
}

