/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.hql.SavedHqlExportToCSV;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLExecuteRpcRequest.class)
public class HQLExecuteBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLExecuteRpcRequest, SavedHQLInterface.Table> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public SavedHQLInterface.Table execute(SavedHQLInterface.HQLExecuteRpcRequest request, SessionContext context) {
        try {
            final SavedHQLInterface.Table ret = new SavedHQLInterface.Table();
            Exporter.Printer out = new Exporter.Printer(){

                public void printLine(String ... fields) throws IOException {
                    ret.add(fields);
                }

                public void printHeader(String ... fields) throws IOException {
                    ret.add(fields);
                }

                public void hideColumn(int col) {
                }

                public String getContentType() {
                    return null;
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
            SavedHqlExportToCSV.execute(this.sessionContext.getUser(), out, request.getQuery().getQuery() == null ? ((SavedHQL)SavedHQLDAO.getInstance().get(request.getQuery().getId())).getQuery() : request.getQuery().getQuery(), request.getOptions(), request.getFromRow(), request.getMaxRows());
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(MESSAGES.failedExecution(e.getMessage() + (e.getCause() == null ? "" : " (" + e.getCause().getMessage() + ")")));
        }
    }
}

