/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.Date;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.dao.PointInTimeDataDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.Formats;

@Service(value="gwtAdminTable[type=pitds]")
public class PointInTimeDataSnapshots
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pagePointInTimeDataSnapshot(), MESSAGES.pagePointInTimeDataSnapshots());
    }

    @PreAuthorize(value="checkPermission('PointInTimeData')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 200, 100, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldNote(), SimpleEditInterface.FieldType.textarea, 100, 1000, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldSnapshotTimestamp(), SimpleEditInterface.FieldType.date, 80, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldSavedSuccessfully(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.READ_ONLY));
        data.setSortBy(1, 2);
        data.setAddable(false);
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        for (PointInTimeData pitd : PointInTimeData.findAllForSession(context.getUser().getCurrentAcademicSessionId(), hibSession)) {
            SimpleEditInterface.Record r = data.addRecord(pitd.getUniqueId(), true);
            r.setField(0, pitd.getName());
            r.setField(1, pitd.getNote());
            r.setField(2, dateFormat.format(pitd.getTimestamp()));
            r.setField(3, pitd.isSavedSuccessfully() != false ? "true" : "false");
            r.setDeletable(true);
        }
        data.setEditable(context.hasPermission(Right.PointInTimeDataEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('PointInTimeDataEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (PointInTimeData pointInTimeData : PointInTimeDataDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(pointInTimeData.getUniqueId());
            if (r == null) {
                this.delete(pointInTimeData, context, hibSession);
                continue;
            }
            this.update(pointInTimeData, r, context, hibSession);
        }
    }

    protected void update(PointInTimeData pointInTimeData, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (pointInTimeData == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)pointInTimeData.getName(), (Object)record.getField(0)) || !ToolBox.equals((Object)pointInTimeData.getNote(), (Object)record.getField(1));
        pointInTimeData.setName(record.getField(0));
        pointInTimeData.setNote(record.getField(1));
        hibSession.saveOrUpdate((Object)pointInTimeData);
        if (changed) {
            ChangeLog.addChange(hibSession, context, pointInTimeData, pointInTimeData.getName() + " " + pointInTimeData.getNote(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @PreAuthorize(value="checkPermission('PointInTimeDataEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((PointInTimeData)PointInTimeDataDAO.getInstance().get(record.getUniqueId()), record, context, hibSession);
    }

    protected void delete(PointInTimeData pointInTimeData, SessionContext context, Session hibSession) {
        if (pointInTimeData == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, pointInTimeData, pointInTimeData.getName() + " " + pointInTimeData.getNote(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)pointInTimeData);
    }

    @PreAuthorize(value="checkPermission('PointInTimeDataEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((PointInTimeData)PointInTimeDataDAO.getInstance().get(record.getUniqueId()), context, hibSession);
    }

    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }
}

