/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import java.net.URL;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.sectioning.CourseDetailsWidget;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=CourseDetailsWidget.CourseDetailsRpcRequest.class)
public class CourseDetailsBackend
implements GwtRpcImplementation<CourseDetailsWidget.CourseDetailsRpcRequest, CourseDetailsWidget.CourseDetailsRpcResponse> {
    @Override
    public CourseDetailsWidget.CourseDetailsRpcResponse execute(CourseDetailsWidget.CourseDetailsRpcRequest request, SessionContext context) {
        Session hibSession = CourseOfferingDAO.getInstance().getSession();
        AcademicSessionInfo session = null;
        String subject = null;
        String course = null;
        if (request.hasCourseId()) {
            CourseOffering courseOffering = request.getCourseId() < 0L ? ((InstructionalOffering)InstructionalOfferingDAO.getInstance().get(-request.getCourseId().longValue(), hibSession)).getControllingCourseOffering() : (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId(), hibSession);
            session = new AcademicSessionInfo(courseOffering.getSubjectArea().getSession());
            subject = courseOffering.getSubjectAreaAbbv();
            course = courseOffering.getCourseNbr();
        } else {
            SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(request.getSubjectId(), hibSession);
            session = new AcademicSessionInfo(subjectArea.getSession());
            subject = subjectArea.getSubjectAreaAbbreviation();
            course = request.getCourseNumber();
        }
        CourseDetailsWidget.CourseDetailsRpcResponse response = new CourseDetailsWidget.CourseDetailsRpcResponse();
        response.setDetails(CourseDetailsBackend.getCourseDetails(session, subject, course));
        URL url = CourseDetailsBackend.getCourseUrl(session, subject, course);
        if (url != null) {
            response.setLink(url.toString());
        }
        return response;
    }

    public static String getCourseDetails(AcademicSessionInfo session, String subject, String courseNbr) {
        try {
            String providerClass = ApplicationProperty.CustomizationCourseDetails.value();
            if (providerClass != null) {
                return ((CourseDetailsProvider)Class.forName(providerClass).newInstance()).getDetails(session, subject, courseNbr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static URL getCourseUrl(AcademicSessionInfo session, String subject, String courseNbr) {
        try {
            String providerClass = ApplicationProperty.CustomizationCourseLink.value();
            if (providerClass != null) {
                return ((CourseUrlProvider)Class.forName(providerClass).newInstance()).getCourseUrl(session, subject, courseNbr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

