/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class ExaminationTimetablingPermissions {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ExaminationPdfReports)
    public static class ExaminationPdfReports
    implements Permission<Session> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Session source) {
            if (SubjectArea.getUserSubjectAreas(user, false).isEmpty()) {
                return false;
            }
            if (ExamType.findAllUsed(source.getUniqueId()).isEmpty()) {
                return false;
            }
            return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamView);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationReports)
    public static class ExaminationReports
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.ExaminationSolverLog)
    public static class ExaminationSolverLog
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.ExaminationConflictStatistics)
    public static class ExaminationConflictStatistics
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.ExaminationAssignmentChanges)
    public static class ExaminationAssignmentChanges
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.NotAssignedExaminations)
    public static class NotAssignedExaminations
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.AssignedExaminations)
    public static class AssignedExaminations
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.ExaminationTimetable)
    public static class ExaminationTimetable
    extends ExaminationTimetabling {
    }

    @PermissionForRight(value=Right.ExaminationSolutionExportXml)
    public static class ExaminationSolutionExportXml
    extends ExaminationSolver {
    }

    @PermissionForRight(value=Right.ExaminationSolver)
    public static class ExaminationSolver
    extends ExaminationTimetabling {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ExaminationTimetabling)
    public static class ExaminationTimetabling
    implements Permission<Session> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamTimetable) && (Exam.hasFinalExams(source.getUniqueId()) || Exam.hasMidtermExams(source.getUniqueId()));
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }
}

