/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.permissions.SimpleDepartmentPermission;
import org.unitime.timetable.security.permissions.SimpleSessionPermission;
import org.unitime.timetable.security.rights.Right;

public class AdministrationPermissions {

    @PermissionForRight(value=Right.EventServiceProviderEditDepartment)
    public static class EventServiceProviderEditDepartment
    extends SimpleDepartmentPermission {
    }

    @PermissionForRight(value=Right.EventServiceProviderEditSession)
    public static class EventServiceProviderEditSession
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveStudentGroups)
    public static class ApiRetrieveStudentGroups
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveCurricula)
    public static class ApiRetriveCurricula
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveInstructors)
    public static class ApiRetriveInstructors
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiOnlineStudentScheduliung)
    public static class ApiOnlineStudentScheduliung
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveClassInfo)
    public static class ApiRetrieveClassInfo
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveInstructorSchedule)
    public static class ApiRetrieveInstructorSchedule
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveEnrollments)
    public static class ApiRetrieveEnrollments
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveEvents)
    public static class ApiRetrieveEvents
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRoomEdit)
    public static class ApiRoomEdit
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRoomPictureUpload)
    public static class ApiRoomPictureUpload
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ApiRetrieveRooms)
    public static class ApiRetrieveRooms
    extends SimpleSessionPermission {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ChangePassword)
    public static class ChangePassword
    implements Permission<Session> {
        @Override
        public boolean check(UserContext user, Session source) {
            if (user instanceof UserContext.Chameleon) {
                return false;
            }
            return User.findByUserName(user.getUsername()) != null;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.StandardEventNotesDepartmentEdit)
    public static class StandardEventNotesDepartmentEdit
    extends SimpleDepartmentPermission {
    }

    @PermissionForRight(value=Right.StandardEventNotesSessionEdit)
    public static class StandardEventNotesSessionEdit
    extends SimpleSessionPermission {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.EventDateMappingEdit)
    public static class EventDateMappingEdit
    implements Permission<Session> {
        @Autowired
        Permission<Session> permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source)) {
                return false;
            }
            int nrCommitted = ((Number)SessionDAO.getInstance().getSession().createQuery("select count(s) from Solution s where s.owner.session.uniqueId = :sessionId and s.commited = true").setLong("sessionId", source.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            return nrCommitted == 0;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.EventDateMappings)
    public static class EventDateMappings
    implements Permission<Session> {
        @Autowired
        Permission<Session> permissionSession;
        @Autowired
        Permission<Session> permissionEventDateMappingEdit;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source)) {
                return false;
            }
            if (EventDateMapping.hasMapping(source.getUniqueId())) {
                return true;
            }
            return user.getCurrentAuthority().hasRight(Right.EventDateMappingEdit) && this.permissionEventDateMappingEdit.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.InstructorRoleEdit)
    public static class InstructorRoleEdit
    extends InstructorRoles {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorRoles)
    public static class InstructorRoles
    implements Permission<Department> {
        @Autowired
        Permission<Department> permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            if (!this.permissionDepartment.check(user, source)) {
                return false;
            }
            return source.isAllowEvents() != false && !Roles.findAllInstructorRoles().isEmpty();
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.EventStatusEdit)
    public static class EventStatusEdit
    extends EventStatuses {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.EventStatuses)
    public static class EventStatuses
    implements Permission<Department> {
        @Autowired
        Permission<Department> permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            if (!this.permissionDepartment.check(user, source)) {
                return false;
            }
            if (!source.isAllowEvents().booleanValue()) {
                return false;
            }
            int nrRooms = ((Number)DepartmentDAO.getInstance().getSession().createQuery("select count(r) from Room r where r.eventDepartment.uniqueId=:deptId").setLong("deptId", source.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            if (nrRooms > 0) {
                return true;
            }
            int nrLocations = ((Number)DepartmentDAO.getInstance().getSession().createQuery("select count(r) from NonUniversityLocation r where r.eventDepartment.uniqueId=:deptId").setLong("deptId", source.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            return nrLocations > 0;
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.StudentAccommodationEdit)
    public static class StudentAccommodationEdit
    extends StudentAccommodations {
    }

    @PermissionForRight(value=Right.StudentGroupEdit)
    public static class StudentGroupEdit
    extends StudentGroups {
    }

    @PermissionForRight(value=Right.MinorEdit)
    public static class MinorEdit
    extends MajorEdit {
    }

    @PermissionForRight(value=Right.MajorEdit)
    public static class MajorEdit
    extends Majors {
    }

    @PermissionForRight(value=Right.AcademicClassificationEdit)
    public static class AcademicClassificationEdit
    extends AcademicClassifications {
    }

    @PermissionForRight(value=Right.AcademicAreaEdit)
    public static class AcademicAreaEdit
    extends AcademicAreas {
    }

    @PermissionForRight(value=Right.StudentAccommodations)
    public static class StudentAccommodations
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.StudentGroups)
    public static class StudentGroups
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.Minors)
    public static class Minors
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.Majors)
    public static class Majors
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.AcademicClassifications)
    public static class AcademicClassifications
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.AcademicAreas)
    public static class AcademicAreas
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.PointInTimeDataReports)
    public static class PointInTimeDataReports
    extends SimpleSessionPermission {
        public boolean check(UserContext user, Session session, DepartmentStatusType.Status ... status) {
            if (!super.check(user, session, status)) {
                return false;
            }
            return !PointInTimeData.findAllForSession(session).isEmpty();
        }
    }

    @PermissionForRight(value=Right.HQLReportsAdminOnly)
    public static class HQLReportsAdminOnly
    extends HQLReports {
    }

    @PermissionForRight(value=Right.HQLReportsAdministration)
    public static class HQLReportsAdministration
    extends HQLReports {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && (user.getCurrentAuthority().hasRight(Right.HQLReportAdd) || SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_ADMINISTRATION, user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly)));
        }
    }

    @PermissionForRight(value=Right.HQLReportsStudents)
    public static class HQLReportsStudents
    extends HQLReports {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_SECTIONING, user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly));
        }
    }

    @PermissionForRight(value=Right.HQLReportsEvents)
    public static class HQLReportsEvents
    extends HQLReports {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EVENTS, user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly));
        }
    }

    @PermissionForRight(value=Right.HQLReportsExaminations)
    public static class HQLReportsExaminations
    extends HQLReports {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EXAMS, user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly));
        }
    }

    @PermissionForRight(value=Right.HQLReportsCourses)
    public static class HQLReportsCourses
    extends HQLReports {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_COURSES, user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly));
        }
    }

    @PermissionForRight(value=Right.HQLReportDelete)
    public static class HQLReportDelete
    extends HQLReportEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.HQLReportEdit)
    public static class HQLReportEdit
    implements Permission<SavedHQL> {
        @Override
        public boolean check(UserContext user, SavedHQL source) {
            if (source.isSet(SavedHQL.Flag.ADMIN_ONLY)) {
                return user.getCurrentAuthority().hasRight(Right.HQLReportsAdminOnly);
            }
            return true;
        }

        @Override
        public Class<SavedHQL> type() {
            return SavedHQL.class;
        }
    }

    @PermissionForRight(value=Right.HQLReportAdd)
    public static class HQLReportAdd
    extends HQLReports {
    }

    @PermissionForRight(value=Right.HQLReports)
    public static class HQLReports
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.DistributionTypeEdit)
    public static class DistributionTypeEdit
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.SponsoringOrganizationDelete)
    public static class SponsoringOrganizationDelete
    extends SponsoringOrganizationEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.SponsoringOrganizationEdit)
    public static class SponsoringOrganizationEdit
    implements Permission<SponsoringOrganization> {
        @Autowired
        Permission<Session> permissionSession;

        @Override
        public boolean check(UserContext user, SponsoringOrganization source) {
            return true;
        }

        @Override
        public Class<SponsoringOrganization> type() {
            return SponsoringOrganization.class;
        }
    }

    @PermissionForRight(value=Right.InstructionalTypeDelete)
    public static class InstructionalTypeDelete
    extends InstructionalTypeEdit {
        public boolean check(UserContext user, ItypeDesc source) {
            int nrUsed = ((Number)ItypeDescDAO.getInstance().getSession().createQuery("select count(s) from SchedulingSubpart s where s.itype.itype=:itype").setInteger("itype", source.getItype().intValue()).setCacheable(true).uniqueResult()).intValue();
            int nrChildren = ((Number)ItypeDescDAO.getInstance().getSession().createQuery("select count(i) from ItypeDesc i where i.parent.itype=:itype").setInteger("itype", source.getItype().intValue()).setCacheable(true).uniqueResult()).intValue();
            return nrUsed == 0 && nrChildren == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructionalTypeEdit)
    public static class InstructionalTypeEdit
    implements Permission<ItypeDesc> {
        @Override
        public boolean check(UserContext user, ItypeDesc source) {
            return true;
        }

        @Override
        public Class<ItypeDesc> type() {
            return ItypeDesc.class;
        }
    }

    @PermissionForRight(value=Right.LastChanges)
    public static class LastChanges
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.SubjectAreaChangeDepartment)
    public static class SubjectAreaChangeDepartment
    extends SubjectAreaEdit {
        public boolean check(UserContext user, SubjectArea source) {
            if (!super.check(user, source)) {
                return false;
            }
            return !source.hasOfferedCourses() || source.getDepartment() == null || source.getDepartment().getSolverGroup() == null || source.getDepartment().getSolverGroup().getSolutions() == null || source.getDepartment().getSolverGroup().getSolutions().isEmpty();
        }
    }

    @PermissionForRight(value=Right.SubjectAreaDelete)
    public static class SubjectAreaDelete
    extends SubjectAreaEdit {
        public boolean check(UserContext user, SubjectArea source) {
            if (!super.check(user, source)) {
                return false;
            }
            return !source.hasOfferedCourses();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.SubjectAreaEdit)
    public static class SubjectAreaEdit
    implements Permission<SubjectArea> {
        @Autowired
        Permission<Session> permissionSession;

        @Override
        public boolean check(UserContext user, SubjectArea source) {
            return this.permissionSession.check(user, source.getSession());
        }

        @Override
        public Class<SubjectArea> type() {
            return SubjectArea.class;
        }
    }

    @PermissionForRight(value=Right.SubjectAreaAdd)
    public static class SubjectAreaAdd
    extends SubjectAreas {
    }

    @PermissionForRight(value=Right.SubjectAreas)
    public static class SubjectAreas
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.SolverGroups)
    public static class SolverGroups
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.TimetableManagerDelete)
    public static class TimetableManagerDelete
    extends TimetableManagerEdit {
        public boolean check(UserContext user, TimetableManager source) {
            for (Department d : source.getDepartments()) {
                if (this.permissionSession.check(user, d.getSession())) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.TimetableManagerEdit)
    public static class TimetableManagerEdit
    implements Permission<TimetableManager> {
        @Autowired
        Permission<Session> permissionSession;

        @Override
        public boolean check(UserContext user, TimetableManager source) {
            for (Department d : source.getDepartments()) {
                if (!d.getSessionId().equals(user.getCurrentAcademicSessionId())) continue;
                return this.permissionSession.check(user, d.getSession());
            }
            return true;
        }

        @Override
        public Class<TimetableManager> type() {
            return TimetableManager.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AcademicSessionDelete)
    public static class AcademicSessionDelete
    implements Permission<Session> {
        @Autowired
        Permission<Session> permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source)) {
                return false;
            }
            return source.getStatusType() == null || !source.getStatusType().isActive() || source.getStatusType().isTestSession();
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.AcademicSessionEdit)
    public static class AcademicSessionEdit
    extends SimpleSessionPermission {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmentEditChangeExternalManager)
    public static class DepartmentEditChangeExternalManager
    implements Permission<Department> {
        @Autowired
        Permission<Department> permissionDepartmentEdit;

        @Override
        public boolean check(UserContext user, Department source) {
            if (!this.permissionDepartmentEdit.check(user, source)) {
                return false;
            }
            if (source.isExternalManager().booleanValue()) {
                int nrExtManaged = ((Number)DepartmentDAO.getInstance().getSession().createQuery("select count(c) from Class_ c where c.managingDept.uniqueId=:deptId").setLong("deptId", source.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
                return nrExtManaged == 0;
            }
            return source.getSubjectAreas().isEmpty();
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmentDelete)
    public static class DepartmentDelete
    implements Permission<Department> {
        @Autowired
        Permission<Department> permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            if (!this.permissionDepartment.check(user, source)) {
                return false;
            }
            if (source.getSolverGroup() != null) {
                return false;
            }
            int nrOffered = ((Number)DepartmentDAO.getInstance().getSession().createQuery("select count(io) from CourseOffering co inner join co.instructionalOffering io where co.subjectArea.department.uniqueId=:deptId and io.notOffered = 0").setLong("deptId", source.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            return nrOffered == 0;
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.DepartmentLimitedEdit)
    public static class DepartmentEditControllingDepartmentStatuses
    extends DepartmentEdit {
        public boolean check(UserContext user, Department source) {
            return super.check(user, source) && source.isExternalManager() != false;
        }
    }

    @PermissionForRight(value=Right.DepartmentEdit)
    public static class DepartmentEdit
    extends SimpleDepartmentPermission {
    }

    @PermissionForRight(value=Right.DepartmentAdd)
    public static class DepartmentAdd
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.Departments)
    public static class Departments
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.SessionRollForward)
    public static class SessionRollForward
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.DataExchange)
    public static class DataExchange
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.ExaminationPeriods)
    public static class ExaminationPeriods
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.TimePatterns)
    public static class TimePatterns
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.DatePatterns)
    public static class DatePatterns
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.Chameleon)
    public static class Chameleon
    extends SimpleSessionPermission {
    }
}

