/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class HttpSessionContext
implements SessionContext {
    @Autowired
    private HttpSession iSession;
    @Autowired
    PermissionCheck unitimePermissionCheck;

    public HttpSessionContext() {
    }

    public HttpSessionContext(HttpSession session) {
        this.iSession = session;
        this.unitimePermissionCheck = (PermissionCheck)SpringApplicationContextHolder.getBean("unitimePermissionCheck");
    }

    public Object getAttribute(String name) {
        return this.iSession.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.iSession.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.iSession.setAttribute(name, value);
    }

    public void removeAttribute(SessionAttribute attribute) {
        this.removeAttribute(attribute.key());
    }

    public void setAttribute(SessionAttribute attribute, Object value) {
        this.setAttribute(attribute.key(), value);
    }

    public Object getAttribute(SessionAttribute attribute) {
        Object value = this.getAttribute(attribute.key());
        return value != null ? value : attribute.defaultValue();
    }

    public boolean isHttpSessionNew() {
        return this.iSession.isNew();
    }

    public UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.getUser() != null;
    }

    public String getHttpSessionId() {
        try {
            return this.iSession.getId();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public void checkPermission(Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), null, null, right);
    }

    public void checkPermission(Serializable targetId, String targetType, Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetId, targetType, right);
    }

    public void checkPermission(Object targetObject, Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetObject, right);
    }

    public boolean hasPermission(Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), null, null, right);
    }

    public boolean hasPermission(Serializable targetId, String targetType, Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetId, targetType, right);
    }

    public boolean hasPermission(Object targetObject, Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetObject, right);
    }

    public void checkPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    public void checkPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    public void checkPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }

    public static SessionContext getSessionContext(ServletContext context) {
        return (SessionContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)context).getBean("sessionContext");
    }
}

