/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEByDayOfWeekAndPeriod
extends BasePointInTimeDataReports {
    private ArrayList<Long> iDepartmentIds;
    private ArrayList<Long> iSubjectAreaIds;
    private ArrayList<Long> iRoomTypeIds;
    private ArrayList<Long> iPositionTypeIds;
    private Integer iMinimumLocationCapacity;
    private Integer iMaximumLocationCapacity;
    private HashMap<String, PeriodEnrollment> periodEnrollmentMap = new HashMap();

    public static String dayOfWeekTimeLabelFor(Date date) {
        return Localization.getDateFormat("EEEE, HH:mm").format(date);
    }

    public WSEByDayOfWeekAndPeriod() {
        this.getParameters().add(BasePointInTimeDataReports.Parameter.DEPARTMENTS);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.SUBJECTS);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.RoomTypes);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.PositionTypes);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.MINIMUM_LOCATION_CAPACITY);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.MAXIMUM_LOCATION_CAPACITY);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDayOfWeek());
        hdr.add(MSG.columnPeriod());
        hdr.add(MSG.columnOrganizedWeeklyStudentEnrollmentPerPeriod());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentEnrollmentPerPeriod());
        hdr.add(MSG.columnWeeklyStudentEnrollmentPerPeriod());
        this.setHeader(hdr);
    }

    @Override
    public String reportName() {
        return MSG.wseByDayOfWeekAndPeriodReport();
    }

    @Override
    public String reportDescription() {
        return MSG.wseByDayOfWeekAndPeriodReportNote();
    }

    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> validRoomPermanentIds = new HashSet<Long>();
        for (Location l : pointInTimeData.getSession().getRooms()) {
            if (!this.getRoomTypeIds().contains(l.getRoomType().getUniqueId()) || l.getCapacity() > this.getMaximumLocationCapacity() || l.getCapacity() < this.getMinimumLocationCapacity()) continue;
            validRoomPermanentIds.add(l.getPermanentId());
        }
        ArrayList<Long> positionIds = null;
        if (BasePointInTimeDataReports.Parameter.PositionTypes.values(null).size() != this.getPositionTypeIds().size()) {
            positionIds = this.getPositionTypeIds();
        }
        HashSet<Long> revisedDepartmentIds = new HashSet<Long>();
        block1: for (Department department : pointInTimeData.getSession().getDepartments()) {
            if (!this.getDepartmentIds().contains(department.getUniqueId())) continue;
            for (SubjectArea subjectArea : department.getSubjectAreas()) {
                if (!this.getSubjectAreaIds().contains(subjectArea.getUniqueId())) continue;
                revisedDepartmentIds.add(department.getUniqueId());
                continue block1;
            }
        }
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (Long deptId : revisedDepartmentIds) {
            for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, deptId, hibSession)) {
                for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                    if (processedClasses.contains(pc.getUniqueId())) continue;
                    processedClasses.add(pc.getUniqueId());
                    if (!this.getSubjectAreaIds().contains(pc.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getControllingPitCourseOffering().getSubjectArea().getUniqueId())) continue;
                    HashMap<Date, Float> datePeriodEnrollments = pc.findPeriodEnrollmentsForCriteria(validRoomPermanentIds, positionIds);
                    for (Date date : datePeriodEnrollments.keySet()) {
                        String label = WSEByDayOfWeekAndPeriod.dayOfWeekTimeLabelFor(date);
                        PeriodEnrollment pe = this.periodEnrollmentMap.get(label);
                        if (pe == null) {
                            pe = new PeriodEnrollment(date, this.getStandardWeeksInReportingTerm());
                            this.periodEnrollmentMap.put(label, pe);
                        }
                        pe.addEnrollment(pc, datePeriodEnrollments.get(date));
                    }
                }
            }
        }
        TreeSet<PeriodEnrollment> treeSet = new TreeSet<PeriodEnrollment>();
        treeSet.addAll(this.periodEnrollmentMap.values());
        for (PeriodEnrollment periodEnrollment : treeSet) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(periodEnrollment.getDayOfWeekLabel());
            row.add(periodEnrollment.getTimeLabel());
            row.add(Float.toString(periodEnrollment.getOrganizedWeeklyStudentEnrollment()));
            row.add(Float.toString(periodEnrollment.getNotOrganizedWeeklyStudentEnrollment()));
            row.add(Float.toString(periodEnrollment.getWeeklyStudentEnrollment()));
            this.addDataRow(row);
        }
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS).size() >= 1) {
            this.setDepartmentIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.SUBJECTS).size() >= 1) {
            this.setSubjectAreaIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.SUBJECTS));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.PositionTypes).size() >= 1) {
            this.setPositionTypeIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.PositionTypes));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.RoomTypes).size() >= 1) {
            this.setRoomTypeIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.RoomTypes));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.MINIMUM_LOCATION_CAPACITY).size() == 1) {
            this.setMinimumLocationCapacity((Integer)this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.MINIMUM_LOCATION_CAPACITY).get(0));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.MAXIMUM_LOCATION_CAPACITY).size() == 1) {
            this.setMaximumLocationCapacity((Integer)this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.MAXIMUM_LOCATION_CAPACITY).get(0));
        }
    }

    public ArrayList<Long> getPositionTypeIds() {
        return this.iPositionTypeIds;
    }

    public void setPositionTypeIds(ArrayList<Object> positionTypeIds) {
        this.iPositionTypeIds = new ArrayList();
        for (Object o : positionTypeIds) {
            this.iPositionTypeIds.add((Long)o);
        }
    }

    public ArrayList<Long> getSubjectAreaIds() {
        return this.iSubjectAreaIds;
    }

    public void setSubjectAreaIds(ArrayList<Object> subjectAreaIds) {
        this.iSubjectAreaIds = new ArrayList();
        for (Object o : subjectAreaIds) {
            this.iSubjectAreaIds.add((Long)o);
        }
    }

    public Integer getMinimumLocationCapacity() {
        return this.iMinimumLocationCapacity;
    }

    public void setMinimumLocationCapacity(Integer minimumLocationCapacity) {
        this.iMinimumLocationCapacity = minimumLocationCapacity;
    }

    public Integer getMaximumLocationCapacity() {
        return this.iMaximumLocationCapacity;
    }

    public void setMaximumLocationCapacity(Integer maximumLocationCapacity) {
        this.iMaximumLocationCapacity = maximumLocationCapacity;
    }

    @Override
    protected void runReport(Session hibSession) {
        PointInTimeData pitd = (PointInTimeData)hibSession.createQuery("from PointInTimeData pitd where pitd.uniqueId = :uid").setLong("uid", this.getPointInTimeDataUniqueId().longValue()).uniqueResult();
        this.createRoomUtilizationReportFor(pitd, hibSession);
    }

    public ArrayList<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(ArrayList<Object> departmentIds) {
        this.iDepartmentIds = new ArrayList();
        for (Object o : departmentIds) {
            this.iDepartmentIds.add((Long)o);
        }
    }

    public ArrayList<Long> getRoomTypeIds() {
        return this.iRoomTypeIds;
    }

    public void setRoomTypeIds(ArrayList<Object> roomTypeIds) {
        this.iRoomTypeIds = new ArrayList();
        for (Object o : roomTypeIds) {
            this.iRoomTypeIds.add((Long)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PeriodEnrollment
    implements Comparable<PeriodEnrollment> {
        private float iWeeklyStudentEnrollment = 0.0f;
        private float iOrganizedWeeklyStudentEnrollment = 0.0f;
        private float iNotOrganizedWeeklyStudentEnrollment = 0.0f;
        private Date iPeriod;
        private Float iStandardWeeksInReportingTerm;
        private int iDayOfWeek;
        private int iHourOfDay;
        private int iMinute;

        public Date getPeriod() {
            return this.iPeriod;
        }

        public int getDayOfWeek() {
            return this.iDayOfWeek;
        }

        public int getHourOfDay() {
            return this.iHourOfDay;
        }

        public int getMinute() {
            return this.iMinute;
        }

        public float getOrganizedWeeklyStudentEnrollment() {
            return this.iOrganizedWeeklyStudentEnrollment;
        }

        public float getNotOrganizedWeeklyStudentEnrollment() {
            return this.iNotOrganizedWeeklyStudentEnrollment;
        }

        public float getWeeklyStudentEnrollment() {
            return this.iWeeklyStudentEnrollment;
        }

        public String getDayOfWeekLabel() {
            return Localization.getDateFormat("EEEE").format(this.getPeriod());
        }

        public String getTimeLabel() {
            return Localization.getDateFormat("HH:mm").format(this.getPeriod());
        }

        public PeriodEnrollment(Date period, Float standardWeeksInReportingTerm) {
            this.iPeriod = period;
            this.iStandardWeeksInReportingTerm = standardWeeksInReportingTerm;
            Calendar cal = Calendar.getInstance();
            cal.setTime(period);
            this.iDayOfWeek = cal.get(7);
            this.iHourOfDay = cal.get(11);
            this.iMinute = cal.get(12);
        }

        public void addEnrollment(PitClass pitClass, Float enrollment) {
            this.iWeeklyStudentEnrollment += enrollment.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
            if (pitClass.isOrganized()) {
                this.iOrganizedWeeklyStudentEnrollment += enrollment.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
            } else {
                this.iNotOrganizedWeeklyStudentEnrollment += enrollment.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
            }
        }

        @Override
        public int compareTo(PeriodEnrollment o) {
            if (this.iDayOfWeek == o.getDayOfWeek()) {
                if (this.iHourOfDay == o.getHourOfDay()) {
                    if (this.iMinute == o.getMinute()) {
                        return 0;
                    }
                    if (this.iMinute < o.getMinute()) {
                        return -1;
                    }
                    return 1;
                }
                if (this.iHourOfDay < o.getHourOfDay()) {
                    return -1;
                }
                return 1;
            }
            if (this.iDayOfWeek < o.getDayOfWeek()) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof PeriodEnrollment) {
                PeriodEnrollment pe2 = (PeriodEnrollment)o;
                return 0 == this.compareTo(pe2);
            }
            return false;
        }
    }
}

