/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.WSCHByDayOfWeekAndHourOfDay;

public class WSCHByItypeDayOfWeekHourOfDay
extends WSCHByDayOfWeekAndHourOfDay {
    public String reportName() {
        return MSG.wseByItypeDayOfWeekAndHourOfDayReport();
    }

    public String reportDescription() {
        return MSG.wseByItypeDayOfWeekAndHourOfDayReportNote();
    }

    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnItype());
        hdr.add(MSG.columnOrganized());
        hdr.add(MSG.columnDayOfWeek());
        this.addTimeColumns(hdr);
        this.setHeader(hdr);
    }

    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        this.calculatePeriodsWithEnrollments(pointInTimeData, hibSession);
        int minute = this.startOnHalfHour ? 30 : 0;
        for (ItypeDesc itype : ItypeDesc.findAll(true)) {
            for (int dayOfWeek = 1; dayOfWeek < 8; ++dayOfWeek) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(itype.getDesc());
                row.add(itype.getOrganized().toString());
                row.add(this.getDayOfWeekLabel(this.periodDayOfWeek(dayOfWeek)));
                for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
                    String key = this.getPeriodTag(itype.getAbbv(), dayOfWeek, hourOfDay, minute);
                    row.add(this.periodEnrollmentMap.get(key) == null ? "0" : "" + ((WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(key)).getWeeklyStudentEnrollment());
                }
                this.addDataRow(row);
            }
        }
    }

    private void calculatePeriodsWithEnrollments(PointInTimeData pointInTimeData, Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct pc.pitSchedulingSubpart.itype, pc").append("\tfrom PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append("\tinner join pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pitCourseOfferings as pco").append("\twhere pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :sessId").append(" and pco.subjectArea.uniqueId = :saId").append("\tand pco.isControl = true");
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (SubjectArea subjectArea : pointInTimeData.getSession().getSubjectAreas()) {
            for (Object[] result : hibSession.createQuery(sb.toString()).setLong("sessId", pointInTimeData.getUniqueId().longValue()).setLong("saId", subjectArea.getUniqueId().longValue()).setCacheable(true).list()) {
                ItypeDesc itype = (ItypeDesc)result[0];
                PitClass pc = (PitClass)result[1];
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                for (Date meetingPeriod : pc.getUniquePeriods()) {
                    String label = this.getPeriodTag(itype.getParent() == null ? itype.getAbbv() : itype.getParent().getAbbv(), meetingPeriod);
                    WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment pe = (WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(label);
                    if (pe == null) {
                        pe = new WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment(label, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        this.periodEnrollmentMap.put(label, pe);
                    }
                    pe.addEnrollment(pc.getEnrollment());
                }
            }
        }
    }
}

