/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.reports.pointintimedata.RoomUtilization;

public class RoomTypeUtilizationByDepartment
extends RoomUtilization {
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnRoomDepartmentCode());
        hdr.add(MSG.columnRoomDepartmentAbbreviation());
        hdr.add(MSG.columnRoomDepartmentName());
        hdr.add(MSG.columnRoomType());
        hdr.add(MSG.columnStationHours());
        hdr.add(MSG.columnOccupancy());
        hdr.add(MSG.columnOrganizedWeeklyRoomHours());
        hdr.add(MSG.columnNotOrganizedWeeklyRoomHours());
        hdr.add(MSG.columnWeeklyRoomHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    public String reportName() {
        return MSG.roomTypeUtilizationByDepartmentReport();
    }

    public String reportDescription() {
        return MSG.roomTypeUtilizationByDepartmentReportNote();
    }

    private void addRowForDepartmentRoomType(DepartmentRoomTypeHours departmentRoomTypeHours) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(departmentRoomTypeHours.getDepartment() == null ? "" : departmentRoomTypeHours.getDepartment().getDeptCode());
        row.add(departmentRoomTypeHours.getDepartment() == null ? "" : departmentRoomTypeHours.getDepartment().getAbbreviation());
        row.add(departmentRoomTypeHours.getDepartment() == null ? "" : departmentRoomTypeHours.getDepartment().getName());
        row.add(departmentRoomTypeHours.getRoomType().getLabel());
        row.add(Float.toString(departmentRoomTypeHours.getStationHours()));
        row.add(Float.toString(departmentRoomTypeHours.getOccupancy()));
        row.add(Float.toString(departmentRoomTypeHours.getOrganizedWeeklyRoomHours()));
        row.add(Float.toString(departmentRoomTypeHours.getNotOrganizedWeeklyRoomHours()));
        row.add(Float.toString(departmentRoomTypeHours.getWeeklyRoomHours()));
        row.add(Float.toString(departmentRoomTypeHours.getOrganizedWeeklyStudentClassHours()));
        row.add(Float.toString(departmentRoomTypeHours.getNotOrganizedWeeklyStudentClassHours()));
        row.add(Float.toString(departmentRoomTypeHours.getWeeklyStudentClassHours()));
        this.addDataRow(row);
    }

    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashMap<Long, RoomUtilization.LocationHours> locationUtilization = new HashMap<Long, RoomUtilization.LocationHours>();
        HashSet<Long> processedClassIds = new HashSet<Long>();
        for (Long deptId : this.getDepartmentIds()) {
            for (PitClass pc : this.findAllPitClassesWithContactHoursForRoomDepartmentAndRoomTypes(deptId, pointInTimeData, hibSession)) {
                if (processedClassIds.contains(pc.getUniqueId())) continue;
                processedClassIds.add(pc.getUniqueId());
                for (Long locationPermanentId : pc.getLocationPermanentIdList()) {
                    RoomUtilization.LocationHours lh = (RoomUtilization.LocationHours)locationUtilization.get(locationPermanentId);
                    if (lh == null) {
                        lh = new RoomUtilization.LocationHours(this, locationPermanentId, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        locationUtilization.put(locationPermanentId, lh);
                    }
                    lh.addRoomHours(pc);
                }
            }
        }
        HashMap departmentRoomTypeHours = new HashMap();
        HashSet<Location> locations = new HashSet<Location>();
        if (pointInTimeData.getSession().getRooms() != null && !pointInTimeData.getSession().getRooms().isEmpty()) {
            locations.addAll(pointInTimeData.getSession().getRooms());
            for (Location l : locations) {
                DepartmentRoomTypeHours drth;
                RoomUtilization.LocationHours lh = (RoomUtilization.LocationHours)locationUtilization.get(l.getPermanentId());
                if (lh == null || (l.getControllingDepartment() == null || !this.getDepartmentIds().contains(l.getControllingDepartment().getUniqueId()) || !this.getRoomTypeIds().contains(l.getRoomType().getUniqueId())) && (l.getControllingDepartment() != null || !this.getRoomTypeIds().contains(l.getRoomType().getUniqueId()))) continue;
                HashMap<RoomType, DepartmentRoomTypeHours> rth = (HashMap<RoomType, DepartmentRoomTypeHours>)departmentRoomTypeHours.get(l.getControllingDepartment());
                if (rth == null) {
                    rth = new HashMap<RoomType, DepartmentRoomTypeHours>();
                    departmentRoomTypeHours.put(l.getControllingDepartment(), rth);
                }
                if ((drth = (DepartmentRoomTypeHours)rth.get(l.getRoomType())) == null) {
                    drth = new DepartmentRoomTypeHours(l.getControllingDepartment(), l.getRoomType());
                    rth.put(l.getRoomType(), drth);
                }
                drth.addRoomHours(l, lh);
            }
        }
        for (Department d : departmentRoomTypeHours.keySet()) {
            for (RoomType rt : ((HashMap)departmentRoomTypeHours.get(d)).keySet()) {
                this.addRowForDepartmentRoomType((DepartmentRoomTypeHours)((HashMap)departmentRoomTypeHours.get(d)).get(rt));
            }
        }
    }

    protected void runReport(Session hibSession) {
        PointInTimeData pitd = (PointInTimeData)hibSession.createQuery("from PointInTimeData pitd where pitd.uniqueId = :uid").setLong("uid", this.getPointInTimeDataUniqueId().longValue()).uniqueResult();
        this.createRoomUtilizationReportFor(pitd, hibSession);
    }

    private class DepartmentRoomTypeHours {
        private float iWeeklyRoomHours = 0.0f;
        private float iOrganizedWeeklyRoomHours = 0.0f;
        private float iNotOrganizedWeeklyRoomHours = 0.0f;
        private float iWeeklyStudentClassHours = 0.0f;
        private float iOrganizedWeeklyStudentClassHours = 0.0f;
        private float iNotOrganizedWeeklyStudentClassHours = 0.0f;
        private float iStationHours = 0.0f;
        private RoomType iRoomType;
        private Department iDepartment;

        public RoomType getRoomType() {
            return this.iRoomType;
        }

        public Department getDepartment() {
            return this.iDepartment;
        }

        public float getOrganizedWeeklyStudentClassHours() {
            return this.iOrganizedWeeklyStudentClassHours;
        }

        public float getNotOrganizedWeeklyStudentClassHours() {
            return this.iNotOrganizedWeeklyStudentClassHours;
        }

        public float getWeeklyStudentClassHours() {
            return this.iWeeklyStudentClassHours;
        }

        public float getWeeklyRoomHours() {
            return this.iWeeklyRoomHours;
        }

        public float getOrganizedWeeklyRoomHours() {
            return this.iOrganizedWeeklyRoomHours;
        }

        public float getNotOrganizedWeeklyRoomHours() {
            return this.iNotOrganizedWeeklyRoomHours;
        }

        public float getStationHours() {
            return this.iStationHours;
        }

        public float getOccupancy() {
            return this.getWeeklyStudentClassHours() / this.getStationHours();
        }

        public DepartmentRoomTypeHours(Department department, RoomType roomType) {
            this.iDepartment = department;
            this.iRoomType = roomType;
        }

        public void addRoomHours(Location location, RoomUtilization.LocationHours locationHours) {
            this.iStationHours += (float)location.getCapacity().intValue() * locationHours.getWeeklyRoomHours();
            this.iWeeklyRoomHours += locationHours.getWeeklyRoomHours();
            this.iOrganizedWeeklyRoomHours += locationHours.getOrganizedWeeklyRoomHours();
            this.iNotOrganizedWeeklyRoomHours += locationHours.getNotOrganizedWeeklyRoomHours();
            this.iWeeklyStudentClassHours += locationHours.getWeeklyStudentClassHours();
            this.iOrganizedWeeklyStudentClassHours += locationHours.getOrganizedWeeklyStudentClassHours();
            this.iNotOrganizedWeeklyStudentClassHours += locationHours.getNotOrganizedWeeklyStudentClassHours();
        }
    }
}

