/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.solver.TimetableDatabaseLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ReloadAllData
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Throwable throwable2;
        Boolean bl;
        OnlineSectioningServer.Lock lock = server.lockAll();
        helper.beginTransaction();
        try {
            helper.info("Updating course infos and the student sectining model for session " + server.getAcademicSession());
            long t0 = System.currentTimeMillis();
            server.clearAll();
            Hashtable<Long, ArrayList<XDistribution>> distributions = new Hashtable<Long, ArrayList<XDistribution>>();
            List distPrefs = helper.getHibSession().createQuery("select p from DistributionPref p, Department d where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and p.owner = d and p.prefLevel.prefProlog = :pref").setString("ref1", GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setString("ref2", "NO_CONFLICT").setString("pref", PreferenceLevel.sRequired).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            if (!distPrefs.isEmpty()) {
                for (DistributionPref pref : distPrefs) {
                    int variant = 0;
                    for (Collection<Class_> collection : ReloadAllData.getSections(pref)) {
                        XDistributionType type = XDistributionType.IngoreConflicts;
                        if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                            type = XDistributionType.LinkedSections;
                        }
                        XDistribution distribution = new XDistribution(type, pref.getUniqueId(), variant++, collection);
                        for (Long offeringId : distribution.getOfferingIds()) {
                            ArrayList<XDistribution> list = (ArrayList<XDistribution>)distributions.get(offeringId);
                            if (list == null) {
                                list = new ArrayList<XDistribution>();
                                distributions.put(offeringId, list);
                            }
                            list.add(distribution);
                        }
                    }
                }
            }
            HashMap<Long, Object> offeringMap = new HashMap<Long, Object>();
            HashMap<Long, XSection> sectionMap = new HashMap<Long, XSection>();
            HashMap spaceMap = new HashMap();
            List offerings = helper.getHibSession().createQuery("select distinct io from InstructionalOffering io left join fetch io.courseOfferings co left join fetch io.instrOfferingConfigs cf left join fetch cf.schedulingSubparts ss left join fetch ss.classes c left join fetch c.assignments a left join fetch a.rooms r left join fetch c.classInstructors i left join fetch io.reservations x left join fetch co.creditConfigs cc left join fetch ss.creditConfigs sc inner join io.courseOfferings cox where io.session.uniqueId = :sessionId and io.notOffered = false and cox.subjectArea.department.allowStudentScheduling = true").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            for (InstructionalOffering io : offerings) {
                XOffering offering = ReloadAllData.loadOffering(io, (List)distributions.get(io.getUniqueId()), server, helper);
                if (offering == null) continue;
                offeringMap.put(offering.getOfferingId(), offering);
                for (XConfig config : offering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sectionMap.put(section.getSectionId(), section);
                        }
                    }
                }
                spaceMap.put(offering.getOfferingId(), new HashMap());
                server.update(offering);
            }
            HashMap<Long, List<XCourseRequest>> hashMap = new HashMap<Long, List<XCourseRequest>>();
            List students = helper.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where s.session.uniqueId=:sessionId").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            for (Object student : students) {
                XStudent s = ReloadAllData.loadStudent((Student)student, hashMap, server, helper);
                if (s == null) continue;
                server.update(s, true);
            }
            List infos = helper.getHibSession().createQuery("select i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId, i.clazz.uniqueId, i.nbrExpectedStudents from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            for (Object[] info : infos) {
                Long offeringId = (Long)info[0];
                Long sectionId = (Long)info[1];
                Double expected = (Double)info[2];
                Map space = (Map)spaceMap.get(offeringId);
                if (space == null) continue;
                space.put(sectionId, expected);
            }
            for (Map.Entry entry : spaceMap.entrySet()) {
                server.update(new XExpectations((Long)entry.getKey(), (Map)entry.getValue()));
            }
            long t1 = System.currentTimeMillis();
            helper.info("  Update of session " + server.getAcademicSession() + " done " + new DecimalFormat("0.0").format((double)(t1 - t0) / 1000.0) + " seconds.");
            helper.commitTransaction();
            bl = true;
        }
        catch (Exception e) {
            try {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
            catch (Throwable throwable2) {
                Object var22_26 = null;
                lock.release();
            }
        }
        Object var22_25 = null;
        lock.release();
        return bl;
        throw throwable2;
    }

    public static XOffering loadOffering(InstructionalOffering io, List<XDistribution> distributions, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (io.getInstrOfferingConfigs().isEmpty() || io.isNotOffered().booleanValue()) {
            return null;
        }
        return new XOffering(io, distributions, helper);
    }

    public static XStudent loadStudent(Student s, Map<Long, List<XCourseRequest>> requestMap, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student = new XStudent(s, helper, server.getAcademicSession().getFreeTimePattern());
        Iterator<XRequest> i = student.getRequests().iterator();
        while (i.hasNext()) {
            XRequest request = i.next();
            if (!(request instanceof XCourseRequest)) continue;
            HashMap<XSection, XEnrollment> checked = new HashMap<XSection, XEnrollment>();
            XCourseRequest courseRequest = (XCourseRequest)request;
            Iterator<XCourseId> j = courseRequest.getCourseIds().iterator();
            while (j.hasNext()) {
                XCourseId course = j.next();
                XOffering offering = server.getOffering(course.getOfferingId());
                if (offering != null) continue;
                helper.warn("Student " + helper.getStudentNameFormat().format(s) + " (" + s.getExternalUniqueId() + ") requests course " + course.getCourseName() + " that is not loaded.");
                j.remove();
            }
            if (courseRequest.getCourseIds().isEmpty()) {
                i.remove();
                continue;
            }
            XEnrollment enrollment = courseRequest.getEnrollment();
            if (enrollment == null) continue;
            XOffering offering = server.getOffering(enrollment.getOfferingId());
            if (!offering.getReservations().isEmpty()) {
                if (requestMap != null) {
                    List<XCourseRequest> assigned = requestMap.get(enrollment.getOfferingId());
                    if (assigned == null) {
                        assigned = new ArrayList<XCourseRequest>();
                        requestMap.put(enrollment.getOfferingId(), assigned);
                    }
                    enrollment.setReservation(offering.guessReservation(assigned, student, enrollment));
                    assigned.add(courseRequest);
                } else {
                    enrollment.setReservation(offering.guessReservation(server.getRequests(enrollment.getOfferingId()), student, enrollment));
                }
            }
            boolean mixedConfig = false;
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    int nrMatches = 0;
                    for (XSection section : subpart.getSections()) {
                        if (!enrollment.getSectionIds().contains(section.getSectionId())) continue;
                        for (XSection other : checked.keySet()) {
                            if (!section.isOverlapping(offering.getDistributions(), other)) continue;
                            helper.warn("There is a problem assigning " + enrollment.getCourseName() + " to " + helper.getStudentNameFormat().format(s) + " (" + s.getExternalUniqueId() + "): " + section.getSubpartName() + " " + section.getName() + " " + section.getTime() + " overlaps with " + ((XEnrollment)checked.get(other)).getCourseName() + " " + other.getSubpartName() + " " + other.getName() + " " + other.getTime());
                        }
                        if (!mixedConfig && !config.getConfigId().equals(enrollment.getConfigId())) {
                            helper.warn("There is a problem assigning " + enrollment.getCourseName() + " to " + helper.getStudentNameFormat().format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                            mixedConfig = true;
                        }
                        checked.put(section, enrollment);
                        ++nrMatches;
                    }
                    if (!config.getConfigId().equals(enrollment.getConfigId()) || nrMatches == true) continue;
                    if (nrMatches > 1) {
                        helper.warn("There is a problem assigning " + enrollment.getCourseName() + " to " + helper.getStudentNameFormat().format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart " + subpart.getName() + ".");
                        continue;
                    }
                    helper.warn("There is a problem assigning " + enrollment.getCourseName() + " to " + helper.getStudentNameFormat().format(s) + " (" + s.getExternalUniqueId() + "): no class of the subpart " + subpart.getName() + ".");
                }
            }
        }
        return student;
    }

    public static XStudent loadStudentNoCheck(Student s, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student = new XStudent(s, helper, server.getAcademicSession().getFreeTimePattern());
        for (XRequest request : student.getRequests()) {
            XOffering offering;
            XCourseRequest courseRequest;
            XEnrollment enrollment;
            if (!(request instanceof XCourseRequest) || (enrollment = (courseRequest = (XCourseRequest)request).getEnrollment()) == null || (offering = server.getOffering(enrollment.getOfferingId())) == null || offering.getReservations().isEmpty()) continue;
            enrollment.setReservation(offering.guessReservation(server.getRequests(enrollment.getOfferingId()), student, enrollment));
        }
        return student;
    }

    public static List<Collection<Class_>> getSections(DistributionPref pref) {
        ArrayList<Collection<Class_>> ret = new ArrayList<Collection<Class_>>();
        DistributionPref.Structure structure = pref.getStructure();
        if (structure == null) {
            structure = DistributionPref.Structure.AllClasses;
        }
        if (structure == DistributionPref.Structure.Progressive) {
            int maxSize = 0;
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    maxSize = Math.max(maxSize, 1);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                maxSize = Math.max(maxSize, ((SchedulingSubpart)distributionObject.getPrefGroup()).getClasses().size());
            }
            Set[] sections = new Set[maxSize];
            for (int i = 0; i < sections.length; ++i) {
                sections[i] = new HashSet();
            }
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(pref.getDistributionObjects());
            Collections.sort(distributionObjects, new TimetableDatabaseLoader.ChildrenFirstDistributionObjectComparator());
            for (DistributionObject distributionObject : distributionObjects) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ section = (Class_)distributionObject.getPrefGroup();
                    if (section == null) continue;
                    for (int j = 0; j < sections.length; ++j) {
                        sections[j].add(section);
                    }
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (int j = 0; j < sections.length; ++j) {
                    Class_ section = null;
                    block11: for (Class_ s : sections[j]) {
                        for (Class_ p = s.getParentClass(); p != null; p = p.getParentClass()) {
                            if (!p.getSchedulingSubpart().getUniqueId().equals(subpart.getUniqueId())) continue;
                            section = p;
                            break block11;
                        }
                    }
                    if (section == null) {
                        section = (Class_)classes.get(j % classes.size());
                    }
                    if (section == null) continue;
                    sections[j].add(section);
                }
            }
            for (Set s : sections) {
                ret.add(s);
            }
        } else if (structure == DistributionPref.Structure.OneOfEach) {
            ArrayList<Class_> sections = new ArrayList<Class_>();
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                int count = 0;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    sections.add(clazz);
                    ++count;
                } else if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    sections.addAll(classes);
                    count += classes.size();
                }
                if (count <= 0) continue;
                counts.add(count);
            }
            if (counts.size() > 1) {
                Enumeration e = DistributionPref.permutations(sections, counts);
                while (e.hasMoreElements()) {
                    ret.add(e.nextElement());
                }
            }
        } else {
            ArrayList<Class_> sections = new ArrayList<Class_>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    sections.add((Class_)distributionObject.getPrefGroup());
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                sections.addAll(classes);
            }
            if (structure == DistributionPref.Structure.Pairwise) {
                if (sections.size() >= 2) {
                    for (int idx1 = 0; idx1 < sections.size() - 1; ++idx1) {
                        Class_ s1 = (Class_)sections.get(idx1);
                        for (int idx2 = idx1 + 1; idx2 < sections.size(); ++idx2) {
                            Class_ s2 = (Class_)sections.get(idx2);
                            HashSet<Class_> s = new HashSet<Class_>();
                            s.add(s1);
                            s.add(s2);
                            ret.add(s);
                        }
                    }
                }
            } else if (structure == DistributionPref.Structure.AllClasses) {
                ret.add(sections);
            } else {
                int grouping = 2;
                switch (structure) {
                    case GroupsOfTwo: {
                        grouping = 2;
                        break;
                    }
                    case GroupsOfThree: {
                        grouping = 3;
                        break;
                    }
                    case GroupsOfFour: {
                        grouping = 4;
                        break;
                    }
                    case GroupsOfFive: {
                        grouping = 5;
                    }
                }
                ArrayList<Class_> s = new ArrayList<Class_>();
                for (Class_ section : sections) {
                    s.add(section);
                    if (s.size() != grouping) continue;
                    ret.add(s);
                    s = new ArrayList();
                }
                if (s.size() >= 2) {
                    ret.add(new HashSet(s));
                }
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return "reload-all";
    }

    public static interface SectionProvider {
        public XSection get(Class_ var1);
    }
}

