/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.cpsolver.studentsct.model.Course;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.model.CourseOffering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XCourseIdSerializer.class)
public class XCourseId
implements Serializable,
Comparable<XCourseId>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iOfferingId;
    private Long iCourseId;
    private String iCourseName;
    private String iTitle = null;
    private boolean iHasUniqueName = true;
    private String iType = null;

    public XCourseId() {
    }

    public XCourseId(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseId(CourseOffering course) {
        this.iOfferingId = course.getInstructionalOffering().getUniqueId();
        this.iCourseId = course.getUniqueId();
        this.iCourseName = course.getCourseName().trim();
        this.iTitle = course.getTitle() == null ? null : course.getTitle().trim();
        this.iType = course.getCourseType() == null ? null : course.getCourseType().getReference();
    }

    public XCourseId(Long offeringId, Long courseId, String courseName) {
        this.iOfferingId = offeringId;
        this.iCourseId = courseId;
        this.iCourseName = courseName;
    }

    public XCourseId(XCourseId course) {
        this.iOfferingId = course.getOfferingId();
        this.iCourseId = course.getCourseId();
        this.iCourseName = course.getCourseName();
        this.iTitle = course.getTitle();
        this.iType = course.getType();
    }

    public XCourseId(Course course) {
        this.iOfferingId = course.getOffering().getId();
        this.iCourseId = course.getId();
        this.iCourseName = course.getName();
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Long getCourseId() {
        return this.iCourseId;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public boolean hasType() {
        return this.iType != null && !this.iType.isEmpty();
    }

    public String getType() {
        return this.iType;
    }

    public String getCourseNameInLowerCase() {
        return this.getCourseName().toLowerCase();
    }

    public boolean hasUniqueName() {
        return this.iHasUniqueName;
    }

    public void setHasUniqueName(boolean hasUniqueName) {
        this.iHasUniqueName = hasUniqueName;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XCourseId)) {
            return false;
        }
        return this.getCourseId().equals(((XCourseId)o).getCourseId());
    }

    public int hashCode() {
        return (int)(this.getCourseId() ^ this.getCourseId() >>> 32);
    }

    public String toString() {
        return this.getCourseName();
    }

    @Override
    public int compareTo(XCourseId c) {
        int cmp = NaturalOrderComparator.getInstance().compare(this.getCourseName(), c.getCourseName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (this.getTitle() == null ? "" : this.getTitle()).compareToIgnoreCase(c.getTitle() == null ? "" : c.getTitle());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getCourseId() == null ? new Long(-1L) : this.getCourseId()).compareTo(c.getCourseId() == null ? -1L : c.getCourseId());
    }

    public boolean matchCourseName(String queryInLowerCase) {
        if (this.getCourseName().toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        if (this.getTitle() == null) {
            return false;
        }
        if ((this.getCourseName() + " " + this.getTitle()).toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        return (this.getCourseName() + " - " + this.getTitle()).toLowerCase().startsWith(queryInLowerCase);
    }

    public boolean matchTitle(String queryInLowerCase) {
        if (this.getTitle() == null) {
            return false;
        }
        return !this.matchCourseName(queryInLowerCase) && (this.getTitle().toLowerCase().startsWith(queryInLowerCase) || this.getTitle().toLowerCase().contains(" " + queryInLowerCase));
    }

    public boolean matchType(boolean allCourseTypes, boolean noCourseType, Set<String> allowedCourseTypes) {
        if (allCourseTypes) {
            return true;
        }
        if (this.hasType()) {
            return allowedCourseTypes != null && allowedCourseTypes.contains(this.getType());
        }
        return noCourseType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iOfferingId = in.readLong();
        this.iCourseId = in.readLong();
        this.iCourseName = (String)in.readObject();
        this.iTitle = (String)in.readObject();
        this.iHasUniqueName = in.readBoolean();
        this.iType = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iOfferingId);
        out.writeLong(this.iCourseId);
        out.writeObject(this.iCourseName);
        out.writeObject(this.iTitle);
        out.writeBoolean(this.iHasUniqueName);
        out.writeObject(this.iType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCourseIdSerializer
    implements Externalizer<XCourseId> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCourseId object) throws IOException {
            object.writeExternal(output);
        }

        public XCourseId readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCourseId(input);
        }
    }
}

