/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInfo
implements OnlineSectioningAction<Map<String, String>> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<String, String> info = new HashMap<String, String>();
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            void var19_35;
            HashMap<Long, Offering> offerings = new HashMap<Long, Offering>();
            Hashtable<Long, Course> courses = new Hashtable<Long, Course>();
            HashMap<String, ArrayList<GroupReservation>> groups = new HashMap<String, ArrayList<GroupReservation>>();
            Hashtable<Long, Config> configs = new Hashtable<Long, Config>();
            Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
            Hashtable<Long, Section> sections = new Hashtable<Long, Section>();
            Hashtable<Long, Iterator<Object>> reservations = new Hashtable<Long, Iterator<Object>>();
            for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || offerings.containsKey(offering.getOfferingId())) continue;
                Offering offering2 = new Offering(offering.getOfferingId().longValue(), offering.getName());
                for (XCourse course : offering.getCourses()) {
                    Course clonedCourse = new Course(course.getCourseId().longValue(), course.getSubjectArea(), course.getCourseNumber(), offering2, course.getLimit(), course.getProjected());
                    clonedCourse.setNote(course.getNote());
                    clonedCourse.setCredit(course.getCredit());
                    courses.put(course.getCourseId(), clonedCourse);
                }
                for (XConfig config : offering.getConfigs()) {
                    Config clonedConfig = new Config(config.getConfigId().longValue(), config.getLimit(), config.getName(), offering2);
                    if (config.getInstructionalMethod() != null) {
                        clonedConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                        clonedConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                    }
                    configs.put(config.getConfigId(), clonedConfig);
                    for (XSubpart subpart : config.getSubparts()) {
                        Subpart clonedSubpart = new Subpart(subpart.getSubpartId().longValue(), subpart.getInstructionalType(), subpart.getName(), clonedConfig, subpart.getParentId() == null ? null : (Subpart)subparts.get(subpart.getParentId()));
                        clonedSubpart.setAllowOverlap(subpart.isAllowOverlap());
                        clonedSubpart.setCredit(subpart.getCredit(null));
                        subparts.put(subpart.getSubpartId(), clonedSubpart);
                        for (XSection section : subpart.getSections()) {
                            Section clonedSection = new Section(section.getSectionId().longValue(), section.getLimit(), section.getName(), clonedSubpart, section.toPlacement(), section.toInstructors(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                            clonedSection.setName(-1L, section.getName(-1L));
                            clonedSection.setNote(section.getNote());
                            clonedSection.setCancelled(section.isCancelled());
                            for (XDistribution xDistribution : offering.getDistributions()) {
                                if (xDistribution.getDistributionType() != XDistributionType.IngoreConflicts || !xDistribution.hasSection(section.getSectionId())) continue;
                                for (Long id : xDistribution.getSectionIds()) {
                                    if (id.equals(section.getSectionId())) continue;
                                    clonedSection.addIgnoreConflictWith(id.longValue());
                                }
                            }
                            sections.put(section.getSectionId(), clonedSection);
                        }
                    }
                }
                for (XReservation reservation : offering.getReservations()) {
                    Iterator<Object> clonedReservation = null;
                    switch (reservation.getType()) {
                        case Course: {
                            XCourseReservation xCourseReservation = (XCourseReservation)reservation;
                            clonedReservation = new CourseReservation(reservation.getReservationId().longValue(), (Course)courses.get(xCourseReservation.getCourseId()));
                            break;
                        }
                        case Curriculum: {
                            XCurriculumReservation curriculumR = (XCurriculumReservation)reservation;
                            clonedReservation = new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, curriculumR.getAcademicArea(), curriculumR.getClassifications(), curriculumR.getMajors());
                            break;
                        }
                        case Group: {
                            XIndividualReservation indR;
                            if (reservation instanceof XIndividualReservation) {
                                indR = (XIndividualReservation)reservation;
                                clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, indR.getStudentIds());
                                break;
                            }
                            XGroupReservation groupR = (XGroupReservation)reservation;
                            clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, new Long[0]);
                            ArrayList<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                            if (list == null) {
                                list = new ArrayList<GroupReservation>();
                                groups.put(groupR.getGroup(), list);
                            }
                            list.add((GroupReservation)clonedReservation);
                            break;
                        }
                        case Individual: {
                            XIndividualReservation indR = (XIndividualReservation)reservation;
                            clonedReservation = new IndividualReservation(reservation.getReservationId().longValue(), offering2, indR.getStudentIds());
                            break;
                        }
                        case Override: {
                            XIndividualReservation ovrR = (XIndividualReservation)reservation;
                            clonedReservation = new ReservationOverride(reservation.getReservationId().longValue(), offering2, ovrR.getStudentIds());
                            ((ReservationOverride)clonedReservation).setMustBeUsed(ovrR.mustBeUsed());
                            ((ReservationOverride)clonedReservation).setAllowOverlap(ovrR.isAllowOverlap());
                            ((ReservationOverride)clonedReservation).setCanAssignOverLimit(ovrR.canAssignOverLimit());
                            break;
                        }
                        default: {
                            clonedReservation = new DummyReservation(offering2);
                        }
                    }
                    for (Long configId : reservation.getConfigsIds()) {
                        clonedReservation.addConfig((Config)configs.get(configId));
                    }
                    for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                        HashSet clonedSections = new HashSet();
                        for (Long sectionId : entry.getValue()) {
                            clonedSections.add(sections.get(sectionId));
                        }
                        clonedReservation.getSections().put(subparts.get(entry.getKey()), clonedSections);
                    }
                    reservations.put(reservation.getReservationId(), clonedReservation);
                }
                offerings.put(offering.getOfferingId(), offering2);
            }
            HashMap<Long, Student> students = new HashMap<Long, Student>();
            AssignmentMap assignmentMap = new AssignmentMap();
            for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                Collection<Long> offeringIds;
                XStudent student;
                XStudent xStudent = student = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                if (student == null) {
                    XReservation reservation;
                    reservation = null;
                    Object var48_56 = null;
                    lock.release();
                    return reservation;
                }
                Student clonnedStudent = new Student(student.getStudentId().longValue());
                clonnedStudent.setExternalId(student.getExternalId());
                clonnedStudent.setName(student.getName());
                for (String string : student.getGroups()) {
                    List list = (List)groups.get(string);
                    if (list == null) continue;
                    for (Object gr : list) {
                        gr.getStudentIds().add(student.getStudentId());
                    }
                }
                for (XRequest xRequest : student.getRequests()) {
                    if (xRequest instanceof XFreeTimeRequest) {
                        XFreeTimeRequest ft = (XFreeTimeRequest)xRequest;
                        new FreeTimeRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                    } else {
                        Object gr;
                        XCourseRequest cr = (XCourseRequest)xRequest;
                        ArrayList<Course> req = new ArrayList<Course>();
                        gr = cr.getCourseIds().iterator();
                        while (gr.hasNext()) {
                            XCourseId c = (XCourseId)gr.next();
                            Course course = (Course)courses.get(c.getCourseId());
                            if (course == null) continue;
                            req.add(course);
                        }
                        if (!req.isEmpty()) {
                            CourseRequest clonnedRequest = new CourseRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, req, cr.isWaitlist(), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                            XEnrollment enrollment = cr.getEnrollment();
                            if (enrollment != null) {
                                Reservation reservation;
                                Config config = (Config)configs.get(enrollment.getConfigId());
                                HashSet<Section> assignments = new HashSet<Section>();
                                for (Long sectionId : enrollment.getSectionIds()) {
                                    Section section = (Section)sections.get(sectionId);
                                    if (section == null) continue;
                                    assignments.add(section);
                                }
                                Reservation reservation2 = reservation = enrollment.getReservation() == null ? null : (Reservation)reservations.get(enrollment.getReservation().getReservationId());
                                if (config != null && !sections.isEmpty()) {
                                    assignmentMap.assign(0L, (Value)new Enrollment((Request)clonnedRequest, 0, (Course)courses.get(enrollment.getCourseId()), config, assignments, reservation));
                                }
                            }
                        }
                    }
                    students.put(student.getStudentId(), clonnedStudent);
                }
                if (clonnedStudent.getExternalId() == null || clonnedStudent.getExternalId().isEmpty() || (offeringIds = server.getInstructedOfferings(clonnedStudent.getExternalId())) == null) continue;
                for (Long offeringId : offeringIds) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    offering.fillInUnavailabilities(clonnedStudent);
                }
            }
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            StudentSchedulingAssistantWeights studentSchedulingAssistantWeights = new StudentSchedulingAssistantWeights(server.getConfig());
            DistanceConflict dc = new DistanceConflict(server.getDistanceMetric(), server.getConfig());
            TimeOverlapsCounter toc = new TimeOverlapsCounter(null, server.getConfig());
            int nrVars = 0;
            boolean bl = false;
            int nrStud = 0;
            int compStud = 0;
            int dist = 0;
            int overlap = 0;
            int free = 0;
            int unav = 0;
            double d = 0.0;
            for (Student student : students.values()) {
                boolean complete = true;
                for (Request request : student.getRequests()) {
                    if (request instanceof FreeTimeRequest) continue;
                    Enrollment enrollment = (Enrollment)assignmentMap.getValue((Variable)request);
                    if (enrollment != null) {
                        ++var19_35;
                        ++nrVars;
                        d += studentSchedulingAssistantWeights.getWeight((Assignment)assignmentMap, enrollment);
                        continue;
                    }
                    if (!student.canAssign((Assignment)assignmentMap, request)) continue;
                    ++nrVars;
                    complete = false;
                }
                ++nrStud;
                if (complete) {
                    ++compStud;
                }
                for (int i = 0; i < student.getRequests().size() - 1; ++i) {
                    Enrollment e1 = (Enrollment)assignmentMap.getValue((Variable)student.getRequests().get(i));
                    if (e1 == null || !e1.isCourseRequest()) continue;
                    dist += dc.nrConflicts(e1);
                    free += toc.nrFreeTimeConflicts(e1);
                    unav += toc.nrNotAvailableTimeConflicts(e1);
                    for (int j = i + 1; j < student.getRequests().size(); ++j) {
                        Enrollment e2;
                        Request r2 = (Request)student.getRequests().get(j);
                        if (r2 instanceof FreeTimeRequest || (e2 = (Enrollment)assignmentMap.getValue((Variable)r2)) == null) continue;
                        dist += dc.nrConflicts(e1, e2);
                        overlap += toc.nrConflicts(e1, e2);
                    }
                }
            }
            info.put("Assigned variables", df.format(100.0 * (double)var19_35 / (double)nrVars) + "% (" + (int)var19_35 + "/" + nrVars + ")");
            info.put("Overall solution value", df.format(d));
            info.put("Students with complete schedule", df.format(100.0 * (double)compStud / (double)nrStud) + "% (" + compStud + "/" + nrStud + ")");
            info.put("Student distance conflicts", df.format(1.0 * (double)dist / (double)nrStud) + " (" + dist + ")");
            info.put("Time overlapping conflicts", df.format((double)overlap / 12.0 / (double)nrStud) + "h (" + overlap + ")");
            info.put("Free time overlapping conflicts", df.format((double)free / 12.0 / (double)nrStud) + "h (" + free + ")");
            info.put("Instructing class overlapping conflicts", df.format((double)unav / 12.0 / (double)nrStud) + "h (" + unav + ")");
            double disbWeight = 0.0;
            int disbSections = 0;
            int disb10Sections = 0;
            boolean balanceUnlimited = server.getConfig().getPropertyBoolean("General.BalanceUnlimited", false);
            for (Offering offering : offerings.values()) {
                for (Config config : offering.getConfigs()) {
                    double enrl = config.getEnrollments((Assignment)assignmentMap).size();
                    for (Subpart subpart : config.getSubparts()) {
                        if (subpart.getSections().size() <= 1) continue;
                        if (subpart.getLimit() > 0) {
                            double ratio = enrl / (double)subpart.getLimit();
                            for (Section section : subpart.getSections()) {
                                double desired = ratio * (double)section.getLimit();
                                disbWeight += Math.abs((double)section.getEnrollments((Assignment)assignmentMap).size() - desired);
                                ++disbSections;
                                if (!(Math.abs(desired - (double)section.getEnrollments((Assignment)assignmentMap).size()) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                                ++disb10Sections;
                            }
                            continue;
                        }
                        if (!balanceUnlimited) continue;
                        for (Section section : subpart.getSections()) {
                            double desired = enrl / (double)subpart.getSections().size();
                            disbWeight += Math.abs((double)section.getEnrollments((Assignment)assignmentMap).size() - desired);
                            ++disbSections;
                            if (!(Math.abs(desired - (double)section.getEnrollments((Assignment)assignmentMap).size()) >= Math.max(1.0, 0.1 * desired))) continue;
                            ++disb10Sections;
                        }
                    }
                }
            }
            if (disbSections != 0) {
                info.put("Average disbalance", df.format(disbWeight / (double)disbSections) + " (" + df.format(var19_35 == false ? 0.0 : 100.0 * disbWeight / (double)var19_35) + "%)");
                info.put("Sections disbalanced by 10% or more", disb10Sections + " (" + df.format(disbSections == 0 ? 0.0 : 100.0 * (double)disb10Sections / (double)disbSections) + "%)");
            }
        }
        catch (Throwable throwable) {
            Object var48_58 = null;
            lock.release();
            throw throwable;
        }
        Object var48_57 = null;
        lock.release();
        return info;
    }

    @Override
    public String name() {
        return "info";
    }
}

