/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Student
extends BaseStudent
implements Comparable<Student>,
NameInterface {
    private static final long serialVersionUID = 1L;

    public Student() {
    }

    public Student(Long uniqueId) {
        super(uniqueId);
    }

    public static List findAll(Long sessionId) {
        return new StudentDAO().getSession().createQuery("select s from Student s where s.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public static Student findByExternalId(Long sessionId, String externalId) {
        return (Student)new StudentDAO().getSession().createQuery("select s from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId=:externalId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    public static Student findByExternalIdBringBackEnrollments(Session hibSession, Long sessionId, String externalId) {
        return (Student)hibSession.createQuery("select s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors left join fetch s.areaClasfMinors where s.session.uniqueId=:sessionId and s.externalUniqueId=:externalId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    public void removeAllEnrollments(Session hibSession) {
        HashSet<StudentClassEnrollment> enrollments = new HashSet<StudentClassEnrollment>();
        if (this.getClassEnrollments() != null) {
            enrollments.addAll(this.getClassEnrollments());
        }
        if (!enrollments.isEmpty()) {
            for (StudentClassEnrollment enrollment : enrollments) {
                this.getClassEnrollments().remove(enrollment);
                hibSession.delete((Object)enrollment);
            }
        }
    }

    @Deprecated
    public Set<Exam> getExams(Integer examType) {
        HashSet<Exam> exams = new HashSet<Exam>();
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.uniqueId and o.exam.examType.type=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 3).setInteger("examType", examType.intValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.type=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 2).setInteger("examType", examType.intValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.uniqueId and o.exam.examType.type=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 1).setInteger("examType", examType.intValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.instructionalOffering.uniqueId and o.exam.examType.type=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 0).setInteger("examType", examType.intValue()).setCacheable(true).list());
        return exams;
    }

    public Set<Exam> getExams(ExamType examType) {
        HashSet<Exam> exams = new HashSet<Exam>();
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.uniqueId and o.exam.examType.uniqueId=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 3).setLong("examType", examType.getUniqueId().longValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 2).setLong("examType", examType.getUniqueId().longValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.uniqueId and o.exam.examType.uniqueId=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 1).setLong("examType", examType.getUniqueId().longValue()).setCacheable(true).list());
        exams.addAll(new StudentDAO().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examType").setLong("studentId", this.getUniqueId().longValue()).setInteger("ownerType", 0).setLong("examType", examType.getUniqueId().longValue()).setCacheable(true).list());
        return exams;
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    @Override
    public int compareTo(Student student) {
        int cmp = NameFormat.LAST_FIRST.format(this).compareTo(NameFormat.LAST_FIRST.format(student));
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(student.getUniqueId() == null ? -1L : student.getUniqueId());
    }

    public static Hashtable<Long, Set<Long>> findConflictingStudents(Long classId, int startSlot, int length, List<Date> dates) {
        Hashtable<Long, Set<Long>> table = new Hashtable<Long, Set<Long>>();
        if (dates.isEmpty()) {
            return table;
        }
        String datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = datesStr + ", ";
            }
            datesStr = datesStr + ":date" + i;
        }
        Query q = LocationDAO.getInstance().getSession().createQuery("select distinct e.clazz.uniqueId, e.student.uniqueId from StudentClassEnrollment e, ClassEvent c inner join c.meetings m, StudentClassEnrollment x where x.clazz.uniqueId=:classId and x.student=e.student and e.clazz=c.clazz and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + datesStr + ") and m.approvalStatus = 1").setLong("classId", classId.longValue()).setInteger("startSlot", startSlot).setInteger("endSlot", startSlot + length);
        for (int i = 0; i < dates.size(); ++i) {
            q.setDate("date" + i, dates.get(i));
        }
        for (Object[] o : q.setCacheable(true).list()) {
            Set<Long> set = table.get((Long)o[0]);
            if (set == null) {
                set = new HashSet<Long>();
                table.put((Long)o[0], set);
            }
            set.add((Long)o[1]);
        }
        return table;
    }

    public boolean hasSectioningStatusOption(StudentSectioningStatus.Option option) {
        if (this.getSectioningStatus() != null) {
            return this.getSectioningStatus().hasOption(option);
        }
        if (this.getSession().getDefaultSectioningStatus() != null) {
            return this.getSession().getDefaultSectioningStatus().hasOption(option);
        }
        return false;
    }

    @Override
    public String getAcademicTitle() {
        return null;
    }
}

