/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseRoomFeature;
import org.unitime.timetable.model.dao.RoomFeatureDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomFeature
extends BaseRoomFeature
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static String FEATURE_LIST_ATTR_NAME = "roomFeaturesList";

    public RoomFeature() {
    }

    public RoomFeature(Long uniqueId) {
        super(uniqueId);
    }

    public static String featureTypeDisplayString() {
        return "";
    }

    public static List<GlobalRoomFeature> getAllGlobalRoomFeatures(Long sessionId) throws HibernateException {
        return RoomFeatureDAO.getInstance().getSession().createQuery("from GlobalRoomFeature rf where rf.session.uniqueId = :sessionId order by label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<GlobalRoomFeature> getAllGlobalRoomFeatures(Long sessionId, Long featureTypeId) throws HibernateException {
        if (featureTypeId == null || featureTypeId < 0L) {
            return RoomFeatureDAO.getInstance().getSession().createQuery("from GlobalRoomFeature rf where rf.session.uniqueId = :sessionId and rf.featureType is null order by label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        }
        return RoomFeatureDAO.getInstance().getSession().createQuery("from GlobalRoomFeature rf where rf.session.uniqueId = :sessionId and rf.featureType = :featureTypeId order by label").setLong("sessionId", sessionId.longValue()).setLong("featureTypeId", featureTypeId.longValue()).setCacheable(true).list();
    }

    public static List<GlobalRoomFeature> getAllGlobalRoomFeatures(Session session) throws HibernateException {
        return RoomFeature.getAllGlobalRoomFeatures(session.getUniqueId());
    }

    public static List<DepartmentRoomFeature> getAllDepartmentRoomFeatures(Department dept) throws HibernateException {
        if (dept == null) {
            return null;
        }
        return RoomFeatureDAO.getInstance().getSession().createQuery("from DepartmentRoomFeature rf where rf.department.uniqueId = :deptId order by label").setLong("deptId", dept.getUniqueId().longValue()).setCacheable(true).list();
    }

    public static List<DepartmentRoomFeature> getAllDepartmentRoomFeaturesInSession(Long sessionId) throws HibernateException {
        return RoomFeatureDAO.getInstance().getSession().createQuery("from DepartmentRoomFeature rf where rf.department.session.uniqueId = :sessionId order by label").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static RoomFeature getRoomFeatureById(Long id) throws HibernateException {
        return (RoomFeature)new RoomFeatureDAO().get(id);
    }

    public static void deleteRoomFeatureById(Long id) throws HibernateException {
        RoomFeature rf = RoomFeature.getRoomFeatureById(id);
        if (rf != null) {
            new RoomFeatureDAO().delete(rf);
        }
    }

    public void saveOrUpdate() throws HibernateException {
        new RoomFeatureDAO().saveOrUpdate(this);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof RoomFeature)) {
            return -1;
        }
        RoomFeature rf = (RoomFeature)o;
        int cmp = this.getLabel().compareTo(rf.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(rf.getUniqueId() == null ? -1L : rf.getUniqueId());
    }

    public boolean hasLocation(Location location) {
        return this.getRooms().contains(location);
    }

    public String getLabelWithType() {
        return this.getLabel() + (this.getFeatureType() == null ? "" : " (" + this.getFeatureType().getReference() + ")");
    }

    @Override
    public String getAbbv() {
        if (super.getAbbv() != null && super.getAbbv().trim().length() > 0) {
            return super.getAbbv();
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer stk = new StringTokenizer(this.getLabel(), " ");
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            if ("and".equalsIgnoreCase(word)) {
                sb.append("&amp;");
                continue;
            }
            if (word.replaceAll("[a-zA-Z\\.]*", "").length() == 0) {
                for (int i = 0; i < word.length(); ++i) {
                    if (i == 0) {
                        sb.append(word.substring(i, i + 1).toUpperCase());
                        continue;
                    }
                    if ((i != 1 || word.length() <= 3) && (word.charAt(i) < 'A' || word.charAt(i) > 'Z')) continue;
                    sb.append(word.charAt(i));
                }
                continue;
            }
            sb.append(word);
        }
        return sb.toString();
    }

    public RoomFeature findSameFeatureInSession(Session session) {
        if (session == null) {
            return null;
        }
        List matchingFeatures = null;
        matchingFeatures = this instanceof DepartmentRoomFeature ? RoomFeatureDAO.getInstance().getSession().createQuery("select distinct d from DepartmentRoomFeature d where d.department.session.uniqueId=:sessionId and d.label=:label and d.department.deptCode=:deptCode").setLong("sessionId", session.getUniqueId().longValue()).setString("deptCode", ((DepartmentRoomFeature)this).getDeptCode()).setString("label", this.getLabel()).setCacheable(true).list() : RoomFeatureDAO.getInstance().getSession().createQuery("select g from GlobalRoomFeature g where g.session.uniqueId=:sessionId and g.label=:label").setLong("sessionId", session.getUniqueId().longValue()).setString("label", this.getLabel()).setCacheable(true).list();
        return matchingFeatures.size() == 1 ? (RoomFeature)matchingFeatures.get(0) : null;
    }
}

