/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseRelatedCourseInfo;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.ExamOwnerDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.RelatedCourseInfoDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedCourseInfo
extends BaseRelatedCourseInfo
implements Comparable<RelatedCourseInfo> {
    private static final long serialVersionUID = 1L;
    private Object iOwnerObject = null;

    public RelatedCourseInfo() {
    }

    public RelatedCourseInfo(Long uniqueId) {
        super(uniqueId);
    }

    public static List findByOwnerIdType(Session hibSession, Long ownerId, Integer ownerType) {
        return hibSession.createQuery("select o from RelatedCourseInfo o where o.ownerId=:ownerId and o.ownerType=:ownerType").setLong("ownerId", ownerId.longValue()).setInteger("ownerType", ownerType.intValue()).setCacheable(true).list();
    }

    public static List findByOwnerIdType(Long ownerId, Integer ownerType) {
        return RelatedCourseInfo.findByOwnerIdType(new RelatedCourseInfoDAO().getSession(), ownerId, ownerType);
    }

    public Object getOwnerObject() {
        if (this.iOwnerObject != null) {
            return this.iOwnerObject;
        }
        switch (this.getOwnerType()) {
            case 3: {
                this.iOwnerObject = new Class_DAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 2: {
                this.iOwnerObject = new InstrOfferingConfigDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 1: {
                this.iOwnerObject = new CourseOfferingDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 0: {
                this.iOwnerObject = new InstructionalOfferingDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public void setOwner(Class_ clazz) {
        this.setOwnerId(clazz.getUniqueId());
        this.setOwnerType(3);
        this.setCourse(clazz.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering());
    }

    public void setOwner(InstrOfferingConfig config) {
        this.setOwnerId(config.getUniqueId());
        this.setOwnerType(2);
        this.setCourse(config.getControllingCourseOffering());
    }

    public void setOwner(CourseOffering course) {
        this.setOwnerId(course.getUniqueId());
        this.setOwnerType(1);
        this.setCourse(course);
    }

    public void setOwner(InstructionalOffering offering) {
        this.setOwnerId(offering.getUniqueId());
        this.setOwnerType(0);
        this.setCourse(offering.getControllingCourseOffering());
    }

    public CourseOffering computeCourse() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getSchedulingSubpart().getControllingCourseOffering();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getControllingCourseOffering();
            }
            case 1: {
                return (CourseOffering)owner;
            }
            case 0: {
                return ((InstructionalOffering)owner).getControllingCourseOffering();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Override
    public int compareTo(RelatedCourseInfo owner) {
        CourseOffering c1 = this.getCourse();
        CourseOffering c2 = owner.getCourse();
        int cmp = 0;
        cmp = c1.getSubjectAreaAbbv().compareTo(c2.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = c1.getCourseNbr().compareTo(c2.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getOwnerType().compareTo(owner.getOwnerType());
        if (cmp != 0) {
            return cmp;
        }
        switch (this.getOwnerType()) {
            case 3: {
                return new ClassComparator(5).compare((Class_)this.getOwnerObject(), (Class_)owner.getOwnerObject());
            }
            case 2: {
                return new InstrOfferingConfigComparator(null).compare(this.getOwnerObject(), owner.getOwnerObject());
            }
        }
        return this.getOwnerId().compareTo(owner.getOwnerId());
    }

    public List getStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        switch (this.getOwnerType()) {
            case 3: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("classId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("configId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new ExamOwnerDAO().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.uniqueId = :courseId").setLong("courseId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new ExamOwnerDAO().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public List getStudentIds() {
        switch (this.getOwnerType()) {
            case 3: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public List getInstructors() {
        switch (this.getOwnerType()) {
            case 3: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.uniqueId = :eventOwnerId and ci.lead=true").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new RelatedCourseInfoDAO().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int countStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return ((Number)new RelatedCourseInfoDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 2: {
                return ((Number)new RelatedCourseInfoDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 1: {
                return ((Number)new RelatedCourseInfoDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 0: {
                return ((Number)new RelatedCourseInfoDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId").setLong("eventOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int getLimit() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getClassLimit();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getLimit();
            }
            case 1: {
                CourseOffering course = (CourseOffering)owner;
                if (course.getReservation() != null) {
                    return course.getReservation();
                }
                return course.getInstructionalOffering().getLimit() == null ? 0 : course.getInstructionalOffering().getLimit();
            }
            case 0: {
                return ((InstructionalOffering)owner).getLimit() == null ? 0 : ((InstructionalOffering)owner).getLimit();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public String getLabel() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getClassLabel(this.getCourse());
            }
            case 2: {
                return this.getCourse().getCourseName() + " [" + ((InstrOfferingConfig)owner).getName() + "]";
            }
            case 1: {
                return ((CourseOffering)owner).getCourseName();
            }
            case 0: {
                return ((InstructionalOffering)owner).getCourseName();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }
}

