/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseAttachmentType;
import org.unitime.timetable.model.dao.AttachmentTypeDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentType
extends BaseAttachmentType
implements Comparable<AttachmentType> {
    private static final long serialVersionUID = 1L;

    @Override
    public int compareTo(AttachmentType a) {
        int cmp = this.getLabel().compareTo(a.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return this.getUniqueId().compareTo(a.getUniqueId());
    }

    public static List<AttachmentType> listTypes(int flag) {
        if (flag == 0) {
            return AttachmentTypeDAO.getInstance().getSession().createQuery("from AttachmentType order by label").setCacheable(true).list();
        }
        return AttachmentTypeDAO.getInstance().getSession().createQuery("from AttachmentType where bit_and(visibility, :flag) = :flag order by label").setInteger("flag", flag).setCacheable(true).list();
    }

    public static List<AttachmentType> listTypes(VisibilityFlag ... flags) {
        int flag = 0;
        for (VisibilityFlag f : flags) {
            flag = f.set(flag);
        }
        return AttachmentType.listTypes(flag);
    }

    public static AttachmentType findByReference(Session hibSession, String reference) {
        if (reference == null) {
            return null;
        }
        return (AttachmentType)hibSession.createQuery("from AttachmentType t where t.reference = :reference").setString("reference", reference).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisibilityFlag {
        IS_IMAGE,
        ROOM_PICTURE_TYPE,
        SHOW_ROOMS_TABLE,
        SHOW_ROOM_TOOLTIP;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }
}

