/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iSessionId;
    private Long iStudentId;
    private ArrayList<Request> iCourses = new ArrayList();
    private ArrayList<Request> iAlternatives = new ArrayList();
    private boolean iSaved = false;
    private boolean iNoChange = false;
    private Boolean iUpdateLastRequest = null;
    private RequestedCourse iLastCourse = null;

    public Long getAcademicSessionId() {
        return this.iSessionId;
    }

    public void setAcademicSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    public ArrayList<Request> getCourses() {
        return this.iCourses;
    }

    public ArrayList<Request> getAlternatives() {
        return this.iAlternatives;
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
    }

    public boolean isNoChange() {
        return this.iNoChange;
    }

    public void setNoChange(boolean noChange) {
        this.iNoChange = noChange;
    }

    public boolean isUpdateLastRequest() {
        return this.iUpdateLastRequest == null || this.iUpdateLastRequest != false;
    }

    public void setUpdateLastRequest(boolean updateLastRequest) {
        this.iUpdateLastRequest = updateLastRequest;
    }

    public boolean addCourse(RequestedCourse course) {
        this.iLastCourse = course;
        if (this.getRequestPriority(course) != null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (!r.isEmpty()) continue;
            r.addRequestedCourse(course);
            return true;
        }
        Request r = new Request();
        r.addRequestedCourse(course);
        this.getCourses().add(r);
        return true;
    }

    public boolean hasLastCourse() {
        return this.iLastCourse != null;
    }

    public RequestedCourse getLastCourse() {
        return this.iLastCourse;
    }

    private RequestPriority __getRequestPriority(Object course) {
        int i;
        if (course == null) {
            return null;
        }
        int priority = 1;
        for (Request r : this.getCourses()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(false, priority, i, r);
                }
            }
            ++priority;
        }
        priority = 1;
        for (Request r : this.getAlternatives()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(true, priority, i, r);
                }
            }
            ++priority;
        }
        return null;
    }

    public RequestPriority getRequestPriority(ClassAssignmentInterface.CourseAssignment course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(DegreePlanInterface.DegreeCourseInterface course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(RequestedCourse course) {
        return this.__getRequestPriority(course);
    }

    public String toString() {
        String ret = "CourseRequests(student = " + this.iStudentId + ", session = " + this.iSessionId + ", requests = {";
        int idx = 1;
        for (Request r : this.iCourses) {
            ret = ret + "\n   " + idx++ + ". " + r;
        }
        idx = 1;
        for (Request r : this.iAlternatives) {
            ret = ret + "\n  A" + idx++ + ". " + r;
        }
        return ret + "\n})";
    }

    public static class RequestPriority
    implements IsSerializable {
        private boolean iAlternative = false;
        private int iPriority = 0;
        private int iChoice = 0;
        private Request iRequest;

        RequestPriority(boolean alternative, int priority, int choice, Request request) {
            this.iAlternative = alternative;
            this.iPriority = priority;
            this.iChoice = choice;
            this.iRequest = request;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public int getChoice() {
            return this.iChoice;
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String toString() {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return "Alt " + this.iPriority + ".";
                    }
                    case 1: {
                        return "Alt " + this.iPriority + "A.";
                    }
                }
                return "Alt " + this.iPriority + "B.";
            }
            switch (this.iChoice) {
                case 0: {
                    return this.iPriority + ".";
                }
                case 1: {
                    return this.iPriority + "A.";
                }
            }
            return this.iPriority + "B.";
        }

        public String toString(StudentSectioningMessages MESSAGES) {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return MESSAGES.degreeRequestedAlternative(this.iPriority);
                    }
                    case 1: {
                        return MESSAGES.degreeRequestedAlternativeFirstAlt(this.iPriority);
                    }
                }
                return MESSAGES.degreeRequestedAlternativeSecondAlt(this.iPriority);
            }
            switch (this.iChoice) {
                case 0: {
                    return MESSAGES.degreeRequestedCourse(this.iPriority);
                }
                case 1: {
                    return MESSAGES.degreeRequestedCourseFirstAlt(this.iPriority);
                }
            }
            return MESSAGES.degreeRequestedCourseSecondAlt(this.iPriority);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<RequestedCourse> iRequestedCourse = null;
        private Boolean iWaitList = false;

        public List<RequestedCourse> getRequestedCourse() {
            return this.iRequestedCourse;
        }

        public RequestedCourse getRequestedCourse(int index) {
            if (this.iRequestedCourse != null && index < this.iRequestedCourse.size()) {
                return this.iRequestedCourse.get(index);
            }
            return null;
        }

        public boolean hasRequestedCourse() {
            return this.iRequestedCourse != null && !this.iRequestedCourse.isEmpty();
        }

        public void addRequestedCourse(RequestedCourse requestedCourse) {
            if (this.iRequestedCourse == null) {
                this.iRequestedCourse = new ArrayList<RequestedCourse>();
            }
            this.iRequestedCourse.add(requestedCourse);
        }

        public boolean hasRequestedCourse(ClassAssignmentInterface.CourseAssignment course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRequestedCourse(RequestedCourse course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return !this.hasRequestedCourse();
        }

        public boolean isReadOnly() {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.isReadOnly()) continue;
                return true;
            }
            return false;
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public String toString() {
            return (this.hasRequestedCourse() ? this.iRequestedCourse.toString() : "-") + (this.isWaitList() ? " (w)" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestedCourse
    implements IsSerializable,
    Serializable,
    Comparable<RequestedCourse> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourseName;
        private Boolean iReadOnly = null;
        private List<FreeTime> iFreeTime;
        private Set<String> iSelectedIntructionalMethods;
        private Set<String> iSelectedClasses;

        public RequestedCourse() {
        }

        public RequestedCourse(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public RequestedCourse(ClassAssignmentInterface.CourseAssignment course, boolean showTitle) {
            this.iCourseId = course.getCourseId();
            this.iCourseName = course.hasUniqueName() && !showTitle ? course.getCourseName() : course.getCourseNameWithTitle();
        }

        public boolean isCourse() {
            return this.hasCourseId() || this.hasCourseName();
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public boolean hasCourseName() {
            return this.iCourseName != null && !this.iCourseName.isEmpty();
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public List<FreeTime> getFreeTime() {
            return this.iFreeTime;
        }

        public boolean isFreeTime() {
            return this.iFreeTime != null && !this.iFreeTime.isEmpty();
        }

        public void setFreeTime(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public void addFreeTime(FreeTime freeTime) {
            if (this.iFreeTime == null) {
                this.iFreeTime = new ArrayList<FreeTime>();
            }
            this.iFreeTime.add(freeTime);
        }

        public boolean isReadOnly() {
            return this.iReadOnly != null && this.iReadOnly != false;
        }

        public void setReadOnly(Boolean readOnly) {
            this.iReadOnly = readOnly;
        }

        public boolean isEmpty() {
            return !this.isCourse() && !this.isFreeTime();
        }

        public boolean hasSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods != null && !this.iSelectedIntructionalMethods.isEmpty();
        }

        public Set<String> getSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods;
        }

        public void setSelectedIntructionalMethod(String id, boolean value) {
            if (this.iSelectedIntructionalMethods == null) {
                this.iSelectedIntructionalMethods = new HashSet<String>();
            }
            if (value) {
                this.iSelectedIntructionalMethods.add(id);
            } else {
                this.iSelectedIntructionalMethods.remove(id);
            }
        }

        public boolean isSelectedIntructionalMethod(String id) {
            if (this.iSelectedIntructionalMethods == null) {
                return false;
            }
            return this.iSelectedIntructionalMethods.contains(id);
        }

        public boolean hasSelectedClasses() {
            return this.iSelectedClasses != null && !this.iSelectedClasses.isEmpty();
        }

        public Set<String> getSelectedClasses() {
            return this.iSelectedClasses;
        }

        public void setSelectedClasses(Set<String> classes) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<String>();
            } else {
                this.iSelectedClasses.clear();
            }
            if (classes != null) {
                this.iSelectedClasses.addAll(classes);
            }
        }

        public void setSelectedClass(String id, boolean value) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<String>();
            }
            if (value) {
                this.iSelectedClasses.add(id);
            } else {
                this.iSelectedClasses.remove(id);
            }
        }

        public boolean isSelectedClass(String id) {
            if (this.iSelectedClasses == null || id == null) {
                return false;
            }
            return this.iSelectedClasses.contains(id);
        }

        public int hashCode() {
            return this.hasCourseId() ? this.getCourseId().hashCode() : this.getCourseName().hashCode();
        }

        public String toString() {
            if (this.isCourse()) {
                return this.getCourseName() + (this.hasSelectedIntructionalMethods() ? " method:" + this.getSelectedIntructionalMethods() : "") + (this.hasSelectedClasses() ? " section:" + this.getSelectedClasses() : "") + (this.isReadOnly() ? " [S]" : "") + (this.hasCourseId() ? "[i]" : "");
            }
            if (this.isFreeTime()) {
                String ret = "";
                for (FreeTime ft : this.getFreeTime()) {
                    ret = ret + (ret.isEmpty() ? "" : ", ") + ft.toString();
                }
                return ret;
            }
            return "N/A";
        }

        public String toString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                String display = "";
                String lastDays = null;
                for (FreeTime ft : this.getFreeTime()) {
                    if (display.length() > 0) {
                        display = display + ", ";
                    }
                    String days = ft.getDaysString(CONSTANTS.shortDays(), "");
                    if (ft.getDays().size() == CONSTANTS.freeTimeDays().length && !ft.getDays().contains(5) && !ft.getDays().contains(6)) {
                        days = "";
                    }
                    display = display + (days.isEmpty() || days.equals(lastDays) ? "" : days + " ") + ft.getStartString(CONSTANTS.useAmPm()) + " - " + ft.getEndString(CONSTANTS.useAmPm());
                    lastDays = days;
                }
                return CONSTANTS.freePrefix() + display;
            }
            return "";
        }

        public String toAriaString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                String status = "";
                for (FreeTime ft : this.getFreeTime()) {
                    status = status + (status.isEmpty() ? "" : " ") + ft.toAriaString(CONSTANTS.longDays(), CONSTANTS.useAmPm());
                }
                return status;
            }
            return "";
        }

        public boolean equals(Object o) {
            IsSerializable c;
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return ((String)o).equalsIgnoreCase(this.getCourseName());
            }
            if (o instanceof Long) {
                return ((Long)o).equals(this.getCourseId());
            }
            if (o instanceof RequestedCourse) {
                c = (RequestedCourse)o;
                if (c.hasCourseId() && this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (c.hasCourseName() && this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName());
                }
                if (c.isFreeTime() && this.isFreeTime()) {
                    return c.getFreeTime().equals(this.getFreeTime());
                }
            }
            if (o instanceof ClassAssignmentInterface.CourseAssignment) {
                c = (ClassAssignmentInterface.CourseAssignment)o;
                if (this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            if (o instanceof DegreePlanInterface.DegreeCourseInterface) {
                c = (DegreePlanInterface.DegreeCourseInterface)o;
                if (this.hasCourseId() && c.getCourseId() != null) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            return false;
        }

        @Override
        public int compareTo(RequestedCourse o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeTime
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;

        public FreeTime() {
        }

        public FreeTime(List<Integer> days, int start, int length) {
            if (days != null) {
                this.iDays.addAll(days);
            }
            this.iStart = start;
            this.iLength = length;
        }

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public int getDayCode() {
            int ret = 0;
            for (int day : this.iDays) {
                ret += 1 << day;
            }
            return ret;
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int startSlot) {
            this.iStart = startSlot;
        }

        public String getStartString(boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            int h = (this.iStart + this.iLength) / 12;
            int m = 5 * ((this.iStart + this.iLength) % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString(String[] shortDays, boolean useAmPm) {
            return this.getDaysString(shortDays, "") + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String toString() {
            return "Free " + this.toString(new String[]{"M", "T", "W", "R", "F", "S", "U"}, true);
        }

        public String toAriaString(String[] longDays, boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FreeTime)) {
                return false;
            }
            FreeTime f = (FreeTime)o;
            return f.getStart() == this.getStart() && f.getLength() == this.getLength() && f.getDayCode() == this.getDayCode();
        }
    }
}

