/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.command.server;

import java.io.Serializable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.rights.Right;

public class GwtRpcHelper
implements SessionContext {
    private UserContext iUser;
    private String iHttpSessionId;
    private boolean iHttpSessionNew;
    private PermissionCheck iCheck;

    public GwtRpcHelper(SessionContext context, PermissionCheck check) {
        this.iUser = context.getUser();
        this.iHttpSessionId = context.getHttpSessionId();
        this.iHttpSessionNew = context.isHttpSessionNew();
        this.iCheck = check;
    }

    public boolean isAuthenticated() {
        return this.iUser != null;
    }

    public UserContext getUser() {
        return this.iUser;
    }

    public boolean isHttpSessionNew() {
        return this.iHttpSessionNew;
    }

    public String getHttpSessionId() {
        return this.iHttpSessionId;
    }

    public Object getAttribute(String name) {
        throw new RuntimeException("Operation not supported.");
    }

    public void removeAttribute(String name) {
        throw new RuntimeException("Operation not supported.");
    }

    public void setAttribute(String name, Object value) {
        throw new RuntimeException("Operation not supported.");
    }

    public void removeAttribute(SessionAttribute attribute) {
        this.removeAttribute(attribute.name());
    }

    public void setAttribute(SessionAttribute attribute, Object value) {
        this.setAttribute(attribute.name(), value);
    }

    public Object getAttribute(SessionAttribute attribute) {
        Object value = this.getAttribute(attribute.name());
        return value != null ? value : attribute.defaultValue();
    }

    public void checkPermission(Right right) {
        this.iCheck.checkPermission(this.getUser(), null, null, right);
    }

    public void checkPermission(Serializable targetId, String targetType, Right right) {
        this.iCheck.checkPermission(this.getUser(), targetId, targetType, right);
    }

    public void checkPermission(Object targetObject, Right right) {
        this.iCheck.checkPermission(this.getUser(), targetObject, right);
    }

    public boolean hasPermission(Right right) {
        return this.iCheck.hasPermission(this.getUser(), null, null, right);
    }

    public boolean hasPermission(Serializable targetId, String targetType, Right right) {
        return this.iCheck.hasPermission(this.getUser(), targetId, targetType, right);
    }

    public boolean hasPermission(Object targetObject, Right right) {
        return this.iCheck.hasPermission(this.getUser(), targetObject, right);
    }

    public void checkPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        this.iCheck.checkPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    public void checkPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        this.iCheck.checkPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    public void checkPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        this.iCheck.checkPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        return this.iCheck.hasPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        return this.iCheck.hasPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    public boolean hasPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        return this.iCheck.hasPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }
}

