/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestLine;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestsTable
extends P
implements HasValue<CourseRequestInterface> {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private AcademicSessionProvider iSessionProvider;
    private ArrayList<CourseRequestLine> iCourses;
    private ArrayList<CourseRequestLine> iAlternatives;
    private Label iTip;
    private boolean iOnline;
    Validator<CourseSelection> iCheckForDuplicities;
    private boolean iCanWaitList = true;
    private P iHeader;
    private P iHeaderTitle;
    private P iHeaderWaitlist;
    private P iAltHeader;
    private P iAltHeaderTitle;
    private P iAltHeaderNote;
    private boolean iArrowsVisible = true;

    public CourseRequestsTable(AcademicSessionProvider sessionProvider, boolean online) {
        super("unitime-CourseRequests");
        CourseRequestLine prev;
        CourseRequestLine line;
        int i;
        this.iOnline = online;
        this.iSessionProvider = sessionProvider;
        this.iHeader = new P("header");
        this.iHeaderTitle = new P("title");
        this.iHeaderTitle.setText(MESSAGES.courseRequestsCourses());
        this.iHeaderWaitlist = new P("waitlist");
        this.iHeaderWaitlist.setHTML(MESSAGES.courseRequestsWaitList());
        this.iHeader.add((Widget)this.iHeaderTitle);
        this.iHeader.add((Widget)this.iHeaderWaitlist);
        this.add((Widget)this.iHeader);
        this.iCourses = new ArrayList();
        this.iAlternatives = new ArrayList();
        this.iCheckForDuplicities = new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                CourseRequestInterface.RequestedCourse course = (CourseRequestInterface.RequestedCourse)source.getValue();
                if (course == null || course.isFreeTime()) {
                    return null;
                }
                for (CourseRequestLine line : CourseRequestsTable.this.iCourses) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        if (courseSelectionBox == source || !course.equals(courseSelectionBox.getValue())) continue;
                        return MESSAGES.validationMultiple(course.getCourseName());
                    }
                }
                for (CourseRequestLine line : CourseRequestsTable.this.iAlternatives) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        if (courseSelectionBox == source || !course.equals(courseSelectionBox.getValue())) continue;
                        return MESSAGES.validationMultiple(course.getCourseName());
                    }
                }
                return null;
            }
        };
        for (i = 0; i < CONSTANTS.numberOfCourses(); ++i) {
            line = new CourseRequestLine(this.iSessionProvider, i, false, this.iCheckForDuplicities);
            this.iCourses.add(line);
            if (i > 0) {
                prev = this.iCourses.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (event.getValue() != null && CourseRequestsTable.this.iCourses.indexOf((Object)line) + 1 == CourseRequestsTable.this.iCourses.size()) {
                        CourseRequestsTable.this.addCourseLine();
                    }
                }
            });
            this.add((Widget)line);
        }
        this.iCourses.get(1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint1());
        this.iCourses.get(3).getCourses().get(0).setHint(MESSAGES.courseRequestsHint3());
        this.iCourses.get(4).getCourses().get(0).setHint(MESSAGES.courseRequestsHint4());
        this.iCourses.get(CONSTANTS.numberOfCourses() - 1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        this.iTip = new Label(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        ToolBox.disableTextSelectInternal((Element)this.iTip.getElement());
        this.iTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseRequestsTable.this.iTip.getText();
                do {
                    CourseRequestsTable.this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
                } while (oldText.equals(CourseRequestsTable.this.iTip.getText()));
            }
        });
        this.iTip.addStyleName("tip");
        this.add((Widget)this.iTip);
        if (CONSTANTS.numberOfAlternatives() > 0) {
            this.iAltHeader = new P("alt-header");
            this.iAltHeaderTitle = new P("title");
            this.iAltHeaderTitle.setText(MESSAGES.courseRequestsAlternatives());
            this.iAltHeaderNote = new P("note");
            this.iAltHeaderNote.setText(MESSAGES.courseRequestsAlternativesNote());
            this.iAltHeader.add((Widget)this.iAltHeaderTitle);
            this.iAltHeader.add((Widget)this.iAltHeaderNote);
            this.add((Widget)this.iAltHeader);
        }
        for (i = 0; i < CONSTANTS.numberOfAlternatives(); ++i) {
            line = new CourseRequestLine(this.iSessionProvider, i, true, this.iCheckForDuplicities);
            this.iAlternatives.add(line);
            if (i == 0) {
                prev = this.iCourses.get(this.iCourses.size() - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            } else {
                prev = this.iAlternatives.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (event.getValue() != null && CourseRequestsTable.this.iAlternatives.indexOf((Object)line) + 1 == CourseRequestsTable.this.iAlternatives.size()) {
                        CourseRequestsTable.this.addAlternativeLine();
                    }
                }
            });
            this.add((Widget)line);
        }
        if (CONSTANTS.numberOfAlternatives() > 0) {
            this.iAlternatives.get(0).getCourses().get(0).setHint(MESSAGES.courseRequestsHintA0());
        }
    }

    private void addCourseLine() {
        int i = this.iCourses.size();
        final CourseRequestLine line = new CourseRequestLine(this.iSessionProvider, i, false, this.iCheckForDuplicities);
        this.iCourses.add(line);
        CourseRequestLine prev = this.iCourses.get(i - 1);
        prev.getCourses().get(0).setHint("");
        line.getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        CourseRequestLine next = this.iAlternatives.isEmpty() ? null : this.iAlternatives.get(0);
        line.setPrevious(prev);
        prev.setNext(line);
        if (next != null) {
            line.setNext(next);
            next.setPrevious(line);
        }
        line.setArrowsVisible(this.iArrowsVisible);
        line.setWaitListVisible(this.iCanWaitList);
        this.insert((Widget)line, 1 + i);
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (event.getValue() != null && CourseRequestsTable.this.iCourses.indexOf((Object)line) + 1 == CourseRequestsTable.this.iCourses.size()) {
                    CourseRequestsTable.this.addCourseLine();
                }
            }
        });
    }

    private void addAlternativeLine() {
        CourseRequestLine prev;
        if (this.iAlternatives.isEmpty()) {
            this.iAltHeader = new P("alt-header");
            this.iAltHeaderTitle = new P("title");
            this.iAltHeaderTitle.setText(MESSAGES.courseRequestsAlternatives());
            this.iAltHeaderNote = new P("note");
            this.iAltHeaderNote.setText(MESSAGES.courseRequestsAlternativesNote());
            this.iAltHeader.add((Widget)this.iAltHeaderTitle);
            this.iAltHeader.add((Widget)this.iAltHeaderNote);
            this.add((Widget)this.iAltHeader);
        }
        int i = this.iAlternatives.size();
        final CourseRequestLine line = new CourseRequestLine(this.iSessionProvider, i, true, this.iCheckForDuplicities);
        this.iAlternatives.add(line);
        CourseRequestLine courseRequestLine = prev = i == 0 ? this.iCourses.get(this.iCourses.size() - 1) : this.iAlternatives.get(i - 1);
        if (prev != null) {
            line.setPrevious(prev);
            prev.setNext(line);
        }
        line.setArrowsVisible(this.iArrowsVisible);
        this.insert((Widget)line, 3 + this.iCourses.size() + i);
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (event.getValue() != null && CourseRequestsTable.this.iAlternatives.indexOf((Object)line) + 1 == CourseRequestsTable.this.iAlternatives.size()) {
                    CourseRequestsTable.this.addAlternativeLine();
                }
            }
        });
    }

    public void setCanWaitList(boolean canWaitList) {
        this.iCanWaitList = canWaitList;
        this.iHeaderWaitlist.setVisible(canWaitList);
        for (CourseRequestLine line : this.iCourses) {
            line.setWaitListVisible(canWaitList);
        }
    }

    public void setArrowsVisible(boolean arrowsVisible) {
        this.iArrowsVisible = arrowsVisible;
        this.iHeaderWaitlist.setHTML(arrowsVisible ? MESSAGES.courseRequestsWaitList() : MESSAGES.courseRequestsWaitListNoArrows());
        this.iHeader.setStyleName("noarrows", !arrowsVisible);
        for (CourseRequestLine line : this.iCourses) {
            line.setArrowsVisible(arrowsVisible);
        }
        for (CourseRequestLine line : this.iAlternatives) {
            line.setArrowsVisible(arrowsVisible);
        }
    }

    public void validate(AsyncCallback<Boolean> callback) {
        this.validate(null, callback);
    }

    public void validate(Boolean updateLastRequest, final AsyncCallback<Boolean> callback) {
        try {
            String message;
            String failed = null;
            LoadingWidget.getInstance().show(MESSAGES.courseRequestsValidating());
            for (CourseRequestLine line : this.iCourses) {
                message = line.validate();
                if (message == null) continue;
                failed = message;
            }
            for (CourseRequestLine line : this.iAlternatives) {
                message = line.validate();
                if (message == null) continue;
                failed = message;
            }
            CourseRequestInterface cr = new CourseRequestInterface();
            cr.setAcademicSessionId(this.iSessionProvider.getAcademicSessionId());
            if (cr.getAcademicSessionId() == null) {
                throw new SectioningException(MESSAGES.sessionSelectorNoSession());
            }
            this.fillInCourses(cr);
            this.fillInAlternatives(cr);
            if (updateLastRequest != null) {
                cr.setUpdateLastRequest(updateLastRequest);
            }
            final boolean success = failed == null;
            this.iSectioningService.checkCourses(this.iOnline, cr, new AsyncCallback<Collection<String>>(){

                public void onSuccess(Collection<String> result) {
                    for (String course : result) {
                        CourseRequestsTable.this.setError(course, MESSAGES.validationCourseNotExists(course));
                    }
                    LoadingWidget.getInstance().hide();
                    callback.onSuccess((Object)(success && result.isEmpty() ? 1 : 0));
                }

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    callback.onFailure(caught);
                }
            });
        }
        catch (Exception e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void setError(String course, String error) {
        GWT.log((String)error);
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!course.equals(courseSelectionBox.getText())) continue;
                courseSelectionBox.setError(error);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!course.equals(courseSelectionBox.getText())) continue;
                courseSelectionBox.setError(error);
            }
        }
    }

    public void changeTip() {
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
    }

    public void fillInCourses(CourseRequestInterface cr) {
        for (CourseRequestLine line : this.iCourses) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getCourses().add(req);
        }
    }

    public void fillInAlternatives(CourseRequestInterface cr) {
        for (CourseRequestLine line : this.iAlternatives) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getAlternatives().add(req);
        }
    }

    public CourseRequestInterface getRequest() {
        CourseRequestInterface cr = new CourseRequestInterface();
        cr.setAcademicSessionId(this.iSessionProvider.getAcademicSessionId());
        this.fillInCourses(cr);
        this.fillInAlternatives(cr);
        return cr;
    }

    public void setRequest(CourseRequestInterface request) {
        int idx;
        this.clear();
        while (this.iCourses.size() < request.getCourses().size()) {
            this.addCourseLine();
        }
        for (idx = 0; idx < request.getCourses().size(); ++idx) {
            this.iCourses.get(idx).setValue(request.getCourses().get(idx), true);
        }
        while (this.iAlternatives.size() < request.getAlternatives().size()) {
            this.addAlternativeLine();
        }
        for (idx = 0; idx < request.getAlternatives().size(); ++idx) {
            this.iAlternatives.get(idx).setValue(request.getAlternatives().get(idx), true);
        }
    }

    public Boolean getWaitList(String course) {
        if (this.iCanWaitList) {
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!course.equals(courseSelectionBox.getValue())) continue;
                    return line.getWaitList();
                }
            }
        }
        return null;
    }

    public void setWaitList(String course, boolean waitList) {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!course.equals(courseSelectionBox.getValue())) continue;
                line.setWaitList(waitList);
            }
        }
    }

    public void clear() {
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        for (CourseRequestLine line : this.iCourses) {
            line.setValue(null);
        }
        for (CourseRequestLine line : this.iAlternatives) {
            line.setValue(null);
        }
    }

    public String getFirstError() {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (courseSelectionBox.getError() == null) continue;
                return courseSelectionBox.getError();
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (courseSelectionBox.getError() == null) continue;
                return courseSelectionBox.getError();
            }
        }
        return null;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface getValue() {
        return this.getRequest();
    }

    public void setValue(CourseRequestInterface value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface value, boolean fireEvents) {
        this.setRequest(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    protected void clearErrors() {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.setError(null);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.setError(null);
            }
        }
    }

    public Command addCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request = new CourseRequestInterface.Request();
        request.addRequestedCourse(rc);
        for (final CourseRequestLine line : this.iCourses) {
            if (line.getValue() != null) continue;
            line.setValue(request, true);
            return new Command(){

                public void execute() {
                    line.setValue(null, true);
                    CourseRequestsTable.this.clearErrors();
                }
            };
        }
        this.addCourseLine();
        final CourseRequestLine line = this.iCourses.get(this.iCourses.size() - 1);
        line.setValue(request, true);
        return new Command(){

            public void execute() {
                line.setValue(null, true);
                CourseRequestsTable.this.clearErrors();
            }
        };
    }

    public boolean hasCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request;
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            return true;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            return true;
        }
        return false;
    }

    public void dropCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request;
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            line.delete();
            return;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            line.delete();
            return;
        }
    }

    public void dropCourse(ClassAssignmentInterface.ClassAssignment assignment) {
        block8: {
            block7: {
                if (!assignment.isFreeTime() || !assignment.isAssigned()) break block7;
                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime(assignment.getDays(), assignment.getStart(), assignment.getLength());
                for (CourseRequestLine line : this.iCourses) {
                    CourseRequestInterface.Request request = line.getValue();
                    if (request == null || !request.hasRequestedCourse() || !request.getRequestedCourse(0).isFreeTime() || !request.getRequestedCourse(0).getFreeTime().contains(ft)) continue;
                    request.getRequestedCourse(0).getFreeTime().remove(ft);
                    if (request.getRequestedCourse(0).isEmpty()) {
                        line.delete();
                    } else {
                        line.setValue(request, true);
                    }
                    return;
                }
                break block8;
            }
            if (assignment.isFreeTime()) break block8;
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue())) continue;
                    line.delete();
                    return;
                }
            }
            for (CourseRequestLine line : this.iAlternatives) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue())) continue;
                    line.delete();
                    return;
                }
            }
        }
    }
}

