/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorComparator;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.InstructorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorsTable
extends UniTimeTable<InstructorInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private InstructorInterface.InstructorsColumn iSortBy = null;
    private boolean iAsc = true;
    private boolean iSelectable = false;
    private InstructorInterface.InstructorAttributePropertiesInterface iProperties = null;

    public InstructorsTable(InstructorInterface.InstructorAttributePropertiesInterface properties, boolean selectable) {
        this.setStyleName("unitime-Instructorss");
        this.iSelectable = selectable;
        this.iProperties = properties;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final InstructorInterface.InstructorsColumn column : InstructorInterface.InstructorsColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final InstructorInterface.InstructorsColumn column : InstructorInterface.InstructorsColumn.values()) {
            if (!InstructorComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    InstructorsTable.this.doSort(column);
                }

                public boolean isApplicable() {
                    return InstructorsTable.this.getRowCount() > 1 && h.isVisible();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(InstructorCookie.getInstance().getSortAttributesBy());
        if (this.iSelectable) {
            ((UniTimeTableHeader)header.get(0)).addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 1; row < InstructorsTable.this.getRowCount(); ++row) {
                        Widget w = InstructorsTable.this.getWidget(row, 0);
                        if (w != null && w instanceof CheckBox) {
                            CheckBox ch = (CheckBox)w;
                            ch.setValue(Boolean.valueOf(true));
                        }
                        InstructorsTable.this.setSelected(row, true);
                    }
                }

                public boolean isApplicable() {
                    for (int row = 1; row < InstructorsTable.this.getRowCount(); ++row) {
                        CheckBox ch;
                        Widget w = InstructorsTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || (ch = (CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opSelectAll();
                }
            });
            ((UniTimeTableHeader)header.get(0)).addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 1; row < InstructorsTable.this.getRowCount(); ++row) {
                        Widget w = InstructorsTable.this.getWidget(row, 0);
                        if (w != null && w instanceof CheckBox) {
                            CheckBox ch = (CheckBox)w;
                            ch.setValue(Boolean.valueOf(false));
                        }
                        InstructorsTable.this.setSelected(row, false);
                    }
                }

                public boolean isApplicable() {
                    for (int row = 1; row < InstructorsTable.this.getRowCount(); ++row) {
                        CheckBox ch;
                        Widget w = InstructorsTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opClearSelection();
                }
            });
            this.setAllowSelection(true);
            this.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface> event) {
                    InstructorsTable.this.selectInstructor(event.getRow(), InstructorsTable.this.isSelected(event.getRow()));
                }
            });
        }
    }

    protected void doSort(InstructorInterface.InstructorsColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        InstructorCookie.getInstance().setSortInstructorsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = InstructorInterface.InstructorsColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = InstructorInterface.InstructorsColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = InstructorInterface.InstructorsColumn.NAME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        Comparator<InstructorInterface> ic = null;
        ic = this.iSelectable && this.iSortBy == InstructorInterface.InstructorsColumn.SELECTION ? new Comparator<InstructorInterface>(){
            private Comparator<InstructorInterface> iIC;
            {
                this.iIC = new InstructorComparator(InstructorsTable.this.iSortBy, true);
            }

            @Override
            public int compare(InstructorInterface r1, InstructorInterface r2) {
                boolean s2;
                boolean s1 = InstructorsTable.this.isInstructorSelected(r1);
                if (s1 != (s2 = InstructorsTable.this.isInstructorSelected(r2))) {
                    return s1 ? -1 : 1;
                }
                return this.iIC.compare(r1, r2);
            }
        } : new InstructorComparator(this.iSortBy, true);
        this.sort(header, ic, this.iAsc);
    }

    protected int getNbrCells(InstructorInterface.InstructorsColumn column) {
        switch (column) {
            case SELECTION: {
                return this.iSelectable ? 1 : 0;
            }
            case ATTRIBUTES: {
                return this.iProperties == null ? 0 : this.iProperties.getAttributeTypes().size();
            }
        }
        return 1;
    }

    protected boolean isVisible(InstructorInterface.InstructorsColumn column, int idx) {
        switch (column) {
            case ATTRIBUTES: {
                return false;
            }
        }
        return true;
    }

    public String getColumnName(InstructorInterface.InstructorsColumn column, int idx) {
        switch (column) {
            case SELECTION: {
                return MESSAGES.colSelection();
            }
            case ID: {
                return MESSAGES.colExternalId();
            }
            case NAME: {
                return MESSAGES.colNamePerson();
            }
            case POSITION: {
                return MESSAGES.colPosition();
            }
            case TEACHING_PREF: {
                return MESSAGES.colTeachingPreference();
            }
            case MAX_LOAD: {
                return MESSAGES.colMaxLoad();
            }
            case ATTRIBUTES: {
                return this.iProperties.getAttributeTypes().get(idx).getLabel();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(InstructorInterface.InstructorsColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(InstructorInterface.InstructorsColumn column) {
        int ret = 0;
        for (InstructorInterface.InstructorsColumn c : InstructorInterface.InstructorsColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(InstructorInterface instructor, InstructorInterface.InstructorsColumn column, int idx) {
        switch (column) {
            case ID: {
                if (instructor.getExternalId() == null) {
                    Image warning = new Image(RESOURCES.warning());
                    warning.setTitle(MESSAGES.warnInstructorHasNoExternalId(instructor.getFormattedName()));
                    return warning;
                }
                return new Label(instructor.getExternalId());
            }
            case NAME: {
                return new Label(instructor.getFormattedName());
            }
            case POSITION: {
                return new Label(instructor.getPosition() == null ? "" : instructor.getPosition().getLabel());
            }
            case TEACHING_PREF: {
                if (instructor.getTeachingPreference() == null) {
                    return new Label("");
                }
                Label pref = new Label(instructor.getTeachingPreference().getName());
                if (instructor.getTeachingPreference().getColor() != null) {
                    pref.getElement().getStyle().setColor(instructor.getTeachingPreference().getColor());
                }
                return pref;
            }
            case MAX_LOAD: {
                return new Label(instructor.hasMaxLoad() ? NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat()).format((Number)instructor.getMaxLoad()) : "");
            }
            case SELECTION: {
                return new SelectableCell(instructor);
            }
            case ATTRIBUTES: {
                InstructorInterface.AttributeTypeInterface type = this.iProperties.getAttributeTypes().get(idx);
                List<InstructorInterface.AttributeInterface> attributes = instructor.getAttributes(type);
                if (!attributes.isEmpty() && !this.isColumnVisible(this.getCellIndex(column) + idx)) {
                    this.setColumnVisible(this.getCellIndex(column) + idx, true);
                }
                return new AttributesCell(attributes);
            }
        }
        return null;
    }

    public void resetVisibility() {
        int col = 0;
        for (InstructorInterface.InstructorsColumn column : InstructorInterface.InstructorsColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                if (!this.isVisible(column, idx)) {
                    this.setColumnVisible(col, false);
                }
                ++col;
            }
        }
    }

    public int addInstructor(InstructorInterface attribute) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (InstructorInterface.InstructorsColumn column : InstructorInterface.InstructorsColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(attribute, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(attribute, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    @Override
    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof UniTimeTable.HasRefresh)) continue;
                ((UniTimeTable.HasRefresh)w).refresh();
            }
        }
    }

    public InstructorInterface getAttribute(Long instructorId) {
        if (instructorId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!instructorId.equals(((InstructorInterface)this.getData(i)).getId())) continue;
            return (InstructorInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long instructorId) {
        if (instructorId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!instructorId.equals(((InstructorInterface)this.getData(i)).getId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
            return;
        }
    }

    public Boolean isInstructorSelected(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return ((CheckBox)w).getValue();
        }
        return null;
    }

    public boolean isInstructorSelected(InstructorInterface instructor) {
        if (!this.iSelectable) {
            return false;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((InstructorInterface)this.getData(row)).getId().equals(instructor.getId())) continue;
            return this.isInstructorSelected(row);
        }
        return false;
    }

    public int getRow(InstructorInterface instructor) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((InstructorInterface)this.getData(row)).getId().equals(instructor.getId())) continue;
            return row;
        }
        return -1;
    }

    public void selectInstructor(InstructorInterface instructor, boolean value) {
        if (!this.iSelectable) {
            return;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((InstructorInterface)this.getData(row)).getId().equals(instructor.getId())) continue;
            this.selectInstructor(row, value);
            break;
        }
    }

    public void selectInstructor(int row, boolean value) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf(value));
        }
    }

    public CheckBox getInstructorSelection(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return (CheckBox)w;
        }
        return null;
    }

    class SelectableCell
    extends CheckBox {
        SelectableCell(final InstructorInterface instructor) {
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    InstructorsTable.this.setSelected(InstructorsTable.this.getRow(instructor), (Boolean)event.getValue());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributesCell
    extends P {
        public AttributesCell(List<? extends InstructorInterface.AttributeInterface> attributes) {
            super(new String[0]);
            this.setStyleName("attributes");
            for (InstructorInterface.AttributeInterface attributeInterface : attributes) {
                P p = new P("attribute");
                p.setText(attributeInterface.getName());
                this.add((Widget)p);
            }
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    public static class InstructorCell
    extends P {
        public InstructorCell(InstructorInterface instructor, boolean hasNext) {
            super("instructor");
            this.setText(instructor.getFormattedName() + (hasNext ? "," : ""));
        }
    }

    public static class InstructorsCell
    extends P {
        public InstructorsCell(InstructorInterface.AttributeInterface attribute) {
            super("instructors");
            if (attribute.hasInstructors()) {
                Iterator<InstructorInterface> i = attribute.getInstructors().iterator();
                while (i.hasNext()) {
                    InstructorInterface instructor = i.next();
                    this.add((Widget)new InstructorCell(instructor, i.hasNext()));
                }
            }
        }
    }
}

