/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorAttributesComparator;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.InstructorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorAttributesTable
extends UniTimeTable<InstructorInterface.AttributeInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private InstructorInterface.AttributesColumn iSortBy = null;
    private boolean iAsc = true;

    public InstructorAttributesTable() {
        this.setStyleName("unitime-InstructorAttributes");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final InstructorInterface.AttributesColumn column : InstructorInterface.AttributesColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final InstructorInterface.AttributesColumn column : InstructorInterface.AttributesColumn.values()) {
            if (!InstructorAttributesComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    InstructorAttributesTable.this.doSort(column);
                }

                public boolean isApplicable() {
                    return InstructorAttributesTable.this.getRowCount() > 1 && h.isVisible();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(InstructorCookie.getInstance().getSortAttributesBy());
    }

    protected void doSort(InstructorInterface.AttributesColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        InstructorCookie.getInstance().setSortAttributesBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = InstructorInterface.AttributesColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = InstructorInterface.AttributesColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = InstructorInterface.AttributesColumn.NAME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new InstructorAttributesComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(InstructorInterface.AttributesColumn column) {
        switch (column) {
            default: 
        }
        return 1;
    }

    public String getColumnName(InstructorInterface.AttributesColumn column, int idx) {
        switch (column) {
            case CODE: {
                return MESSAGES.colAbbreviation();
            }
            case NAME: {
                return MESSAGES.colName();
            }
            case TYPE: {
                return MESSAGES.colType();
            }
            case PARENT: {
                return MESSAGES.colParentAttribute();
            }
            case INSTRUCTORS: {
                return MESSAGES.colInstructors();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(InstructorInterface.AttributesColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(InstructorInterface.AttributesColumn column) {
        int ret = 0;
        for (InstructorInterface.AttributesColumn c : InstructorInterface.AttributesColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(InstructorInterface.AttributeInterface feature, InstructorInterface.AttributesColumn column, int idx) {
        switch (column) {
            case NAME: {
                return new Label(feature.getName() == null ? "" : feature.getName(), false);
            }
            case CODE: {
                return new Label(feature.getCode() == null ? "" : feature.getCode(), false);
            }
            case TYPE: {
                if (feature.getType() == null) {
                    return null;
                }
                Label type = new Label(feature.getType().getAbbreviation(), false);
                type.setTitle(feature.getType().getLabel());
                return type;
            }
            case PARENT: {
                return new Label(feature.getParentName() == null ? "" : feature.getParentName(), false);
            }
            case INSTRUCTORS: {
                if (feature.hasInstructors()) {
                    return new InstructorsCell(feature);
                }
                return null;
            }
        }
        return null;
    }

    public int addAttribute(InstructorInterface.AttributeInterface attribute) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (InstructorInterface.AttributesColumn column : InstructorInterface.AttributesColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(attribute, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(attribute, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    @Override
    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof HasRefresh)) continue;
                ((HasRefresh)w).refresh();
            }
        }
    }

    public InstructorInterface.AttributeInterface getAttribute(Long attributeId) {
        if (attributeId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!attributeId.equals(((InstructorInterface.AttributeInterface)this.getData(i)).getId())) continue;
            return (InstructorInterface.AttributeInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long attributeId) {
        if (attributeId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!attributeId.equals(((InstructorInterface.AttributeInterface)this.getData(i)).getId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
            return;
        }
    }

    public static interface HasRefresh {
        public void refresh();
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    public static class InstructorCell
    extends P {
        public InstructorCell(InstructorInterface instructor, boolean hasNext) {
            super("instructor");
            this.setText(instructor.getFormattedName() + (hasNext ? ";" : ""));
        }
    }

    public static class InstructorsCell
    extends P {
        public InstructorsCell(InstructorInterface.AttributeInterface attribute) {
            super("instructors");
            if (attribute.hasInstructors()) {
                Iterator<InstructorInterface> i = attribute.getInstructors().iterator();
                while (i.hasNext()) {
                    InstructorInterface instructor = i.next();
                    this.add((Widget)new InstructorCell(instructor, i.hasNext()));
                }
            }
        }
    }
}

