/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeGrid
extends Composite {
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    public static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static DateTimeFormat sDateFormat = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormat());
    private boolean iShowRoomNote = false;
    private P iContainer;
    private ScrollPanel iScrollPanel;
    private P iPanel;
    private P iGrid;
    private P iHeader;
    private P iDock;
    private P iVLines;
    private P iSelections;
    private P[] iSeparators = new P[7];
    private P iWorkingHours;
    private P iTimes;
    private P iRoomNote;
    private SelectionLayer iSelectionLayer;
    private List<EventInterface.SelectionInterface> iAllSelections = new ArrayList<EventInterface.SelectionInterface>();
    private EventInterface.ResourceType iResourceType;
    private boolean iShowShadows;
    private ArrayList<ArrayList<Meeting>> iMeetings = new ArrayList();
    private ArrayList<Meeting>[][] iMeetingTable = new ArrayList[7][288];
    private int iCellWidth = 150;
    private int iCellHeight = 60;
    private int[] iDays = new int[]{0, 1, 2, 3, 4};
    private int iStart = 0;
    private int iEnd = 24;
    private int iTotalNrColumns = 0;
    private ArrayList<MeetingClickHandler> iMeetingClickHandlers = new ArrayList();
    private HashMap<Long, String> iColors = new HashMap();
    private List<EventInterface.ResourceInterface> iRoomResources = null;
    private List<EventInterface.WeekInterface> iSelectedWeeks = null;
    private EventAdd.EventPropertiesProvider iPropertiesProvider = null;
    private List<HandlerRegistration> iHandlerRegistrations = new ArrayList<HandlerRegistration>();
    private Mode iMode = Mode.FILLSPACE;
    private List<P> iDayLabels = new ArrayList<P>();
    private List<String> iDayOfWeeks = null;

    public TimeGrid(EventAdd.EventPropertiesProvider properties) {
        this(new HashMap<Long, String>(), new int[]{0, 1, 2, 3, 4}, (int)(0.9 * (double)ToolBox.getClientWidth() / 5.0), false, false, 0, 24, properties);
    }

    public TimeGrid(HashMap<Long, String> colors, int[] days, int cellWidth, boolean print, boolean scroll, int start, int end, EventAdd.EventPropertiesProvider properties) {
        this(colors, days, cellWidth, 60, print, scroll, start, end, properties);
    }

    public TimeGrid(HashMap<Long, String> colors, int[] days, int cellWidth, int cellHeight, boolean print, boolean scroll, int start, int end, EventAdd.EventPropertiesProvider properties) {
        int i;
        this.iPropertiesProvider = properties;
        this.iColors = colors;
        this.iDays = days;
        this.iCellWidth = cellWidth;
        this.iCellHeight = cellHeight;
        this.iStart = start;
        this.iEnd = end;
        boolean bl = this.iShowShadows = !print;
        if (days.length > 7) {
            this.iMeetingTable = new ArrayList[days.length][288];
            this.iSeparators = new P[days.length];
        }
        this.iContainer = new P("unitime-TimeGrid");
        this.iContainer.setSize(40 + this.iDays.length * this.iCellWidth, scroll ? 575.0 : (double)(25 + this.iCellHeight * (this.iEnd - this.iStart)));
        this.iHeader = new P("calendar-header");
        this.iHeader.setWidth(this.iDays.length * this.iCellWidth);
        this.iDock = new P("calendar-dock");
        this.iDock.setHeight(this.iCellHeight * (this.iEnd - this.iStart) + 5);
        this.iPanel = new P("calendar-panel");
        this.iPanel.setSize(this.iDays.length * this.iCellWidth + 5, this.iCellHeight * (this.iEnd - this.iStart));
        this.iTimes = new P("calendar-times");
        this.iTimes.setHeight(this.iCellHeight * (this.iEnd - this.iStart));
        for (i = 0; i < this.iDays.length; ++i) {
            P sp = new P("header-time-interval");
            sp.setWidth(this.iCellWidth);
            sp.setText(CONSTANTS.longDays()[this.iDays[i]]);
            this.iHeader.add((Widget)sp, i * this.iCellWidth, 0);
            this.iDayLabels.add(sp);
        }
        this.iGrid = new P("calendar-grid");
        this.iWorkingHours = new P("working-hours");
        this.iWorkingHours.setSize(this.iCellWidth * this.nrWorkDays(), this.iCellHeight * (CONSTANTS.eventStopDefault() - CONSTANTS.eventStartDefault()) / 12);
        this.iPanel.add((Widget)this.iWorkingHours, this.iCellWidth * this.firstWorkDay(), this.iCellHeight * CONSTANTS.eventStartDefault() / 12 - this.iCellHeight * this.iStart);
        this.iRoomNote = new P("room-note");
        this.iPanel.add((Widget)this.iRoomNote, 0, 0);
        for (i = this.iStart; i < this.iEnd; ++i) {
            P sp1 = new P("major-time-interval");
            this.iGrid.add((Widget)sp1, 0, this.iCellHeight * (i - this.iStart));
            P sp3 = new P("dummy-time-interval");
            sp3.setText(CONSTANTS.useAmPm() ? (i == 0 ? "12am" : (i <= 11 ? i + "am" : (i == 12 ? "12pm" : i - 12 + "pm"))) : String.valueOf(i));
            this.iTimes.add((Widget)sp3, 0, this.iCellHeight * (i - this.iStart));
            P sp2 = new P("minor-time-interval");
            this.iGrid.add((Widget)sp2, 0, this.iCellHeight * (i - this.iStart) + this.iCellHeight / 2);
            P sp4 = new P("dummy-time-interval");
            this.iTimes.add((Widget)sp4, 0, this.iCellHeight * (i - this.iStart) + this.iCellHeight / 2);
        }
        for (int day = 0; day < this.iDays.length; ++day) {
            this.iSeparators[day] = new P("day-separator");
            this.iGrid.add((Widget)this.iSeparators[day], this.iCellWidth * day, 0);
        }
        P lastSeparator = new P("day-separator");
        lastSeparator.getElement().getStyle().setRight(0.0, Style.Unit.PX);
        lastSeparator.getElement().getStyle().setTop(0.0, Style.Unit.PX);
        lastSeparator.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        this.iGrid.add((Widget)lastSeparator);
        this.iPanel.add((Widget)this.iGrid, 0, 0);
        this.iDock.add((Widget)this.iTimes, 0, 0);
        this.iDock.add((Widget)this.iPanel, 30, 0);
        this.iContainer.add((Widget)this.iHeader, 30, 0);
        this.iVLines = new P("calendar-grid");
        this.iPanel.add((Widget)this.iVLines, 0, 0);
        this.iSelections = new P("calendar-grid");
        this.iPanel.add((Widget)this.iSelections, 0, 0);
        this.iSelectionLayer = new SelectionLayer();
        this.iSelectionLayer.setVisible(false);
        this.iPanel.add((Widget)this.iSelectionLayer, 0, 0);
        if (scroll) {
            this.iScrollPanel = new ScrollPanel((Widget)this.iDock);
            this.iScrollPanel.setStyleName("calendar-scroll");
            this.iContainer.add((Widget)this.iScrollPanel, 0, 20);
        } else {
            this.iContainer.add((Widget)this.iDock, 0, 20);
        }
        this.initWidget((Widget)this.iContainer);
        if (!print) {
            this.iHandlerRegistrations.add(RootPanel.get().addDomHandler((EventHandler)new MouseUpHandler(){

                public void onMouseUp(MouseUpEvent event) {
                    if (TimeGrid.this.iSelectionLayer.isVisible()) {
                        TimeGrid.this.iSelectionLayer.onMouseUp();
                    }
                }
            }, MouseUpEvent.getType()));
        }
    }

    public void destroy() {
        this.iMeetingClickHandlers.clear();
        for (HandlerRegistration reg : this.iHandlerRegistrations) {
            reg.removeHandler();
        }
    }

    public void setShowRoomNote(boolean showRoomNote) {
        this.iShowRoomNote = showRoomNote;
    }

    public boolean isShowRoomNote() {
        return this.iShowRoomNote;
    }

    public void setResourceType(EventInterface.ResourceType resourceType) {
        this.iResourceType = resourceType;
    }

    public EventInterface.ResourceType getResourceType() {
        return this.iResourceType;
    }

    public boolean isShowVerticalSplit() {
        if (CONSTANTS.timeGridStudentGroupDoesNotOverlap()) {
            return this.getMode() == Mode.OVERLAP && (this.getResourceType() != EventInterface.ResourceType.PERSON || !this.isSingleWeek() || this.getResourceType() != EventInterface.ResourceType.GROUP);
        }
        return this.getMode() == Mode.OVERLAP && (this.getResourceType() != EventInterface.ResourceType.PERSON || !this.isSingleWeek());
    }

    public boolean isAllowSelection() {
        if (CONSTANTS.timeGridStudentGroupDoesNotOverlap()) {
            return this.getMode() == Mode.OVERLAP && (this.isSingleRoom() || this.isSingleWeek()) && this.getResourceType() != EventInterface.ResourceType.PERSON && this.getResourceType() != EventInterface.ResourceType.GROUP;
        }
        return this.getMode() == Mode.OVERLAP && (this.isSingleRoom() || this.isSingleWeek()) && this.getResourceType() != EventInterface.ResourceType.PERSON;
    }

    private boolean isVerticalSplitByWeek() {
        return this.isSingleRoom() || this.getResourceType() == EventInterface.ResourceType.PERSON || CONSTANTS.timeGridStudentGroupDoesNotOverlap() && this.getResourceType() == EventInterface.ResourceType.GROUP;
    }

    public List<EventInterface.WeekInterface> getSelectedWeeks() {
        return this.iSelectedWeeks;
    }

    public void setSelectedWeeks(List<EventInterface.WeekInterface> weeks) {
        this.iSelectedWeeks = weeks;
    }

    public boolean isSingleWeek() {
        return this.iSelectedWeeks != null && this.iSelectedWeeks.size() == 1;
    }

    public void setRoomResources(List<EventInterface.ResourceInterface> roomResources) {
        this.iRoomResources = roomResources;
        if (this.isSingleRoom() && this.isShowRoomNote()) {
            EventInterface.ResourceInterface r = this.iRoomResources.get(0);
            this.iRoomNote.setHTML(r.hasMessage() && r.isShowMessageInGrid() ? r.getMessage() : "");
        } else {
            this.iRoomNote.setHTML("");
        }
    }

    public List<EventInterface.ResourceInterface> getRoomResources() {
        return this.iRoomResources;
    }

    public boolean isSingleRoom() {
        return this.iRoomResources != null && this.iRoomResources.size() == 1;
    }

    public void setMode(Mode mode) {
        this.iMode = mode;
        this.showSelections();
    }

    public Mode getMode() {
        return this.iMode;
    }

    public TimeGrid getPrintWidget() {
        int firstSlot = this.firstSlot();
        int firstHour = firstSlot / 12;
        int maxFirstHour = CONSTANTS.eventStartDefault() / 12;
        int minLastHour = (11 + CONSTANTS.eventStopDefault()) / 12;
        if (firstHour <= maxFirstHour && firstHour > 0 && firstSlot % 12 <= 6) {
            --firstHour;
        }
        int lastHour = (11 + this.lastSlot()) / 12;
        TimeGrid tg = new TimeGrid(this.iColors, this.iDays, 1000 / this.iDays.length, true, false, firstHour < maxFirstHour ? firstHour : maxFirstHour, lastHour > minLastHour ? lastHour : minLastHour, this.iPropertiesProvider);
        tg.setShowRoomNote(this.isShowRoomNote());
        tg.setSelectedWeeks(this.getSelectedWeeks());
        tg.setRoomResources(this.getRoomResources());
        tg.setResourceType(this.getResourceType());
        tg.setMode(this.getMode());
        tg.showVerticalSplit();
        return tg;
    }

    public void addPrintEvent(EventInterface event) {
        this.addPrintEvent(event, event.getMeetings());
    }

    public void addPrintEvent(EventInterface event, Collection<EventInterface.MeetingInterface> meetings) {
        for (Meeting m : this.addEvent(event, meetings)) {
            m.setDummy();
            m.addStyleName(event.getType() == EventInterface.EventType.Unavailabile ? "unavailability-selected-noshadow" : "meeting-selected-noshadow");
        }
    }

    public void labelDays(EventInterface.WeekInterface first, EventInterface.WeekInterface last) {
        for (int i = 0; i < this.iDays.length; ++i) {
            this.iDayLabels.get(i).setText(CONSTANTS.longDays()[this.iDays[i]] + (first == null ? "" : " " + first.getDayNames().get(this.iDays[i])) + (last == null ? "" : " - " + last.getDayNames().get(this.iDays[i])));
        }
    }

    public void labelDays(List<String> dows, EventInterface.WeekInterface week) {
        this.iDayOfWeeks = dows;
        for (int i = 0; i < this.iDays.length; ++i) {
            this.iDayLabels.get(i).setText(dows.get(i) + " " + week.getDayNames().get(i));
        }
    }

    private int nrWorkDays() {
        int ret = 0;
        for (int i = 0; i < this.iDays.length; ++i) {
            if (this.iDays[i] >= 5) continue;
            ++ret;
        }
        return ret;
    }

    private int firstWorkDay() {
        for (int i = 0; i < this.iDays.length; ++i) {
            if (this.iDays[i] >= 5) continue;
            return i;
        }
        return this.iDays.length;
    }

    public void yellow(int start, int stop) {
        this.iWorkingHours.setWidth(this.iCellWidth * this.iDays.length);
        this.iWorkingHours.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
        this.iWorkingHours.getElement().getStyle().setTop((double)(this.iCellHeight * start / 12 - this.iCellHeight * this.iStart), Style.Unit.PX);
        this.iWorkingHours.setHeight(this.iCellHeight * (stop - start) / 12);
    }

    public void gray(int firstDay, int lastDay) {
        P selectionDisabled = new P("selection-disabled");
        if (lastDay - firstDay + 1 < this.iDays.length) {
            selectionDisabled.setWidth(3 + this.iCellWidth * (lastDay - firstDay + 1));
        }
        this.iPanel.add((Widget)selectionDisabled, this.iCellWidth * firstDay, 0);
    }

    public void setDays(int[] days) {
        this.iDays = days;
        this.iCellWidth = (int)(0.9 * (double)ToolBox.getClientWidth() / (double)this.iDays.length);
        this.iContainer.setWidth(40 + this.iDays.length * this.iCellWidth);
        this.iHeader.setWidth(this.iDays.length * this.iCellWidth);
        this.iPanel.setWidth(this.iDays.length * this.iCellWidth);
        this.iWorkingHours.setWidth(this.iCellWidth * this.nrWorkDays());
        this.iWorkingHours.getElement().getStyle().setLeft((double)(this.iCellWidth * this.firstWorkDay()), Style.Unit.PX);
        for (int day = 0; day < 7; ++day) {
            if (day < this.iDays.length) {
                if (this.iSeparators[day] == null) {
                    this.iSeparators[day] = new P("day-separator");
                    this.iGrid.add((Widget)this.iSeparators[day], this.iCellWidth * day, 0);
                    continue;
                }
                this.iSeparators[day].getElement().getStyle().setLeft((double)(this.iCellWidth * day), Style.Unit.PX);
                this.iSeparators[day].setVisible(true);
                continue;
            }
            if (this.iSeparators[day] == null) continue;
            this.iSeparators[day].setVisible(false);
        }
        this.iHeader.clear();
        this.iDayLabels.clear();
        for (int i = 0; i < this.iDays.length; ++i) {
            P sp = new P("header-time-interval");
            sp.setWidth(this.iCellWidth);
            sp.setText(CONSTANTS.longDays()[this.iDays[i]]);
            this.iHeader.add((Widget)sp, i * this.iCellWidth, 0);
            this.iDayLabels.add(sp);
        }
        for (ArrayList<Meeting> meetings : this.iMeetings) {
            for (Meeting meeting : meetings) {
                meeting.move();
            }
        }
        for (int i = 0; i < this.iSelections.getWidgetCount(); ++i) {
            Widget w = this.iSelections.getWidget(i);
            if (!(w instanceof SelectionPanel)) continue;
            ((SelectionPanel)w).move();
        }
        this.showVerticalSplit();
    }

    public void showVerticalSplit() {
        block8: {
            this.iVLines.clear();
            if (!this.isShowVerticalSplit()) break block8;
            if (this.isVerticalSplitByWeek()) {
                for (int d = 0; d < this.iDays.length; ++d) {
                    for (int w = 0; w < this.iSelectedWeeks.size(); ++w) {
                        if (w > 0) {
                            this.iVLines.add((Widget)new P("week-separator"), 3 + this.iCellWidth * d + w * (this.iCellWidth - 6) / this.iSelectedWeeks.size(), 0);
                        }
                        EventInterface.DateInterface di = this.iSelectedWeeks.get(w).getDayNames().get(this.iDays[d]);
                        P p = new P("week-title");
                        p.setHTML(CONSTANTS.firstDayThenMonth() ? di.getDay() + "<br>" + di.getMonth() : di.getMonth() + "<br>" + di.getDay());
                        p.setWidth((this.iCellWidth - 6) / this.iSelectedWeeks.size());
                        this.iVLines.add((Widget)p, 3 + this.iCellWidth * d + w * (this.iCellWidth - 6) / this.iSelectedWeeks.size(), 0);
                    }
                }
            } else {
                for (int d = 0; d < this.iDays.length; ++d) {
                    for (int w = 0; w < this.iRoomResources.size(); ++w) {
                        if (w > 0) {
                            this.iVLines.add((Widget)new P("week-separator"), 3 + this.iCellWidth * d + w * (this.iCellWidth - 6) / this.iRoomResources.size(), 0);
                        }
                        P p = new P("week-title");
                        p.setHTML(this.iRoomResources.get(w).getName().replaceAll(" ", "<br>"));
                        p.setWidth((this.iCellWidth - 6) / this.iRoomResources.size());
                        this.iVLines.add((Widget)p, 3 + this.iCellWidth * d + w * (this.iCellWidth - 6) / this.iRoomResources.size(), 0);
                    }
                }
            }
        }
    }

    public int firstSlot() {
        for (int slot = 0; slot < 288; ++slot) {
            for (int day = 0; day < 7; ++day) {
                if (this.iMeetingTable[day][slot] == null || this.iMeetingTable[day][slot].isEmpty()) continue;
                return slot;
            }
        }
        return 289;
    }

    public int lastSlot() {
        for (int slot = 287; slot >= 0; --slot) {
            for (int day = 0; day < 7; ++day) {
                if (this.iMeetingTable[day][slot] == null || this.iMeetingTable[day][slot].isEmpty()) continue;
                return slot;
            }
        }
        return 0;
    }

    public void shrink(boolean skipDays, boolean showUnavailable, boolean ... day) {
        int i;
        boolean[] hasDay = new boolean[]{!skipDays, !skipDays, !skipDays, !skipDays, !skipDays, false, false};
        for (i = 0; i < day.length; ++i) {
            if (!day[i]) continue;
            hasDay[i] = true;
        }
        block1: for (i = 0; i < 7; ++i) {
            if (hasDay[i]) continue;
            block2: for (int slot = 0; slot < 288; ++slot) {
                if (this.iMeetingTable[i][slot] == null) continue;
                if (showUnavailable) {
                    if (this.iMeetingTable[i][slot].isEmpty()) continue;
                    hasDay[i] = true;
                    continue block1;
                }
                for (Meeting meeting : this.iMeetingTable[i][slot]) {
                    if (meeting.getEvent().getType() == EventInterface.EventType.Unavailabile) continue;
                    hasDay[i] = true;
                    continue block2;
                }
            }
        }
        for (i = 0; i < this.iSelections.getWidgetCount(); ++i) {
            Widget w = this.iSelections.getWidget(i);
            if (!(w instanceof SelectionPanel)) continue;
            SelectionPanel sp = (SelectionPanel)w;
            for (int dow = sp.getFirstDayOfWeek(); dow <= sp.getLastDayOfWeek(); ++dow) {
                hasDay[dow] = true;
            }
        }
        int nrDays = 0;
        for (boolean d : hasDay) {
            if (!d) continue;
            ++nrDays;
        }
        int[] days = new int[nrDays];
        int d = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (!hasDay[i2]) continue;
            days[d++] = i2;
        }
        this.setDays(days);
    }

    public void clear() {
        for (ArrayList<Meeting> meetings : this.iMeetings) {
            for (Meeting meeting : meetings) {
                if (meeting.hasShadow()) {
                    this.iPanel.remove((Widget)meeting.getShadow());
                }
                this.iPanel.remove((Widget)meeting);
            }
        }
        this.iMeetings.clear();
        for (int i = 0; i < this.iMeetingTable.length; ++i) {
            for (int j = 0; j < this.iMeetingTable[i].length; ++j) {
                if (this.iMeetingTable[i][j] == null) continue;
                this.iMeetingTable[i][j].clear();
            }
        }
        this.iTotalNrColumns = 0;
        this.iSelections.clear();
    }

    public void showSelections() {
        this.iSelectionLayer.setVisible(this.isAllowSelection());
        this.iSelections.clear();
        if (!this.isAllowSelection()) {
            return;
        }
        block0: for (EventInterface.SelectionInterface selection : this.iAllSelections) {
            for (EventInterface.ResourceInterface location : this.iRoomResources) {
                if (!selection.getLocations().contains(location)) continue;
                SelectionPanel panel = new SelectionPanel(selection);
                if (!panel.isVisible()) continue block0;
                this.iSelections.add((Widget)panel, panel.getLeft(), panel.getTop());
                continue block0;
            }
        }
    }

    public String getColor(EventInterface event) {
        if (event.getType() == EventInterface.EventType.Unavailabile) {
            return null;
        }
        String color = this.iColors.get(event.getId());
        if (color == null) {
            color = CONSTANTS.meetingColors()[this.iColors.size() % CONSTANTS.meetingColors().length];
            this.iColors.put(event.getId(), color);
        }
        return color;
    }

    protected Meeting addMeeting(EventInterface event, EventInterface.MeetingInterface firstMeeting, int day, int startSlot, int length, int startOffset, int endOffset, String name, ArrayList<String> note, String color, int firstWeekIndex, int nrMeetings, ArrayList<Meeting> meetings, String dates, String rooms) {
        switch (this.iMode) {
            case PROPORTIONAL: {
                int i;
                int i2;
                boolean[] used = new boolean[this.iTotalNrColumns + nrMeetings];
                for (i2 = 0; i2 < used.length; ++i2) {
                    used[i2] = false;
                }
                for (i2 = 0; i2 < length; ++i2) {
                    if (this.iMeetingTable[day][startSlot + i2] == null) continue;
                    for (Meeting m : this.iMeetingTable[day][startSlot + i2]) {
                        for (int k = 0; k < m.getNrMeetings(); ++k) {
                            used[m.getColumn() + k] = true;
                        }
                    }
                }
                int col = 0;
                block9: for (i = 0; i <= this.iTotalNrColumns; ++i) {
                    for (int j = 0; j < nrMeetings; ++j) {
                        if (used[i + j]) continue block9;
                    }
                    col = i;
                    break;
                }
                if (this.iTotalNrColumns < col + nrMeetings) {
                    this.iTotalNrColumns = col + nrMeetings;
                    for (i = 0; i < this.iPanel.getWidgetCount(); ++i) {
                        Widget w = this.iPanel.getWidget(i);
                        if (!(w instanceof Meeting)) continue;
                        ((Meeting)w).move();
                    }
                }
                Meeting meeting = new Meeting(event, firstMeeting, name, note, day, startSlot, length, col, 1, nrMeetings, meetings, startOffset, endOffset, dates, rooms);
                meeting.setColor(color);
                if (meeting.hasShadow()) {
                    this.iPanel.add((Widget)meeting.getShadow());
                }
                this.iPanel.add((Widget)meeting);
                for (int i3 = 0; i3 < length; ++i3) {
                    if (this.iMeetingTable[day][startSlot + i3] == null) {
                        this.iMeetingTable[day][startSlot + i3] = new ArrayList();
                    }
                    this.iMeetingTable[day][startSlot + i3].add(meeting);
                }
                return meeting;
            }
            case FILLSPACE: {
                int col = -1;
                for (int i = 0; i < length; ++i) {
                    if (this.iMeetingTable[day][startSlot + i] == null) continue;
                    for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                        if (m.getColumn() <= col) continue;
                        col = m.getColumn();
                    }
                }
                int cols = ++col + 1;
                if (col > 0) {
                    int i;
                    boolean[] used = new boolean[cols - 1];
                    for (i = 0; i < cols - 1; ++i) {
                        used[i] = false;
                    }
                    for (i = 0; i < length; ++i) {
                        if (this.iMeetingTable[day][startSlot + i] == null) continue;
                        for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                            used[m.getColumn()] = true;
                        }
                    }
                    for (i = 0; i < cols - 1; ++i) {
                        if (used[i]) continue;
                        col = i;
                        --cols;
                        break;
                    }
                }
                Meeting meeting = new Meeting(event, firstMeeting, name, note, day, startSlot, length, col, cols, 1, meetings, startOffset, endOffset, dates, rooms);
                meeting.setColor(color);
                if (meeting.hasShadow()) {
                    this.iPanel.add((Widget)meeting.getShadow());
                }
                this.iPanel.add((Widget)meeting);
                for (int i = 0; i < length; ++i) {
                    if (this.iMeetingTable[day][startSlot + i] == null) {
                        this.iMeetingTable[day][startSlot + i] = new ArrayList();
                    }
                    for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                        m.setNrColumns(cols);
                    }
                    this.iMeetingTable[day][startSlot + i].add(meeting);
                }
                return meeting;
            }
            case OVERLAP: {
                int overlap = -1;
                for (int i = 0; i < length; ++i) {
                    if (this.iMeetingTable[day][startSlot + i] == null) continue;
                    for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                        if (m.getColumn() != firstWeekIndex || m.getNrColumns() <= overlap) continue;
                        overlap = m.getNrColumns();
                    }
                }
                int overlaps = ++overlap + 1;
                if (overlap > 0) {
                    int i;
                    boolean[] used = new boolean[overlaps - 1];
                    for (i = 0; i < overlaps - 1; ++i) {
                        used[i] = false;
                    }
                    for (i = 0; i < length; ++i) {
                        if (this.iMeetingTable[day][startSlot + i] == null) continue;
                        for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                            if (m.getColumn() != firstWeekIndex) continue;
                            used[m.getNrColumns()] = true;
                        }
                    }
                    for (i = 0; i < overlaps - 1; ++i) {
                        if (used[i]) continue;
                        overlap = i;
                        --overlaps;
                        break;
                    }
                }
                Meeting meeting = new Meeting(event, firstMeeting, name, note, day, startSlot, length, firstWeekIndex, overlap, nrMeetings, meetings, startOffset, endOffset, dates, rooms);
                meeting.setColor(color);
                if (meeting.hasShadow()) {
                    this.iPanel.add((Widget)meeting.getShadow());
                }
                this.iPanel.add((Widget)meeting);
                for (int i = 0; i < length; ++i) {
                    if (this.iMeetingTable[day][startSlot + i] == null) {
                        this.iMeetingTable[day][startSlot + i] = new ArrayList();
                    }
                    this.iMeetingTable[day][startSlot + i].add(meeting);
                }
                return meeting;
            }
        }
        return null;
    }

    private int weekIndex(EventInterface.MeetingInterface m) {
        if (this.isVerticalSplitByWeek()) {
            if (this.iSelectedWeeks == null) {
                return -1;
            }
            for (int i = 0; i < this.iSelectedWeeks.size(); ++i) {
                if (this.iSelectedWeeks.get(i).getDayOfYear() > m.getDayOfYear() || m.getDayOfYear() > this.iSelectedWeeks.get(i).getLastDayOfYear()) continue;
                return i;
            }
            return -1;
        }
        if (this.isSingleWeek()) {
            return this.iRoomResources == null || m.getLocation() == null ? -1 : this.iRoomResources.indexOf(m.getLocation());
        }
        return -1;
    }

    public ArrayList<Meeting> addEvent(EventInterface event) {
        return this.addEvent(event, event.getMeetings());
    }

    public ArrayList<Meeting> addEvent(EventInterface event, Collection<EventInterface.MeetingInterface> eventMeetings) {
        if (event.getType() == EventInterface.EventType.Unavailabile && (this.iMode != Mode.OVERLAP || this.iResourceType != EventInterface.ResourceType.ROOM)) {
            return new ArrayList<Meeting>();
        }
        String color = this.getColor(event);
        ArrayList<Meeting> done = new ArrayList<Meeting>();
        ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>(eventMeetings);
        while (!meetings.isEmpty()) {
            Meeting m;
            EventInterface.MeetingInterface meeting = null;
            TreeSet<EventInterface.MeetingInterface> dates = new TreeSet<EventInterface.MeetingInterface>(new Comparator<EventInterface.MeetingInterface>(){

                @Override
                public int compare(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
                    return new Integer(m1.getDayOfYear()).compareTo(new Integer(m2.getDayOfYear()));
                }
            });
            TreeSet<String> rooms = new TreeSet<String>();
            EventInterface.MeetingInterface prev = null;
            Iterator<EventInterface.MeetingInterface> i = meetings.iterator();
            while (i.hasNext()) {
                EventInterface.MeetingInterface m2 = i.next();
                if (meeting == null) {
                    meeting = m2;
                    prev = m2;
                    dates.add(m2);
                    if (m2.getLocation() != null) {
                        rooms.add(m2.getLocation().getNameWithDisplayName(MESSAGES));
                    }
                    i.remove();
                    continue;
                }
                if (meeting.getStartSlot() != m2.getStartSlot() || meeting.getEndSlot() != m2.getEndSlot() || meeting.getGridIndex() != m2.getGridIndex() || meeting.getStartOffset() != m2.getStartOffset() || meeting.getEndOffset() != m2.getEndOffset() || this.iMode == Mode.OVERLAP && this.weekIndex(prev) != this.weekIndex(m2) && this.weekIndex(prev) + 1 != this.weekIndex(m2)) continue;
                dates.add(m2);
                if (m2.getLocation() != null) {
                    rooms.add(m2.getLocation().getNameWithDisplayName(MESSAGES));
                }
                prev = m2;
                i.remove();
            }
            String dateString = null;
            int lastDay = 0;
            String endDate = null;
            TreeSet<Integer> days = new TreeSet<Integer>();
            for (EventInterface.MeetingInterface m3 : dates) {
                days.add(m3.getDayOfYear());
                if (dateString == null) {
                    dateString = sDateFormat.format(m3.getMeetingDate());
                    lastDay = m3.getDayOfYear();
                    endDate = null;
                    continue;
                }
                if (lastDay == m3.getDayOfYear()) continue;
                if (lastDay + 7 == m3.getDayOfYear()) {
                    endDate = sDateFormat.format(m3.getMeetingDate());
                    lastDay = m3.getDayOfYear();
                    continue;
                }
                if (endDate != null) {
                    dateString = dateString + "&nbsp;&#8209;&nbsp;" + endDate;
                }
                dateString = dateString + ", " + sDateFormat.format(m3.getMeetingDate());
                lastDay = m3.getDayOfYear();
                endDate = null;
            }
            if (endDate != null) {
                dateString = dateString + "&nbsp;&#8209;&nbsp;" + endDate;
            }
            ArrayList<String> notes = new ArrayList<String>();
            notes.add(meeting.getMeetingTime(CONSTANTS));
            if (dates.size() != this.getSelectedWeeks().size()) {
                notes.add(dateString);
            }
            String roomString = "";
            for (String room : rooms) {
                if (!roomString.isEmpty()) {
                    roomString = roomString + ", ";
                }
                roomString = roomString + room;
            }
            if (!this.isSingleRoom() || this.getResourceType() != EventInterface.ResourceType.ROOM) {
                notes.add(roomString);
            }
            if (event.hasEnrollment() || event.hasMaxCapacity()) {
                notes.add("<i>" + (event.hasEnrollment() ? MESSAGES.eventGridEnrolled(event.getEnrollment()) + (event.hasMaxCapacity() ? ", " : "") : "") + (event.hasMaxCapacity() ? MESSAGES.eventGridLimit(event.getMaxCapacity()) : "") + "</i>");
            }
            if (event.hasInstructors()) {
                for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                    notes.add(instructor.getName(MESSAGES));
                }
            }
            if (event.hasSponsor()) {
                notes.add(event.getSponsor().getName());
            }
            String eventName = event.getName();
            if (this.iPropertiesProvider.getProperties() != null && this.iPropertiesProvider.getProperties().isGridDisplayTitle() && event.hasCourseTitles() && event.getType() == EventInterface.EventType.Class) {
                eventName = event.getCourseTitles().get(0);
                if (event.hasInstruction()) {
                    eventName = event.hasExternalIds() ? eventName + " (" + event.getInstruction() + " " + event.getExternalIds().get(0) + ")" : (event.hasSectionNumber() ? eventName + " (" + event.getInstruction() + " " + event.getSectionNumber() + ")" : eventName + " (" + event.getInstruction() + ")");
                } else if (event.getType() != EventInterface.EventType.Unavailabile) {
                    eventName = eventName + " (" + CONSTANTS.eventTypeShort()[event.getType().ordinal()] + ")";
                }
            } else if (event.hasInstruction()) {
                eventName = eventName + " (" + event.getInstruction() + ")";
            } else if (event.getType() != EventInterface.EventType.Unavailabile) {
                eventName = eventName + " (" + CONSTANTS.eventTypeShort()[event.getType().ordinal()] + ")";
            }
            if (!meeting.isApproved()) {
                eventName = MESSAGES.gridEventHeaderNotApproved(eventName);
            }
            if ((m = this.addMeeting(event, meeting, meeting.getGridIndex(), meeting.getStartSlot(), meeting.getEndSlot() - meeting.getStartSlot(), meeting.getStartOffset(), meeting.getEndOffset(), eventName, notes, color, this.weekIndex(meeting), !this.isVerticalSplitByWeek() && this.iMode == Mode.OVERLAP ? rooms.size() : days.size(), done, dateString, roomString)) == null) continue;
            done.add(m);
        }
        this.iMeetings.add(done);
        return done;
    }

    private static String list2string(List<String> list) {
        String ret = "";
        for (String item : list) {
            if (!ret.isEmpty()) {
                ret = ret + "<br>";
            }
            ret = ret + item;
        }
        return ret;
    }

    public void addMeetingClickHandler(MeetingClickHandler h) {
        this.iMeetingClickHandlers.add(h);
    }

    public void removeMeetingClickHandler(MeetingClickHandler h) {
        this.iMeetingClickHandlers.remove(h);
    }

    public void hideSelectionPopup() {
        if (this.iSelectionLayer != null) {
            this.iSelectionLayer.iPopup.hide();
        }
    }

    public List<EventInterface.SelectionInterface> getSelections() {
        return this.iAllSelections;
    }

    public class SelectionPanel
    extends AbsolutePanel {
        private int iFirstDayOfWeek = -1;
        private int iLastDayOfWeek;
        private int iStartSlot;
        private int iEndSlot;
        private int iStartWeek;
        private int iEndWeek;
        private boolean iActive = false;
        private P iRemove = null;
        private P iText = null;
        private EventInterface.SelectionInterface iSelection = null;
        private Style.Cursor iCursor = null;
        private double iX;
        private double iY;
        private int iSS;
        private int iES;
        private int iSW;
        private int iEW;
        private int iSD;
        private int iED;

        public SelectionPanel(boolean fixed) {
            this.setStyleName(fixed ? "selection" : "active-selection");
            if (fixed) {
                this.iRemove = new P("x");
                this.iRemove.setHTML("&times;");
                this.iRemove.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        TimeGrid.this.iSelections.remove((Widget)SelectionPanel.this);
                        if (SelectionPanel.this.iSelection != null) {
                            TimeGrid.this.iAllSelections.remove(SelectionPanel.this.iSelection);
                        }
                    }
                });
                this.iRemove.getElement().getStyle().setRight(2.0, Style.Unit.PX);
                this.iRemove.getElement().getStyle().setTop(2.0, Style.Unit.PX);
                this.iRemove.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
                this.add((Widget)this.iRemove);
                this.iText = new P("text");
                this.add((Widget)this.iText, 0, 0);
            }
            this.sinkEvents(4);
            this.sinkEvents(8);
            this.sinkEvents(64);
        }

        private Style.Cursor cursor(double x, double y) {
            if (x <= 6.0) {
                if (y <= 6.0) {
                    return Style.Cursor.NW_RESIZE;
                }
                if (y >= (double)(this.getHeight() - 6)) {
                    return Style.Cursor.SW_RESIZE;
                }
                return Style.Cursor.W_RESIZE;
            }
            if (x >= (double)(this.getWidth() - 6)) {
                if (y <= 6.0) {
                    return Style.Cursor.NE_RESIZE;
                }
                if (y >= (double)(this.getHeight() - 6)) {
                    return Style.Cursor.SE_RESIZE;
                }
                return Style.Cursor.E_RESIZE;
            }
            if (y <= 6.0) {
                return Style.Cursor.N_RESIZE;
            }
            if (y >= (double)(this.getHeight() - 6)) {
                return Style.Cursor.S_RESIZE;
            }
            return Style.Cursor.MOVE;
        }

        public void onBrowserEvent(Event event) {
            if (this.iText == null) {
                return;
            }
            double dx = event.getClientX() - this.getAbsoluteLeft() + Window.getScrollLeft();
            double dy = event.getClientY() - this.getAbsoluteTop() + Window.getScrollTop();
            double x = event.getClientX() - TimeGrid.this.iSelectionLayer.getAbsoluteLeft() + Window.getScrollLeft();
            double y = event.getClientY() - TimeGrid.this.iSelectionLayer.getAbsoluteTop() + Window.getScrollTop();
            switch (DOM.eventGetType((Event)event)) {
                case 64: {
                    if (this.iCursor == null) {
                        this.getElement().getStyle().setCursor(this.cursor(dx, dy));
                        break;
                    }
                    this.getElement().getStyle().setCursor(this.iCursor);
                    int dSlot = 3 * (int)Math.round(4.0 * (y - this.iY) / (double)TimeGrid.this.iCellHeight);
                    int weeks = TimeGrid.this.isSingleRoom() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size();
                    int dWeek = (int)Math.round((double)weeks * (x - this.iX) / (double)(TimeGrid.this.iCellWidth - 6));
                    int dDay = 0;
                    if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                        dDay = (int)Math.round((x - this.iX - 2.0) / (double)TimeGrid.this.iCellWidth);
                        dWeek = 0;
                    }
                    switch (this.iCursor) {
                        case MOVE: {
                            dSlot = Math.min(Math.max(dSlot, TimeGrid.this.iStart * 12 - this.iSS), 12 * TimeGrid.this.iEnd - this.iES);
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.min(Math.max(dDay, -this.iSD), TimeGrid.this.iDays.length - 1 - this.iED);
                            } else {
                                dWeek = Math.min(Math.max(dWeek, -this.iSW), weeks - this.iEW - 1);
                            }
                            this.iStartSlot = this.iSS + dSlot;
                            this.iEndSlot = this.iES + dSlot;
                            this.iStartWeek = this.iSW + dWeek;
                            this.iEndWeek = this.iEW + dWeek;
                            this.iFirstDayOfWeek = TimeGrid.this.iDays[this.iSD + dDay];
                            this.iLastDayOfWeek = TimeGrid.this.iDays[this.iED + dDay];
                            break;
                        }
                        case N_RESIZE: {
                            dSlot = Math.max(dSlot, TimeGrid.this.iStart * 12 - this.iSS);
                            if (this.iSS + dSlot >= this.iES) break;
                            this.iStartSlot = this.iSS + dSlot;
                            break;
                        }
                        case NW_RESIZE: {
                            dSlot = Math.max(dSlot, TimeGrid.this.iStart * 12 - this.iSS);
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.max(dDay, -this.iSD);
                            } else {
                                dWeek = Math.max(dWeek, -this.iSW);
                            }
                            if (this.iSS + dSlot < this.iES) {
                                this.iStartSlot = this.iSS + dSlot;
                            }
                            if (this.iSW + dWeek <= this.iEW) {
                                this.iStartWeek = this.iSW + dWeek;
                            }
                            if (this.iSD + dDay > this.iED) break;
                            this.iFirstDayOfWeek = TimeGrid.this.iDays[this.iSD + dDay];
                            break;
                        }
                        case NE_RESIZE: {
                            dSlot = Math.max(dSlot, TimeGrid.this.iStart * 12 - this.iSS);
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.min(dDay, TimeGrid.this.iDays.length - 1 - this.iED);
                            } else {
                                dWeek = Math.min(dWeek, weeks - this.iEW - 1);
                            }
                            if (this.iSS + dSlot < this.iES) {
                                this.iStartSlot = this.iSS + dSlot;
                            }
                            if (this.iSW <= this.iEW + dWeek) {
                                this.iEndWeek = this.iEW + dWeek;
                            }
                            if (this.iSD > this.iED + dDay) break;
                            this.iLastDayOfWeek = TimeGrid.this.iDays[this.iED + dDay];
                            break;
                        }
                        case E_RESIZE: {
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.min(dDay, TimeGrid.this.iDays.length - 1 - this.iED);
                            } else {
                                dWeek = Math.min(dWeek, weeks - this.iEW - 1);
                            }
                            if (this.iSW <= this.iEW + dWeek) {
                                this.iEndWeek = this.iEW + dWeek;
                            }
                            if (this.iSD > this.iED + dDay) break;
                            this.iLastDayOfWeek = TimeGrid.this.iDays[this.iED + dDay];
                            break;
                        }
                        case SE_RESIZE: {
                            dWeek = Math.min(dWeek, weeks - this.iEW - 1);
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.min(dDay, TimeGrid.this.iDays.length - 1 - this.iED);
                            } else {
                                dSlot = Math.min(dSlot, 12 * TimeGrid.this.iEnd - this.iES);
                            }
                            if (this.iSW <= this.iEW + dWeek) {
                                this.iEndWeek = this.iEW + dWeek;
                            }
                            if (this.iSS < this.iES + dSlot) {
                                this.iEndSlot = this.iES + dSlot;
                            }
                            if (this.iSD > this.iED + dDay) break;
                            this.iLastDayOfWeek = TimeGrid.this.iDays[this.iED + dDay];
                            break;
                        }
                        case S_RESIZE: {
                            dSlot = Math.min(dSlot, 12 * TimeGrid.this.iEnd - this.iES);
                            if (this.iSS >= this.iES + dSlot) break;
                            this.iEndSlot = this.iES + dSlot;
                            break;
                        }
                        case SW_RESIZE: {
                            dSlot = Math.min(dSlot, 12 * TimeGrid.this.iEnd - this.iES);
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.max(dDay, -this.iSD);
                            } else {
                                dWeek = Math.max(dWeek, -this.iSW);
                            }
                            if (this.iSS < this.iES + dSlot) {
                                this.iEndSlot = this.iES + dSlot;
                            }
                            if (this.iSW + dWeek <= this.iEW) {
                                this.iStartWeek = this.iSW + dWeek;
                            }
                            if (this.iSD + dDay > this.iED) break;
                            this.iFirstDayOfWeek = TimeGrid.this.iDays[this.iSD + dDay];
                            break;
                        }
                        case W_RESIZE: {
                            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                                dDay = Math.max(dDay, -this.iSD);
                            } else {
                                dWeek = Math.max(dWeek, -this.iSW);
                            }
                            if (this.iSW + dWeek <= this.iEW) {
                                this.iStartWeek = this.iSW + dWeek;
                            }
                            if (this.iSD + dDay > this.iED) break;
                            this.iFirstDayOfWeek = TimeGrid.this.iDays[this.iSD + dDay];
                        }
                    }
                    this.move();
                    if (this.iSS != this.iStartSlot || this.iES != this.iEndSlot) {
                        this.iSelection.setStartSlot(this.iStartSlot);
                        this.iSelection.setLength(this.getLength());
                    }
                    if (this.iSW == this.iStartWeek && this.iEW == this.iEndWeek && this.iSW == this.iFirstDayOfWeek && this.iEW == this.iLastDayOfWeek) break;
                    if (TimeGrid.this.isSingleRoom()) {
                        this.iSelection.getDays().clear();
                        if (TimeGrid.this.isSingleWeek()) {
                            for (int i = this.getFirstDayOfWeek(); i <= this.getLastDayOfWeek(); ++i) {
                                this.iSelection.addDay(((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getStartWeek())).getDayOfYear() + i);
                            }
                        } else {
                            for (int i = this.getStartWeek(); i <= this.getEndWeek(); ++i) {
                                this.iSelection.getDays().add(((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(i)).getDayOfYear() + this.getFirstDayOfWeek());
                            }
                        }
                    } else {
                        this.iSelection.getLocations().clear();
                        for (int i = this.getStartWeek(); i <= this.getEndWeek(); ++i) {
                            this.iSelection.addLocation((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(i));
                        }
                    }
                    break;
                }
                case 4: {
                    this.iCursor = this.cursor(dx, dy);
                    this.iX = x;
                    this.iY = y;
                    TimeGrid.this.iSelectionLayer.iMoving = this;
                    this.iSS = this.iStartSlot;
                    this.iES = this.iEndSlot;
                    this.iSW = this.iStartWeek;
                    this.iEW = this.iEndWeek;
                    this.iSD = this.getStartDay();
                    this.iED = this.getEndDay();
                    break;
                }
                case 8: {
                    this.onMouseUp();
                }
            }
            event.preventDefault();
            event.stopPropagation();
        }

        public SelectionPanel() {
            this(false);
        }

        public SelectionPanel(int firstDay, int lastDay, int start, int length, int week, int nrWeeks) {
            this(true);
            this.setStart(firstDay, start, week);
            this.setEnd(lastDay, start + length, week + nrWeeks - 1);
            this.iSelection = new EventInterface.SelectionInterface();
            this.iSelection.setStartSlot(this.getStartSlot());
            this.iSelection.setLength(this.getLength());
            if (this$0.isSingleRoom()) {
                if (this$0.isSingleWeek()) {
                    for (int i = this.getFirstDayOfWeek(); i <= this.getLastDayOfWeek(); ++i) {
                        this.iSelection.addDay(((EventInterface.WeekInterface)this$0.iSelectedWeeks.get(this.getStartWeek())).getDayOfYear() + i);
                    }
                } else {
                    for (int i = this.getStartWeek(); i <= this.getEndWeek(); ++i) {
                        this.iSelection.addDay(((EventInterface.WeekInterface)this$0.iSelectedWeeks.get(i)).getDayOfYear() + this.getFirstDayOfWeek());
                    }
                }
                this.iSelection.addLocation(this$0.getRoomResources().get(0));
            } else {
                this.iSelection.addDay(((EventInterface.WeekInterface)this$0.iSelectedWeeks.get(0)).getDayOfYear() + this.getFirstDayOfWeek());
                for (int i = this.getStartWeek(); i <= this.getEndWeek(); ++i) {
                    this.iSelection.addLocation((EventInterface.ResourceInterface)this$0.iRoomResources.get(i));
                }
            }
            this$0.iAllSelections.add(this.iSelection);
        }

        public SelectionPanel(EventInterface.SelectionInterface selection) {
            this(true);
            this.iSelection = selection;
            int startDay = this$0.iDays.length;
            int endDay = -1;
            int startWeek = this$0.iSelectedWeeks.size();
            int endWeek = -1;
            for (int d : selection.getDays()) {
                if (this$0.isSingleWeek() && this$0.isSingleRoom()) {
                    startWeek = 0;
                    endWeek = 0;
                    int doy = this$0.getSelectedWeeks().get(0).getDayOfYear();
                    for (int f = 0; f < this$0.iDays.length; ++f) {
                        if (!selection.getDays().contains(doy + this$0.iDays[f])) continue;
                        startDay = this$0.iDays[f];
                        for (int l = f; l < this$0.iDays.length && selection.getDays().contains(doy + this$0.iDays[l]); ++l) {
                            endDay = this$0.iDays[l];
                        }
                    }
                    continue;
                }
                for (int i = 0; i < this$0.iSelectedWeeks.size(); ++i) {
                    EventInterface.WeekInterface w = (EventInterface.WeekInterface)this$0.iSelectedWeeks.get(i);
                    if (w.getDayOfYear() > d || d >= w.getDayOfYear() + 7) continue;
                    startWeek = Math.min(startWeek, i);
                    endWeek = Math.max(endWeek, i);
                    startDay = d - w.getDayOfYear();
                    endDay = d - w.getDayOfYear();
                }
            }
            int startRoom = this$0.iRoomResources.size();
            int endRoom = -1;
            for (EventInterface.ResourceInterface location : selection.getLocations()) {
                for (int i = 0; i < this$0.iRoomResources.size(); ++i) {
                    EventInterface.ResourceInterface r = (EventInterface.ResourceInterface)this$0.iRoomResources.get(i);
                    if (!r.equals(location)) continue;
                    startRoom = Math.min(startRoom, i);
                    endRoom = Math.max(endRoom, i);
                }
            }
            if (startDay <= endDay) {
                this.setStart(startDay, selection.getStartSlot(), this$0.isSingleRoom() ? startWeek : startRoom);
                this.setEnd(endDay, selection.getStartSlot() + selection.getLength(), this$0.isSingleRoom() ? endWeek : endRoom);
            } else {
                this.setVisible(false);
            }
        }

        public void setStart(int day, int slot, int week) {
            this.iFirstDayOfWeek = day;
            this.iStartSlot = slot;
            this.iStartWeek = week;
        }

        public void setEnd(int day, int slot, int week) {
            this.iEndSlot = slot;
            if (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek()) {
                this.iLastDayOfWeek = day;
                this.iEndWeek = week;
            } else if (this.iFirstDayOfWeek == day) {
                this.iEndWeek = week;
                this.iLastDayOfWeek = this.iFirstDayOfWeek;
            } else if (day < this.iFirstDayOfWeek) {
                this.iEndWeek = 0;
                this.iLastDayOfWeek = this.iFirstDayOfWeek;
            } else {
                this.iEndWeek = (TimeGrid.this.isSingleRoom() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size()) - 1;
                this.iLastDayOfWeek = this.iFirstDayOfWeek;
            }
            this.move();
        }

        public void setActive(boolean active) {
            this.iActive = active;
        }

        public boolean isActive() {
            return this.iActive;
        }

        private void move() {
            this.getElement().getStyle().setWidth((double)this.getWidth(), Style.Unit.PX);
            this.getElement().getStyle().setLeft((double)this.getLeft(), Style.Unit.PX);
            this.getElement().getStyle().setTop((double)this.getTop(), Style.Unit.PX);
            this.getElement().getStyle().setHeight((double)this.getHeight(), Style.Unit.PX);
            if (this.iText != null) {
                this.iText.setHTML((TimeGrid.this.iDayOfWeeks == null ? CONSTANTS.days()[this.getFirstDayOfWeek()] : (String)TimeGrid.this.iDayOfWeeks.get(this.getFirstDayOfWeek())) + " " + (TimeGrid.this.isSingleRoom() ? ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getStartWeek())).getDayNames().get(this.getFirstDayOfWeek()) + (this.getNrWeeks() <= 1 ? "" : "&nbsp;&#8209;&nbsp;" + ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getEndWeek())).getDayNames().get(this.getLastDayOfWeek())) : ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(0)).getDayNames().get(this.getFirstDayOfWeek())) + " " + (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek() && this.getNrDays() > 1 ? " - " + (TimeGrid.this.iDayOfWeeks == null ? CONSTANTS.days()[this.getLastDayOfWeek()] : (String)TimeGrid.this.iDayOfWeeks.get(this.getLastDayOfWeek())) + " " + ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getStartWeek())).getDayNames().get(this.getLastDayOfWeek()) + " " : "") + this.getStartTime() + "&nbsp;&#8209;&nbsp;" + this.getEndTime() + " (" + 5 * this.getLength() + "&nbsp;mins) " + (TimeGrid.this.isSingleRoom() ? ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(0)).getName().replace(" ", "&nbsp;") : ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(this.getStartWeek())).getName().replace(" ", "&nbsp;") + (this.getNrWeeks() <= 1 ? "" : "&nbsp;&#8209;&nbsp;" + ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(this.getEndWeek())).getName().replace(" ", "&nbsp;"))));
            }
        }

        public int getLeft() {
            return 4 + TimeGrid.this.iCellWidth * this.getStartDay() + this.getStartWeek() * (TimeGrid.this.iCellWidth - 6) / (TimeGrid.this.isSingleRoom() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size());
        }

        public int getTop() {
            return 1 + TimeGrid.this.iCellHeight * this.getStartSlot() / 12 - TimeGrid.this.iCellHeight * TimeGrid.this.iStart;
        }

        public int getHeight() {
            return TimeGrid.this.iCellHeight * this.getLength() / 12;
        }

        public int getWidth() {
            if (TimeGrid.this.isSingleWeek() && TimeGrid.this.isSingleRoom()) {
                return this.getNrDays() * TimeGrid.this.iCellWidth - 3;
            }
            int weeks = TimeGrid.this.isSingleRoom() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size();
            return this.getNrWeeks() * (TimeGrid.this.iCellWidth - 6) / weeks + (this.getStartWeek() + this.getNrWeeks() != weeks && weeks > 1 ? 0 : 3);
        }

        public int getStartDay() {
            for (int i = 0; i < TimeGrid.this.iDays.length; ++i) {
                if (TimeGrid.this.iDays[i] != this.getFirstDayOfWeek()) continue;
                return i;
            }
            return -1;
        }

        public int getEndDay() {
            for (int i = 0; i < TimeGrid.this.iDays.length; ++i) {
                if (TimeGrid.this.iDays[i] != this.getLastDayOfWeek()) continue;
                return i;
            }
            return -1;
        }

        public int getFirstDayOfWeek() {
            return this.iFirstDayOfWeek <= this.iLastDayOfWeek ? this.iFirstDayOfWeek : this.iLastDayOfWeek;
        }

        public int getLastDayOfWeek() {
            return this.iFirstDayOfWeek <= this.iLastDayOfWeek ? this.iLastDayOfWeek : this.iFirstDayOfWeek;
        }

        public int getStartSlot() {
            return this.iStartSlot <= this.iEndSlot ? this.iStartSlot : this.iEndSlot;
        }

        public int getEndSlot() {
            return this.getStartSlot() + this.getLength();
        }

        public int getLength() {
            return Math.max(3, this.iStartSlot < this.iEndSlot ? this.iEndSlot - this.iStartSlot : this.iStartSlot - this.iEndSlot);
        }

        public int getStartWeek() {
            return this.iStartWeek <= this.iEndWeek ? this.iStartWeek : this.iEndWeek;
        }

        public int getEndWeek() {
            return this.iStartWeek <= this.iEndWeek ? this.iEndWeek : this.iStartWeek;
        }

        public int getNrWeeks() {
            return this.iStartWeek < this.iEndWeek ? 1 + this.iEndWeek - this.iStartWeek : 1 + this.iStartWeek - this.iEndWeek;
        }

        public int getNrDays() {
            return this.iFirstDayOfWeek < this.iLastDayOfWeek ? 1 + this.iLastDayOfWeek - this.iFirstDayOfWeek : 1 + this.iFirstDayOfWeek - this.iLastDayOfWeek;
        }

        public String getStartTime() {
            int h = this.getStartSlot() / 12;
            int m = 5 * (this.getStartSlot() % 12);
            return (CONSTANTS.useAmPm() ? (h == 0 ? "12" : Integer.valueOf(h <= 12 ? h : h - 12)) : Integer.valueOf(h)) + ":" + (m < 10 ? "0" : "") + m + (CONSTANTS.useAmPm() ? (h <= 11 ? "a" : "p") : "");
        }

        public String getEndTime() {
            int h = (this.getStartSlot() + this.getLength()) / 12;
            int m = 5 * ((this.getStartSlot() + this.getLength()) % 12);
            return (CONSTANTS.useAmPm() ? (h == 0 ? "12" : Integer.valueOf(h <= 12 ? h : h - 12)) : Integer.valueOf(h)) + ":" + (m < 10 ? "0" : "") + m + (CONSTANTS.useAmPm() ? (h <= 11 ? "a" : "p") : "");
        }

        public String toString() {
            return (TimeGrid.this.iDayOfWeeks == null ? CONSTANTS.longDays()[this.getFirstDayOfWeek()] : (String)TimeGrid.this.iDayOfWeeks.get(this.getFirstDayOfWeek())) + " " + (TimeGrid.this.isSingleRoom() ? ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getStartWeek())).getDayNames().get(this.getFirstDayOfWeek()) + (this.getNrWeeks() <= 1 ? "" : " - " + ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getEndWeek())).getDayNames().get(this.getFirstDayOfWeek())) : ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(0)).getDayNames().get(this.getFirstDayOfWeek())) + " " + (TimeGrid.this.isSingleRoom() && TimeGrid.this.isSingleWeek() && this.getNrDays() > 1 ? " - " + (TimeGrid.this.iDayOfWeeks == null ? CONSTANTS.days()[this.getLastDayOfWeek()] : (String)TimeGrid.this.iDayOfWeeks.get(this.getLastDayOfWeek())) + " " + ((EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(this.getStartWeek())).getDayNames().get(this.getLastDayOfWeek()) + " " : "") + this.getStartTime() + " - " + this.getEndTime() + " (" + 5 * this.getLength() + " mins)" + " " + (TimeGrid.this.isSingleRoom() ? ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(0)).getName() : ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(this.getStartWeek())).getName() + (this.getNrWeeks() <= 1 ? "" : " - " + ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(this.getEndWeek())).getName()));
        }

        public EventInterface.SelectionInterface getSelection() {
            return this.iSelection;
        }

        private void onMouseUp() {
            if (TimeGrid.this.iSelectionLayer.iMoving != null) {
                ((SelectionLayer)((TimeGrid)TimeGrid.this).iSelectionLayer).iMoving.iCursor = null;
                TimeGrid.this.iSelectionLayer.iMoving = null;
            }
            this.iCursor = null;
        }
    }

    class SelectionLayer
    extends AbsolutePanel {
        private SelectionPanel iSelection;
        private P iHint;
        private PopupPanel iPopup;
        private SelectionPanel iMoving = null;
        private Long iLastRoomId = null;

        public SelectionLayer() {
            this.setStyleName("selection-layer");
            this.iPopup = new PopupPanel();
            this.iPopup.setStyleName("unitime-TimeGridSelectionPopup");
            this.iHint = new P("content");
            this.iPopup.setWidget((Widget)this.iHint);
            this.iSelection = new SelectionPanel();
            this.iSelection.setVisible(false);
            this.add((Widget)this.iSelection, 0, 0);
            this.sinkEvents(4);
            this.sinkEvents(8);
            this.sinkEvents(64);
            this.sinkEvents(16);
            this.sinkEvents(32);
        }

        public void onBrowserEvent(Event event) {
            if (64 == DOM.eventGetType((Event)event) && !this.iSelection.isActive() && this.iMoving != null) {
                this.iMoving.onBrowserEvent(event);
                if (this.iMoving.iCursor != null) {
                    this.getElement().getStyle().setCursor(this.iMoving.iCursor);
                }
                return;
            }
            double x = event.getClientX() - this.getAbsoluteLeft() + Window.getScrollLeft();
            double y = event.getClientY() - this.getAbsoluteTop() + Window.getScrollTop();
            int slot = 3 * Math.min(Math.max(0, (int)Math.round(4.0 * (y - 1.0 + (double)(TimeGrid.this.iStart * TimeGrid.this.iCellHeight)) / (double)TimeGrid.this.iCellHeight)), 96);
            int day = Math.min(Math.max(0, (int)Math.floor((x - 2.0) / (double)TimeGrid.this.iCellWidth)), TimeGrid.this.iDays.length - 1);
            int dayOfWeek = TimeGrid.this.iDays[day];
            int weeks = TimeGrid.this.isSingleRoom() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size();
            int week = Math.min(Math.max(0, (int)Math.floor((double)weeks * (x - 2.0 - (double)(TimeGrid.this.iCellWidth * day)) / (double)(TimeGrid.this.iCellWidth - 6))), weeks - 1);
            int h = slot / 12;
            int m = 5 * (slot % 12);
            String time = (CONSTANTS.useAmPm() ? (h == 0 ? "12" : Integer.valueOf(h <= 12 ? h : h - 12)) : Integer.valueOf(h)) + ":" + (m < 10 ? "0" : "") + m + (CONSTANTS.useAmPm() ? (h <= 11 ? "a" : "p") : "");
            String text = (TimeGrid.this.iDayOfWeeks == null ? CONSTANTS.longDays()[dayOfWeek] : (String)TimeGrid.this.iDayOfWeeks.get(dayOfWeek)) + " " + (TimeGrid.this.isSingleRoom() ? (EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(week) : (EventInterface.WeekInterface)TimeGrid.this.iSelectedWeeks.get(0)).getDayNames().get(dayOfWeek) + " " + time + (TimeGrid.this.isSingleRoom() ? "" : " " + ((EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(week)).getName());
            EventInterface.ResourceInterface room = TimeGrid.this.isSingleRoom() ? (EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(0) : (EventInterface.ResourceInterface)TimeGrid.this.iRoomResources.get(week);
            this.iPopup.setPopupPosition(event.getClientX() + Window.getScrollLeft(), event.getClientY() + Window.getScrollTop());
            this.getElement().getStyle().setCursor(Style.Cursor.CROSSHAIR);
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    this.iSelection.setStart(dayOfWeek, slot, week);
                    this.iSelection.setEnd(dayOfWeek, slot, week);
                    this.iSelection.setVisible(true);
                    this.iSelection.setActive(true);
                    break;
                }
                case 64: {
                    this.iSelection.setEnd(dayOfWeek, slot, week);
                    if (!this.iPopup.isShowing()) {
                        this.iPopup.show();
                    }
                    if (room.getId().equals(this.iLastRoomId)) break;
                    RoomHint.showHint((Element)this.iPopup.getElement(), room.getId(), "", room.hasDistance() ? String.valueOf(Math.round(room.getDistance())) : "", false);
                    this.iLastRoomId = room.getId();
                    break;
                }
                case 8: {
                    this.onMouseUp();
                    break;
                }
                case 16: {
                    if (!this.iPopup.isShowing() && (this.iSelection.isActive() || this.iMoving == null)) {
                        this.iPopup.show();
                    }
                    if (this.iSelection.isActive() && !this.iSelection.isVisible()) {
                        this.iSelection.setVisible(true);
                    }
                    if (room.getId().equals(this.iLastRoomId)) break;
                    RoomHint.showHint((Element)this.iPopup.getElement(), room.getId(), "", room.hasDistance() ? String.valueOf(Math.round(room.getDistance())) : "", false);
                    this.iLastRoomId = room.getId();
                    break;
                }
                case 32: {
                    com.google.gwt.user.client.Element child = DOM.eventGetToElement((Event)event);
                    if (child == null || this.getElement().isOrHasChild((Node)child)) break;
                    if (this.iPopup.isShowing()) {
                        this.iPopup.hide();
                        RoomHint.hideHint();
                        this.iLastRoomId = null;
                    }
                    this.iSelection.setVisible(false);
                }
            }
            this.iHint.setText(this.iSelection.isVisible() && this.iSelection.isActive() ? this.iSelection.toString() : text);
            event.preventDefault();
            event.stopPropagation();
        }

        public void onMouseUp() {
            if (this.iSelection.isVisible() && this.iSelection.isActive()) {
                SelectionPanel s = new SelectionPanel(this.iSelection.getFirstDayOfWeek(), this.iSelection.getLastDayOfWeek(), this.iSelection.getStartSlot(), this.iSelection.getLength(), this.iSelection.getStartWeek(), this.iSelection.getNrWeeks());
                TimeGrid.this.iSelections.add((Widget)s, s.getLeft(), s.getTop());
            }
            this.iSelection.setVisible(false);
            this.iSelection.setActive(false);
            for (int i = 0; i < TimeGrid.this.iSelections.getWidgetCount(); ++i) {
                Widget w = TimeGrid.this.iSelections.getWidget(i);
                if (!(w instanceof SelectionPanel)) continue;
                ((SelectionPanel)w).onMouseUp();
            }
        }

        public void clear() {
            super.clear();
            this.iSelection.setVisible(false);
            this.iSelection.setActive(false);
            this.add((Widget)this.iSelection, 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Meeting
    extends AbsolutePanel {
        private EventInterface iEvent;
        private EventInterface.MeetingInterface iMeeting;
        private int iColumn;
        private int iDayOfWeek;
        private int iNrColumns;
        private double iLeft;
        private double iWidth;
        private ArrayList<Meeting> iMeetings;
        private boolean iDummy = false;
        private int iNrMeetings;
        private P iShadow;
        private SimpleForm iHint = null;
        private String iDates = null;
        private String iRooms = null;

        private Meeting(EventInterface event, EventInterface.MeetingInterface meeting, String name, ArrayList<String> note, int dayOfWeek, int start, int length, int column, int nrColumns, int nrMeetings, ArrayList<Meeting> meetings, int startOffset, int endOffset, String dates, String rooms) {
            this.iEvent = event;
            this.iMeeting = meeting;
            this.iDates = dates;
            this.iRooms = rooms;
            this.iMeetings = meetings;
            this.iDayOfWeek = dayOfWeek;
            this.iColumn = column;
            this.iNrMeetings = nrMeetings;
            this.iNrColumns = nrColumns;
            this.setStyleName(event.getType() == EventInterface.EventType.Unavailabile ? "unavailability" : "meeting");
            P header = new P("header", "label");
            if (event.getType() != EventInterface.EventType.Unavailabile || event.getId() != null && event.getId() >= 0L) {
                header.setHTML(name);
            }
            this.add((Widget)header);
            P footer = new P("footer");
            String notes = "";
            String delim = "<br>";
            if (note.size() > 2 && length < 12) {
                delim = ", ";
            }
            if (note.size() > 3 && length < 18) {
                delim = ", ";
            }
            for (String n : note) {
                if (n == null || n.isEmpty()) continue;
                if (notes.length() > 0) {
                    notes = notes + delim;
                }
                notes = notes + "<span  style=\"white-space: nowrap\">" + n + "</span>";
            }
            if (event.getType() != EventInterface.EventType.Unavailabile || event.getId() != null && event.getId() >= 0L) {
                footer.setHTML(notes);
            }
            this.add((Widget)footer);
            double totalHeight = (double)(TimeGrid.this.iCellHeight * length) / 12.0 - 3.0;
            double setupHeight = (double)(TimeGrid.this.iCellHeight * startOffset) / 60.0;
            double teardownHeight = (double)(-TimeGrid.this.iCellHeight * endOffset) / 60.0;
            int day = -1;
            for (int d = 0; d < TimeGrid.this.iDays.length; ++d) {
                if (TimeGrid.this.iDays[d] != this.iDayOfWeek) continue;
                day = d;
                break;
            }
            switch (TimeGrid.this.iMode) {
                case PROPORTIONAL: {
                    this.iWidth = Math.max(3.0, (double)this.iNrMeetings * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)TimeGrid.this.iTotalNrColumns + (double)(this.iColumn + this.iNrMeetings != TimeGrid.this.iTotalNrColumns && TimeGrid.this.iTotalNrColumns > 1 ? -3 : 0));
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * day) + (double)this.iColumn * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)TimeGrid.this.iTotalNrColumns;
                    break;
                }
                case FILLSPACE: {
                    this.iWidth = Math.max(3.0, ((double)TimeGrid.this.iCellWidth - 6.0) / (double)this.iNrColumns + (double)(this.iColumn + 1 != this.iNrColumns && this.iNrColumns > 1 ? -3 : 0));
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * day) + (double)(this.iColumn * (TimeGrid.this.iCellWidth - 6) / this.iNrColumns);
                    break;
                }
                case OVERLAP: {
                    int weeks = TimeGrid.this.isVerticalSplitByWeek() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size();
                    this.iWidth = Math.max(3.0, (double)this.iNrMeetings * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)weeks + (double)(this.iColumn + this.iNrMeetings != weeks && weeks > 1 ? -3 : 0) - (double)(5 * this.iNrColumns));
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * day) + (double)(this.iColumn * (TimeGrid.this.iCellWidth - 6) / weeks) + (double)(5 * this.iNrColumns);
                }
            }
            this.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
            this.getElement().getStyle().setHeight(totalHeight - setupHeight - teardownHeight, Style.Unit.PX);
            this.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            this.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
            this.getElement().getStyle().setTop((double)(1 + TimeGrid.this.iCellHeight * start / 12 - TimeGrid.this.iCellHeight * TimeGrid.this.iStart) + setupHeight, Style.Unit.PX);
            if (TimeGrid.this.iShowShadows && (startOffset != 0 || endOffset != 0) && event.getType() != EventInterface.EventType.Unavailabile) {
                this.iShadow = new P("meeting-shadow");
                this.iShadow.getElement().getStyle().setHeight(totalHeight, Style.Unit.PX);
                this.iShadow.getElement().getStyle().setTop((double)(1 + TimeGrid.this.iCellHeight * start / 12 - TimeGrid.this.iCellHeight * TimeGrid.this.iStart), Style.Unit.PX);
                this.iShadow.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
                this.iShadow.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
                this.iShadow.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            }
            this.sinkEvents(1);
            this.sinkEvents(16);
            this.sinkEvents(64);
            this.sinkEvents(32);
        }

        public void setColor(String color) {
            if (color != null) {
                this.addStyleName(color);
                if (this.hasShadow()) {
                    this.iShadow.addStyleName(color);
                }
            }
        }

        public EventInterface getEvent() {
            return this.iEvent;
        }

        public boolean hasShadow() {
            return this.iShadow != null;
        }

        public P getShadow() {
            return this.iShadow;
        }

        private void select(boolean selected) {
            if (this.iEvent.getType() == EventInterface.EventType.Unavailabile && this.iEvent.getId() != null && this.iEvent.getId() < 0L) {
                return;
            }
            if (selected) {
                this.getElement().getStyle().setWidth((double)(TimeGrid.this.iCellWidth - 6), Style.Unit.PX);
                this.getElement().getStyle().setLeft((double)(4 + TimeGrid.this.iCellWidth * this.getDay()), Style.Unit.PX);
                if (this.hasShadow()) {
                    this.iShadow.getElement().getStyle().setWidth((double)(TimeGrid.this.iCellWidth - 6), Style.Unit.PX);
                    this.iShadow.getElement().getStyle().setLeft((double)(4 + TimeGrid.this.iCellWidth * this.getDay()), Style.Unit.PX);
                }
                this.getElement().getStyle().setZIndex(1001);
                if (this.hasShadow()) {
                    this.iShadow.getElement().getStyle().setZIndex(1000);
                }
                for (Meeting meeting : this.iMeetings) {
                    meeting.addStyleName(meeting.getEvent().getType() == EventInterface.EventType.Unavailabile ? "unavailability-selected" : "meeting-selected");
                    meeting.getElement().getStyle().setCursor(this.iEvent.isCanView() ? Style.Cursor.POINTER : Style.Cursor.AUTO);
                }
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        GwtHint.showHint((Element)Meeting.this.getElement(), (Widget)Meeting.this.getHint(), false);
                    }
                });
            } else {
                this.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
                this.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
                if (this.hasShadow()) {
                    this.iShadow.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
                    this.iShadow.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
                }
                this.getElement().getStyle().clearZIndex();
                if (this.hasShadow()) {
                    this.iShadow.getElement().getStyle().clearZIndex();
                }
                for (Meeting meeting : this.iMeetings) {
                    meeting.removeStyleName(meeting.getEvent().getType() == EventInterface.EventType.Unavailabile ? "unavailability-selected" : "meeting-selected");
                    meeting.getElement().getStyle().clearCursor();
                }
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        GwtHint.hideHint();
                    }
                });
            }
        }

        public void onBrowserEvent(Event event) {
            if (this.iDummy) {
                return;
            }
            com.google.gwt.user.client.Element target = DOM.eventGetTarget((Event)event);
            boolean anchor = false;
            while (target != null) {
                String tag = target.getPropertyString("tagName");
                if ("a".equalsIgnoreCase(tag)) {
                    anchor = true;
                    break;
                }
                if ("div".equalsIgnoreCase(tag)) break;
                target = DOM.getParent((Element)target);
            }
            EventTarget related = event.getRelatedEventTarget();
            switch (DOM.eventGetType((Event)event)) {
                case 1: {
                    this.select(false);
                    if (anchor) break;
                    MeetingClickEvent e = new MeetingClickEvent(this);
                    for (MeetingClickHandler h : TimeGrid.this.iMeetingClickHandlers) {
                        h.onMeetingClick(e);
                    }
                    break;
                }
                case 16: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.select(true);
                    break;
                }
                case 32: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.select(false);
                    break;
                }
                case 64: {
                    int relativeX = event.getClientX() - this.getElement().getAbsoluteLeft() + this.getElement().getScrollLeft() + this.getElement().getOwnerDocument().getScrollLeft();
                    if (!((double)relativeX < this.iLeft - 6.0 - (double)(this.getDay() * TimeGrid.this.iCellWidth)) && !((double)relativeX > this.iLeft - 2.0 - (double)(this.getDay() * TimeGrid.this.iCellWidth) + this.iWidth)) break;
                    this.select(false);
                }
            }
            super.onBrowserEvent(event);
        }

        public void setNrColumns(int nrColumns) {
            if (nrColumns == this.iNrColumns) {
                return;
            }
            this.iNrColumns = nrColumns;
            this.move();
        }

        public void move() {
            switch (TimeGrid.this.iMode) {
                case PROPORTIONAL: {
                    this.iWidth = Math.max(3.0, (double)this.iNrMeetings * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)TimeGrid.this.iTotalNrColumns + (double)(this.iColumn + this.iNrMeetings != TimeGrid.this.iTotalNrColumns && TimeGrid.this.iTotalNrColumns > 1 ? -3 : 0));
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * this.getDay()) + (double)this.iColumn * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)TimeGrid.this.iTotalNrColumns;
                    break;
                }
                case FILLSPACE: {
                    this.iWidth = ((double)TimeGrid.this.iCellWidth - 6.0) / (double)this.iNrColumns + (double)(this.iColumn + 1 != this.iNrColumns && this.iNrColumns > 1 ? -3 : 0);
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * this.getDay()) + (double)(this.iColumn * (TimeGrid.this.iCellWidth - 6) / this.iNrColumns);
                    break;
                }
                case OVERLAP: {
                    int weeks = TimeGrid.this.isVerticalSplitByWeek() ? TimeGrid.this.iSelectedWeeks.size() : TimeGrid.this.iRoomResources.size();
                    this.iWidth = (double)this.iNrMeetings * ((double)TimeGrid.this.iCellWidth - 6.0) / (double)weeks + (double)(this.iColumn + this.iNrMeetings != weeks && weeks > 1 ? -3 : 0) - (double)(5 * this.iNrColumns);
                    this.iLeft = 4.0 + (double)(TimeGrid.this.iCellWidth * this.getDay()) + (double)(this.iColumn * (TimeGrid.this.iCellWidth - 6) / weeks) + (double)(5 * this.iNrColumns);
                }
            }
            this.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
            this.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
            if (this.hasShadow()) {
                this.iShadow.getElement().getStyle().setWidth(this.iWidth, Style.Unit.PX);
                this.iShadow.getElement().getStyle().setLeft(this.iLeft, Style.Unit.PX);
            }
        }

        public SimpleForm getHint() {
            if (this.iHint == null) {
                this.iHint = new SimpleForm();
                this.iHint.addStyleName("unitime-EventMeetings");
                this.iHint.removeStyleName("unitime-NotPrintableBottomLine");
                if (this.iEvent.hasCourseNames()) {
                    ArrayList<String> name = new ArrayList<String>();
                    ArrayList<String> section = new ArrayList<String>();
                    ArrayList<String> title = new ArrayList<String>();
                    if (this.iEvent.getType() == EventInterface.EventType.Course) {
                        name.add(this.iEvent.getName());
                        section.add("");
                    }
                    for (String cn : this.iEvent.getCourseNames()) {
                        if (name.isEmpty()) {
                            name.add(cn);
                            continue;
                        }
                        if (this.iEvent.getInstruction() != null || this.iEvent.getType() == EventInterface.EventType.Course) {
                            name.add("<span class='no-control'>" + cn + "</span>");
                            continue;
                        }
                        name.add(cn);
                    }
                    if (this.iEvent.hasExternalIds()) {
                        for (String ex : this.iEvent.getExternalIds()) {
                            if (section.isEmpty()) {
                                section.add(ex);
                                continue;
                            }
                            if (this.iEvent.getInstruction() != null || this.iEvent.getType() == EventInterface.EventType.Course) {
                                section.add("<span class='no-control'>" + ex + "</span>");
                                continue;
                            }
                            section.add(ex);
                        }
                    } else if (this.iEvent.hasSectionNumber()) {
                        section.clear();
                        section.add(this.iEvent.getSectionNumber());
                    }
                    if (this.iEvent.hasCourseTitles()) {
                        String last = null;
                        for (String ct : this.iEvent.getCourseTitles()) {
                            if (last != null && !last.isEmpty() && last.equals(ct)) {
                                ct = "";
                            } else {
                                last = ct;
                            }
                            if (title.isEmpty()) {
                                title.add(ct);
                                continue;
                            }
                            if (this.iEvent.getInstruction() != null || this.iEvent.getType() == EventInterface.EventType.Course) {
                                title.add("<span class='no-control'>" + ct + "</span>");
                                continue;
                            }
                            title.add(ct);
                        }
                    }
                    this.iHint.addRow(MESSAGES.propName(), (Widget)new HTML(TimeGrid.list2string(name), false));
                    if (!TimeGrid.list2string(section).isEmpty()) {
                        this.iHint.addRow(MESSAGES.propSection(), (Widget)new HTML(TimeGrid.list2string(section), false));
                    }
                    this.iHint.addRow(MESSAGES.propType(), (Widget)new Label(this.iEvent.getInstruction() == null ? this.iEvent.getType().getAbbreviation(CONSTANTS) : this.iEvent.getInstruction(), false));
                    if (!TimeGrid.list2string(title).isEmpty()) {
                        this.iHint.addRow(MESSAGES.propTitle(), (Widget)new HTML(TimeGrid.list2string(title), false));
                    }
                } else {
                    this.iHint.addRow(MESSAGES.propName(), (Widget)new Label(this.iEvent.getName(), false));
                    if (this.iEvent.hasSectionNumber()) {
                        this.iHint.addRow(MESSAGES.propSection(), (Widget)new Label(this.iEvent.getSectionNumber(), false));
                    }
                    this.iHint.addRow(MESSAGES.propType(), (Widget)new Label(this.iEvent.getType().getAbbreviation(CONSTANTS), false));
                }
                if (this.iEvent.hasEventNote()) {
                    this.iHint.addRow(MESSAGES.propNote(), (Widget)new HTML(this.iEvent.getEventNote("<br>").replace("\n", "<br>"), true));
                }
                ToolBox.setMaxWidth(this.iHint.getElement().getStyle(), "400px");
                this.iHint.addRow(MESSAGES.propDate(), (Widget)new HTML(this.iDates, true));
                this.iHint.addRow(MESSAGES.propPublishedTime(), (Widget)new Label(this.iMeeting.getMeetingTime(CONSTANTS), false));
                if (this.iMeeting.getStartOffset() != 0 || this.iMeeting.getEndOffset() != 0) {
                    this.iHint.addRow(MESSAGES.propAllocatedTime(), (Widget)new Label(this.iMeeting.getAllocatedTime(CONSTANTS), false));
                }
                this.iHint.addRow(MESSAGES.propLocation(), (Widget)new Label(this.iRooms, true));
                if (this.iEvent.hasEnrollment()) {
                    if (this.iEvent.hasMaxCapacity()) {
                        this.iHint.addRow(MESSAGES.propEnrollment(), (Widget)new Label(MESSAGES.enrollmentOfLimit(this.iEvent.getEnrollment(), this.iEvent.getMaxCapacity()), false));
                    } else {
                        this.iHint.addRow(MESSAGES.propEnrollment(), (Widget)new Label(this.iEvent.getEnrollment().toString(), false));
                    }
                } else if (this.iEvent.hasMaxCapacity()) {
                    this.iHint.addRow(MESSAGES.propLimit(), (Widget)new Label(this.iEvent.getMaxCapacity().toString(), false));
                }
                if (this.iEvent.hasInstructors()) {
                    this.iHint.addRow(MESSAGES.propInstructor(), (Widget)new HTML(this.iEvent.getInstructorNames("<br>", MESSAGES), false));
                }
                if (this.iEvent.hasSponsor()) {
                    this.iHint.addRow(MESSAGES.propSponsor(), (Widget)new Label(this.iEvent.getSponsor().getName(), false));
                }
                if (this.iEvent.hasRequestedServices()) {
                    this.iHint.addRow(MESSAGES.propEventRequestedServices(), (Widget)new HTML(this.iEvent.getRequestedServices("<br>"), false));
                }
                this.iHint.addRow(MESSAGES.propApproved(), (Widget)new HTML(this.iMeeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? "<span class='deleted-meeting'>" + MESSAGES.approvalDeleted() + "</span>" : (this.iMeeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? "<span class='cancelled-meeting'>" + MESSAGES.approvalCancelled() + "</span>" : (this.iMeeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? "<span class='rejected-meeting'>" + MESSAGES.approvalRejected() + "</span>" : (this.iMeeting.getMeetingDate() == null ? "" : (this.iMeeting.getId() == null ? (this.iEvent != null && this.iEvent.getType() == EventInterface.EventType.Unavailabile ? (this.iEvent.getId() != null && this.iEvent.getId() < 0L ? "" : "<span class='new-meeting'>" + MESSAGES.approvalNewUnavailabiliyMeeting() + "</span>") : (this.iMeeting.isCanApprove() ? "<span class='new-approved-meeting'>" + MESSAGES.approvelNewApprovedMeeting() + "</span>" : "<span class='new-meeting'>" + MESSAGES.approvalNewMeeting() + "</span>")) : (this.iMeeting.isApproved() ? (this.iMeeting.isPast() ? "<span class='past-meeting'>" + sDateFormat.format(this.iMeeting.getApprovalDate()) + "</span>" : sDateFormat.format(this.iMeeting.getApprovalDate())) : (this.iMeeting.isPast() ? "<span class='not-approved-past'>" + MESSAGES.approvalNotApprovedPast() + "</span>" : (this.iEvent.hasExpirationDate() ? "<span class='not-approved'>" + MESSAGES.approvalExpire(sDateFormat.format(this.iEvent.getExpirationDate())) + "</span>" : "<span class='not-approved'>" + MESSAGES.approvalNotApproved() + "</span>"))))))), false));
            }
            return this.iHint;
        }

        public int getColumn() {
            return this.iColumn;
        }

        public int getDayOfWeek() {
            return this.iDayOfWeek;
        }

        public int getDay() {
            for (int d = 0; d < TimeGrid.this.iDays.length; ++d) {
                if (TimeGrid.this.iDays[d] != this.iDayOfWeek) continue;
                return d;
            }
            return -1;
        }

        public int getNrColumns() {
            return this.iNrColumns;
        }

        public void add(Widget w) {
            super.add(w, (Element)this.getElement());
        }

        public void setDummy() {
            this.iDummy = true;
        }

        public int getNrMeetings() {
            return this.iNrMeetings;
        }
    }

    public class MeetingClickEvent {
        private Meeting iMeeting;

        MeetingClickEvent(Meeting meeting) {
            this.iMeeting = meeting;
        }

        public EventInterface getEvent() {
            return this.iMeeting.getEvent();
        }
    }

    public static interface MeetingClickHandler {
        public void onMeetingClick(MeetingClickEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        FILLSPACE,
        PROPORTIONAL,
        OVERLAP;

    }
}

