/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class TimetableManagerForm
extends ActionForm {
    private static final long serialVersionUID = 3763101881496582452L;
    private String op;
    private String op1;
    private String uniqueId;
    private String externalId;
    private String lookupResult;
    private String firstName;
    private String middleName;
    private String lastName;
    private String title;
    private String primaryRole;
    private String email;
    private String role;
    private String dept;
    private String solverGr;
    private List depts;
    private List deptLabels;
    private List roles;
    private List roleRefs;
    private List roleReceiveEmailFlags;
    private List solverGrs;
    private List solverGrLabels;
    private Boolean lookupEnabled;
    protected DynamicListObjectFactory factoryDepts = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factoryDeptLabels = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factoryRoles = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factoryRoleRefs = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factoryRoleReceiveEmailFlags = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factorySolverGrs = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factorySolverGrLabels = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op1 = "1";
        this.op = "";
        this.uniqueId = "";
        this.externalId = "";
        this.firstName = "";
        this.middleName = "";
        this.lastName = "";
        this.title = "";
        this.primaryRole = "";
        this.role = "";
        this.dept = "";
        this.solverGr = "";
        this.lookupEnabled = null;
        this.depts = DynamicList.getInstance(new ArrayList(), this.factoryDepts);
        this.deptLabels = DynamicList.getInstance(new ArrayList(), this.factoryDeptLabels);
        this.roles = DynamicList.getInstance(new ArrayList(), this.factoryRoles);
        this.roleRefs = DynamicList.getInstance(new ArrayList(), this.factoryRoleRefs);
        this.roleReceiveEmailFlags = DynamicList.getInstance(new ArrayList(), this.factoryRoleReceiveEmailFlags);
        this.solverGrs = DynamicList.getInstance(new ArrayList(), this.factorySolverGrs);
        this.solverGrLabels = DynamicList.getInstance(new ArrayList(), this.factorySolverGrLabels);
        super.reset(mapping, request);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.op.equalsIgnoreCase(rsc.getMessage("button.addRole")) && this.role.equals(Constants.BLANK_OPTION_VALUE)) {
            errors.add("role", new ActionMessage("errors.invalid", (Object)"Role"));
        }
        if (this.op.equalsIgnoreCase(rsc.getMessage("button.addDepartment")) && this.dept.equals(Constants.BLANK_OPTION_VALUE)) {
            errors.add("dept", new ActionMessage("errors.invalid", (Object)"Department"));
        }
        if (this.op.equalsIgnoreCase(rsc.getMessage("button.addSolverGroup")) && this.solverGr.equals(Constants.BLANK_OPTION_VALUE)) {
            errors.add("solverGr", new ActionMessage("errors.invalid", (Object)"Solver Group"));
        }
        if (this.op.equalsIgnoreCase(rsc.getMessage("button.insertTimetableManager")) || this.op.equalsIgnoreCase(rsc.getMessage("button.updateTimetableManager"))) {
            TimetableManager mgr;
            if (this.externalId == null || this.externalId.trim().length() == 0) {
                errors.add("externalId", new ActionMessage("errors.required", (Object)"External ID"));
            }
            if (this.email == null || this.email.trim().length() == 0) {
                errors.add("email", new ActionMessage("errors.required", (Object)"Email Address"));
            }
            if (this.primaryRole == null || this.primaryRole.trim().length() == 0) {
                errors.add("primaryRole", new ActionMessage("errors.required", (Object)"Primary Role"));
            }
            if (this.roles.size() == 0) {
                errors.add("roles", new ActionMessage("errors.generic", (Object)"At least one role must be assigned"));
            }
            if (this.externalId != null && this.externalId.trim().length() > 0 && (mgr = TimetableManager.findByExternalId(this.externalId)) != null && !mgr.getUniqueId().toString().equals(this.getUniqueId())) {
                errors.add("roles", new ActionMessage("errors.generic", (Object)"Duplicate Record - This manager already exists"));
            }
            if (!this.lookupEnabled.booleanValue()) {
                if (this.firstName == null || this.firstName.isEmpty()) {
                    errors.add("firstName", new ActionMessage("errors.required", (Object)"First Name"));
                }
                if (this.lastName == null || this.lastName.isEmpty()) {
                    errors.add("lastName", new ActionMessage("errors.required", (Object)"Last Name"));
                }
            }
        }
        return errors;
    }

    public void addToRoles(Roles role) {
        this.roles.add(role.getRoleId());
        this.roleRefs.add(role.getAbbv());
    }

    public void removeFromRoles(int index) {
        this.roles.remove(index);
        this.roleRefs.remove(index);
        if (index < this.roleReceiveEmailFlags.size()) {
            this.roleReceiveEmailFlags.remove(index);
        }
    }

    public void addToDepts(Department dept) {
        this.depts.add(dept.getUniqueId());
        this.deptLabels.add(dept.getLabel());
    }

    public void removeFromDepts(int index) {
        this.depts.remove(index);
        this.deptLabels.remove(index);
    }

    public void addToSolverGrs(SolverGroup sg) {
        this.solverGrs.add(sg.getUniqueId());
        this.solverGrLabels.add(sg.getName());
    }

    public void removeFromSolverGrs(int index) {
        this.solverGrs.remove(index);
        this.solverGrLabels.remove(index);
    }

    public String getLookupResult() {
        return this.lookupResult;
    }

    public void setLookupResult(String lookupResult) {
        this.lookupResult = lookupResult;
    }

    public String getDept() {
        return this.dept;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }

    public String getSolverGr() {
        return this.solverGr;
    }

    public void setSolverGr(String solverGr) {
        this.solverGr = solverGr;
    }

    public List getDepts() {
        return this.depts;
    }

    public String getDepts(int key) {
        return this.depts.get(key).toString();
    }

    public void setDepts(int key, Object value) {
        this.depts.set(key, value);
    }

    public void setDepts(List depts) {
        this.depts = depts;
    }

    public List getDeptLabels() {
        return this.deptLabels;
    }

    public String getDeptLabels(int key) {
        return this.deptLabels.get(key).toString();
    }

    public void setDeptLabels(int key, Object value) {
        this.deptLabels.set(key, value);
    }

    public void setDeptLabels(List deptLabels) {
        this.deptLabels = deptLabels;
    }

    public List getSolverGrs() {
        return this.solverGrs;
    }

    public String getSolverGrs(int key) {
        return this.solverGrs.get(key).toString();
    }

    public void setSolverGrs(int key, Object value) {
        this.solverGrs.set(key, value);
    }

    public void setSolverGrs(List solverGrs) {
        this.solverGrs = solverGrs;
    }

    public List getSolverGrLabels() {
        return this.solverGrLabels;
    }

    public String getSolverGrLabels(int key) {
        return this.solverGrLabels.get(key).toString();
    }

    public void setSolverGrLabels(int key, Object value) {
        this.solverGrLabels.set(key, value);
    }

    public void setSolverGrLabels(List solverGrLabels) {
        this.solverGrLabels = solverGrLabels;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getOp1() {
        return this.op1;
    }

    public void setOp1(String op1) {
        this.op1 = op1;
    }

    public String getPrimaryRole() {
        return this.primaryRole;
    }

    public void setPrimaryRole(String primaryRole) {
        this.primaryRole = primaryRole;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public List getRoles() {
        return this.roles;
    }

    public String getRoles(int key) {
        return this.roles.get(key).toString();
    }

    public void setRoles(int key, Object value) {
        this.roles.set(key, value);
    }

    public void setRoles(List roles) {
        this.roles = roles;
    }

    public List getRoleRefs() {
        return this.roleRefs;
    }

    public String getRoleRefs(int key) {
        return this.roleRefs.get(key).toString();
    }

    public void setRoleRefs(int key, Object value) {
        this.roleRefs.set(key, value);
    }

    public void setRoleRefs(List roleRefs) {
        this.roleRefs = roleRefs;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    public List getRoleReceiveEmailFlags() {
        return this.roleReceiveEmailFlags;
    }

    public void setRoleReceiveEmailFlags(int key, Object value) {
        this.roleReceiveEmailFlags.set(key, value);
    }

    public void setRoleReceiveEmailFlags(List roleReceiveEmailFlags) {
        this.roleReceiveEmailFlags = roleReceiveEmailFlags;
    }
}

