/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.ClassInstructorDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseRequestDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.LastLikeCourseDemandDAO;
import org.unitime.timetable.model.dao.OfferingCoordinatorDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.util.SessionRollForward;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollForwardSessionForm
extends ActionForm {
    private static final long serialVersionUID = 7553214589949959977L;
    private Collection<SubjectArea> subjectAreas;
    private String[] subjectAreaIds;
    private String buttonAction;
    private Collection<Session> toSessions;
    private Collection<Session> fromSessions;
    private Collection<PointInTimeData> fromPointInTimeDataSnapshots;
    private Long sessionToRollForwardTo;
    private Boolean rollForwardDatePatterns;
    private Long sessionToRollDatePatternsForwardFrom;
    private Boolean rollForwardTimePatterns;
    private Long sessionToRollTimePatternsForwardFrom;
    private Boolean rollForwardDepartments;
    private Long sessionToRollDeptsFowardFrom;
    private Boolean rollForwardManagers;
    private Long sessionToRollManagersForwardFrom;
    private Boolean rollForwardRoomData;
    private Long sessionToRollRoomDataForwardFrom;
    private Collection<Department> departments;
    private String[] rollForwardDepartmentIds;
    private Boolean rollForwardSubjectAreas;
    private Long sessionToRollSubjectAreasForwardFrom;
    private Boolean rollForwardInstructorData;
    private Long sessionToRollInstructorDataForwardFrom;
    private Boolean rollForwardCourseOfferings;
    private Long sessionToRollCourseOfferingsForwardFrom;
    private String[] rollForwardSubjectAreaIds;
    private Boolean rollForwardClassInstructors;
    private String[] rollForwardClassInstrSubjectIds;
    private Boolean addNewCourseOfferings;
    private String[] addNewCourseOfferingsSubjectIds;
    private Boolean rollForwardExamConfiguration;
    private Long sessionToRollExamConfigurationForwardFrom;
    private Boolean rollForwardMidtermExams;
    private Boolean rollForwardFinalExams;
    private Boolean rollForwardStudents;
    private String rollForwardStudentsMode;
    private Long pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    private String subpartLocationPrefsAction;
    private String subpartTimePrefsAction;
    private String classPrefsAction;
    private String rollForwardDistributions;
    private String cancelledClassAction;
    private Boolean rollForwardCurricula;
    private Long sessionToRollCurriculaForwardFrom;
    private String midtermExamsPrefsAction;
    private String finalExamsPrefsAction;
    private Boolean rollForwardSessionConfig;
    private Long sessionToRollSessionConfigForwardFrom;
    private Boolean rollForwardReservations;
    private Long sessionToRollReservationsForwardFrom;
    private String[] rollForwardReservationsSubjectIds;
    private Boolean rollForwardCourseReservations;
    private Boolean rollForwardCurriculumReservations;
    private Boolean rollForwardGroupReservations;
    private String expirationCourseReservations;
    private String expirationCurriculumReservations;
    private String expirationGroupReservations;
    private Boolean createStudentGroupsIfNeeded;
    private Boolean rollForwardOfferingCoordinators;
    private String[] rollForwardOfferingCoordinatorsSubjectIds;
    private Boolean rollForwardTeachingRequests;
    private String[] rollForwardTeachingRequestsSubjectIds;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        this.validateSessionToRollForwardTo(errors);
        return errors;
    }

    private void validateRollForwardSessionHasNoDataOfType(ActionErrors errors, Session sessionToRollForwardTo, String rollForwardType, Collection checkCollection) {
        if (checkCollection != null && !checkCollection.isEmpty()) {
            errors.add("sessionHasData", new ActionMessage("errors.rollForward.sessionHasData", (Object)rollForwardType, (Object)sessionToRollForwardTo.getLabel()));
        }
    }

    protected void validateRollForward(ActionErrors errors, Session sessionToRollForwardTo, Long sessionIdToRollForwardFrom, String rollForwardType, Collection checkCollection) {
        this.validateRollForwardSessionHasNoDataOfType(errors, sessionToRollForwardTo, rollForwardType, checkCollection);
        Session sessionToRollForwardFrom = Session.getSessionById(sessionIdToRollForwardFrom);
        if (sessionToRollForwardFrom == null) {
            errors.add("mustSelectSession", new ActionMessage("errors.rollForward.missingFromSession", (Object)rollForwardType));
        }
        if (sessionToRollForwardFrom.equals(sessionToRollForwardTo)) {
            errors.add("sessionsMustBeDifferent", new ActionMessage("errors.rollForward.sessionsMustBeDifferent", (Object)rollForwardType, (Object)sessionToRollForwardTo.getLabel()));
        }
    }

    public void validateDatePatternRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardDatePatterns().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollDatePatternsForwardFrom(), "Date Patterns", DatePattern.findAll(toAcadSession, true, null, null));
        }
    }

    public void validateTimePatternRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardTimePatterns().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollTimePatternsForwardFrom(), "Time Patterns", TimePattern.findAll(toAcadSession, null));
        }
    }

    public void validateDepartmentRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardDepartments().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollDeptsFowardFrom(), "Departments", Department.findAll(toAcadSession.getUniqueId()));
        }
    }

    public void validateManagerRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardManagers().booleanValue()) {
            TimetableManagerDAO tmDao = new TimetableManagerDAO();
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollManagersForwardFrom(), "Managers", tmDao.getQuery("from TimetableManager tm inner join tm.departments d where d.session.uniqueId =" + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateBuildingAndRoomRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardRoomData().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollRoomDataForwardFrom(), "Buildings", new ArrayList());
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Buildings", Building.findAll(toAcadSession.getUniqueId()));
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Rooms", Location.findAll(toAcadSession.getUniqueId()));
            RoomFeatureDAO rfDao = new RoomFeatureDAO();
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Room Features", rfDao.getQuery("from RoomFeature rf where rf.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            RoomGroupDAO rgDao = new RoomGroupDAO();
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Room Groups", rgDao.getQuery("from RoomGroup rg where rg.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and rg.global = 0").list());
        }
    }

    public void validateSubjectAreaRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardSubjectAreas().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollSubjectAreasForwardFrom(), "Subject Areas", SubjectArea.getSubjectAreaList(toAcadSession.getUniqueId()));
        }
    }

    public void validateInstructorDataRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardInstructorData().booleanValue()) {
            DepartmentalInstructorDAO diDao = new DepartmentalInstructorDAO();
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollInstructorDataForwardFrom(), "Instructors", diDao.getQuery("from DepartmentalInstructor di where di.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateCourseOfferingRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardCourseOfferings().booleanValue()) {
            if (this.getSubpartLocationPrefsAction() != null && !this.getSubpartLocationPrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) && !this.getSubpartLocationPrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION)) {
                errors.add("invalidSubpartLocationAction", new ActionMessage("errors.generic", (Object)("Invalid subpart location preference roll forward action:  " + this.getSubpartLocationPrefsAction())));
            }
            if (this.getSubpartTimePrefsAction() != null && !this.getSubpartTimePrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) && !this.getSubpartTimePrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION)) {
                errors.add("invalidSubpartTimeAction", new ActionMessage("errors.generic", (Object)("Invalid subpart time preference roll forward action:  " + this.getSubpartLocationPrefsAction())));
            }
            if (!(this.getClassPrefsAction() == null || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.PUSH_UP_ACTION) || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION))) {
                errors.add("invalidClassAction", new ActionMessage("errors.generic", (Object)("Invalid class preference roll forward action:  " + this.getClassPrefsAction())));
            }
            if (!(this.getRollForwardDistributions() == null || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.ALL.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.MIXED.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.SUBPART.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.NONE.name()))) {
                errors.add("invalidDistributionAction", new ActionMessage("errors.generic", (Object)("Invalid roll forward distribution preferences action:  " + this.getRollForwardDistributions())));
            }
            if (!(this.getCancelledClassAction() == null || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.KEEP.name()) || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.REOPEN.name()) || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.SKIP.name()))) {
                errors.add("invalidCancelAction", new ActionMessage("errors.generic", (Object)("Invalid cancelled class roll forward action:  " + this.getCancelledClassAction())));
            }
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), "Course Offerings", new ArrayList());
            CourseOfferingDAO coDao = new CourseOfferingDAO();
            for (int i = 0; i < this.getRollForwardSubjectAreaIds().length; ++i) {
                String queryStr = "from CourseOffering co where co.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = 1 and co.subjectArea.uniqueId  = '" + this.getRollForwardSubjectAreaIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Course Offerings - " + this.getRollForwardSubjectAreaIds()[i], coDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateClassInstructorRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardClassInstructors().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), "Class Instructors", new ArrayList());
            ClassInstructorDAO ciDao = new ClassInstructorDAO();
            for (int i = 0; i < this.getRollForwardClassInstrSubjectIds().length; ++i) {
                String queryStr = "from ClassInstructor c  inner join c.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where c.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = 1 and co.subjectArea.uniqueId  = '" + this.getRollForwardClassInstrSubjectIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Class Instructors - " + this.getRollForwardClassInstrSubjectIds()[i], ciDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateOfferingCoordinatorsRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardOfferingCoordinators().booleanValue()) {
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), "Offering Coordinators", new ArrayList());
            OfferingCoordinatorDAO ocDao = OfferingCoordinatorDAO.getInstance();
            for (int i = 0; i < this.getRollForwardOfferingCoordinatorsSubjectIds().length; ++i) {
                String queryStr = "from OfferingCoordinator c inner join c.offering.courseOfferings as co where c.offering.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = 1 and co.subjectArea.uniqueId  = '" + this.getRollForwardOfferingCoordinatorsSubjectIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Offering Coordinators - " + this.getRollForwardOfferingCoordinatorsSubjectIds()[i], ocDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateExamConfigurationRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardExamConfiguration().booleanValue()) {
            ExamPeriodDAO epDao = new ExamPeriodDAO();
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollExamConfigurationForwardFrom(), "Exam Configuration", epDao.getQuery("from ExamPeriod ep where ep.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateMidtermExamRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardMidtermExams().booleanValue()) {
            ExamDAO eDao = new ExamDAO();
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Midterm Exams", eDao.getQuery("from Exam e where e.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and e.examType.type = " + 1).list());
        }
    }

    public void validateFinalExamRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardFinalExams().booleanValue()) {
            ExamDAO epDao = new ExamDAO();
            this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Final Exams", epDao.getQuery("from Exam e where e.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and e.examType.type = " + 0).list());
        }
    }

    public void validateLastLikeDemandRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardStudents().booleanValue()) {
            if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.LAST_LIKE.name())) {
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Last-like Student Course Requests", LastLikeCourseDemandDAO.getInstance().getQuery("from LastLikeCourseDemand d where d.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.STUDENT_CLASS_ENROLLMENTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Student Class Enrollments", StudentClassEnrollmentDAO.getInstance().getQuery("from StudentClassEnrollment d where d.courseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.STUDENT_COURSE_REQUESTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Course Requests", CourseRequestDAO.getInstance().getQuery("from CourseRequest r where r.courseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.POINT_IN_TIME_CLASS_ENROLLMENTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(errors, toAcadSession, "Point In Time Data Student Class Enrollments", StudentClassEnrollmentDAO.getInstance().getQuery("from PitStudentClassEnrollment d where d.pitCourseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else {
                errors.add("invalidCancelAction", new ActionMessage("errors.generic", (Object)("Invalid last like course demand roll forward action:  " + this.getRollForwardStudentsMode())));
            }
        }
    }

    public void validateCurriculaRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardCurricula().booleanValue()) {
            CurriculumDAO curDao = new CurriculumDAO();
            this.validateRollForward(errors, toAcadSession, this.getSessionToRollCurriculaForwardFrom(), "Curricula", curDao.getQuery("from Curriculum c where c.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateSessionToRollForwardTo(ActionErrors errors) {
        Session toAcadSession = Session.getSessionById(this.getSessionToRollForwardTo());
        if (toAcadSession == null) {
            errors.add("mustSelectSession", new ActionMessage("errors.rollForward.missingToSession"));
            return;
        }
        this.validateDepartmentRollForward(toAcadSession, errors);
        this.validateManagerRollForward(toAcadSession, errors);
        this.validateBuildingAndRoomRollForward(toAcadSession, errors);
        this.validateDatePatternRollForward(toAcadSession, errors);
        this.validateTimePatternRollForward(toAcadSession, errors);
        this.validateSubjectAreaRollForward(toAcadSession, errors);
        this.validateCourseOfferingRollForward(toAcadSession, errors);
        this.validateTeachingRequestsRollForward(toAcadSession, errors);
        this.validateClassInstructorRollForward(toAcadSession, errors);
        this.validateOfferingCoordinatorsRollForward(toAcadSession, errors);
        this.validateExamConfigurationRollForward(toAcadSession, errors);
        this.validateMidtermExamRollForward(toAcadSession, errors);
        this.validateFinalExamRollForward(toAcadSession, errors);
        this.validateLastLikeDemandRollForward(toAcadSession, errors);
        this.validateCurriculaRollForward(toAcadSession, errors);
    }

    public void init() {
        this.subjectAreas = new ArrayList<SubjectArea>();
        this.subjectAreaIds = new String[0];
        this.fromSessions = null;
        this.toSessions = null;
        this.sessionToRollForwardTo = null;
        this.rollForwardDatePatterns = new Boolean(false);
        this.sessionToRollDatePatternsForwardFrom = null;
        this.rollForwardTimePatterns = new Boolean(false);
        this.sessionToRollTimePatternsForwardFrom = null;
        this.rollForwardDepartments = new Boolean(false);
        this.sessionToRollDeptsFowardFrom = null;
        this.rollForwardManagers = new Boolean(false);
        this.sessionToRollManagersForwardFrom = null;
        this.rollForwardRoomData = new Boolean(false);
        this.sessionToRollRoomDataForwardFrom = null;
        this.setDepartments(new ArrayList<Department>());
        this.setRollForwardDepartmentIds(new String[0]);
        this.rollForwardSubjectAreas = new Boolean(false);
        this.sessionToRollSubjectAreasForwardFrom = null;
        this.rollForwardInstructorData = new Boolean(false);
        this.sessionToRollInstructorDataForwardFrom = null;
        this.rollForwardCourseOfferings = new Boolean(false);
        this.sessionToRollCourseOfferingsForwardFrom = null;
        this.rollForwardSubjectAreaIds = new String[0];
        this.rollForwardClassInstructors = new Boolean(false);
        this.rollForwardClassInstrSubjectIds = new String[0];
        this.addNewCourseOfferings = new Boolean(false);
        this.addNewCourseOfferingsSubjectIds = new String[0];
        this.rollForwardExamConfiguration = new Boolean(false);
        this.sessionToRollExamConfigurationForwardFrom = null;
        this.rollForwardMidtermExams = new Boolean(false);
        this.rollForwardFinalExams = new Boolean(false);
        this.rollForwardStudents = new Boolean(false);
        this.rollForwardStudentsMode = null;
        this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = null;
        this.setFromPointInTimeDataSnapshots(new ArrayList<PointInTimeData>());
        this.subpartLocationPrefsAction = null;
        this.subpartTimePrefsAction = null;
        this.classPrefsAction = null;
        this.rollForwardDistributions = null;
        this.cancelledClassAction = null;
        this.rollForwardCurricula = false;
        this.sessionToRollCurriculaForwardFrom = null;
        this.finalExamsPrefsAction = null;
        this.midtermExamsPrefsAction = null;
        this.rollForwardSessionConfig = false;
        this.sessionToRollSessionConfigForwardFrom = null;
        this.rollForwardReservations = false;
        this.sessionToRollReservationsForwardFrom = null;
        this.rollForwardReservationsSubjectIds = new String[0];
        this.rollForwardCurriculumReservations = false;
        this.rollForwardCourseReservations = false;
        this.rollForwardGroupReservations = false;
        this.expirationCourseReservations = null;
        this.expirationCurriculumReservations = null;
        this.expirationGroupReservations = null;
        this.createStudentGroupsIfNeeded = false;
        this.rollForwardTeachingRequests = false;
        this.rollForwardTeachingRequestsSubjectIds = new String[0];
        this.rollForwardOfferingCoordinators = new Boolean(false);
        this.rollForwardOfferingCoordinatorsSubjectIds = new String[0];
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.init();
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public Collection<SubjectArea> getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection<SubjectArea> subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Boolean getRollForwardCourseOfferings() {
        return this.rollForwardCourseOfferings;
    }

    public void setRollForwardCourseOfferings(Boolean rollForwardCourseOfferings) {
        this.rollForwardCourseOfferings = rollForwardCourseOfferings;
    }

    public Boolean getRollForwardDatePatterns() {
        return this.rollForwardDatePatterns;
    }

    public void setRollForwardDatePatterns(Boolean rollForwardDatePatterns) {
        this.rollForwardDatePatterns = rollForwardDatePatterns;
    }

    public Boolean getRollForwardDepartments() {
        return this.rollForwardDepartments;
    }

    public void setRollForwardDepartments(Boolean rollForwardDepartments) {
        this.rollForwardDepartments = rollForwardDepartments;
    }

    public Boolean getRollForwardInstructorData() {
        return this.rollForwardInstructorData;
    }

    public void setRollForwardInstructorData(Boolean rollForwardInstructorData) {
        this.rollForwardInstructorData = rollForwardInstructorData;
    }

    public Boolean getRollForwardManagers() {
        return this.rollForwardManagers;
    }

    public void setRollForwardManagers(Boolean rollForwardManagers) {
        this.rollForwardManagers = rollForwardManagers;
    }

    public Boolean getRollForwardRoomData() {
        return this.rollForwardRoomData;
    }

    public void setRollForwardRoomData(Boolean rollForwardRoomData) {
        this.rollForwardRoomData = rollForwardRoomData;
    }

    public String[] getRollForwardSubjectAreaIds() {
        return this.rollForwardSubjectAreaIds;
    }

    public void setRollForwardSubjectAreaIds(String[] rollForwardSubjectAreaIds) {
        this.rollForwardSubjectAreaIds = rollForwardSubjectAreaIds;
    }

    public Boolean getRollForwardSubjectAreas() {
        return this.rollForwardSubjectAreas;
    }

    public void setRollForwardSubjectAreas(Boolean rollForwardSubjectAreas) {
        this.rollForwardSubjectAreas = rollForwardSubjectAreas;
    }

    public Long getSessionToRollCourseOfferingsForwardFrom() {
        return this.sessionToRollCourseOfferingsForwardFrom;
    }

    public void setSessionToRollCourseOfferingsForwardFrom(Long sessionToRollCourseOfferingsForwardFrom) {
        this.sessionToRollCourseOfferingsForwardFrom = sessionToRollCourseOfferingsForwardFrom;
    }

    public Long getSessionToRollDatePatternsForwardFrom() {
        return this.sessionToRollDatePatternsForwardFrom;
    }

    public void setSessionToRollDatePatternsForwardFrom(Long sessionToRollDatePatternsForwardFrom) {
        this.sessionToRollDatePatternsForwardFrom = sessionToRollDatePatternsForwardFrom;
    }

    public Long getSessionToRollDeptsFowardFrom() {
        return this.sessionToRollDeptsFowardFrom;
    }

    public void setSessionToRollDeptsFowardFrom(Long sessionToRollDeptsFowardFrom) {
        this.sessionToRollDeptsFowardFrom = sessionToRollDeptsFowardFrom;
    }

    public Long getSessionToRollForwardTo() {
        return this.sessionToRollForwardTo;
    }

    public void setSessionToRollForwardTo(Long sessionToRollForwardTo) {
        this.sessionToRollForwardTo = sessionToRollForwardTo;
    }

    public Long getSessionToRollInstructorDataForwardFrom() {
        return this.sessionToRollInstructorDataForwardFrom;
    }

    public void setSessionToRollInstructorDataForwardFrom(Long sessionToRollInstructorDataForwardFrom) {
        this.sessionToRollInstructorDataForwardFrom = sessionToRollInstructorDataForwardFrom;
    }

    public Long getSessionToRollManagersForwardFrom() {
        return this.sessionToRollManagersForwardFrom;
    }

    public void setSessionToRollManagersForwardFrom(Long sessionToRollManagersForwardFrom) {
        this.sessionToRollManagersForwardFrom = sessionToRollManagersForwardFrom;
    }

    public Long getSessionToRollRoomDataForwardFrom() {
        return this.sessionToRollRoomDataForwardFrom;
    }

    public void setSessionToRollRoomDataForwardFrom(Long sessionToRollRoomDataForwardFrom) {
        this.sessionToRollRoomDataForwardFrom = sessionToRollRoomDataForwardFrom;
    }

    public Collection<Department> getDepartments() {
        return this.departments;
    }

    public void setFromPointInTimeDataSnapshots(Collection<PointInTimeData> fromPointInTimeDataSnapshots) {
        this.fromPointInTimeDataSnapshots = fromPointInTimeDataSnapshots;
    }

    public Collection<PointInTimeData> getFromPointInTimeDataSnapshots() {
        return this.fromPointInTimeDataSnapshots;
    }

    public void setDepartments(Collection<Department> departments) {
        this.departments = departments;
    }

    public String[] getRollForwardDepartmentIds() {
        return this.rollForwardDepartmentIds;
    }

    public void setRollForwardDepartmentIds(String[] rollForwardDepartmentIds) {
        this.rollForwardDepartmentIds = rollForwardDepartmentIds;
    }

    public Long getSessionToRollSubjectAreasForwardFrom() {
        return this.sessionToRollSubjectAreasForwardFrom;
    }

    public void setSessionToRollSubjectAreasForwardFrom(Long sessionToRollSubjectAreasForwardFrom) {
        this.sessionToRollSubjectAreasForwardFrom = sessionToRollSubjectAreasForwardFrom;
    }

    public Collection<Session> getFromSessions() {
        return this.fromSessions;
    }

    public void setFromSessions(Collection<Session> fromSessions) {
        this.fromSessions = fromSessions;
    }

    public Boolean getRollForwardTimePatterns() {
        return this.rollForwardTimePatterns;
    }

    public void setRollForwardTimePatterns(Boolean rollForwardTimePatterns) {
        this.rollForwardTimePatterns = rollForwardTimePatterns;
    }

    public Long getSessionToRollTimePatternsForwardFrom() {
        return this.sessionToRollTimePatternsForwardFrom;
    }

    public void setSessionToRollTimePatternsForwardFrom(Long sessionToRollTimePatternsForwardFrom) {
        this.sessionToRollTimePatternsForwardFrom = sessionToRollTimePatternsForwardFrom;
    }

    public Boolean getRollForwardClassInstructors() {
        return this.rollForwardClassInstructors;
    }

    public void setRollForwardClassInstructors(Boolean rollForwardClassInstructors) {
        this.rollForwardClassInstructors = rollForwardClassInstructors;
    }

    public String[] getRollForwardClassInstrSubjectIds() {
        return this.rollForwardClassInstrSubjectIds;
    }

    public void setRollForwardClassInstrSubjectIds(String[] rollForwardClassInstrSubjectIds) {
        this.rollForwardClassInstrSubjectIds = rollForwardClassInstrSubjectIds;
    }

    public Boolean getRollForwardOfferingCoordinators() {
        return this.rollForwardOfferingCoordinators;
    }

    public void setRollForwardOfferingCoordinators(Boolean rollForwardOfferingCoordinators) {
        this.rollForwardOfferingCoordinators = rollForwardOfferingCoordinators;
    }

    public String[] getRollForwardOfferingCoordinatorsSubjectIds() {
        return this.rollForwardOfferingCoordinatorsSubjectIds;
    }

    public void setRollForwardOfferingCoordinatorsSubjectIds(String[] rollForwardOfferingCoordinatorsSubjectIds) {
        this.rollForwardOfferingCoordinatorsSubjectIds = rollForwardOfferingCoordinatorsSubjectIds;
    }

    public Collection<Session> getToSessions() {
        return this.toSessions;
    }

    public void setToSessions(Collection<Session> toSessions) {
        this.toSessions = toSessions;
    }

    public Boolean getAddNewCourseOfferings() {
        return this.addNewCourseOfferings;
    }

    public void setAddNewCourseOfferings(Boolean addNewCourseOfferings) {
        this.addNewCourseOfferings = addNewCourseOfferings;
    }

    public String[] getAddNewCourseOfferingsSubjectIds() {
        return this.addNewCourseOfferingsSubjectIds;
    }

    public void setAddNewCourseOfferingsSubjectIds(String[] addNewCourseOfferingsSubjectIds) {
        this.addNewCourseOfferingsSubjectIds = addNewCourseOfferingsSubjectIds;
    }

    public Boolean getRollForwardExamConfiguration() {
        return this.rollForwardExamConfiguration;
    }

    public void setRollForwardExamConfiguration(Boolean rollForwardExamConfiguration) {
        this.rollForwardExamConfiguration = rollForwardExamConfiguration;
    }

    public Boolean getRollForwardMidtermExams() {
        return this.rollForwardMidtermExams;
    }

    public void setRollForwardMidtermExams(Boolean rollForwardMidtermExams) {
        this.rollForwardMidtermExams = rollForwardMidtermExams;
    }

    public Boolean getRollForwardFinalExams() {
        return this.rollForwardFinalExams;
    }

    public void setRollForwardFinalExams(Boolean rollForwardFinalExams) {
        this.rollForwardFinalExams = rollForwardFinalExams;
    }

    public Long getSessionToRollExamConfigurationForwardFrom() {
        return this.sessionToRollExamConfigurationForwardFrom;
    }

    public void setSessionToRollExamConfigurationForwardFrom(Long sessionToRollExamConfigurationForwardFrom) {
        this.sessionToRollExamConfigurationForwardFrom = sessionToRollExamConfigurationForwardFrom;
    }

    public Boolean getRollForwardStudents() {
        return this.rollForwardStudents;
    }

    public void setRollForwardStudents(Boolean rollForwardStudents) {
        this.rollForwardStudents = rollForwardStudents;
    }

    public String getRollForwardStudentsMode() {
        return this.rollForwardStudentsMode;
    }

    public void setRollForwardStudentsMode(String rollForwardStudentsMode) {
        this.rollForwardStudentsMode = rollForwardStudentsMode;
    }

    public Long getPointInTimeSnapshotToRollCourseEnrollmentsForwardFrom() {
        return this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    }

    public void setPointInTimeSnapshotToRollCourseEnrollmentsForwardFrom(Long pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom) {
        this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    }

    public Boolean getRollForwardCurricula() {
        return this.rollForwardCurricula;
    }

    public void setRollForwardCurricula(Boolean rollForwardCurricula) {
        this.rollForwardCurricula = rollForwardCurricula;
    }

    public Long getSessionToRollCurriculaForwardFrom() {
        return this.sessionToRollCurriculaForwardFrom;
    }

    public void setSessionToRollCurriculaForwardFrom(Long sessionToRollCurriculaForwardFrom) {
        this.sessionToRollCurriculaForwardFrom = sessionToRollCurriculaForwardFrom;
    }

    public Boolean getRollForwardSessionConfig() {
        return this.rollForwardSessionConfig;
    }

    public void setRollForwardSessionConfig(Boolean rollForwardSessionConfig) {
        this.rollForwardSessionConfig = rollForwardSessionConfig;
    }

    public Long getSessionToRollSessionConfigForwardFrom() {
        return this.sessionToRollSessionConfigForwardFrom;
    }

    public void setSessionToRollSessionConfigForwardFrom(Long sessionToRollSessionConfigForwardFrom) {
        this.sessionToRollSessionConfigForwardFrom = sessionToRollSessionConfigForwardFrom;
    }

    public String getSubpartLocationPrefsAction() {
        return this.subpartLocationPrefsAction;
    }

    public void setSubpartLocationPrefsAction(String subpartLocationPrefsAction) {
        this.subpartLocationPrefsAction = subpartLocationPrefsAction;
    }

    public String getSubpartTimePrefsAction() {
        return this.subpartTimePrefsAction;
    }

    public void setSubpartTimePrefsAction(String subpartTimePrefsAction) {
        this.subpartTimePrefsAction = subpartTimePrefsAction;
    }

    public String getClassPrefsAction() {
        return this.classPrefsAction;
    }

    public void setClassPrefsAction(String classPrefsAction) {
        this.classPrefsAction = classPrefsAction;
    }

    public String getRollForwardDistributions() {
        return this.rollForwardDistributions;
    }

    public void setRollForwardDistributions(String rollForwardDistributions) {
        this.rollForwardDistributions = rollForwardDistributions;
    }

    public String getCancelledClassAction() {
        return this.cancelledClassAction;
    }

    public void setCancelledClassAction(String cancelledClassAction) {
        this.cancelledClassAction = cancelledClassAction;
    }

    public String getMidtermExamsPrefsAction() {
        return this.midtermExamsPrefsAction;
    }

    public void setMidtermExamsPrefsAction(String midtermExamsPrefsAction) {
        this.midtermExamsPrefsAction = midtermExamsPrefsAction;
    }

    public String getFinalExamsPrefsAction() {
        return this.finalExamsPrefsAction;
    }

    public void setFinalExamsPrefsAction(String finalExamsPrefsAction) {
        this.finalExamsPrefsAction = finalExamsPrefsAction;
    }

    public boolean getRollForwardReservations() {
        return this.rollForwardReservations;
    }

    public void setRollForwardReservations(boolean rollForwardReservations) {
        this.rollForwardReservations = rollForwardReservations;
    }

    public Long getSessionToRollReservationsForwardFrom() {
        return this.sessionToRollReservationsForwardFrom;
    }

    public void setSessionToRollReservationsForwardFrom(Long sessionToRollReservationsForwardFrom) {
        this.sessionToRollReservationsForwardFrom = sessionToRollReservationsForwardFrom;
    }

    public String[] getRollForwardReservationsSubjectIds() {
        return this.rollForwardReservationsSubjectIds;
    }

    public void setRollForwardReservationsSubjectIds(String[] rollForwardReservationsSubjectIds) {
        this.rollForwardReservationsSubjectIds = rollForwardReservationsSubjectIds;
    }

    public boolean getRollForwardCourseReservations() {
        return this.rollForwardCourseReservations;
    }

    public void setRollForwardCourseReservations(boolean rollForwardCourseReservations) {
        this.rollForwardCourseReservations = rollForwardCourseReservations;
    }

    public boolean getRollForwardCurriculumReservations() {
        return this.rollForwardCurriculumReservations;
    }

    public void setRollForwardCurriculumReservations(boolean rollForwardCurriculumReservations) {
        this.rollForwardCurriculumReservations = rollForwardCurriculumReservations;
    }

    public boolean getRollForwardGroupReservations() {
        return this.rollForwardGroupReservations;
    }

    public void setRollForwardGroupReservations(boolean rollForwardGroupReservations) {
        this.rollForwardGroupReservations = rollForwardGroupReservations;
    }

    public String getExpirationCourseReservations() {
        return this.expirationCourseReservations;
    }

    public void setExpirationCourseReservations(String expirationCourseReservations) {
        this.expirationCourseReservations = expirationCourseReservations;
    }

    public String getExpirationCurriculumReservations() {
        return this.expirationCurriculumReservations;
    }

    public void setExpirationCurriculumReservations(String expirationCurriculumReservations) {
        this.expirationCurriculumReservations = expirationCurriculumReservations;
    }

    public String getExpirationGroupReservations() {
        return this.expirationGroupReservations;
    }

    public void setExpirationGroupReservations(String expirationGroupReservations) {
        this.expirationGroupReservations = expirationGroupReservations;
    }

    public boolean getCreateStudentGroupsIfNeeded() {
        return this.createStudentGroupsIfNeeded;
    }

    public void setCreateStudentGroupsIfNeeded(boolean createStudentGroupsIfNeeded) {
        this.createStudentGroupsIfNeeded = createStudentGroupsIfNeeded;
    }

    public void copyTo(RollForwardSessionForm form) {
        form.subjectAreas = this.subjectAreas;
        form.subjectAreaIds = this.subjectAreaIds;
        form.buttonAction = this.buttonAction;
        form.toSessions = this.toSessions;
        form.fromSessions = this.fromSessions;
        form.sessionToRollForwardTo = this.sessionToRollForwardTo;
        form.rollForwardDatePatterns = this.rollForwardDatePatterns;
        form.sessionToRollDatePatternsForwardFrom = this.sessionToRollDatePatternsForwardFrom;
        form.rollForwardTimePatterns = this.rollForwardTimePatterns;
        form.sessionToRollTimePatternsForwardFrom = this.sessionToRollTimePatternsForwardFrom;
        form.rollForwardDepartments = this.rollForwardDepartments;
        form.sessionToRollDeptsFowardFrom = this.sessionToRollDeptsFowardFrom;
        form.rollForwardManagers = this.rollForwardManagers;
        form.sessionToRollManagersForwardFrom = this.sessionToRollManagersForwardFrom;
        form.rollForwardRoomData = this.rollForwardRoomData;
        form.departments = this.departments;
        form.rollForwardDepartmentIds = this.rollForwardDepartmentIds;
        form.sessionToRollRoomDataForwardFrom = this.sessionToRollRoomDataForwardFrom;
        form.rollForwardSubjectAreas = this.rollForwardSubjectAreas;
        form.sessionToRollSubjectAreasForwardFrom = this.sessionToRollSubjectAreasForwardFrom;
        form.rollForwardInstructorData = this.rollForwardInstructorData;
        form.sessionToRollInstructorDataForwardFrom = this.sessionToRollInstructorDataForwardFrom;
        form.rollForwardCourseOfferings = this.rollForwardCourseOfferings;
        form.sessionToRollCourseOfferingsForwardFrom = this.sessionToRollCourseOfferingsForwardFrom;
        form.rollForwardSubjectAreaIds = this.rollForwardSubjectAreaIds;
        form.rollForwardClassInstructors = this.rollForwardClassInstructors;
        form.rollForwardClassInstrSubjectIds = this.rollForwardClassInstrSubjectIds;
        form.addNewCourseOfferings = this.addNewCourseOfferings;
        form.addNewCourseOfferingsSubjectIds = this.addNewCourseOfferingsSubjectIds;
        form.rollForwardExamConfiguration = this.rollForwardExamConfiguration;
        form.sessionToRollExamConfigurationForwardFrom = this.sessionToRollExamConfigurationForwardFrom;
        form.rollForwardMidtermExams = this.rollForwardMidtermExams;
        form.rollForwardFinalExams = this.rollForwardFinalExams;
        form.rollForwardStudents = this.rollForwardStudents;
        form.rollForwardStudentsMode = this.rollForwardStudentsMode;
        form.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
        form.fromPointInTimeDataSnapshots = this.fromPointInTimeDataSnapshots;
        form.subpartLocationPrefsAction = this.subpartLocationPrefsAction;
        form.subpartTimePrefsAction = this.subpartTimePrefsAction;
        form.classPrefsAction = this.classPrefsAction;
        form.cancelledClassAction = this.cancelledClassAction;
        form.rollForwardCurricula = this.rollForwardCurricula;
        form.sessionToRollCurriculaForwardFrom = this.sessionToRollCurriculaForwardFrom;
        form.midtermExamsPrefsAction = this.midtermExamsPrefsAction;
        form.finalExamsPrefsAction = this.finalExamsPrefsAction;
        form.rollForwardSessionConfig = this.rollForwardSessionConfig;
        form.sessionToRollSessionConfigForwardFrom = this.sessionToRollSessionConfigForwardFrom;
        form.rollForwardReservations = this.rollForwardReservations;
        form.sessionToRollReservationsForwardFrom = this.sessionToRollReservationsForwardFrom;
        form.rollForwardReservationsSubjectIds = this.rollForwardReservationsSubjectIds;
        form.rollForwardCurriculumReservations = this.rollForwardCurriculumReservations;
        form.rollForwardCourseReservations = this.rollForwardCourseReservations;
        form.rollForwardGroupReservations = this.rollForwardGroupReservations;
        form.expirationCourseReservations = this.expirationCourseReservations;
        form.expirationCurriculumReservations = this.expirationCurriculumReservations;
        form.expirationGroupReservations = this.expirationGroupReservations;
        form.createStudentGroupsIfNeeded = this.createStudentGroupsIfNeeded;
        form.rollForwardOfferingCoordinators = this.rollForwardOfferingCoordinators;
        form.rollForwardOfferingCoordinatorsSubjectIds = this.rollForwardOfferingCoordinatorsSubjectIds;
        form.rollForwardTeachingRequests = this.rollForwardTeachingRequests;
        form.rollForwardTeachingRequestsSubjectIds = this.rollForwardTeachingRequestsSubjectIds;
        form.rollForwardDistributions = this.rollForwardDistributions;
    }

    public Boolean getRollForwardTeachingRequests() {
        return this.rollForwardTeachingRequests;
    }

    public void setRollForwardTeachingRequests(Boolean rollForwardTeachingRequests) {
        this.rollForwardTeachingRequests = rollForwardTeachingRequests;
    }

    public String[] getRollForwardTeachingRequestsSubjectIds() {
        return this.rollForwardTeachingRequestsSubjectIds;
    }

    public void setRollForwardTeachingRequestsSubjectIds(String[] rollForwardTeachingRequestsSubjectIds) {
        this.rollForwardTeachingRequestsSubjectIds = rollForwardTeachingRequestsSubjectIds;
    }

    public void validateTeachingRequestsRollForward(Session toAcadSession, ActionErrors errors) {
        if (this.getRollForwardTeachingRequests().booleanValue()) {
            if (this.getRollForwardOfferingCoordinatorsSubjectIds() == null || this.getRollForwardOfferingCoordinatorsSubjectIds().length == 0) {
                errors.add("mustSelectDepartment", new ActionMessage("errors.rollForward.generic", (Object)"Teaching Requests", (Object)"No subject area selected."));
            } else {
                this.validateRollForward(errors, toAcadSession, this.getSessionToRollInstructorDataForwardFrom(), "Teaching Requests", TeachingRequestDAO.getInstance().getQuery("select tr from TeachingRequest tr inner join tr.offering.courseOfferings co where co.isControl = true and co.subjectArea.uniqueId in :subjectIds").setParameterList("subjectIds", (Object[])this.getRollForwardOfferingCoordinatorsSubjectIds(), (Type)new StringType()).list());
            }
        }
    }

    public Object clone() {
        RollForwardSessionForm form = new RollForwardSessionForm();
        this.copyTo(form);
        return form;
    }
}

