/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

@Service(value="org.unitime.timetable.export.Exporter:solution.xml")
public class ExportSolutionXML
implements Exporter {
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    public String reference() {
        return "solution.xml";
    }

    public void export(ExportHelper helper) throws IOException {
        String t = helper.getParameter("type");
        if (t == null || t.isEmpty()) {
            throw new IllegalArgumentException("Type parameter was not provided.");
        }
        SolverInterface.SolverType type = null;
        try {
            type = SolverInterface.SolverType.valueOf(t.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong solver type.");
        }
        CommonSolverInterface solver = this.getSolver(type);
        if (solver == null) {
            throw new IllegalArgumentException("Solver is not started.");
        }
        if (solver.isWorking()) {
            throw new IllegalArgumentException("Solver is working, stop it first.");
        }
        switch (type) {
            case COURSE: {
                helper.getSessionContext().checkPermission((Serializable)solver.getProperties().getPropertyLongArry("General.SolverGroupId", null), "SolverGroup", Right.SolverSolutionExportXml);
                break;
            }
            case EXAM: {
                helper.getSessionContext().checkPermission(Right.ExaminationSolutionExportXml);
                break;
            }
            case STUDENT: {
                helper.getSessionContext().checkPermission(Right.StudentSectioningSolutionExportXml);
                break;
            }
            case INSTRUCTOR: {
                helper.getSessionContext().checkPermission(Right.InstructorSchedulingSolutionExportXml);
            }
        }
        byte[] buf = solver.exportXml();
        helper.setup("application/xml", type.name().toLowerCase() + "-solution.xml", true);
        OutputStream out = helper.getOutputStream();
        out.write(buf);
        out.flush();
        out.close();
    }

    protected CommonSolverInterface getSolver(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.courseTimetablingSolverService.getSolver();
            }
            case EXAM: {
                return this.examinationSolverService.getSolver();
            }
            case STUDENT: {
                return this.studentSectioningSolverService.getSolver();
            }
            case INSTRUCTOR: {
                return this.instructorSchedulingSolverService.getSolver();
            }
        }
        throw new IllegalArgumentException("Invalid solver type " + (Object)((Object)type));
    }
}

