/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import com.lowagie.text.Font;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.rooms.RoomGroupsExportCSV;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.util.PdfFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:roomgroups.pdf")
public class RoomGroupsExportPDF
extends RoomGroupsExportCSV {
    @Override
    public String reference() {
        return "roomgroups.pdf";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.GroupInterface> groups, int dm, String department) throws IOException {
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        this.print(out, groups, dm, department);
        out.flush();
        out.close();
    }

    @Override
    protected void printHeader(Exporter.Printer out) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colAbbreviation(), MESSAGES.colDepartment(), MESSAGES.colRooms(), MESSAGES.colDescription());
    }

    @Override
    protected void printLine(Exporter.Printer out, RoomInterface.GroupInterface group, int dm) throws IOException {
        ((PDFPrinter)out).printLine(new PDFPrinter.A(group.getLabel(), new PDFPrinter.F[0]), new PDFPrinter.A(group.getAbbreviation(), new PDFPrinter.F[0]), new PDFPrinter.A(group.isDepartmental() ? this.dept2string(group.getDepartment(), dm) : (group.isDefault() ? MESSAGES.exportDefaultRoomGroup() : MESSAGES.exportGlobalRoomGroup()), new PDFPrinter.F[0]), this.rooms(group), new PDFPrinter.A(group.getDescription(), new PDFPrinter.F[0]).maxWidth(Float.valueOf(250.0f)));
    }

    protected PDFPrinter.A rooms(RoomInterface.GroupInterface group) {
        PDFPrinter.A ret = new PDFPrinter.A();
        if (group.hasRooms()) {
            Font font = PdfFont.getFont(true);
            String rooms = "";
            Iterator<EventInterface.FilterRpcResponse.Entity> i = group.getRooms().iterator();
            while (i.hasNext()) {
                String chip = this.name(i.next()) + (i.hasNext() ? ", " : "");
                StringBuilder stringBuilder = new StringBuilder();
                if (font.getBaseFont().getWidthPoint(stringBuilder.append(rooms).append(chip).toString(), font.getSize()) < 500.0f) {
                    rooms = rooms + chip;
                    continue;
                }
                ret.add(new PDFPrinter.A(rooms, new PDFPrinter.F[0]));
                rooms = chip;
            }
            if (!rooms.isEmpty()) {
                ret.add(new PDFPrinter.A(rooms, new PDFPrinter.F[0]));
            }
        }
        return ret;
    }
}

