/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:meetings.pdf")
public class EventsExportMeetingsToPDF
extends EventsExporter {
    @Override
    public String reference() {
        return "meetings.pdf";
    }

    @Override
    protected void print(ExportHelper helper, EventInterface.EventLookupRpcRequest request, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        PDFPrinter printer = new PDFPrinter(helper.getOutputStream(), true);
        helper.setup(printer.getContentType(), this.reference(), false);
        this.hideColumns(printer, events, eventCookieFlags);
        this.print(printer, this.meetings(events, sort, asc));
    }

    @Override
    protected void hideColumn(Exporter.Printer out, List<EventInterface> events, EventInterface.EventFlag flag) {
        switch (flag) {
            case SHOW_SECTION: {
                out.hideColumn(1);
                break;
            }
            case SHOW_TITLE: {
                out.hideColumn(3);
                break;
            }
            case SHOW_NOTE: {
                out.hideColumn(4);
                break;
            }
            case SHOW_PUBLISHED_TIME: {
                out.hideColumn(6);
                break;
            }
            case SHOW_ALLOCATED_TIME: {
                out.hideColumn(7);
                break;
            }
            case SHOW_SETUP_TIME: {
                out.hideColumn(8);
                break;
            }
            case SHOW_TEARDOWN_TIME: {
                out.hideColumn(9);
                break;
            }
            case SHOW_CAPACITY: {
                out.hideColumn(11);
                break;
            }
            case SHOW_MEETING_CONTACTS: {
                out.hideColumn(12);
                break;
            }
            case SHOW_ENROLLMENT: {
                out.hideColumn(13);
                break;
            }
            case SHOW_LIMIT: {
                out.hideColumn(14);
                break;
            }
            case SHOW_SPONSOR: {
                out.hideColumn(15);
                break;
            }
            case SHOW_REQUESTED_SERVICES: {
                out.hideColumn(16);
                break;
            }
            case SHOW_MAIN_CONTACT: {
                out.hideColumn(17);
                break;
            }
            case SHOW_APPROVAL: {
                out.hideColumn(18);
                break;
            }
            case SHOW_LAST_CHANGE: {
                out.hideColumn(19);
            }
        }
    }

    protected void print(Exporter.Printer out, Set<EventsExporter.EventMeeting> meetings) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colSection(), MESSAGES.colType(), MESSAGES.colTitle(), MESSAGES.colNote(), MESSAGES.colDate(), MESSAGES.colPublishedTime(), MESSAGES.colAllocatedTime(), MESSAGES.colSetupTimeShort(), MESSAGES.colTeardownTimeShort(), MESSAGES.colLocation(), MESSAGES.colCapacity(), MESSAGES.colMeetingContacts(), MESSAGES.colEnrollment(), MESSAGES.colLimit(), MESSAGES.colSponsorOrInstructor(), MESSAGES.colRequestedServices(), MESSAGES.colMainContact(), MESSAGES.colApproval(), MESSAGES.colLastChange());
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        Formats.Format<Date> dfMeeting = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        EventInterface last = null;
        for (EventsExporter.EventMeeting em : meetings) {
            EventInterface event = em.getEvent();
            EventInterface.MeetingInterface meeting = em.getMeeting();
            if (last == null || !last.equals(event)) {
                out.flush();
                last = event;
            }
            String[] stringArray = new String[20];
            stringArray[0] = this.getName(event);
            stringArray[1] = this.getSection(event);
            stringArray[2] = event.hasInstruction() ? event.getInstruction() : event.getType().getAbbreviation(CONSTANTS);
            stringArray[3] = this.getTitle(event);
            String string = stringArray[4] = event.hasEventNote() ? event.getEventNote("\n").replace("<br>", "\n") : "";
            stringArray[5] = meeting.isArrangeHours() ? (event.hasMessage() ? event.getMessage() : CONSTANTS.arrangeHours()) : dfMeeting.format(meeting.getMeetingDate());
            stringArray[6] = meeting.isArrangeHours() && event.hasMessage() ? CONSTANTS.arrangeHours() : meeting.getMeetingTime(CONSTANTS);
            stringArray[7] = meeting.getAllocatedTime(CONSTANTS);
            stringArray[8] = String.valueOf(meeting.getStartOffset());
            stringArray[9] = String.valueOf(-meeting.getEndOffset());
            stringArray[10] = meeting.getLocationName(MESSAGES);
            stringArray[11] = meeting.hasLocation() && meeting.getLocation().hasSize() ? meeting.getLocation().getSize().toString() : null;
            stringArray[12] = meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES);
            stringArray[13] = event.hasEnrollment() ? event.getEnrollment().toString() : null;
            String string2 = stringArray[14] = event.hasMaxCapacity() ? event.getMaxCapacity().toString() : null;
            stringArray[15] = event.hasInstructors() ? event.getInstructorNames("\n", MESSAGES) : (event.hasSponsor() ? event.getSponsor().getName() : null);
            stringArray[16] = event.hasRequestedServices() ? event.getRequestedServices("\n") : null;
            String string3 = stringArray[17] = event.hasContact() ? event.getContact().getName(MESSAGES) : null;
            stringArray[18] = event.getType() == EventInterface.EventType.Unavailabile ? "" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? df.format(meeting.getApprovalDate()) : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? MESSAGES.approvalCancelled() : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? MESSAGES.approvalRejected() : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? MESSAGES.approvalDeleted() : (meeting.isPast() ? MESSAGES.approvalNotApprovedPast() : (event.getExpirationDate() != null ? MESSAGES.approvalExpire(df.format(event.getExpirationDate())) : MESSAGES.approvalNotApproved()))))));
            stringArray[19] = event.getLastNote() != null ? df.format(event.getLastNote().getDate()) + " " + event.getLastNote().getType().getName() : null;
            out.printLine(stringArray);
        }
        out.flush();
        out.close();
    }
}

