/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=AcademicSessionSelectionBox.ListAcademicSessions.class)
public class ListAcademicSessions
implements GwtRpcImplementation<AcademicSessionSelectionBox.ListAcademicSessions, GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession>> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession> execute(AcademicSessionSelectionBox.ListAcademicSessions command, SessionContext context) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        Session selected = null;
        if (command.hasTerm()) {
            try {
                selected = ListAcademicSessions.findSession(hibSession, command.getTerm());
            }
            catch (GwtRpcException e) {}
        } else {
            Long sessionId;
            Long l = sessionId = context.isAuthenticated() && context.getUser().getCurrentAuthority() != null ? context.getUser().getCurrentAcademicSessionId() : null;
            if (sessionId != null) {
                selected = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
            }
        }
        if (selected == null) {
            try {
                selected = ListAcademicSessions.findSession(hibSession, "current");
            }
            catch (GwtRpcException e) {
                // empty catch block
            }
        }
        Right permission = Right.Events;
        if (command.hasSource()) {
            permission = Right.valueOf(command.getSource());
        }
        TreeSet<Object> sessions = new TreeSet();
        if (ApplicationProperty.ListSessionsReverse.isTrue()) {
            sessions = new TreeSet<Session>(new Comparator<Session>(){

                @Override
                public int compare(Session s1, Session s2) {
                    int cmp = s1.getAcademicInitiative().compareTo(s2.getAcademicInitiative());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s2.getSessionBeginDateTime().compareTo(s1.getSessionBeginDateTime());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getUniqueId().compareTo(s2.getUniqueId());
                }
            });
        }
        for (Object session : hibSession.createQuery("select s from Session s").list()) {
            if (((BaseSession)session).getStatusType() == null || ((BaseSession)session).getStatusType().isTestSession() || !context.hasPermissionAnyAuthority(permission, new SimpleQualifier("Session", ((BasePreferenceGroup)session).getUniqueId()))) continue;
            sessions.add(session);
        }
        if (sessions.isEmpty()) {
            throw new GwtRpcException(MESSAGES.noSessionAvailable());
        }
        if (selected == null || !sessions.contains(selected)) {
            selected = UniTimeUserContext.defaultSession(sessions, null, UserProperty.PrimaryCampus.get(context.getUser()));
        }
        if (selected == null) {
            selected = (Session)sessions.last();
        }
        if (!command.hasTerm() && !context.hasPermissionAnyAuthority((Object)selected, Right.EventAddSpecial, new Qualifiable[0])) {
            Session defaultSession;
            TreeSet<Session> preferred = new TreeSet<Session>();
            for (Session session : sessions) {
                if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddSpecial, new SimpleQualifier("Session", session.getUniqueId()))) {
                    preferred.add(session);
                    continue;
                }
                if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddCourseRelated, new SimpleQualifier("Session", session.getUniqueId()))) {
                    preferred.add(session);
                    continue;
                }
                if (!context.hasPermissionAnyAuthority((Object)session, Right.EventAddUnavailable, new SimpleQualifier("Session", session.getUniqueId()))) continue;
                preferred.add(session);
            }
            if (!preferred.isEmpty() && (defaultSession = UniTimeUserContext.defaultSession(preferred, null, UserProperty.PrimaryCampus.get(context.getUser()))) != null) {
                selected = defaultSession;
            }
        }
        GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession> ret = new GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession>();
        for (Session session : sessions) {
            AcademicSessionSelectionBox.AcademicSession acadSession = new AcademicSessionSelectionBox.AcademicSession(session.getUniqueId(), session.getLabel(), session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative(), df.format(session.getEventBeginDate()) + " - " + df.format(session.getEventEndDate()), session.equals(selected));
            if (session.canNoRoleReportClass()) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasClasses);
            }
            if (session.canNoRoleReportExamFinal()) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasFinalExams);
            }
            if (session.canNoRoleReportExamMidterm()) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasMidtermExams);
            }
            if (context.hasPermissionAnyAuthority((Object)session, Right.Events, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasEvents);
            }
            if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddSpecial, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.CanAddEvents);
            } else if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddCourseRelated, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.CanAddEvents);
            } else if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddUnavailable, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.CanAddEvents);
            }
            BasePreferenceGroup prev = null;
            BasePreferenceGroup next = null;
            for (Session session2 : sessions) {
                if (session2.getUniqueId().equals(session.getUniqueId()) || !session2.getAcademicInitiative().equals(session.getAcademicInitiative())) continue;
                if (session2.getSessionEndDateTime().before(session.getSessionBeginDateTime())) {
                    if (prev != null && !((BaseSession)prev).getSessionBeginDateTime().before(session2.getSessionBeginDateTime())) continue;
                    prev = session2;
                    continue;
                }
                if (!session2.getSessionBeginDateTime().after(session.getSessionEndDateTime()) || next != null && !((BaseSession)next).getSessionBeginDateTime().after(session2.getSessionBeginDateTime())) continue;
                next = session2;
            }
            if (next != null) {
                acadSession.setNextId(next.getUniqueId());
            }
            if (prev != null) {
                acadSession.setPreviousId(prev.getUniqueId());
            }
            ret.add(acadSession);
        }
        return ret;
    }

    public static Session findSession(org.hibernate.Session hibSession, String term) {
        try {
            Session ret = (Session)SessionDAO.getInstance().get(Long.parseLong(term), hibSession);
            if (ret != null) {
                return ret;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        List sessions = hibSession.createQuery("select s from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term").setString("term", term).list();
        if (!sessions.isEmpty()) {
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                return session;
            }
        }
        if ("current".equalsIgnoreCase(term) && !(sessions = hibSession.createQuery("select s from Session s where s.eventBeginDate <= :today and s.eventEndDate >= :today").setDate("today", new Date()).list()).isEmpty()) {
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                return session;
            }
        }
        throw new GwtRpcException("Academic session " + term + " not found.");
    }
}

