/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Element;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseTimetableImport
extends BaseImport {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private DateFormat iDateFormat = null;
    private DateFormat iTimeFormat = null;
    private DateFormat iHHmm = new SimpleDateFormat("HHmm", Locale.US);
    private HashMap<String, Class_> iExtId2class;
    private HashMap<String, Class_> iName2class;
    private HashMap<Long, Solution> iOwnerId2solution;
    private HashMap<String, Room> iExtId2room;
    private HashMap<String, Room> iName2room;
    private HashMap<String, Location> iExtId2location;
    private HashMap<String, Location> iName2location;
    private HashMap<String, DatePattern> iName2dp;
    private List<DatePattern> iDatePatterns;
    private List<TimePattern> iTimePatterns;
    private HashMap<String, TimePattern> iName2tp;
    private Date iToday;
    private Session iSession;
    private boolean iInstructors;
    private boolean iPreferExtId;
    private boolean iNotes;
    private boolean iShowClassSuffix;
    private boolean iShowConfigName;

    @Override
    public void loadXml(Element rootElement) throws Exception {
        if (!rootElement.getName().equalsIgnoreCase("timetable")) {
            throw new Exception("Given XML file is not a course timetable import file.");
        }
        try {
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            String action = rootElement.attributeValue("action");
            this.iInstructors = "true".equalsIgnoreCase(rootElement.attributeValue("instructors", "false"));
            this.iNotes = "true".equalsIgnoreCase(rootElement.attributeValue("notes", "false"));
            this.iPreferExtId = "id".equalsIgnoreCase(rootElement.attributeValue("prefer", "id"));
            this.iDateFormat = new SimpleDateFormat(rootElement.attributeValue("dateFormat", "yyyy/M/d"), Locale.US);
            String timeFormat = rootElement.attributeValue("timeFormat", "HHmm");
            if (!"HHmm".equals(timeFormat)) {
                this.iTimeFormat = new SimpleDateFormat(timeFormat, Locale.US);
            }
            this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
            this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
            this.beginTransaction();
            this.iSession = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (this.iSession == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            this.iExtId2class = new HashMap();
            this.iName2class = new HashMap();
            this.info("Loading classes...");
            for (Object[] o : this.getHibSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", this.iSession.getUniqueId().longValue()).list()) {
                CourseOffering course;
                Class_ clazz = (Class_)o[0];
                String extId = clazz.getExternalId(course = (CourseOffering)o[1]);
                if (extId != null && !extId.isEmpty()) {
                    this.iExtId2class.put(extId, clazz);
                }
                String name = course.getCourseName() + " " + clazz.getItypeDesc().trim() + " " + this.getClassSuffix(clazz);
                this.iName2class.put(name, clazz);
            }
            this.iOwnerId2solution = new HashMap();
            if ("update".equals(action)) {
                this.info("Loading solutions...");
                for (Solution solution : this.getHibSession().createQuery("select s from Solution s where s.commited = true and s.owner.session.uniqueId = :sessionId").setLong("sessionId", this.iSession.getUniqueId().longValue()).list()) {
                    this.iOwnerId2solution.put(solution.getOwner().getUniqueId(), solution);
                }
            }
            this.info("Loading rooms...");
            this.iExtId2room = new HashMap();
            this.iName2room = new HashMap();
            for (Room room : this.getHibSession().createQuery("select r from Room r where r.session.uniqueId = :sessionId").setLong("sessionId", this.iSession.getUniqueId().longValue()).list()) {
                if (room.getExternalUniqueId() != null && !room.getExternalUniqueId().isEmpty()) {
                    this.iExtId2room.put(room.getExternalUniqueId(), room);
                }
                this.iName2room.put(room.getLabel(), room);
            }
            this.iExtId2location = new HashMap();
            this.iName2location = new HashMap();
            for (Location location : this.getHibSession().createQuery("select r from Location r where r.session.uniqueId = :sessionId").setLong("sessionId", this.iSession.getUniqueId().longValue()).list()) {
                if (location.getExternalUniqueId() != null && !location.getExternalUniqueId().isEmpty()) {
                    this.iExtId2location.put(location.getExternalUniqueId(), location);
                }
                this.iName2location.put(location.getLabel(), location);
            }
            this.iName2dp = new HashMap();
            this.iDatePatterns = DatePattern.findAll(this.iSession.getUniqueId(), true, null, null);
            for (DatePattern dp : this.iDatePatterns) {
                this.iName2dp.put(dp.getName(), dp);
            }
            this.iTimePatterns = TimePattern.findAll(this.iSession.getUniqueId(), (Boolean)true);
            this.iName2tp = new HashMap();
            for (TimePattern tp : this.iTimePatterns) {
                this.iName2tp.put(tp.getName(), tp);
            }
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.iToday = cal.getTime();
            this.info("Importing assignments...");
            Iterator i = rootElement.elementIterator("class");
            while (i.hasNext()) {
                this.importClassAssignment((Element)i.next());
            }
            this.info("Committing new solutions...");
            for (Solution solution : this.iOwnerId2solution.values()) {
                if (solution.isCommited().booleanValue()) continue;
                this.info("Committing solution for " + solution.getOwner().getName());
                ArrayList<String> messages = new ArrayList<String>();
                if (solution.commitSolution(messages, this.getHibSession(), null)) continue;
                this.error("Failed to commit solution for " + solution.getOwner().getName() + ", see the following problems:");
                for (String message : messages) {
                    this.warn(message);
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void importClassAssignment(Element classElement) {
        DatePattern classDatePattern;
        Solution solution;
        SolverGroup sg;
        Department department;
        Iterator i = classElement.elementIterator("class");
        while (i.hasNext()) {
            this.importClassAssignment((Element)i.next());
        }
        Class_ clazz = this.lookupClass(classElement);
        if (clazz == null) {
            return;
        }
        if (this.iInstructors) {
            this.updateInstructors(clazz, classElement);
        }
        if (this.iNotes) {
            clazz.setSchedulePrintNote(classElement.attributeValue("scheduleNote"));
            clazz.setDisplayInstructor("true".equalsIgnoreCase(classElement.attributeValue("displayInScheduleBook", clazz.isDisplayInstructor() != false ? "true" : "false")));
            clazz.setEnabledForStudentScheduling("true".equalsIgnoreCase(classElement.attributeValue("studentScheduling", clazz.isEnabledForStudentScheduling() != false ? "true" : "false")));
        }
        if ((department = clazz.getManagingDept()) == null) {
            department = clazz.getSchedulingSubpart().getControllingDept();
        }
        if ((sg = department.getSolverGroup()) == null) {
            sg = new SolverGroup();
            sg.setDepartments(new HashSet<Department>());
            sg.getDepartments().add(department);
            department.setSolverGroup(sg);
            sg.setAbbv(department.getAbbreviation() == null ? department.getDeptCode() : department.getAbbreviation());
            sg.setName(department.getName());
            sg.setSession(this.iSession);
            sg.setTimetableManagers(new HashSet<TimetableManager>(department.getTimetableManagers()));
            sg.setSolutions(new HashSet<Solution>());
            this.getHibSession().save((Object)sg);
            this.getHibSession().update((Object)department);
        }
        if ((solution = this.iOwnerId2solution.get(sg.getUniqueId())) == null) {
            solution = new Solution();
            solution.setCreated(new Date());
            solution.setCreator("MakeAssignmentsForClassEvents");
            solution.setOwner(sg);
            sg.getSolutions().add(solution);
            solution.setValid(true);
            solution.setAssignments(new HashSet<Assignment>());
            solution.setCommited(false);
            solution.setCommitDate(null);
            this.getHibSession().save((Object)solution);
            this.getHibSession().update((Object)sg);
            this.iOwnerId2solution.put(sg.getUniqueId(), solution);
        }
        Assignment assignment = null;
        for (Assignment a : solution.getAssignments()) {
            if (!a.getClazz().equals(clazz)) continue;
            assignment = a;
        }
        BaseDatePattern datePattern = null;
        TimePattern timePattern = null;
        Integer dayCode = null;
        Integer startSlot = null;
        String datePatternName = null;
        Iterator j = classElement.elementIterator("time");
        while (j.hasNext()) {
            Element timeElement = (Element)j.next();
            try {
                startSlot = this.parseTime(timeElement.attributeValue("startTime"));
            }
            catch (Exception e) {
                this.warn("Failed to parse start time " + timeElement.attributeValue("startTime") + " for " + clazz.getClassLabel());
                return;
            }
            dayCode = (dayCode == null ? 0 : dayCode) | this.parseDaysOfWeek(timeElement.attributeValue("days"));
            if (timeElement.attributeValue("datePattern") != null) {
                datePatternName = timeElement.attributeValue("datePattern");
                datePattern = this.iName2dp.get(timeElement.attributeValue("datePattern"));
            }
            if (timeElement.attributeValue("timePattern") == null) continue;
            timePattern = this.iName2tp.get(timeElement.attributeValue("timePattern"));
        }
        if (dayCode == null) {
            if (assignment != null) {
                if (assignment.getSolution().isCommited().booleanValue()) {
                    ClassEvent event = clazz.getEvent();
                    if (event != null) {
                        if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
                            this.getHibSession().delete((Object)event);
                        } else {
                            Iterator<Meeting> j2 = event.getMeetings().iterator();
                            while (j2.hasNext()) {
                                if (j2.next().getMeetingDate().before(this.iToday)) continue;
                                j2.remove();
                            }
                            if (event.getMeetings().isEmpty()) {
                                this.getHibSession().delete((Object)event);
                            } else {
                                this.getHibSession().saveOrUpdate((Object)event);
                            }
                        }
                    }
                    clazz.setCommittedAssignment(null);
                }
                assignment.getSolution().getAssignments().remove(assignment);
                clazz.getAssignments().remove(assignment);
                for (ConstraintInfo ci : assignment.getConstraintInfo()) {
                    for (Assignment assignment2 : ci.getAssignments()) {
                        if (assignment2.equals(assignment)) continue;
                        assignment2.getConstraintInfo().remove(ci);
                    }
                    this.getHibSession().delete((Object)ci);
                }
                this.getHibSession().delete((Object)assignment);
            }
            this.info(clazz.getClassLabel() + " := arrange hours");
            return;
        }
        Set<Location> locations = this.getLocations(classElement);
        if (locations.size() != clazz.getNbrRooms().intValue()) {
            this.warn("Changed number of rooms for " + clazz.getClassLabel() + " to " + locations.size());
            clazz.setNbrRooms(locations.size());
        }
        if ((classDatePattern = clazz.effectiveDatePattern()) != null) {
            if (classDatePattern.getType() == 4) {
                for (DatePattern datePattern2 : this.iDatePatterns) {
                    if (!datePattern2.getParents().contains(classDatePattern) || !this.match(datePattern2, classElement, dayCode)) continue;
                    datePattern = classDatePattern;
                    break;
                }
            } else if (this.match(classDatePattern, classElement, dayCode)) {
                datePattern = classDatePattern;
            }
        }
        if (datePattern == null) {
            BitSet pattern = this.parseDatePattern(classElement, this.iSession);
            if (pattern.length() > 0) {
                for (DatePattern dp : this.iDatePatterns) {
                    if (!dp.getPatternBitSet().equals(pattern)) continue;
                    datePattern = dp;
                    break;
                }
                if (datePattern == null) {
                    this.info("No date pattern found for " + clazz.getClassLabel() + " -- creating a new one.");
                    datePattern = new DatePattern();
                    datePattern.setName(datePatternName == null ? "import - " + clazz.getClassLabel() : datePatternName);
                    datePattern.setSession(this.iSession);
                    ((DatePattern)datePattern).setPatternBitSet(pattern);
                    datePattern.setType(new Integer(3));
                    datePattern.setVisible(false);
                    datePattern.setParents(new HashSet<DatePattern>());
                    this.getHibSession().saveOrUpdate((Object)datePattern);
                    this.iName2dp.put(datePattern.getName(), (DatePattern)datePattern);
                }
            } else {
                datePattern = this.iSession.getDefaultDatePattern();
            }
        }
        if (datePattern == null) {
            this.warn("No date pattern found for " + clazz.getClassLabel());
            return;
        }
        if (classDatePattern == null || !datePattern.equals(classDatePattern) && !datePattern.getParents().contains(classDatePattern)) {
            clazz.setDatePattern((DatePattern)datePattern);
            this.info("Changing date pattern for " + clazz.getClassLabel() + " (" + datePattern.getName() + ")");
        }
        block10: for (TimePref timePref : clazz.getEffectiveTimePreferences()) {
            TimePatternModel m = timePref.getTimePatternModel();
            if (m.isExactTime()) {
                if (m.getExactDays() != dayCode.intValue() || m.getExactStartSlot() != startSlot.intValue()) continue;
                timePattern = timePref.getTimePattern();
                break;
            }
            for (int d = 0; d < m.getNrDays(); ++d) {
                if (m.getDayCode(d) != dayCode.intValue()) continue;
                for (int t = 0; t < m.getNrTimes(); ++t) {
                    if (m.getStartSlot(t) != startSlot.intValue()) continue;
                    timePattern = timePref.getTimePattern();
                    continue block10;
                }
            }
        }
        DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        if (timePattern == null) {
            void var15_27;
            Object var15_23 = null;
            block13: for (TimePattern tp : this.iTimePatterns) {
                if (tp.getType() != 5 && !dm.isValidCombination(clazz.getSchedulingSubpart().getMinutesPerWk(), (DatePattern)datePattern, tp)) continue;
                TimePatternModel m = tp.getTimePatternModel();
                if (m.isExactTime()) {
                    m.setExactDays(dayCode);
                    m.setExactStartSlot(startSlot);
                    TimePatternModel timePatternModel = m;
                    timePattern = tp;
                    continue;
                }
                for (int d = 0; d < m.getNrDays(); ++d) {
                    if (m.getDayCode(d) != dayCode.intValue()) continue;
                    for (int t = 0; t < m.getNrTimes(); ++t) {
                        if (m.getStartSlot(t) != startSlot.intValue()) continue;
                        m.setPreference(d, t, PreferenceLevel.sStronglyPreferred);
                        TimePatternModel timePatternModel = m;
                        timePattern = tp;
                        break block13;
                    }
                }
            }
            if (var15_27 != null) {
                TimePref tp = new TimePref();
                tp.setOwner(clazz);
                tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                tp.setTimePatternModel((TimePatternModel)var15_27);
                clazz.getPreferences().add(tp);
                this.info("Time pattern " + timePattern.getName() + " added to " + clazz.getClassLabel());
            }
        }
        if (timePattern == null) {
            this.warn("No time pattern found for " + clazz.getClassLabel());
            return;
        }
        if (assignment != null) {
            ClassEvent classEvent;
            assignment.setDatePattern((DatePattern)datePattern);
            assignment.setTimePattern(timePattern);
            assignment.setSlotsPerMtg(-1);
            assignment.setBreakTime(-1);
            assignment.setDays(dayCode);
            assignment.setStartSlot(startSlot);
            assignment.setRooms(locations);
            assignment.setInstructors(new HashSet<DepartmentalInstructor>());
            if (solution.isCommited().booleanValue() && (classEvent = assignment.generateCommittedEvent(clazz.getEvent(), true)) != null) {
                if (!classEvent.getMeetings().isEmpty()) {
                    this.getHibSession().saveOrUpdate((Object)classEvent);
                } else if (classEvent.getMeetings().isEmpty() && classEvent.getUniqueId() != null) {
                    this.getHibSession().delete((Object)classEvent);
                }
            }
        } else {
            assignment = new Assignment();
            assignment.setDatePattern((DatePattern)datePattern);
            assignment.setTimePattern(timePattern);
            assignment.setSlotsPerMtg(-1);
            assignment.setBreakTime(-1);
            assignment.setDays(dayCode);
            assignment.setStartSlot(startSlot);
            assignment.setRooms(locations);
            assignment.setAssignmentInfo(new HashSet<AssignmentInfo>());
            assignment.setInstructors(new HashSet<DepartmentalInstructor>());
            assignment.setSolution(solution);
            assignment.setClazz(clazz);
            assignment.setClassId(clazz.getUniqueId());
            assignment.setClassName(clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName));
            solution.getAssignments().add(assignment);
            clazz.getAssignments().add(assignment);
        }
        for (ClassInstructor instr : clazz.getClassInstructors()) {
            if (!instr.isLead().booleanValue()) continue;
            assignment.getInstructors().add(instr.getInstructor());
        }
        this.info(clazz.getClassLabel() + " := " + assignment.getPlacement().getLongName(CONSTANTS.useAmPm()));
        this.getHibSession().saveOrUpdate((Object)assignment);
        this.getHibSession().saveOrUpdate((Object)clazz);
    }

    protected Class_ lookupClass(Element classElement) {
        String externalId = classElement.attributeValue("id", classElement.attributeValue("externalId"));
        Class_ clazz = null;
        if (externalId != null && (clazz = this.iExtId2class.get(externalId)) == null) {
            clazz = this.iName2class.get(externalId);
        }
        String className = null;
        if (classElement.attributeValue("name") != null) {
            className = classElement.attributeValue("name");
        } else if (classElement.attributeValue("subject") != null) {
            className = classElement.attributeValue("subject") + " " + classElement.attributeValue("courseNbr") + " " + classElement.attributeValue("type") + " " + classElement.attributeValue("suffix");
        }
        if (className != null) {
            if (clazz == null) {
                clazz = this.iName2class.get(className);
            } else {
                Class_ clazzByName = this.iName2class.get(className);
                if (clazzByName != null && !clazzByName.equals(clazz)) {
                    this.warn("Class " + className + " has a different external id " + clazz.getExternalUniqueId() + " != " + externalId + ".");
                    if (!this.iPreferExtId) {
                        clazz = clazzByName;
                    }
                }
            }
        }
        if (clazz == null) {
            this.warn("Class " + (className != null ? className + (externalId == null ? "" : " (" + externalId + ")") : externalId) + " not found.");
        }
        return clazz;
    }

    protected Set<Location> getLocations(Element classElement) {
        String name;
        String id;
        HashSet<Location> locations = new HashSet<Location>();
        Iterator j = classElement.elementIterator("room");
        while (j.hasNext()) {
            Element roomElement = (Element)j.next();
            id = roomElement.attributeValue("id", roomElement.attributeValue("externalId"));
            Room room = null;
            if (id != null && (room = this.iExtId2room.get(id)) == null) {
                room = this.iName2room.get(id);
            }
            name = null;
            if (roomElement.attributeValue("name") != null) {
                name = roomElement.attributeValue("name");
            } else if (roomElement.attributeValue("building") != null && roomElement.attributeValue("roomNbr") != null) {
                name = roomElement.attributeValue("building") + " " + roomElement.attributeValue("roomNbr");
            }
            if (name != null) {
                if (room == null) {
                    room = this.iName2room.get(name);
                } else {
                    Room roomByName = this.iName2room.get(name);
                    if (roomByName != null && !roomByName.equals(room)) {
                        this.warn("Room " + roomByName + " has a different external id " + roomByName.getExternalUniqueId() + " != " + id + ".");
                        if (!this.iPreferExtId) {
                            room = roomByName;
                        }
                    }
                }
            }
            if (room == null) {
                this.warn("Room " + (name != null ? name + (id == null ? "" : " (" + id + ")") : id) + " not found.");
                continue;
            }
            locations.add(room);
        }
        j = classElement.elementIterator("location");
        while (j.hasNext()) {
            Element locationElement = (Element)j.next();
            id = locationElement.attributeValue("id", locationElement.attributeValue("externalId"));
            Location location = null;
            if (id != null && (location = this.iExtId2location.get(id)) == null) {
                location = this.iName2location.get(id);
            }
            name = null;
            if (locationElement.attributeValue("name") != null) {
                name = locationElement.attributeValue("name");
            } else if (locationElement.attributeValue("building") != null && locationElement.attributeValue("roomNbr") != null) {
                name = locationElement.attributeValue("building") + " " + locationElement.attributeValue("roomNbr");
            }
            if (name != null) {
                if (location == null) {
                    location = this.iName2location.get(name);
                } else {
                    Location locationByName = this.iName2location.get(name);
                    if (locationByName != null && !locationByName.equals(location)) {
                        this.warn("Location " + locationByName + " has a different external id " + locationByName.getExternalUniqueId() + " != " + id + ".");
                        if (!this.iPreferExtId) {
                            location = locationByName;
                        }
                    }
                }
            }
            if (location == null) {
                this.warn("Location " + (name != null ? name + (id == null ? "" : " (" + id + ")") : id) + " not found.");
                continue;
            }
            locations.add(location);
        }
        return locations;
    }

    protected int parseDaysOfWeek(String daysOfWeek) {
        int ret = 0;
        String tmpDays = daysOfWeek;
        if (tmpDays.contains("Th")) {
            ret |= Constants.DAY_CODES[3];
            tmpDays = tmpDays.replace("Th", "..");
        }
        if (tmpDays.contains("R")) {
            ret |= Constants.DAY_CODES[3];
            tmpDays = tmpDays.replace("R", "..");
        }
        if (tmpDays.contains("Su")) {
            ret |= Constants.DAY_CODES[6];
            tmpDays = tmpDays.replace("Su", "..");
        }
        if (tmpDays.contains("U")) {
            ret |= Constants.DAY_CODES[6];
            tmpDays = tmpDays.replace("U", "..");
        }
        if (tmpDays.contains("M")) {
            ret |= Constants.DAY_CODES[0];
            tmpDays = tmpDays.replace("M", ".");
        }
        if (tmpDays.contains("T")) {
            ret |= Constants.DAY_CODES[1];
            tmpDays = tmpDays.replace("T", ".");
        }
        if (tmpDays.contains("W")) {
            ret |= Constants.DAY_CODES[2];
            tmpDays = tmpDays.replace("W", ".");
        }
        if (tmpDays.contains("F")) {
            ret |= Constants.DAY_CODES[4];
            tmpDays = tmpDays.replace("F", ".");
        }
        if (tmpDays.contains("S")) {
            ret |= Constants.DAY_CODES[5];
            tmpDays = tmpDays.replace("S", ".");
        }
        return ret;
    }

    protected Integer parseTime(String timeString) throws Exception {
        int time = Integer.parseInt(this.iTimeFormat == null ? timeString : this.iHHmm.format(this.iTimeFormat.parse(timeString)));
        int hour = time / 100;
        int min = time % 100;
        return (60 * hour + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
    }

    protected BitSet parseDatePattern(Element classElement, Session session) {
        int startMonth = session.getPatternStartMonth();
        int endMonth = session.getPatternEndMonth();
        int year = session.getSessionStartYear();
        BitSet pattern = new BitSet();
        int index = 0;
        String endDate = null;
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                String date = this.iDateFormat.format(DateUtils.getDate(d, m, year));
                if (endDate == null) {
                    Iterator i = classElement.elementIterator("date");
                    while (i.hasNext()) {
                        Element dateElement = (Element)i.next();
                        String startDate = dateElement.attributeValue("startDate");
                        try {
                            startDate = this.iDateFormat.format(this.iDateFormat.parse(startDate));
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        if (!date.equals(startDate)) continue;
                        endDate = dateElement.attributeValue("endDate");
                        try {
                            endDate = this.iDateFormat.format(this.iDateFormat.parse(endDate));
                        }
                        catch (ParseException e) {}
                    }
                }
                pattern.set(index++, endDate != null);
                if (!date.equals(endDate)) continue;
                endDate = null;
            }
        }
        return pattern;
    }

    protected boolean match(DatePattern datePattern, Element classElement, int dayCode) {
        BitSet pattern = datePattern.getPatternBitSet();
        int startMonth = datePattern.getSession().getPatternStartMonth();
        int endMonth = datePattern.getSession().getPatternEndMonth();
        int year = datePattern.getSession().getSessionStartYear();
        int index = 0;
        String endDate = null;
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(DateUtils.getDate(1, startMonth, year));
        cal.setLenient(true);
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                String date = this.iDateFormat.format(cal.getTime());
                if (endDate == null) {
                    Iterator i = classElement.elementIterator("date");
                    while (i.hasNext()) {
                        Element dateElement = (Element)i.next();
                        String startDate = dateElement.attributeValue("startDate");
                        try {
                            startDate = this.iDateFormat.format(this.iDateFormat.parse(startDate));
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        if (!date.equals(startDate)) continue;
                        endDate = dateElement.attributeValue("endDate");
                        try {
                            endDate = this.iDateFormat.format(this.iDateFormat.parse(endDate));
                        }
                        catch (ParseException e) {}
                    }
                }
                boolean offered = false;
                switch (cal.get(7)) {
                    case 2: {
                        offered = (dayCode & Constants.DAY_CODES[0]) != 0;
                        break;
                    }
                    case 3: {
                        offered = (dayCode & Constants.DAY_CODES[1]) != 0;
                        break;
                    }
                    case 4: {
                        offered = (dayCode & Constants.DAY_CODES[2]) != 0;
                        break;
                    }
                    case 5: {
                        offered = (dayCode & Constants.DAY_CODES[3]) != 0;
                        break;
                    }
                    case 6: {
                        offered = (dayCode & Constants.DAY_CODES[4]) != 0;
                        break;
                    }
                    case 7: {
                        offered = (dayCode & Constants.DAY_CODES[5]) != 0;
                        break;
                    }
                    case 1: {
                        boolean bl = offered = (dayCode & Constants.DAY_CODES[6]) != 0;
                    }
                }
                if (offered && pattern.get(index) != (endDate != null)) {
                    return false;
                }
                if (date.equals(endDate)) {
                    endDate = null;
                }
                ++index;
                cal.add(6, 1);
            }
        }
        return true;
    }

    protected void updateInstructors(Class_ clazz, Element classElement) {
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(clazz.getClassInstructors());
        Iterator i = classElement.elementIterator("instructor");
        while (i.hasNext()) {
            Element instructorElement = (Element)i.next();
            BaseClassInstructor instructor = null;
            String responsibility = instructorElement.attributeValue("responsibility");
            for (ClassInstructor ci : instructors) {
                DepartmentalInstructor di = ci.getInstructor();
                if (di.getExternalUniqueId() != null && di.getExternalUniqueId().equals(instructorElement.attributeValue("id")) && ToolBox.equals((Object)responsibility, ci.getResponsibility() == null ? null : ci.getResponsibility().getReference())) {
                    instructor = ci;
                    break;
                }
                String name = (di.getFirstName() == null ? "" : di.getFirstName()) + ":" + (di.getMiddleName() == null ? "" : di.getMiddleName()) + ":" + (di.getLastName() == null ? "" : di.getLastName());
                if (!name.equalsIgnoreCase(instructorElement.attributeValue("fname", "") + ":" + instructorElement.attributeValue("mname", "") + ":" + instructorElement.attributeValue("lname", ""))) continue;
                instructor = ci;
                break;
            }
            if (instructor != null) {
                instructors.remove(instructor);
                instructor.setLead("true".equals(instructorElement.attributeValue("lead", instructor.isLead() != false ? "true" : "false")));
                instructor.setPercentShare(Integer.valueOf(instructorElement.attributeValue("share", instructor.getPercentShare() == null ? "100" : instructor.getPercentShare().toString())));
                if (responsibility == null) continue;
                instructor.setResponsibility(TeachingResponsibility.getTeachingResponsibility(responsibility, this.getHibSession()));
                continue;
            }
            String id = instructorElement.attributeValue("id");
            if (id == null) continue;
            DepartmentalInstructor di = this.findDepartmentalInstructorWithExternalUniqueId(id, clazz.getControllingDept());
            if (di == null) {
                di = new DepartmentalInstructor();
                di.setExternalUniqueId(id);
                di.setDepartment(clazz.getControllingDept());
                Staff staff = this.findStaffMember(id);
                if (staff == null) {
                    di.setFirstName(instructorElement.attributeValue("fname", "Unkwnown"));
                    di.setMiddleName(instructorElement.attributeValue("mname", null));
                    di.setLastName(instructorElement.attributeValue("lname", "Instructor"));
                    di.setAcademicTitle(instructorElement.attributeValue("title", null));
                } else {
                    di.setFirstName(staff.getFirstName());
                    di.setMiddleName(staff.getMiddleName());
                    di.setLastName(staff.getLastName());
                    di.setAcademicTitle(staff.getAcademicTitle());
                }
                di.setIgnoreToFar(false);
                this.getHibSession().save((Object)di);
            }
            instructor = new ClassInstructor();
            instructor.setClassInstructing(clazz);
            instructor.setInstructor(di);
            instructor.setLead("true".equals(instructorElement.attributeValue("lead", "true")));
            instructor.setPercentShare(Integer.valueOf(instructorElement.attributeValue("share", "100")));
            if (responsibility != null) {
                instructor.setResponsibility(TeachingResponsibility.getTeachingResponsibility(responsibility, this.getHibSession()));
            }
            clazz.addToclassInstructors((ClassInstructor)instructor);
            di.addToclasses((ClassInstructor)instructor);
            this.getHibSession().saveOrUpdate((Object)instructor);
            this.getHibSession().saveOrUpdate((Object)di);
        }
        for (ClassInstructor instructor : instructors) {
            DepartmentalInstructor di = instructor.getInstructor();
            di.getClasses().remove(instructor);
            instructor.getClassInstructing().getClassInstructors().remove(instructor);
            this.getHibSession().delete((Object)instructor);
            this.getHibSession().saveOrUpdate((Object)di);
        }
    }

    protected DepartmentalInstructor findDepartmentalInstructorWithExternalUniqueId(String externalId, Department department) {
        return (DepartmentalInstructor)this.getHibSession().createQuery("select distinct di from DepartmentalInstructor di where di.externalUniqueId=:externalId and di.department.uniqueId=:departmentId").setString("externalId", externalId).setLong("departmentId", department.getUniqueId().longValue()).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    protected Staff findStaffMember(String id) {
        return (Staff)this.getHibSession().createQuery("select distinct s from Staff s where s.externalUniqueId=:externalId").setString("externalId", id).setMaxResults(1).setCacheable(true).uniqueResult();
    }
}

