/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.SchedulingSubpartEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Service(value="/schedulingSubpartDetail")
public class SchedulingSubpartDetailAction
extends PreferencesAction {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            super.execute(mapping, form, request, response);
            SchedulingSubpartEditForm frm = (SchedulingSubpartEditForm)form;
            ActionMessages errors = new ActionMessages();
            String subpartId = request.getParameter("ssuid") == null ? (request.getAttribute("ssuid") != null ? request.getAttribute("ssuid").toString() : null) : request.getParameter("ssuid");
            String op = frm.getOp();
            if (op == null) {
                throw new Exception(MSG.errorNullOperationNotSupported());
            }
            if (op.equals(MSG.actionEditSubpart()) || op.equals(MSG.actionAddDistributionPreference()) || op.equals(MSG.actionNextSubpart()) || op.equals(MSG.actionPreviousSubpart()) || op.equals(MSG.actionClearClassPreferencesOnSubpart()) || op.equals(MSG.actionEditSubpartInstructorAssignmentPreferences())) {
                subpartId = frm.getSchedulingSubpartId();
            } else {
                frm.reset(mapping, request);
            }
            Debug.debug("op: " + op);
            Debug.debug("subpart: " + subpartId);
            if (subpartId == null || subpartId.trim() == "") {
                throw new Exception(MSG.errorSubpartInfoNotSupplied());
            }
            this.sessionContext.checkPermission((Serializable)((Object)subpartId), "SchedulingSubpart", Right.SchedulingSubpartDetail);
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            SchedulingSubpartDAO sdao = new SchedulingSubpartDAO();
            SchedulingSubpart ss = (SchedulingSubpart)sdao.get(new Long(subpartId));
            if (op.equals(MSG.actionEditSubpart()) && subpartId != null && subpartId.trim() != "") {
                response.sendRedirect(response.encodeURL("schedulingSubpartEdit.do?ssuid=" + ss.getUniqueId().toString()));
                return null;
            }
            if (op.equals(MSG.actionEditSubpartInstructorAssignmentPreferences()) && subpartId != null && subpartId.trim() != "") {
                response.sendRedirect(response.encodeURL("schedulingSubpartInstrAssgnEdit.do?ssuid=" + ss.getUniqueId().toString()));
                return null;
            }
            if (op.equals(MSG.actionAddDistributionPreference())) {
                this.sessionContext.checkPermission(ss, Right.DistributionPreferenceSubpart);
                CourseOffering cco = ss.getInstrOfferingConfig().getControllingCourseOffering();
                request.setAttribute("subjectAreaId", (Object)cco.getSubjectArea().getUniqueId().toString());
                request.setAttribute("schedSubpartId", (Object)subpartId);
                request.setAttribute("courseOffrId", (Object)cco.getUniqueId().toString());
                request.setAttribute("classId", (Object)"-1");
                return mapping.findForward("addDistributionPrefs");
            }
            if (op.equals(MSG.actionNextSubpart())) {
                response.sendRedirect(response.encodeURL("schedulingSubpartDetail.do?ssuid=" + frm.getNextId()));
                return null;
            }
            if (op.equals(MSG.actionClearClassPreferencesOnSubpart()) && "y".equals(request.getParameter("confirm"))) {
                this.sessionContext.checkPermission(ss, Right.SchedulingSubpartDetailClearClassPreferences);
                Class_DAO cdao = new Class_DAO();
                for (Class_ c : ss.getClasses()) {
                    c.getPreferences().clear();
                    cdao.saveOrUpdate(c);
                }
                ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_ALL_PREF, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
            }
            if (op.equals(MSG.actionPreviousSubpart())) {
                response.sendRedirect(response.encodeURL("schedulingSubpartDetail.do?ssuid=" + frm.getPreviousId()));
                return null;
            }
            this.doLoad(request, frm, ss, subpartId);
            Set timePatterns = null;
            frm.setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), ss.getMinutesPerWk(), ss.effectiveDatePattern(), ss.getInstrOfferingConfig().getDurationModel(), false, ss.getManagingDept()));
            this.initPrefs(frm, ss, null, false);
            timePatterns = ss.getTimePatterns();
            DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
            String html = tbl.getDistPrefsTableForSchedulingSubpart(request, this.sessionContext, ss);
            if (html != null) {
                request.setAttribute("distPrefs", (Object)html);
            }
            this.processPrefAction(request, frm, errors);
            this.setupDatePatterns(request, frm, ss);
            super.generateTimePatternGrids(request, frm, ss, ss.getMinutesPerWk(), ss.getInstrOfferingConfig().getDurationModel(), ss.effectiveDatePattern(), timePatterns, "init", timeVertical, false, null);
            LookupTables.setupDatePatterns(request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), ss.getSession().getDefaultDatePatternNotNull(), ss.getManagingDept(), ss.effectiveDatePattern());
            LookupTables.setupRooms(request, ss);
            LookupTables.setupBldgs(request, ss);
            LookupTables.setupRoomFeatures(request, ss);
            LookupTables.setupRoomGroups(request, ss);
            LookupTables.setupInstructorAttributes(request, ss);
            LookupTables.setupInstructors(request, this.sessionContext, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId());
            BackTracker.markForBack(request, "schedulingSubpartDetail.do?ssuid=" + frm.getSchedulingSubpartId(), MSG.backSubpart(ss.getSchedulingSubpartLabel()), true, false);
            return mapping.findForward("displaySchedulingSubpart");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, SchedulingSubpartEditForm frm, SchedulingSubpart ss, String subpartId) {
        SchedulingSubpart parentSS;
        CourseOffering co = ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, ss.getInstrOfferingConfig().getInstructionalOffering());
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        frm.setInstrOfferingId(io.getUniqueId().toString());
        frm.setSchedulingSubpartId(subpartId);
        frm.setInstructionalType(ss.getItype().getItype().toString());
        String label = ss.getItype().getAbbv();
        if (io.hasMultipleConfigurations()) {
            label = label + " [" + ioc.getName() + "]";
        }
        frm.setInstructionalTypeLabel(label);
        frm.setUnlimitedEnroll(ioc.isUnlimitedEnrollment());
        frm.setItypeBasic(ss.getItype() == null || ss.getItype().getBasic() == 1);
        if (!frm.getItypeBasic()) {
            LookupTables.setupItypes(request, false);
        }
        frm.setSubjectArea(co.getSubjectAreaAbbv());
        frm.setSubjectAreaId(co.getSubjectArea().getUniqueId().toString());
        frm.setCourseNbr(co.getCourseNbr());
        frm.setCourseTitle(co.getTitle());
        frm.setAutoSpreadInTime(ss.isAutoSpreadInTime());
        frm.setStudentAllowOverlap(ss.isStudentAllowOverlap());
        frm.setDatePattern(ss.getDatePattern() == null ? new Long(-1L) : ss.getDatePattern().getUniqueId());
        if ((frm.getCreditText() == null || frm.getCreditText().length() == 0) && ss.getCredit() != null) {
            CourseCreditUnitConfig credit = ss.getCredit();
            frm.setCreditText(credit.creditText());
        }
        if (ss.getParentSubpart() != null && ss.getItype().equals(ss.getParentSubpart().getItype())) {
            frm.setSameItypeAsParent(new Boolean(true));
        } else {
            frm.setSameItypeAsParent(new Boolean(false));
        }
        SchedulingSubpart next = ss.getNextSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartDetail);
        frm.setNextId(next == null ? null : next.getUniqueId().toString());
        SchedulingSubpart previous = ss.getPreviousSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartDetail);
        frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        String parentSubpart = "";
        frm.setParentSubpartId(parentSS == null || !this.sessionContext.hasPermission(parentSS, Right.SchedulingSubpartDetail) ? null : parentSS.getUniqueId().toString());
        frm.setParentSubpartLabel(parentSS == null ? null : parentSS.getSchedulingSubpartLabel());
        for (parentSS = ss.getParentSubpart(); parentSS != null; parentSS = parentSS.getParentSubpart()) {
            parentSubpart = parentSS.getItype().getAbbv() + " - " + parentSubpart;
        }
        frm.setParentSubpart(parentSubpart);
        frm.setManagingDeptName(ss.getManagingDept() == null ? null : ss.getManagingDept().getManagingDeptLabel());
        frm.setControllingDept(ss.getControllingDept().getUniqueId());
    }

    private void setupDatePatterns(HttpServletRequest request, SchedulingSubpartEditForm frm, SchedulingSubpart ss) throws Exception {
        DatePattern selectedDatePattern = ss.effectiveDatePattern();
        if (selectedDatePattern != null) {
            List<DatePattern> children = selectedDatePattern.findChildren();
            for (DatePattern dp : children) {
                if (frm.getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                frm.addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
            }
            frm.sortDatePatternPrefs(frm.getDatePatternPrefs(), frm.getDatePatternPrefLevels(), children);
        }
    }
}

