/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.action.RoomGroupListAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomGroupListForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;

@Service(value="/roomGroupSearch")
public class RoomGroupSearchAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroupListForm roomGroupListForm = (RoomGroupListForm)form;
        this.sessionContext.checkPermission(Right.RoomGroups);
        String deptCode = roomGroupListForm.getDeptCodeX();
        if (deptCode == null) {
            deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
        }
        if (deptCode == null && (deptCode = request.getParameter("default")) != null) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)deptCode);
        }
        if (deptCode != null && !deptCode.isEmpty() && ("All".equals(deptCode) || deptCode.matches("Exam[0-9]*"))) {
            roomGroupListForm.setDeptCodeX(deptCode);
            if ("Export PDF".equals(request.getParameter("op"))) {
                this.sessionContext.checkPermission(Right.RoomGroupsExportPdf);
                OutputStream out = ExportUtils.getPdfOutputStream(response, "roomGroups");
                RoomGroupListAction.printPdfGroupTable(out, this.sessionContext, roomGroupListForm);
                out.flush();
                out.close();
                return null;
            }
            return mapping.findForward("roomGroupList");
        }
        if (this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").size() == 1) {
            roomGroupListForm.setDeptCodeX(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").get(0).getQualifierReference());
            return mapping.findForward("roomGroupList");
        }
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("showRoomGroupSearch");
    }
}

