/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.RoomDeptListForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/roomDeptList")
public class RoomDeptListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomDeptListForm roomDeptListForm = (RoomDeptListForm)form;
        this.sessionContext.checkPermission(Right.RoomDepartments);
        this.buildDeptTable(request, roomDeptListForm);
        return mapping.findForward("showRoomDeptList");
    }

    private void buildDeptTable(HttpServletRequest request, RoomDeptListForm roomDeptListForm) throws Exception {
        WebTable.setOrder(this.sessionContext, "roomDeptList.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(5, "Room Departments", "roomDeptList.do?ord=%%", new String[]{"Dept", "Department Abbreviation", "Room", "Capacity", "Room Availability &amp; Sharing"}, new String[]{"left", "left", "left", "right", "left"}, new boolean[]{true, true, true, true, true});
        webTable.setRowStyle("white-space:nowrap");
        TreeSet<Department> depts = Department.getUserDepartments(this.sessionContext.getUser());
        for (Department d : depts) {
            TreeSet<Location> rooms = new TreeSet<Location>();
            for (RoomDept rd : d.getRoomDepts()) {
                if (!(rd.getRoom() instanceof Room)) continue;
                rooms.add(rd.getRoom());
            }
            if (!rooms.isEmpty()) {
                String rmLabel = "";
                String rmCapacity = "";
                String rmDept = "";
                boolean firstRoom = true;
                for (Room room : rooms) {
                    rmLabel = rmLabel + "<TR><TD nowrap " + (!firstRoom ? "style='border-top:black 1px dashed;'" : "") + ">";
                    rmCapacity = rmCapacity + "<TR><TD nowrap " + (!firstRoom ? "style='border-top:black 1px dashed;'" : "") + " align='right'>";
                    rmLabel = rmLabel + room.getLabel();
                    rmCapacity = rmCapacity + room.getCapacity().toString();
                    rmLabel = rmLabel + "<B>&nbsp;</B></TD></TR>";
                    rmCapacity = rmCapacity + "<B>&nbsp;</B></TD></TR>";
                    TreeSet<Department> sortedDepts = new TreeSet<Department>(new Comparator(){

                        public int compare(Object o1, Object o2) {
                            Department d1 = (Department)o1;
                            Department d2 = (Department)o2;
                            return d1.getAbbreviation().compareTo(d2.getAbbreviation());
                        }
                    });
                    for (RoomDept rd : room.getRoomDepts()) {
                        Department department = rd.getDepartment();
                        sortedDepts.add(department);
                    }
                    int deptRow = 0;
                    rmDept = rmDept + "<TR><TD nowrap valign='center' " + (firstRoom ? "" : "style='border-top:black 1px dashed' ") + "rowspan='" + Math.max(2, sortedDepts.size()) + "'>";
                    rmDept = rmDept + "<img border='0' src='pattern?loc=" + room.getUniqueId() + "'>&nbsp;&nbsp;";
                    rmDept = rmDept + "</TD>";
                    for (Department department : sortedDepts) {
                        if (deptRow > 0) {
                            rmLabel = rmLabel + "<TR><TD><B>&nbsp;</B></TD></TR>";
                            rmCapacity = rmCapacity + "<TR><TD><B>&nbsp;</B></TD></TR>";
                        }
                        rmDept = rmDept + (deptRow > 0 ? "<TR>" : "");
                        rmDept = rmDept + "<TD nowrap width='100%' style='color:#" + department.getRoomSharingColor(null) + ";font-weight:bold;" + (!firstRoom && deptRow == 0 ? "border-top:black 1px dashed;" : "") + "'>";
                        rmDept = rmDept + department.getAbbreviation();
                        rmDept = rmDept + "</TD></TR>";
                        ++deptRow;
                    }
                    while (deptRow < 2) {
                        rmLabel = rmLabel + "<TR><TD><B>&nbsp;</B></TD></TR>";
                        rmCapacity = rmCapacity + "<TR><TD><B>&nbsp;</B></TD></TR>";
                        rmDept = rmDept + "<TR><TD><B>&nbsp;</B></TD></TR>";
                        ++deptRow;
                    }
                    firstRoom = false;
                }
                webTable.addLine("onClick=\"document.location='roomDeptEdit.do?doit=editRoomDept&id=" + d.getUniqueId() + "';\"", new String[]{d.getDeptCode(), d.getAbbreviation(), "<table width='100%' border='0' cellspacing='0' cellpadding='1'>" + rmLabel + "</table>", "<table width='100%' border='0' cellspacing='0' cellpadding='1'>" + rmCapacity + "</table>", "<table width='100%' border='0' cellspacing='0' cellpadding='1'>" + rmDept + "</table>"}, new Comparable[]{d.getDeptCode(), d.getAbbreviation(), null, null, null});
            } else {
                webTable.addLine("onClick=\"document.location='roomDeptEdit.do?doit=editRoomDept&id=" + d.getUniqueId() + "';\"", new String[]{d.getDeptCode(), d.getAbbreviation(), "<I>No Room Currently Assigned</I>", "", ""}, new Comparable[]{d.getDeptCode(), d.getAbbreviation(), null, null, null});
            }
            request.setAttribute("roomDepts", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "roomDeptList.ord")));
        }
    }
}

