/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingDetailForm;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingDeleteAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingNotOfferedAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingOfferedAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Service(value="/instructionalOfferingDetail")
public class InstructionalOfferingDetailAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        MessageResources rsc = this.getResources(request);
        InstructionalOfferingDetailForm frm = (InstructionalOfferingDetailForm)form;
        String string = request.getAttribute("op") != null ? request.getAttribute("op").toString() : (request.getParameter("op") != null ? request.getParameter("op") : (op = frm.getOp() != null && !frm.getOp().isEmpty() ? frm.getOp() : request.getParameter("hdnOp")));
        if (op == null || op.trim().length() == 0) {
            throw new Exception(MSG.exceptionOperationNotInterpreted() + op);
        }
        if ("n".equals(request.getParameter("confirm"))) {
            op = rsc.getMessage("op.view");
        }
        Debug.debug("Op: " + op);
        if (op.equals(MSG.actionDeleteIO()) && request.getAttribute("cfgDelete") == null) {
            this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.OfferingDelete);
            this.doDelete(request, frm);
            this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            return mapping.findForward("showInstructionalOfferings");
        }
        if (op.equals(rsc.getMessage("op.view")) || op.equals(MSG.actionUpdateConfiguration()) || op.equals(MSG.actionSaveConfiguration()) || op.equals(MSG.actionDeleteConfiguration()) || op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
            String instrOfferingId;
            Object object = request.getParameter("io") == null ? (request.getAttribute("io") == null ? null : request.getAttribute("io").toString()) : (instrOfferingId = request.getParameter("io"));
            if (instrOfferingId == null && frm.getInstrOfferingId() != null) {
                instrOfferingId = frm.getInstrOfferingId().toString();
            }
            if (instrOfferingId == null && request.getParameter("co") != null) {
                try {
                    instrOfferingId = ((CourseOffering)CourseOfferingDAO.getInstance().get(Long.valueOf(request.getParameter("co")))).getInstructionalOffering().getUniqueId().toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (instrOfferingId == null || instrOfferingId.trim().length() == 0) {
                throw new Exception(MSG.exceptionIODataNotCorrect() + instrOfferingId);
            }
            this.sessionContext.checkPermission((Serializable)((Object)instrOfferingId), "InstructionalOffering", Right.InstructionalOfferingDetail);
            this.doLoad(request, frm, instrOfferingId);
            BackTracker.markForBack(request, "instructionalOfferingDetail.do?io=" + frm.getInstrOfferingId(), MSG.backInstructionalOffering(frm.getInstrOfferingNameNoTitle()), true, false);
            return mapping.findForward("showConfigDetail");
        }
        if (op.equals(MSG.actionAddConfiguration())) {
            this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.InstrOfferingConfigAdd);
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            request.setAttribute("uid", (Object)io.getControllingCourseOffering().getUniqueId().toString());
            return mapping.findForward("modifyConfig");
        }
        if (op.equals(MSG.actionMakeOffered())) {
            this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeOffered);
            this.doMakeOffered(request, frm);
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            request.setAttribute("uid", (Object)io.getControllingCourseOffering().getUniqueId().toString());
            return mapping.findForward("modifyConfig");
        }
        if (op.equals(MSG.actionMakeNotOffered())) {
            this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeNotOffered);
            this.doMakeNotOffered(request, frm);
            if (ApplicationProperty.MakeNotOfferedStaysOnDetail.isFalse()) {
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showInstructionalOfferings"));
                redirect.setAnchor("A" + frm.getInstrOfferingId());
                return redirect;
            }
            response.sendRedirect(response.encodeURL("instructionalOfferingDetail.do?io=" + frm.getInstrOfferingId()));
            return null;
        }
        if (op.equals(MSG.actionCrossLists())) {
            this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.InstructionalOfferingCrossLists);
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            request.setAttribute("uid", (Object)io.getControllingCourseOffering().getUniqueId().toString());
            return mapping.findForward("modifyCrossLists");
        }
        if (op.equals(MSG.actionNextIO())) {
            response.sendRedirect(response.encodeURL("instructionalOfferingDetail.do?io=" + frm.getNextId()));
            return null;
        }
        if (op.equals(MSG.actionPreviousIO())) {
            response.sendRedirect(response.encodeURL("instructionalOfferingDetail.do?io=" + frm.getPreviousId()));
            return null;
        }
        if (op.equals(MSG.actionLockIO())) {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            this.sessionContext.checkPermission(io, Right.OfferingCanLock);
            io.getSession().lockOffering(io.getUniqueId());
            response.sendRedirect(response.encodeURL("instructionalOfferingDetail.do?io=" + io.getUniqueId()));
            return null;
        }
        if (op.equals(MSG.actionUnlockIO())) {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            this.sessionContext.checkPermission(io, Right.OfferingCanUnlock);
            io.getSession().unlockOffering(io, this.sessionContext.getUser());
            response.sendRedirect(response.encodeURL("instructionalOfferingDetail.do?io=" + io.getUniqueId()));
            return null;
        }
        this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.InstructionalOfferingDetail);
        BackTracker.markForBack(request, "instructionalOfferingDetail.do?io=" + frm.getInstrOfferingId(), MSG.backInstructionalOffering(frm.getInstrOfferingName()), true, false);
        return mapping.findForward("showInstructionalOfferings");
    }

    private void doDelete(HttpServletRequest request, InstructionalOfferingDetailForm frm) throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            hibSession = idao.getSession();
            tx = hibSession.beginTransaction();
            io.deleteAllDistributionPreferences(hibSession);
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            String className = ApplicationProperty.ExternalActionInstructionalOfferingDelete.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingDeleteAction deleteAction = (ExternalInstructionalOfferingDeleteAction)Class.forName(className).newInstance();
                deleteAction.performExternalInstructionalOfferingDeleteAction(io, hibSession);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.OFFERING_DETAIL, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            for (CourseOffering co : io.getCourseOfferings()) {
                co.getSubjectArea().getCourseOfferings().remove(co);
                hibSession.delete((Object)co);
            }
            hibSession.delete((Object)io);
            tx.commit();
            hibSession.flush();
            hibSession.clear();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            Debug.error(e);
            throw e;
        }
    }

    private boolean hasConflicts(HttpServletRequest request, InstructionalOffering io) {
        if (RoomAvailability.getInstance() != null && !(RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService)) {
            Session session = io.getSession();
            Date[] bounds = DatePattern.getBounds(session.getUniqueId());
            RoomAvailability.getInstance().activate(session, bounds[0], bounds[1], RoomAvailabilityInterface.sClassType, false);
            RoomAvailability.setAvailabilityWarning(request, session, true, true);
        }
        ClassAssignmentProxy proxy = this.classAssignmentService.getAssignment();
        try {
            if (proxy != null) {
                return proxy.hasConflicts(io.getUniqueId());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void doLoad(HttpServletRequest request, InstructionalOfferingDetailForm frm, String instrOfferingIdStr) throws Exception {
        InstructionalOffering instructionalOffering;
        String linkLookupClass;
        Long instrOfferingId = new Long(instrOfferingIdStr);
        InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
        InstructionalOffering io = (InstructionalOffering)idao.get(instrOfferingId);
        Long subjectAreaId = io.getControllingCourseOffering().getSubjectArea().getUniqueId();
        this.sessionContext.checkPermission(io, Right.InstructionalOfferingDetail);
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, io);
        ArrayList<CourseOffering> offerings = new ArrayList<CourseOffering>(io.getCourseOfferings());
        Collections.sort(offerings, new CourseOfferingComparator(2));
        frm.setInstrOfferingId(instrOfferingId);
        frm.setSubjectAreaId(subjectAreaId);
        frm.setInstrOfferingName(io.getCourseNameWithTitle());
        frm.setSubjectAreaAbbr(io.getControllingCourseOffering().getSubjectAreaAbbv());
        frm.setCourseNbr(io.getControllingCourseOffering().getCourseNbr());
        frm.setInstrOfferingNameNoTitle(io.getCourseName());
        frm.setCtrlCrsOfferingId(io.getControllingCourseOffering().getUniqueId());
        frm.setDemand(io.getDemand());
        frm.setEnrollment(io.getEnrollment());
        frm.setSnapshotLimit(io.getSnapshotLimit());
        frm.setProjectedDemand(io.getProjectedDemand());
        frm.setLimit(io.getLimit());
        frm.setUnlimited(Boolean.FALSE);
        frm.setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(io)));
        frm.setByReservationOnly(io.isByReservationOnly());
        frm.setWkEnroll(io.getLastWeekToEnroll() == null ? "" : io.getLastWeekToEnroll().toString());
        frm.setWkChange(io.getLastWeekToChange() == null ? "" : io.getLastWeekToChange().toString());
        frm.setWkDrop(io.getLastWeekToDrop() == null ? "" : io.getLastWeekToDrop().toString());
        frm.setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(io.getSession().getSessionBeginDateTime()));
        frm.setHasConflict(this.hasConflicts(request, io));
        if (ApplicationProperty.OfferingShowClassNotes.isTrue()) {
            StringBuffer notes = new StringBuffer();
            ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(io.getInstrOfferingConfigs());
            Collections.sort(configs, new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            for (InstrOfferingConfig config : configs) {
                ArrayList<SchedulingSubpart> arrayList = new ArrayList<SchedulingSubpart>(config.getSchedulingSubparts());
                Collections.sort(arrayList, new SchedulingSubpartComparator());
                for (Object subpart : arrayList) {
                    ArrayList<Class_> classes = new ArrayList<Class_>(((BaseSchedulingSubpart)subpart).getClasses());
                    Collections.sort(classes, new ClassComparator(3));
                    for (Class_ clazz : classes) {
                        if (clazz.getNotes() == null || clazz.getNotes().isEmpty()) continue;
                        notes.append("<tr><th valign='top' align='left' nowrap>" + ((SchedulingSubpart)subpart).getItypeDesc().trim() + " " + clazz.getSectionNumberString() + "</th><td>" + clazz.getNotes() + "</td></tr>");
                    }
                }
            }
            if (notes.length() == 0) {
                frm.setNotes(io.getNotes());
            } else {
                frm.setNotes("<table border='0' cellspacing='2' cellpadding='0'>" + (io.getNotes() != null && !io.getNotes().isEmpty() ? "<tr><th valign='top' align='left' nowrap>" + io.getControllingCourseOffering().getCourseName() + "&nbsp;</th><td>" + io.getNotes() + "</td></tr>" : "") + notes + "</table>");
            }
        } else {
            frm.setNotes(io.getNotes());
        }
        String coordinators = "";
        String instructorNameFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
        for (OfferingCoordinator coordinator : new TreeSet<OfferingCoordinator>(io.getOfferingCoordinators())) {
            if (!coordinators.isEmpty()) {
                coordinators = coordinators + "<br>";
            }
            coordinators = coordinators + "<a href='instructorDetail.do?instructorId=" + coordinator.getInstructor().getUniqueId() + "' class='noFancyLinks'>" + coordinator.getInstructor().getName(instructorNameFormat) + (coordinator.getResponsibility() == null ? (coordinator.getPercentShare() != 0 ? " (" + coordinator.getPercentShare() + "%)" : "") : " (" + coordinator.getResponsibility().getLabel() + (coordinator.getPercentShare() > 0 ? ", " + coordinator.getPercentShare() + "%" : "") + ")") + "</a>";
        }
        frm.setCoordinators(coordinators);
        Iterator<InstrOfferingConfig> i = io.getInstrOfferingConfigs().iterator();
        while (i.hasNext()) {
            if (!i.next().isUnlimitedEnrollment().booleanValue()) continue;
            frm.setUnlimited(Boolean.TRUE);
            break;
        }
        frm.setNotOffered(io.isNotOffered());
        frm.setCourseOfferings(offerings);
        if (io.getCourseOfferings().size() > 1 && !frm.getUnlimited().booleanValue()) {
            int lim = 0;
            boolean reservationSet = false;
            for (CourseOffering courseOffering : io.getCourseOfferings()) {
                if (courseOffering.getReservation() == null) continue;
                lim += courseOffering.getReservation().intValue();
                reservationSet = true;
            }
            if (reservationSet && io.getLimit() != null && lim < io.getLimit()) {
                request.setAttribute("limitsDoNotMatch", (Object)("" + lim));
            }
        }
        TreeSet<InstrOfferingConfig> configsWithTooHighLimit = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
            void var14_32;
            if (instrOfferingConfig.isUnlimitedEnrollment().booleanValue()) continue;
            Object var14_31 = null;
            for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                int limit = 0;
                for (Class_ clazz : subpart.getClasses()) {
                    limit += (clazz.getMaxExpectedCapacity() == null ? clazz.getExpectedCapacity() : clazz.getMaxExpectedCapacity()).intValue();
                }
                if (var14_32 != null && var14_32.intValue() <= limit) continue;
                Integer n = limit;
            }
            if (var14_32 == null || var14_32.intValue() >= instrOfferingConfig.getLimit()) continue;
            configsWithTooHighLimit.add(instrOfferingConfig);
        }
        if (!configsWithTooHighLimit.isEmpty()) {
            if (configsWithTooHighLimit.size() == 1) {
                request.setAttribute("configsWithTooHighLimit", (Object)MSG.errorConfigWithTooHighLimit(((InstrOfferingConfig)configsWithTooHighLimit.first()).getName()));
            } else {
                String names = "";
                for (InstrOfferingConfig instrOfferingConfig : configsWithTooHighLimit) {
                    if (!names.isEmpty()) {
                        names = names + ", ";
                    }
                    names = names + instrOfferingConfig.getName();
                }
                request.setAttribute("configsWithTooHighLimit", (Object)MSG.errorConfigsWithTooHighLimit(names));
            }
        }
        if ((linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value()) != null && linkLookupClass.trim().length() > 0) {
            ExternalLinkLookup externalLinkLookup = (ExternalLinkLookup)Class.forName(linkLookupClass).newInstance();
            Map map = externalLinkLookup.getLink(io);
            if (map == null) {
                throw new Exception(externalLinkLookup.getErrorMessage());
            }
            frm.setCatalogLinkLabel((String)map.get("label"));
            frm.setCatalogLinkLocation((String)map.get("href"));
        }
        frm.setNextId((instructionalOffering = io.getNextInstructionalOffering(this.sessionContext)) == null ? null : instructionalOffering.getUniqueId().toString());
        InstructionalOffering instructionalOffering2 = io.getPreviousInstructionalOffering(this.sessionContext);
        frm.setPreviousId(instructionalOffering2 == null ? null : instructionalOffering2.getUniqueId().toString());
        DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
        String html = tbl.getDistPrefsTableForInstructionalOffering(request, this.sessionContext, io);
        if (html != null && html.indexOf(MSG.noPreferencesFound()) < 0) {
            request.setAttribute("distPrefs", (Object)html);
        }
    }

    private void doMakeNotOffered(HttpServletRequest request, InstructionalOfferingDetailForm frm) throws Exception {
        this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeNotOffered);
        org.hibernate.Session hibSession = null;
        try {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            hibSession = idao.getSession();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            io.deleteAllDistributionPreferences(hibSession);
            io.deleteAllClasses(hibSession);
            for (CourseOffering co : io.getCourseOfferings()) {
                Event.deleteFromEvents(hibSession, co);
                Exam.deleteFromExams(hibSession, co);
            }
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            Iterator<Comparable> i = io.getReservations().iterator();
            while (i.hasNext()) {
                Reservation r = (Reservation)i.next();
                hibSession.delete((Object)r);
                i.remove();
            }
            i = io.getTeachingRequests().iterator();
            while (i.hasNext()) {
                TeachingRequest tr = (TeachingRequest)i.next();
                hibSession.delete((Object)tr);
                i.remove();
            }
            io.setNotOffered(new Boolean(true));
            idao.saveOrUpdate(io);
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.MAKE_NOT_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            if (this.sessionContext.hasPermission(io, Right.OfferingCanUnlock)) {
                io.getSession().unlockOffering(io, this.sessionContext.getUser());
            }
            hibSession.flush();
            hibSession.clear();
            String className = ApplicationProperty.ExternalActionInstructionalOfferingNotOffered.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingNotOfferedAction notOfferedAction = (ExternalInstructionalOfferingNotOfferedAction)Class.forName(className).newInstance();
                notOfferedAction.performExternalInstructionalOfferingNotOfferedAction(io, hibSession);
            }
            frm.setNotOffered(io.isNotOffered());
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doMakeOffered(HttpServletRequest request, InstructionalOfferingDetailForm frm) throws Exception {
        this.sessionContext.checkPermission(frm.getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeOffered);
        org.hibernate.Session hibSession = null;
        try {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            hibSession = idao.getSession();
            InstructionalOffering io = (InstructionalOffering)idao.get(frm.getInstrOfferingId());
            io.setNotOffered(new Boolean(false));
            idao.saveOrUpdate(io);
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.MAKE_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            if (this.sessionContext.hasPermission(io, Right.OfferingCanLock)) {
                io.getSession().lockOffering(io.getUniqueId());
            }
            hibSession.flush();
            hibSession.clear();
            String className = ApplicationProperty.ExternalActionInstructionalOfferingOffered.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingOfferedAction offeredAction = (ExternalInstructionalOfferingOfferedAction)Class.forName(className).newInstance();
                offeredAction.performExternalInstructionalOfferingOfferedAction(io, hibSession);
            }
            frm.setNotOffered(io.isNotOffered());
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }
}

