/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ChameleonForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.ChameleonUserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Service(value="/chameleon")
public class ChameleonAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        UserContext user = this.sessionContext.getUser();
        if (user != null && user instanceof UserContext.Chameleon) {
            user = ((UserContext.Chameleon)((Object)user)).getOriginalUserContext();
        } else {
            this.sessionContext.checkPermission(Right.Chameleon);
        }
        MessageResources rsc = this.getResources(request);
        ChameleonForm frm = (ChameleonForm)form;
        frm.setCanLookup(this.sessionContext.hasPermission(Right.HasRole));
        ActionMessages errors = new ActionMessages();
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null || op.trim().length() == 0) {
            op = rsc.getMessage("op.view");
        }
        frm.setOp(op);
        String uid = request.getParameter("uid");
        if (uid != null && !uid.isEmpty() && ApplicationProperty.ChameleonAllowLookup.isTrue()) {
            frm.setPuid(uid);
            frm.setName(request.getParameter("uname"));
            op = rsc.getMessage("button.changeUser");
        }
        if (op.equals(rsc.getMessage("op.view"))) {
            LookupTables.setupTimetableManagers(request);
            if (user != null) {
                frm.setPuid(user.getExternalUserId());
            }
        }
        if (op.equals(rsc.getMessage("button.changeUser"))) {
            try {
                this.doSwitch(request, frm, user);
                return mapping.findForward("reload");
            }
            catch (Exception e) {
                Debug.error(e);
                errors.add("exception", new ActionMessage("errors.generic", (Object)e.getMessage()));
                this.saveErrors(request, errors);
                LookupTables.setupTimetableManagers(request);
                return mapping.findForward("displayForm");
            }
        }
        return mapping.findForward("displayForm");
    }

    private void doSwitch(HttpServletRequest request, ChameleonForm frm, UserContext user) throws Exception {
        Authentication authentication;
        for (SessionAttribute a : SessionAttribute.values()) {
            request.getSession().removeAttribute(a.key());
        }
        if (user instanceof UserContext.Chameleon) {
            user = ((UserContext.Chameleon)((Object)user)).getOriginalUserContext();
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof ChameleonAuthentication) {
            authentication = ((ChameleonAuthentication)authentication).getOriginalAuthentication();
        }
        if (user.getExternalUserId().equals(frm.getPuid())) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        } else {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new ChameleonAuthentication(authentication, new ChameleonUserContext(frm.getPuid(), frm.getName(), user)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChameleonAuthentication
    implements Authentication {
        private static final long serialVersionUID = 1L;
        private Authentication iOriginalAuthentication;
        private UserContext iUserContext;

        public ChameleonAuthentication(Authentication authentication, UserContext user) {
            this.iOriginalAuthentication = authentication;
            this.iUserContext = user;
            if (this.iOriginalAuthentication instanceof ChameleonAuthentication) {
                this.iOriginalAuthentication = ((ChameleonAuthentication)this.iOriginalAuthentication).getOriginalAuthentication();
            }
        }

        public Authentication getOriginalAuthentication() {
            return this.iOriginalAuthentication;
        }

        public String getName() {
            return this.iUserContext.getName();
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.iUserContext.getAuthorities();
        }

        public Object getCredentials() {
            return this.iOriginalAuthentication.getCredentials();
        }

        public Object getDetails() {
            return this.iOriginalAuthentication.getDetails();
        }

        public Object getPrincipal() {
            return this.iUserContext;
        }

        public boolean isAuthenticated() {
            return this.iOriginalAuthentication.isAuthenticated();
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            this.iOriginalAuthentication.setAuthenticated(isAuthenticated);
        }
    }
}

