/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class RandomizedBacktrackNeighbourSelection
extends BacktrackNeighbourSelection<Request, Enrollment> {
    private int iMaxValues = 100;

    public RandomizedBacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iMaxValues = properties.getPropertyInt("Neighbour.MaxValues", this.iMaxValues);
    }

    @Override
    protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
        if (variable instanceof CourseRequest) {
            final CourseRequest request = (CourseRequest)variable;
            final StudentSectioningModel model = (StudentSectioningModel)context.getModel();
            final Assignment<Request, Enrollment> assignment = context.getAssignment();
            List<Enrollment> values = this.iMaxValues > 0 ? request.computeRandomEnrollments(assignment, this.iMaxValues) : request.computeEnrollments(assignment);
            Collections.sort(values, new Comparator<Enrollment>(){
                private HashMap<Enrollment, Double> iValues = new HashMap();

                private Double value(Enrollment e) {
                    Double value = this.iValues.get(e);
                    if (value == null) {
                        value = model.getStudentWeights().getWeight(assignment, e, model.getDistanceConflict() == null ? null : model.getDistanceConflict().conflicts(e), model.getTimeOverlaps() == null ? null : model.getTimeOverlaps().conflicts(e));
                        this.iValues.put(e, value);
                    }
                    return value;
                }

                @Override
                public int compare(Enrollment e1, Enrollment e2) {
                    Double v2;
                    if (e1.equals(assignment.getValue(request))) {
                        return -1;
                    }
                    if (e2.equals(assignment.getValue(request))) {
                        return 1;
                    }
                    Double v1 = this.value(e1);
                    return v1.equals(v2 = this.value(e2)) ? e1.compareTo(assignment, e2) : v2.compareTo(v1);
                }
            });
            return values.iterator();
        }
        return variable.computeEnrollments(context.getAssignment()).iterator();
    }
}

