/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.model;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingRequest;

public class TeachingAssignment
extends Value<TeachingRequest.Variable, TeachingAssignment> {
    private Instructor iInstructor;
    private int iHashCode;
    private int iAttributePreference;
    private int iInstructorPreference;
    private int iCoursePreference;
    private int iTimePreference;

    public TeachingAssignment(TeachingRequest.Variable variable, Instructor instructor, int attributePreference) {
        super(variable, 0.0);
        this.iInstructor = instructor;
        this.iHashCode = variable.hashCode() ^ instructor.hashCode();
        this.iTimePreference = instructor.getTimePreference(variable.getRequest()).getPreferenceInt();
        this.iCoursePreference = instructor.getCoursePreference(variable.getCourse()).getPreference();
        this.iInstructorPreference = variable.getRequest().getInstructorPreference(instructor).getPreference();
        this.iAttributePreference = attributePreference;
    }

    public TeachingAssignment(TeachingRequest.Variable variable, Instructor instructor) {
        this(variable, instructor, variable.getRequest().getAttributePreference(instructor).getPreferenceInt());
    }

    public Instructor getInstructor() {
        return this.iInstructor;
    }

    @Override
    public double toDouble(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        double ret = 0.0;
        for (Criterion<TeachingRequest.Variable, TeachingAssignment> criterion : ((TeachingRequest.Variable)this.variable()).getModel().getCriteria()) {
            ret += criterion.getWeightedValue(assignment, this, null);
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TeachingAssignment)) {
            return false;
        }
        TeachingAssignment a = (TeachingAssignment)o;
        return ((TeachingRequest.Variable)this.variable()).equals(a.variable()) && this.getInstructor().equals(a.getInstructor());
    }

    public int getAttributePreference() {
        return this.iAttributePreference;
    }

    public int getTimePreference() {
        return this.iTimePreference;
    }

    public int getInstructorPreference() {
        return this.iInstructorPreference;
    }

    public int getCoursePreference() {
        return this.iCoursePreference;
    }

    @Override
    public int hashCode() {
        return this.iHashCode;
    }

    @Override
    public String toString() {
        return ((TeachingRequest.Variable)this.variable()).getName() + ": " + this.getInstructor().getName();
    }

    @Override
    public String getName() {
        return this.getInstructor().hasName() ? this.getInstructor().getName() + (this.getInstructor().hasExternalId() ? " (" + this.getInstructor().getExternalId() + ")" : "") : this.getInstructor().getName();
    }
}

